/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.print;

import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.text.print.PrintSettings;
import com.mathworks.widgets.text.print.Scale;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import javax.print.attribute.PrintRequestAttributeSet;

public class GraphicsUtils {
    private GraphicsUtils() {
    }

    public static void applyPrintScale(Graphics2D graphics2D) {
        PrintRequestAttributeSet printRequestAttributeSet;
        Scale scale;
        if (PrintSettings.useMacNativeFixes() && (scale = (Scale)(printRequestAttributeSet = PrintSettings.getInstance().getLastPrintRequestAttributes(null)).get(Scale.class)) != null) {
            double d = (double)scale.getValue() / 100.0;
            AffineTransform affineTransform = graphics2D.getTransform();
            if (Math.abs(affineTransform.getScaleX() - d) > 0.009 || Math.abs(affineTransform.getScaleY() - d) > 0.009) {
                affineTransform.setToScale(d, d);
                graphics2D.setTransform(affineTransform);
            }
        }
    }

    public static float getScaleAdjustedImageableWidth(Graphics2D graphics2D, PageFormat pageFormat) {
        if (PrintSettings.useMacNativeFixes()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            return (float)(pageFormat.getImageableWidth() / affineTransform.getScaleX());
        }
        return (float)pageFormat.getImageableWidth();
    }

    public static float getScaleAdjustedImageableHeight(Graphics2D graphics2D, PageFormat pageFormat) {
        if (PrintSettings.useMacNativeFixes()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            return (float)(pageFormat.getImageableHeight() / affineTransform.getScaleY());
        }
        return (float)pageFormat.getImageableHeight();
    }

    public static float getScaleAdjustedImageableX(Graphics2D graphics2D, PageFormat pageFormat) {
        if (PrintSettings.useMacNativeFixes()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            return (float)(pageFormat.getImageableX() / affineTransform.getScaleX());
        }
        return (float)pageFormat.getImageableX();
    }

    public static float getScaleAdjustedImageableY(Graphics2D graphics2D, PageFormat pageFormat) {
        if (PrintSettings.useMacNativeFixes()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            return (float)(pageFormat.getImageableY() / affineTransform.getScaleY());
        }
        return (float)pageFormat.getImageableY();
    }

    public static double drawStringToGraphics(Graphics2D graphics2D, String string, double d, double d2) {
        if (PrintSettings.useMacNativeFixes() && PlatformInfo.isVersion17()) {
            GlyphVector glyphVector = graphics2D.getFont().createGlyphVector(graphics2D.getFontRenderContext(), string);
            Shape shape = glyphVector.getOutline();
            graphics2D.translate(d, d2);
            graphics2D.fill(shape);
            graphics2D.translate(-d, -d2);
            return glyphVector.getLogicalBounds().getWidth();
        }
        graphics2D.drawString(string, (float)d, (float)d2);
        return graphics2D.getFontMetrics().stringWidth(string);
    }
}

