/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.analyzer;

import com.mathworks.mwswing.ActionUtils;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;

public class CodeAnalyzerActions {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.widgets.text.mcode.resources.RES_mcode");
    public static final String MLINT_AUTO_FIX_ACTION = "mlint-fix-action";
    public static final String SUPPRESS_ALL_IN_FILE_ACTION = "mlint-suppressAll-action";
    public static final String DISABLE_ALL_MESSAGES_ACTION = "mlint-disableAll-action";
    public static final String SUPPRESS_THIS_MESSAGE_ACTION = "mlint-suppressThis-action";
    private static final String SUPPRESS_THIS_STRING = "mkit.mlint.ignore";

    private CodeAnalyzerActions() {
    }

    public static CodeAnalyzerMessageMenuAction createAutoFixMenuAction(MLint.Message message) {
        return new AutoFixActionWrapper(new AutoFixAction(), message);
    }

    public static BaseAction createAutoFixBindingAction() {
        return new AutoFixAction();
    }

    public static CodeAnalyzerMessageMenuAction createDisableAllMenuAction() {
        return new CodeAnalyzerMessageMenuAction(new DisableMessageAction());
    }

    public static BaseAction createDisableAllBindingAction() {
        return new DisableMessageAction();
    }

    public static CodeAnalyzerMessageMenuAction createSuppressAllMenuAction() {
        return new CodeAnalyzerMessageMenuAction(new SuppressAllInFileAction());
    }

    public static BaseAction createSuppressAllBindingAction() {
        return new SuppressAllInFileAction();
    }

    public static CodeAnalyzerMessageMenuAction createSuppressThisMenuAction(MLint.Message message) {
        return new SuppressThisMessageActionWrapper(new SuppressThisMLintMessageAction(), message);
    }

    public static BaseAction createSuppressThisBindingAction() {
        return new SuppressThisMLintMessageAction();
    }

    public static boolean isMessageDisableable(MLint.Message message) {
        return CodeAnalyzerUtils.isSupressableOrDisableable(message) && !MLintPrefsUtils.getActiveConfiguration().isReadOnly();
    }

    private static MLint.Message getMessage(JTextComponent jTextComponent) {
        return CodeAnalyzerUtils.getFirstOrFirstAutoFixableMessage(jTextComponent);
    }

    public static class CodeAnalyzerMessageMenuAction
    extends ChildAction {
        private CodeAnalyzerMessageMenuAction(BaseAction baseAction) {
            super((Action)baseAction);
            String string = (String)baseAction.getValue("Name");
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABEditor", string, (ExtendedAction)this);
        }
    }

    private static class AutoFixAction
    extends BaseAction {
        private AutoFixAction() {
            super(CodeAnalyzerActions.MLINT_AUTO_FIX_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            MLint.Message message = CodeAnalyzerActions.getMessage(jTextComponent);
            if (message != null && message.hasAutoFix()) {
                CodeAnalyzerUtils.applyAutoFixes((STPBaseInterface)((Object)jTextComponent), message.getAutoFixChanges());
            }
        }
    }

    private static class AutoFixActionWrapper
    extends CodeAnalyzerMessageMenuAction {
        private AutoFixActionWrapper(BaseAction baseAction, MLint.Message message) {
            super(baseAction);
            if (message != null) {
                if (message.hasAutoFix()) {
                    ActionUtils.setName((Action)((Object)this), (String)message.getAutoFixMessage(), (boolean)false);
                }
                this.setEnabled(message.hasAutoFix());
            }
        }
    }

    private static class DisableMessageAction
    extends BaseAction {
        DisableMessageAction() {
            super(CodeAnalyzerActions.DISABLE_ALL_MESSAGES_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            try {
                MLint.Message message = CodeAnalyzerActions.getMessage(jTextComponent);
                if (message != null && CodeAnalyzerActions.isMessageDisableable(message)) {
                    CodeAnalyzerUtils.disableMessage(message.getTag());
                }
            }
            catch (IOException iOException) {
                File file = MLintPrefsUtils.getActiveConfiguration().getFile();
                CodeAnalyzerUtils.showErrorDialog(null, "mlint.msg.problemSaving", file, iOException);
            }
        }
    }

    private static class SuppressAllInFileAction
    extends BaseAction {
        SuppressAllInFileAction() {
            super(CodeAnalyzerActions.SUPPRESS_ALL_IN_FILE_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            MLint.Message message = CodeAnalyzerActions.getMessage(jTextComponent);
            if (message != null && CodeAnalyzerUtils.isSupressableOrDisableable(message)) {
                CodeAnalyzerUtils.suppressAllMessages(message.getTag(), jTextComponent, jTextComponent.getCaretPosition());
            }
        }
    }

    private static class SuppressThisMLintMessageAction
    extends BaseAction {
        SuppressThisMLintMessageAction() {
            super(CodeAnalyzerActions.SUPPRESS_THIS_MESSAGE_ACTION);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            MLint.Message message = CodeAnalyzerActions.getMessage(jTextComponent);
            if (message != null && CodeAnalyzerUtils.isSupressableOrDisableable(message)) {
                CodeAnalyzerUtils.suppressMessage(message.getTag(), jTextComponent, jTextComponent.getCaretPosition());
            }
        }
    }

    private static class SuppressThisMessageActionWrapper
    extends CodeAnalyzerMessageMenuAction {
        private SuppressThisMessageActionWrapper(BaseAction baseAction, MLint.Message message) {
            super(baseAction);
            if (message != null) {
                ActionUtils.setName((Action)((Object)this), (String)MessageFormat.format(BUNDLE.getString(CodeAnalyzerActions.SUPPRESS_THIS_STRING), CodeAnalyzerUtils.truncateMessage(message)), (boolean)false);
            }
        }
    }
}

