/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.util.Log;
import com.mathworks.util.tree.Visitor;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeBaseDocumentCache;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.UniquePredicate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class MTreeUtils {
    private MTreeUtils() {
    }

    public static void visit(MTree mTree, Visitor<MTree.Node> visitor) {
        Validate.notNull((Object)mTree, (String)"'tree' cannot be null");
        Validate.notNull(visitor, (String)"'visitor' cannot be null");
        MTreeUtils.doVisit(mTree.getRoot(), visitor);
    }

    public static void visit(MTree.Node node, Visitor<MTree.Node> visitor) {
        Validate.notNull((Object)node, (String)"'node' cannot be null");
        Validate.notNull(visitor, (String)"'visitor' cannot be null");
        visitor.visit((Object)node);
        MTreeUtils.doVisit(node.getLeft(), visitor);
        MTreeUtils.doVisit(node.getRight(), visitor);
    }

    private static void doVisit(MTree.Node node, Visitor<MTree.Node> visitor) {
        for (MTree.Node node2 = node; node2 != MTree.NULL_NODE; node2 = node2.getNext()) {
            MTreeUtils.visit(node2, visitor);
        }
    }

    public static MTree.Node getIfConditionNode(MTree.Node node) {
        return MTreeUtils.getIfheadNode(node).getLeft();
    }

    public static MTree.Node getIfBodyNode(MTree.Node node) {
        return MTreeUtils.getIfheadNode(node).getRight();
    }

    public static MTree.Node getElseNodeFromIf(MTree.Node node) {
        return MTreeUtils.getNextElse(MTreeUtils.getIfheadNode(node));
    }

    public static MTree.Node getElseNodeFromElse(MTree.Node node) {
        if (!node.getType().equals((Object)MTree.NodeType.ELSE) && !node.getType().equals((Object)MTree.NodeType.ELSEIF)) {
            throw new IllegalArgumentException("Node '" + node + "' is not of type ELSE or ELSEIF.");
        }
        return MTreeUtils.getNextElse(node);
    }

    private static MTree.Node getNextElse(MTree.Node node) {
        MTree.Node node2 = node.getNext();
        assert (node2 == MTree.NULL_NODE || node2.getType().equals((Object)MTree.NodeType.ELSE) || node2.getType().equals((Object)MTree.NodeType.ELSEIF)) : "The next node from an if should be null, else, or elseif";
        return node2;
    }

    public static MTree.Node getIfheadNode(MTree.Node node) {
        Validate.isTrue((boolean)MTreeUtils.isType(node, MTree.NodeType.IF), (String)("Node '" + node + "' is not of type IF."));
        MTree.Node node2 = node.getLeft();
        assert (MTreeUtils.isType(node2, MTree.NodeType.IFHEAD)) : "Left child of IF should be IFHEAD";
        return node2;
    }

    public static List<MTree.Node> getLocalStringsAtOffset(BaseDocument baseDocument, int n) {
        Validate.notNull((Object)baseDocument, (String)"input document cannot be null");
        MTree mTree = MTreeBaseDocumentCache.getMTree(baseDocument);
        try {
            n = Utilities.getWordStart((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return MTreeUtils.getLocalStringsAtOffset(mTree, n, baseDocument);
    }

    private static List<MTree.Node> getLocalStringsAtOffset(MTree mTree, int n, BaseDocument baseDocument) {
        ArrayList<MTree.Node> arrayList = new ArrayList<MTree.Node>();
        if (mTree.isEmpty()) {
            return arrayList;
        }
        List<MTree.Node> list = MTreeUtils.getPathToPosition(mTree, n, baseDocument);
        if (MTreeUtils.isType(list.get(list.size() - 1), MTree.NodeType.COMMENT)) {
            return arrayList;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            MTree.Node node = list.get(i);
            if (MTreeUtils.isType(node, MTree.NodeType.METHODS)) continue;
            List<MTree.Node> list2 = MTreeUtils.getListAtSameLevel(mTree, node);
            if (!list2.isEmpty()) {
                boolean bl = i == list.size() - 1 && MTreeUtils.isRootLevelNode(mTree, node) || MTreeUtils.inFunctionOfInnermost(list.get(list.size() - 1), node);
                MTreeUtils.addFunctionsAndVarsAtThisLevel(n, arrayList, list2, bl, node, baseDocument);
            }
            if (!MTreeUtils.isType(node, MTree.NodeType.FUNCTION)) continue;
            MTreeUtils.addInsAndOuts(arrayList, node);
        }
        CollectionUtils.filter(arrayList, (Predicate)new Predicate(){
            private UniquePredicate iPredicate = new UniquePredicate();

            public boolean evaluate(Object object) {
                MTree.Node node = (MTree.Node)object;
                return node.isTextSupported() && this.iPredicate.evaluate((Object)node.getText());
            }
        });
        return arrayList;
    }

    private static boolean inFunctionOfInnermost(MTree.Node node, MTree.Node node2) {
        return MTreeUtils.getFunctionForNode(node) == MTreeUtils.getFunctionForNode(node2);
    }

    private static MTree.Node getFunctionForNode(MTree.Node node) {
        MTree.Node node2;
        for (node2 = node; node2 != MTree.NULL_NODE && !MTreeUtils.isType(node2, MTree.NodeType.FUNCTION); node2 = node2.getTrueParent()) {
        }
        return node2;
    }

    private static void addInsAndOuts(List<MTree.Node> list, MTree.Node node) {
        for (MTree.Node node2 : node.getInputArguments()) {
            list.add(node2);
        }
        for (MTree.Node node2 : node.getOutputArguments()) {
            list.add(node2);
        }
    }

    private static void addFunctionsAndVarsAtThisLevel(int n, List<MTree.Node> list, List<MTree.Node> list2, boolean bl, MTree.Node node, BaseDocument baseDocument) {
        for (MTree.Node node2 : list2) {
            Object object;
            Object object2;
            Object object3;
            if (MTreeUtils.isType(node2, MTree.NodeType.CLASSDEF)) {
                object3 = MTreeUtils.getClassNameNode(node2);
                if (object3 == null) continue;
                list.add((MTree.Node)object3);
                continue;
            }
            object3 = node2.getSubtree();
            if (MTreeUtils.isType(node2, MTree.NodeType.FUNCTION)) {
                if (node2 != node) {
                    object3 = Arrays.asList(node2);
                }
                object2 = node2.getBody();
                MTreeUtils.addFunctionNameNode(list, node2);
                object = ((MTree.Node)object2).getListOfNextNodes();
                List<MTree.Node> list3 = MTreeUtils.find((List<MTree.Node>)object, MTree.NodeType.FUNCTION);
                for (MTree.Node node3 : list3) {
                    if (node3 != node2) {
                        object3.removeAll(node3.getSubtree());
                    }
                    if (node2 != node) continue;
                    MTreeUtils.addFunctionNameNode(list, node3);
                }
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (MTree.Node)object2.next();
                if (!MTreeUtils.isVarOrGlobal((MTree.Node)object) || bl && !MTreeUtils.isBefore((MTree.Node)object, n, baseDocument)) continue;
                list.add((MTree.Node)object);
            }
        }
    }

    private static void addFunctionNameNode(List<MTree.Node> list, MTree.Node node) {
        if (node.getFunctionName().getAttribute() != MTree.Attribute.METHOD) {
            list.add(node.getFunctionName());
        }
    }

    private static boolean isBefore(MTree.Node node, int n, BaseDocument baseDocument) {
        return MTreeUtils.getPosition(node, baseDocument) < n;
    }

    public static int getPosition(MTree.Node node, BaseDocument baseDocument) {
        return MTreeUtils.convertBytePositionToStringPosition(baseDocument, node.getStartLine() - 1, node.getStartColumn() - 1);
    }

    public static int getMinimumPosition(MTree.Node node, BaseDocument baseDocument) {
        while (!node.getLeft().equals(MTree.NULL_NODE) && node.getLeft().getPosition() <= node.getPosition()) {
            node = node.getLeft();
        }
        return MTreeUtils.getPosition(node, baseDocument);
    }

    public static int getMaximumPosition(MTree.Node node, BaseDocument baseDocument) {
        MTree.Node node2 = node.getRightmostNode();
        int n = node.getMaximumPosition() - node2.getPosition() + 1;
        if (n < 0) {
            return -1;
        }
        assert (n > 0) : "Distance to end of subtree should be non-zero";
        return MTreeUtils.convertBytePositionPlusAdditionalBytesToStringPosition(baseDocument, node2.getStartLine() - 1, node2.getStartColumn() - 1, n);
    }

    public static int convertBytePositionToStringPosition(BaseDocument baseDocument, int n, int n2) {
        return MTreeUtils.convertBytePositionPlusAdditionalBytesToStringPosition(baseDocument, n, n2, 0);
    }

    private static int convertBytePositionPlusAdditionalBytesToStringPosition(BaseDocument baseDocument, int n, int n2, int n3) {
        int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n);
        int n5 = n2;
        try {
            int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4);
            int n7 = n6 - n4 + n3;
            n7 = Math.min(n7, baseDocument.getLength() - n4);
            n5 = MTreeUtils.convertFromByteToChar(n2 + n3, baseDocument, n4, n7);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return n4 + n5;
    }

    private static int convertFromByteToChar(int n, BaseDocument baseDocument, int n2, int n3) throws BadLocationException {
        int n4 = n;
        try {
            String string = baseDocument.getText(n2, n3);
            byte[] byArray = string.getBytes("UTF-8");
            n = Math.min(byArray.length, n);
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            n4 = new String(byArray2, "UTF-8").length();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.logException((Exception)unsupportedEncodingException);
        }
        return n4;
    }

    private static List<MTree.Node> find(List<MTree.Node> list, MTree.NodeType nodeType) {
        ArrayList<MTree.Node> arrayList = new ArrayList<MTree.Node>();
        for (MTree.Node node : list) {
            if (!MTreeUtils.isType(node, nodeType)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private static boolean isVarOrGlobal(MTree.Node node) {
        return node.getAttribute() == MTree.Attribute.VARIABLE;
    }

    private static List<MTree.Node> getListAtSameLevel(MTree mTree, MTree.Node node) {
        List<MTree.Node> list = MTreeUtils.isRootLevelNode(mTree, node) ? mTree.getRoot().getListOfNextNodes() : node.getTrueParent().getBody().getListOfNextNodes();
        return list;
    }

    public static boolean isType(MTree.Node node, MTree.NodeType ... nodeTypeArray) {
        Validate.notNull((Object)node, (String)"input node cannot be null");
        Validate.notNull((Object)nodeTypeArray, (String)"types cannot be null");
        return ArrayUtils.contains((Object[])nodeTypeArray, (Object)((Object)node.getType()));
    }

    private static boolean isRootLevelNode(MTree mTree, MTree.Node node) {
        return mTree.getRoot().getListOfNextNodes().contains(node);
    }

    public static MTree.Node getClassNameNode(MTree.Node node) {
        Validate.notNull((Object)node);
        Validate.isTrue((boolean)MTreeUtils.isType(node, MTree.NodeType.CLASSDEF));
        MTree.Node node2 = MTree.NULL_NODE;
        for (MTree.Node node3 : node.getSubtree()) {
            if (!MTreeUtils.isType(node3, MTree.NodeType.CEXPR)) continue;
            MTree.Node node4 = node3.getRight();
            if (MTreeUtils.isType(node4, MTree.NodeType.ID)) {
                node2 = node4;
                break;
            }
            if (!MTreeUtils.isType(node4, MTree.NodeType.LT)) break;
            node2 = node4.getLeft();
            break;
        }
        return node2;
    }

    public static MTree.Node getClassConstructorNode(MTree mTree) {
        Validate.notNull((Object)mTree);
        for (MTree.Node node : mTree.getRoot().getListOfNextNodes()) {
            if (node.getType().isFunction()) {
                return null;
            }
            if (!node.getType().isClass()) continue;
            return MTreeUtils.getClassConstructorNode(node);
        }
        return null;
    }

    public static MTree.Node getClassConstructorNode(MTree.Node node) {
        Validate.notNull((Object)node);
        Validate.isTrue((boolean)node.getType().isClass(), (String)"must provide a classdef node");
        for (MTree.Node node2 : node.getBody().getListOfNextNodes()) {
            if (!MTreeUtils.isType(node2, MTree.NodeType.METHODS)) continue;
            for (MTree.Node node3 : node2.getBody().getListOfNextNodes()) {
                if (!node3.getType().isFunction() || !MTreeUtils.getClassNameNode(node).getText().equals(node3.getFunctionName().getText())) continue;
                return node3;
            }
        }
        return null;
    }

    public static List<MTree.Node> getPathToPosition(MTree mTree, int n, BaseDocument baseDocument) {
        Validate.notNull((Object)mTree);
        Validate.notNull((Object)baseDocument);
        Validate.isTrue((!mTree.isEmpty() ? 1 : 0) != 0);
        List<MTree.Node> list = MTreeUtils.getPathToPosition(mTree.getRoot(), n, baseDocument);
        if (list.isEmpty()) {
            list.add(mTree.getRoot());
        }
        return list;
    }

    private static List<MTree.Node> getPathToPosition(MTree.Node node, int n, BaseDocument baseDocument) {
        Vector<MTree.Node> vector = new Vector<MTree.Node>();
        List<MTree.Node> list = node.getListOfNextNodes();
        for (MTree.Node node2 : list) {
            if (!MTreeUtils.positionInsideNode(n, node2, baseDocument, true)) continue;
            vector.add(node2);
            vector.addAll(MTreeUtils.getPathToPosition(node2.getBody(), n, baseDocument));
        }
        return vector;
    }

    public static MTree.Node getNodeAtPosition(MTree mTree, int n, BaseDocument baseDocument, boolean bl) {
        Validate.notNull((Object)mTree);
        Validate.notNull((Object)baseDocument);
        MTree.Node node = mTree.getRoot();
        return MTreeUtils.getNodeAtPositionUnderNode(n, node, baseDocument, bl);
    }

    private static MTree.Node getNodeAtPositionUnderNode(int n, MTree.Node node, BaseDocument baseDocument, boolean bl) {
        List<MTree.Node> list = node.getListOfNextNodes();
        for (MTree.Node node2 : list) {
            if (!MTreeUtils.positionInsideNode(n, node2, baseDocument, bl)) continue;
            MTree.Node node3 = null;
            if (MTreeUtils.positionInsideNodeList(n, node2.getLeft(), baseDocument)) {
                node3 = MTreeUtils.getNodeAtPositionUnderNode(n, node2.getLeft(), baseDocument, bl);
            } else if (MTreeUtils.positionInsideNodeList(n, node2.getRight(), baseDocument)) {
                node3 = MTreeUtils.getNodeAtPositionUnderNode(n, node2.getRight(), baseDocument, bl);
            }
            return node3 == null ? node2 : node3;
        }
        return null;
    }

    private static boolean positionInsideNode(int n, MTree.Node node, BaseDocument baseDocument, boolean bl) {
        return MTreeUtils.getMinimumPosition(node, baseDocument) <= n && (bl ? MTreeUtils.getMaximumPosition(node, baseDocument) >= n : MTreeUtils.getMaximumPosition(node, baseDocument) > n);
    }

    private static boolean positionInsideNodeList(int n, MTree.Node node, BaseDocument baseDocument) {
        List<MTree.Node> list = node.getListOfNextNodes();
        return !list.isEmpty() && MTreeUtils.getMinimumPosition(list.get(0), baseDocument) <= n && MTreeUtils.getMaximumPosition(list.get(list.size() - 1), baseDocument) >= n;
    }

    public static Map<Integer, MTree.Node> getOtherNodesAndPositionsWithSameSymbolIndex(MTree mTree, MTree.Node node) {
        Validate.notNull((Object)mTree);
        Validate.notNull((Object)node);
        TreeMap<Integer, MTree.Node> treeMap = new TreeMap<Integer, MTree.Node>();
        if (node.getSymbolTableIndex() > 0) {
            for (MTree.Node node2 : mTree.findAsList(MTree.NodeType.ID)) {
                if (node2.getSymbolTableIndex() != node.getSymbolTableIndex()) continue;
                treeMap.put(node2.getPosition() - 1, node2);
            }
        }
        return treeMap;
    }

    public static List<MTree.Node> getOtherIDNodesWithDifferentSymbolIndex(MTree mTree, MTree.Node node) {
        Validate.notNull((Object)mTree);
        Validate.notNull((Object)node);
        ArrayList<MTree.Node> arrayList = new ArrayList<MTree.Node>();
        for (MTree.Node node2 : mTree.findAsList(MTree.NodeType.ID)) {
            if (node2.getSymbolTableIndex() == node.getSymbolTableIndex()) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static Collection<MTree.Node> getNodesOfTypeMatchingCondition(MTree mTree, MTree.NodeType nodeType, com.mathworks.util.Predicate<MTree.Node> predicate) {
        Validate.notNull((Object)mTree);
        Validate.notNull((Object)((Object)nodeType));
        Validate.notNull(predicate);
        ArrayList<MTree.Node> arrayList = new ArrayList<MTree.Node>();
        for (MTree.Node node : mTree.findAsList(nodeType)) {
            if (!predicate.accept((Object)node)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public static void dumpTree(MTree mTree) {
        int n = 0;
        Iterator<MTree.Node> iterator = mTree.iterator();
        while (iterator.hasNext()) {
            MTree.Node node;
            String string = "  ";
            for (MTree.Node node2 = node = iterator.next(); node2 != mTree.getRoot() && node2 != MTree.NULL_NODE; node2 = node2.getTrueParent()) {
                string = string.concat("  ");
            }
            assert (node != null);
            System.out.println(n++ + "=== " + string + " * " + (Object)((Object)node.getType()) + ": " + node.getStartLine() + "/" + node.getStartColumn() + " [" + node.getMinimumPosition() + "," + node.getMaximumPosition() + "]" + (node.isTextSupported() ? " (\"" + node.getText() + "\")" : "") + " (" + node.getSymbolTableIndex() + ": " + (Object)((Object)node.getAttribute()) + ")");
        }
    }
}

