/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.matlab.MatlabStateInfo;
import com.mathworks.widgets.text.matlab.MatlabTokenInfo;
import com.mathworks.widgets.text.mcode.MLexer;
import com.mathworks.widgets.text.mcode.MTokenContext;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;

public class MTokenUtils {
    private MTokenUtils() {
    }

    public static boolean isNewStyle(BaseDocument baseDocument) {
        int n = baseDocument.getLength();
        if (n == 0) {
            return false;
        }
        Utilities.MarkInfo markInfo = Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)(n - 1));
        if (markInfo == null) {
            return false;
        }
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n - 1));
            MatlabTokenInfo matlabTokenInfo = MLexer.getInstance().tokenizeLines(((MatlabStateInfo)markInfo.getStateInfo()).getMatlabState(), baseDocument.getText(n2, n - n2).toCharArray(), 0, n - n2);
            return MLexer.isNewStyle(matlabTokenInfo.getNewState());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return false;
        }
    }

    public static int getMLineEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        if (n2 < Utilities.getRowCount((BaseDocument)baseDocument) - 1) {
            int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n2 + 1));
            assert (n3 != -1);
            Utilities.MarkInfo markInfo = Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)n3);
            while (markInfo != null && markInfo.getStateInfo() != null && MLexer.getInstance().isLineContinuation(markInfo.getStateInfo())) {
                n = markInfo.getStartPos();
                int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(markInfo.getLineNum() + 1));
                if (n4 == -1) break;
                markInfo = Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)n4);
            }
        }
        return Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
    }

    public static int getMLineStart(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2;
        n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        assert (n != -1);
        Utilities.MarkInfo markInfo = Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)n);
        while (markInfo != null && markInfo.getStateInfo() != null && MLexer.getInstance().isLineContinuation(markInfo.getStateInfo()) && (n2 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(markInfo.getLineNum() - 1))) != -1) {
            n = n2;
            markInfo = Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)n2);
        }
        return n;
    }

    public static boolean isIdentifier(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        TokenItem tokenItem = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getTokenChain(n, n2);
        return tokenItem != null && tokenItem.getTokenID().getNumericID() == MTokenContext.IDENTIFIER.getNumericID();
    }
}

