/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab.comment;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.matlab.MatlabTokenUtils;
import com.mathworks.widgets.text.matlab.comment.CommentSection;
import com.mathworks.widgets.text.matlab.comment.CommentWrappingPreferences;
import com.mathworks.widgets.text.matlab.comment.Line;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTokenContext;
import com.mathworks.widgets.text.mcode.MTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.Utilities;

public class CommentWrappingUtils {
    private static final Pattern COMMENT_LINE_PATTERN = Pattern.compile("\\s*%+(?!(\\{|\\}))\\s*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapComments(JTextComponent jTextComponent) {
        Validate.notNull((Object)jTextComponent, (String)"'textComponent' cannot be null");
        Validate.isTrue((boolean)(jTextComponent.getDocument() instanceof BaseDocument), (String)("Must have a BaseDocument installed: " + jTextComponent.getDocument()));
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        try {
            baseDocument.atomicLock();
            boolean bl = jTextComponent.getSelectionEnd() != jTextComponent.getSelectionStart();
            List<CommentSection> list = CommentWrappingUtils.getCommentSections(jTextComponent);
            for (CommentSection commentSection : list) {
                commentSection.wrap();
            }
            if (!list.isEmpty() && bl) {
                jTextComponent.setSelectionStart(list.get(0).getStartPosition());
                jTextComponent.setSelectionEnd(list.get(list.size() - 1).getEndPosition());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    public static void autoWrapCommentLine(BaseDocument baseDocument, int n) {
        Validate.notNull((Object)baseDocument, (String)"'doc' cannot be null");
        Validate.isTrue((n >= 0 && n <= baseDocument.getLength() ? 1 : 0) != 0, (String)("offset is out of bounds: " + n));
        try {
            if (!CommentWrappingPreferences.isAutowrappingComments()) {
                return;
            }
            if (!CommentWrappingUtils.isDotAtEndOfLine(baseDocument, n)) {
                return;
            }
            if (!CommentWrappingUtils.isLineLongEnoughToBeWrapped(baseDocument, n)) {
                return;
            }
            String string = CommentWrappingUtils.getLineCommentPrefix(baseDocument, Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
            if (string != null) {
                CommentWrappingUtils.wrapLongLine(baseDocument, n, string);
            } else {
                CommentWrappingUtils.maybeWrapBlockComment(baseDocument, n);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private static void maybeWrapBlockComment(BaseDocument baseDocument, int n) throws BadLocationException {
        if (CommentWrappingUtils.isToken(baseDocument, n - 1, MTokenContext.BLKCOM) && !new Line(baseDocument, Utilities.getLineOffset((BaseDocument)baseDocument, (int)n)).isBlank()) {
            CommentWrappingUtils.wrapLongLine(baseDocument, n, CommentWrappingUtils.getWhitespacePrefix(baseDocument, n));
        }
    }

    public static List<CommentSection> getCommentSectionsInRange(JTextComponent jTextComponent, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        ArrayList<CommentSection> arrayList = new ArrayList<CommentSection>();
        int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
        int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
        arrayList.addAll(CommentWrappingUtils.identifyLineCommentSections(jTextComponent, baseDocument, n3, n4));
        arrayList.addAll(CommentWrappingUtils.identifyBlockCommentSections(jTextComponent, baseDocument, n3, n4));
        return arrayList;
    }

    private CommentWrappingUtils() {
    }

    private static List<CommentSection> getCommentSections(JTextComponent jTextComponent) throws BadLocationException {
        List<CommentSection> list;
        int n;
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        int n2 = jTextComponent.getSelectionStart();
        if (n2 != (n = jTextComponent.getSelectionEnd())) {
            if (Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                assert (n > 0) : "end should always be greater than zero: " + n;
                --n;
            }
            list = CommentWrappingUtils.getCommentSectionsInRange(jTextComponent, baseDocument, n2, n);
        } else {
            List<CommentSection> list2 = CommentWrappingUtils.getCommentSectionsInRange(jTextComponent, baseDocument, 0, baseDocument.getLength());
            CommentSection commentSection = null;
            for (CommentSection commentSection2 : list2) {
                if (!commentSection2.contains(n2)) continue;
                commentSection = commentSection2;
            }
            list = commentSection == null ? new ArrayList<CommentSection>() : Arrays.asList(commentSection);
        }
        return list;
    }

    private static List<LineCommentSection> identifyLineCommentSections(JTextComponent jTextComponent, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        MTree mTree = MDocumentUtils.getMTree(baseDocument);
        ArrayList<LineCommentSection> arrayList = new ArrayList<LineCommentSection>();
        LineCommentSection lineCommentSection = null;
        for (MTree.Node node : mTree.findAsList(MTree.NodeType.COMMENT, MTree.NodeType.CELL_TITLE)) {
            int n3;
            String string;
            int n4;
            if (node.getTrueParent() != null && node.getTrueParent().getType() == MTree.NodeType.BLOCK_COMMENT || (n4 = node.getStartLine() - 1) < n || n4 > n2 || (string = CommentWrappingUtils.getLineCommentPrefix(baseDocument, n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n4))) == null) continue;
            if (lineCommentSection != null && lineCommentSection.shouldGrow(node, string, CommentWrappingUtils.getLine(baseDocument, n3))) {
                lineCommentSection.grow(n3);
                continue;
            }
            lineCommentSection = new LineCommentSection(jTextComponent, string, n3);
            arrayList.add(lineCommentSection);
        }
        return arrayList;
    }

    private static List<CommentSection> identifyBlockCommentSections(JTextComponent jTextComponent, BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        MTree mTree = MDocumentUtils.getMTree(baseDocument);
        ArrayList<CommentSection> arrayList = new ArrayList<CommentSection>();
        for (MTree.Node node : mTree.findAsList(MTree.NodeType.BLOCK_COMMENT)) {
            int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)Math.max(node.getStartLine() - 1, n));
            int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)Math.min(node.getEndLine() - 1, n2)));
            if (n4 < n3) continue;
            arrayList.add(new BlockCommentSection(jTextComponent, n3, n4));
        }
        return arrayList;
    }

    static void wrapLongLine(BaseDocument baseDocument, int n, String string) throws BadLocationException {
        if (string.length() >= CommentWrappingUtils.getMaximumCommentWidthForLine(baseDocument, n)) {
            return;
        }
        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n3 = CommentWrappingUtils.getCommentBreakPosition(baseDocument, n2 + string.length());
        if (n3 == -1) {
            return;
        }
        int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        String string2 = baseDocument.getText(n3, n4 - n3);
        String string3 = '\n' + string + StringUtils.stripStart((String)string2, null);
        baseDocument.replace(n3, string2.length(), string3, null);
    }

    private static int getCommentBreakPosition(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        int n3 = CommentWrappingUtils.getMaximumCommentWidthForLine(baseDocument, n);
        int n4 = -1;
        boolean bl = false;
        for (int i = n2 - 1; i >= n; --i) {
            boolean bl2 = Character.isWhitespace(baseDocument.getChars(i, 1)[0]);
            if (bl && !bl2) break;
            if (!bl2) continue;
            n4 = i;
            if (Utilities.getVisualColumn((BaseDocument)baseDocument, (int)i) > n3) continue;
            bl = true;
        }
        return n4;
    }

    static boolean isLineLongEnoughToBeWrapped(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2;
        int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        return CommentWrappingUtils.getVisualWidth(baseDocument, n3, n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n)) > CommentWrappingUtils.getMaximumCommentWidthForLine(baseDocument, n);
    }

    private static int getMaximumCommentWidthForLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = CommentWrappingPreferences.getMaximumCommentWidth();
        if (CommentWrappingPreferences.isWrapFromStartOfComment()) {
            int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n4 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n3);
            int n5 = n4 == -1 ? 0 : CommentWrappingUtils.getVisualWidth(baseDocument, n3, n4);
            n2 += n5;
        }
        return n2;
    }

    private static int getVisualWidth(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        return Utilities.getVisualColumn((BaseDocument)baseDocument, (int)n2) - Utilities.getVisualColumn((BaseDocument)baseDocument, (int)n);
    }

    private static boolean isDotAtEndOfLine(BaseDocument baseDocument, int n) throws BadLocationException {
        return Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) == n;
    }

    private static String getLineCommentPrefix(BaseDocument baseDocument, int n) throws BadLocationException {
        String string = CommentWrappingUtils.getLine(baseDocument, n);
        Matcher matcher = COMMENT_LINE_PATTERN.matcher(string);
        String string2 = matcher.lookingAt() ? matcher.group() : null;
        return string2 != null && CommentWrappingUtils.isToken(baseDocument, Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n), MTokenContext.LINE_COMMENT) && string2.length() < string.length() && !StringUtils.stripStart((String)string2, null).startsWith("%% ") && string2.length() < CommentWrappingUtils.getMaximumCommentWidthForLine(baseDocument, n) ? string2 : null;
    }

    private static String getWhitespacePrefix(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n2);
        return baseDocument.getText(n2, n3 - n2);
    }

    private static boolean isCodepadBulletOrNumber(String string) {
        return string.startsWith("* ") || string.startsWith("# ");
    }

    private static String getLine(BaseDocument baseDocument, int n) throws BadLocationException {
        assert (n >= 0) : "Invalid position: " + n;
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        return baseDocument.getText(n, n2 - n);
    }

    private static boolean isToken(BaseDocument baseDocument, int n, BaseTokenID baseTokenID) throws BadLocationException {
        return n >= 0 && MatlabTokenUtils.getToken(baseDocument, n).getTokenID() == baseTokenID;
    }

    private static class BlockCommentSection
    extends CommentSection {
        private BlockCommentSection(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
            super(jTextComponent, CommentWrappingUtils.getWhitespacePrefix((BaseDocument)jTextComponent.getDocument(), n), n, n2);
        }

        @Override
        protected void doWrap() throws BadLocationException {
            ArrayList<Line> arrayList = new ArrayList<Line>();
            for (Line line : this.getCommentLines()) {
                if (line.isBlockCommentStartOrEnd() || line.isBlank()) {
                    this.wrapIfNotEmpty(arrayList);
                    arrayList.clear();
                    if (!line.isBlockCommentEnd()) continue;
                    String string = this.getCommentPrefix() + line.getText().substring(this.getPrefixToRemove(line).length());
                    this.getDocument().replace(line.getStartPosition(), line.getLength(), string, null);
                    continue;
                }
                arrayList.add(line);
            }
            this.wrapIfNotEmpty(arrayList);
        }

        @Override
        protected String getPrefixToRemove(Line line) throws BadLocationException {
            return CommentWrappingUtils.getWhitespacePrefix(this.getDocument(), line.getStartPosition());
        }

        private void wrapIfNotEmpty(List<Line> list) throws BadLocationException {
            if (!list.isEmpty()) {
                this.wrapLines(list);
            }
        }
    }

    private static final class LineCommentSection
    extends CommentSection {
        LineCommentSection(JTextComponent jTextComponent, String string, int n) throws BadLocationException {
            super(jTextComponent, string, n, Utilities.getRowEnd((BaseDocument)((BaseDocument)jTextComponent.getDocument()), (int)n));
        }

        private boolean shouldGrow(MTree.Node node, String string, String string2) throws BadLocationException {
            int n = Utilities.getLineOffset((BaseDocument)this.getDocument(), (int)this.getEndPosition());
            boolean bl = node.getStartLine() - 1 == n + 1;
            return bl && this.getCommentPrefix().equals(string) && !CommentWrappingUtils.isCodepadBulletOrNumber(string2.substring(string.length()));
        }

        private void grow(int n) throws BadLocationException {
            this.setEndPosition(n);
        }

        @Override
        protected void doWrap() throws BadLocationException {
            this.wrapLines(this.getCommentLines());
        }

        @Override
        protected String getPrefixToRemove(Line line) {
            return this.getCommentPrefix();
        }
    }
}

