/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.matlab.MatlabFormatter;
import com.mathworks.widgets.text.matlab.MatlabFunctionIndentingScheme;
import com.mathworks.widgets.text.matlab.MatlabLexer;
import com.mathworks.widgets.text.matlab.MatlabTokenManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;

public abstract class MatlabFormatSupport
extends ExtFormatSupport {
    private final MatlabTokenManager fManager;
    private final Map<TokenItem, TokenItem> fStatementCache;
    private final MatlabLexer fLexer;

    public MatlabFormatSupport(MatlabTokenManager matlabTokenManager, MatlabLexer matlabLexer, FormatWriter formatWriter) {
        super(formatWriter);
        this.fManager = matlabTokenManager;
        this.fLexer = matlabLexer;
        this.fStatementCache = new HashMap<TokenItem, TokenItem>();
    }

    public final boolean isComment(TokenItem tokenItem, int n) {
        return tokenItem != null && tokenItem.getTokenID() != null && tokenItem.getTokenContextPath() == this.getTokenContextPath() && this.fManager.isCommentToken(tokenItem.getTokenID());
    }

    protected abstract boolean isNestedFunction(TokenItem var1);

    protected abstract boolean isIndentableFunction(TokenItem var1);

    public final boolean canModifyWhitespace(TokenItem tokenItem) {
        return tokenItem.getTokenContextPath() == this.fManager.getTokenContextPath() && this.fManager.canModifyWhitespace(tokenItem.getTokenID());
    }

    public final TokenContextPath getWhitespaceTokenContextPath() {
        return this.getTokenContextPath();
    }

    public final boolean isInsideBlockComment(TokenItem tokenItem) {
        return tokenItem.getTokenContextPath() == this.getTokenContextPath() && this.fManager.isBlockCommentToken(tokenItem.getTokenID());
    }

    public final boolean isImportant(TokenItem tokenItem, int n) {
        FormatTokenPosition formatTokenPosition;
        assert (tokenItem != null) : "Token passed in cannot be null";
        if (this.isWhitespace(tokenItem, n) && !this.fManager.isCodepadToken(tokenItem.getTokenID())) {
            return false;
        }
        if (this.isBlockComment(tokenItem)) {
            return false;
        }
        return !this.isComment(tokenItem, n) || (formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem, n))).getToken() == tokenItem;
    }

    private boolean isInsideIndentableFunction(TokenItem tokenItem) {
        TokenItem tokenItem2 = this.getManager().findFunction(tokenItem, this.getStatementCache());
        return tokenItem2 != null && this.isIndentableFunction(tokenItem2);
    }

    private TokenItem findStatementStartForEnd(TokenItem tokenItem) {
        return this.fManager.findStatementStartForEnd(tokenItem, this.fStatementCache);
    }

    protected final boolean isIndentBlockStart(TokenID tokenID) {
        return this.fManager.isStatementBlockStart(tokenID) || this.fManager.isMidStatementStart(tokenID);
    }

    protected final MatlabTokenManager getManager() {
        return this.fManager;
    }

    protected final Map<TokenItem, TokenItem> getStatementCache() {
        return this.fStatementCache;
    }

    protected final int getIndentLevelBasedOnPos(TokenItem tokenItem) {
        FormatTokenPosition formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem, 0));
        if (formatTokenPosition.getToken() == tokenItem) {
            return this.getTokenIndent(tokenItem);
        }
        return this.findIndent(tokenItem, 0);
    }

    private boolean isBlockComment(TokenItem tokenItem) {
        TokenID tokenID = tokenItem.getTokenID();
        return this.isInsideBlockComment(tokenItem) || tokenItem.getTokenContextPath() == this.getTokenContextPath() && this.fManager.isBlockCommentStartOrEnd(tokenID);
    }

    public final FormatTokenPosition indentLine(FormatTokenPosition formatTokenPosition, int n) {
        int n2;
        BaseDocument baseDocument = (BaseDocument)this.getFormatWriter().getDocument();
        Utilities.MarkInfo markInfo = n != -1 ? Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)n) : null;
        int n3 = 0;
        if (markInfo != null && this.fLexer.isLineContinuation(markInfo.getStateInfo())) {
            Utilities.MarkInfo markInfo2 = null;
            if (markInfo.getStartPos() > 0) {
                markInfo2 = Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)(markInfo.getStartPos() - 1));
            }
            n2 = 1;
            if (markInfo2 != null && markInfo2.getLineNum() - 1 >= 0 && this.fLexer.isLineContinuation(markInfo2.getStateInfo())) {
                n2 = 0;
            }
            if (n2 != 0) {
                n3 = this.getShiftWidth();
            }
        } else if (markInfo != null && markInfo.getStateInfo() != null && !this.fLexer.isLineContinuation(markInfo.getStateInfo())) {
            try {
                boolean bl = false;
                while (!bl) {
                    n2 = Utilities.isRowWhite((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(markInfo.getLineNum() - 1))) ? 1 : 0;
                    n = markInfo.getStartPos();
                    markInfo = null;
                    if (n > 0) {
                        markInfo = Utilities.getLeftSyntaxMark((BaseDocument)baseDocument, (int)(n - 1));
                    }
                    if (markInfo != null && markInfo.getStateInfo() != null && this.fLexer.isLineContinuation(markInfo.getStateInfo())) {
                        n3 = -this.getShiftWidth();
                        bl = true;
                        continue;
                    }
                    if (n2 != 0 && markInfo != null) continue;
                    bl = true;
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
        FormatTokenPosition formatTokenPosition2 = this.findLineFirstNonWhitespace(formatTokenPosition);
        n2 = formatTokenPosition2 != null ? this.findIndent(formatTokenPosition2.getToken(), n3) : this.findIndent(formatTokenPosition.getToken(), n3);
        return this.changeLineIndent(formatTokenPosition, n2);
    }

    public final TokenID getWhitespaceTokenID() {
        return this.fManager.getWhitespaceToken();
    }

    private int findIndent(TokenItem tokenItem, int n) {
        FormatTokenPosition formatTokenPosition;
        TokenItem tokenItem2;
        int n2 = -1;
        if (tokenItem != null) {
            tokenItem2 = this.getManager().findStatementStartForMid(tokenItem, this.getStatementCache());
            if (tokenItem2 != null) {
                n2 = this.getIndentLevelBasedOnPos(tokenItem2);
                if (this.getManager().isSwitchToken(tokenItem2.getTokenID())) {
                    n2 += this.getShiftWidth();
                }
            } else if (this.getManager().isEndToken(tokenItem.getTokenID())) {
                formatTokenPosition = this.findStatementStartForEnd(tokenItem);
                if (formatTokenPosition != null) {
                    n2 = this.getIndentLevelBasedOnPos((TokenItem)formatTokenPosition);
                }
            } else if (this.getManager().isFunctionToken(tokenItem.getTokenID())) {
                if (this.isNestedFunction(tokenItem)) {
                    formatTokenPosition = this.getManager().findFunction(tokenItem, this.getStatementCache());
                    if (formatTokenPosition != null) {
                        n2 = this.getIndentLevelBasedOnPos((TokenItem)formatTokenPosition) + this.getShiftWidth();
                    }
                } else if (this.getFunctionIndentingType() == MatlabFunctionIndentingScheme.ALL && (formatTokenPosition = this.getManager().findFunction(tokenItem, this.getStatementCache())) != null) {
                    n2 = this.getIndentLevelBasedOnPos((TokenItem)formatTokenPosition);
                }
            }
        }
        if (n2 < 0) {
            tokenItem2 = this.findImportantToken(tokenItem, null, true);
            if (tokenItem2 != null) {
                formatTokenPosition = this.findLineFirstNonWhitespace(this.getPosition(tokenItem2, 0));
                if (this.getManager().isStatementBlockEnd(tokenItem2.getTokenID()) && tokenItem2 == formatTokenPosition.getToken()) {
                    TokenItem tokenItem3;
                    n2 = this.getTokenIndent(tokenItem2);
                    MatlabFunctionIndentingScheme matlabFunctionIndentingScheme = this.getFunctionIndentingType();
                    if (!(matlabFunctionIndentingScheme != MatlabFunctionIndentingScheme.MIXED && matlabFunctionIndentingScheme != MatlabFunctionIndentingScheme.CLASSIC || (tokenItem3 = this.findStatementStartForEnd(formatTokenPosition.getToken())) == null || !this.isNestedFunction(tokenItem3) || matlabFunctionIndentingScheme != MatlabFunctionIndentingScheme.CLASSIC && this.isInsideIndentableFunction(tokenItem3))) {
                        n2 -= this.getShiftWidth();
                    }
                } else if (formatTokenPosition != null) {
                    int n3 = 0;
                    MatlabFunctionIndentingScheme matlabFunctionIndentingScheme = this.getFunctionIndentingType();
                    TokenItem tokenItem4 = tokenItem2;
                    while (tokenItem4 != null) {
                        tokenItem2 = tokenItem4;
                        if (this.isIndentBlockStart(tokenItem2.getTokenID())) {
                            if (!this.getManager().isFunctionToken(tokenItem2.getTokenID()) || matlabFunctionIndentingScheme == MatlabFunctionIndentingScheme.ALL || this.isIndentableFunction(tokenItem2) && matlabFunctionIndentingScheme == MatlabFunctionIndentingScheme.MIXED) {
                                if (tokenItem2 == formatTokenPosition.getToken()) {
                                    ++n3;
                                } else if (this.getManager().isStatementBlockStart(tokenItem2.getTokenID())) {
                                    ++n3;
                                }
                            }
                        } else if (this.getManager().isStatementBlockEnd(tokenItem2.getTokenID()) && tokenItem2 != formatTokenPosition.getToken()) {
                            TokenItem tokenItem5;
                            --n3;
                            if (this.getFunctionIndentingType() == MatlabFunctionIndentingScheme.MIXED && (tokenItem5 = this.findStatementStartForEnd(tokenItem2)) != null && this.isNestedFunction(tokenItem5) && !this.isInsideIndentableFunction(tokenItem5)) {
                                --n3;
                            }
                        }
                        tokenItem4 = this.findImportantToken(tokenItem2, formatTokenPosition.getToken(), true);
                    }
                    n2 = this.getTokenIndent(tokenItem2) + n3 * this.getShiftWidth();
                }
            }
            n2 += n;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    private MatlabFunctionIndentingScheme getFunctionIndentingType() {
        MatlabFunctionIndentingScheme matlabFunctionIndentingScheme = ((MatlabFormatter)this.getFormatWriter().getFormatter()).getFunctionIndentingType();
        assert (matlabFunctionIndentingScheme != null) : "Should always return an indenting scheme";
        return matlabFunctionIndentingScheme;
    }

    private TokenContextPath getTokenContextPath() {
        return this.fManager.getTokenContextPath();
    }

    private int getTokenIndent(TokenItem tokenItem) {
        FormatTokenPosition formatTokenPosition = this.getPosition(tokenItem, 0);
        FormatTokenPosition formatTokenPosition2 = this.findLineFirstNonWhitespace(formatTokenPosition);
        if (formatTokenPosition2 != null) {
            formatTokenPosition = formatTokenPosition2;
        }
        return this.getVisualColumnOffset(formatTokenPosition);
    }
}

