/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.matlab;

import com.mathworks.util.Log;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.text.MWCaret;
import com.mathworks.widgets.text.matlab.MatlabTokenManager;
import com.mathworks.widgets.text.matlab.MatlabTokenUtils;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;

public final class MatlabCaret
extends MWCaret {
    private final MatlabTokenManager fManager;

    public MatlabCaret(MatlabTokenManager matlabTokenManager, Tokenizer tokenizer) {
        this.setDelimiterMatchingTokenizer(tokenizer);
        this.fManager = matlabTokenManager;
    }

    @Override
    protected final boolean isStartDelimiter(char c, int n) {
        if (super.isStartDelimiter(c, n)) {
            return true;
        }
        try {
            assert (n < this.component.getDocument().getLength() && n >= 0) : "Position is out of range for document: " + n;
            return this.isStatementBlockStart(n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return false;
        }
    }

    @Override
    protected final boolean isEndDelimiter(char c, int n) {
        if (super.isEndDelimiter(c, n)) {
            return true;
        }
        assert (n < this.component.getDocument().getLength() && n >= 0) : "Position is out of range for document: " + n;
        try {
            return this.isMatchingEnd(n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return false;
        }
    }

    @Override
    protected final int[] getDelimiterMatchMarkPositions(int n, int[] nArray) {
        return this.getDelimiterMatchPositions(n, nArray[1] - nArray[0] > 1);
    }

    @Override
    protected final int[] getDelimiterMisMatchMarkPositions(int n, char c) {
        return this.getDelimiterMatchPositions(n, Character.isLetter(c));
    }

    private boolean isStatementBlockStart(int n) throws BadLocationException {
        TokenID tokenID = MatlabTokenUtils.getTokenID((BaseDocument)this.component.getDocument(), n);
        return this.fManager.isStatementBlockStart(tokenID) && !this.fManager.isFunctionWithoutEnd(tokenID, (BaseDocument)this.component.getDocument());
    }

    private int[] getDelimiterMatchPositions(int n, boolean bl) {
        int n2 = n - 1;
        int n3 = n;
        if (bl) {
            int n4 = MatlabCaret.getWordStart(this.component, n);
            n2 = MatlabCaret.getWordStart(this.component, n2);
            n2 = n4 < n ? n4 : n2;
            int n5 = MatlabCaret.getWordEnd(this.component, Math.max(0, n3 - 1));
            n3 = MatlabCaret.getWordEnd(this.component, n3);
            n3 = n5 >= n ? n5 : n3;
        }
        return new int[]{n2, n3};
    }

    private boolean isMatchingEnd(int n) throws BadLocationException {
        TokenID tokenID = MatlabTokenUtils.getTokenID((BaseDocument)this.component.getDocument(), n);
        return this.fManager.isMidStatementStart(tokenID) || this.fManager.isStatementBlockEnd(tokenID);
    }
}

