/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.layer;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.LightButton;
import com.mathworks.widgets.LightScrollPane;
import com.mathworks.widgets.text.layer.LayerUtils;
import com.mathworks.widgets.tooltip.BalloonToolTip;
import com.mathworks.widgets.tooltip.TooltipUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;

public class EditorTip {
    private static final int MESSAGE_ROW_PADDING = 2;
    private static final String TIP_COL_SPEC = "2dlu, p, 2dlu, p:grow, 2dlu, p, 2dlu, p, 2dlu";
    private static final String SHORT_ROW_SPEC = "p, 2dlu, ";
    private static final String EXTENDED_MESSAGE_ROW_SPEC = "2dlu, p, p:grow";
    private static final String LAST_SHORT_ROW_SPEC = "p";
    private static final int BULLET_COLUMN = 2;
    private static final int MESSAGE_COLUMN = 4;
    private static final int DETAILS_BUTTON_COLUMN = 6;
    private static final int ACTION_BUTTON_COLUMN = 8;
    private static final int NUMBER_OF_COLUMNS = 9;
    private static final String MATLAB_COMMAND = "matlab";
    public static final String TIP_DIALOG_NAME = "EditorTip.Dialog";
    public static final String TIP_DIALOG_STRING = "EditorTip.Dialog.String";
    private static final Dimension MAX_EXTENDED_CONTENT_SIZE = new JTextArea("", 15, 80).getPreferredSize();
    private static final int WINDOW_MOUSE_MOVE_BUFFER = 8;
    private static final ResourceBundle BUNDLE = LayerUtils.getBundle();
    public static final String TIP_EXPANDED_MESSAGE_PANE_NAME = "EditorTipExpandedMessagePane";
    public static final String TIP_ACTION_BUTTON = "TipActionButton";
    public static final String TIP_DETAILS_BUTTON = "TipDetailsButton";
    private static HyperlinkTextLabel.HyperlinkStatusBarHandler sSBHandler;
    private static CommandHelper sCommandHelper;
    private BalloonToolTip fBalloon;
    private List<EditorMessage> fMessages;
    private final Rectangle fTargetBounds;
    private HyperlinkTextLabel fExpandedMessageContainer;
    private final MEditorTipStrategy fStrategy;
    private final Point fToolTipCornerLocation;
    private Dimension fPreviousSize;
    private Integer fSelectedMessage;
    private boolean fButtonDown;
    private PanelBuilder fWholeTipContentPanelBuilder;
    private final Window fParent;

    public EditorTip(Component component, MEditorTipStrategy mEditorTipStrategy, List<? extends EditorMessage> list, Rectangle rectangle) {
        this(component, mEditorTipStrategy, list, rectangle, null);
    }

    public EditorTip(Component component, MEditorTipStrategy mEditorTipStrategy, List<? extends EditorMessage> list, Rectangle rectangle, Point point) {
        Validate.notNull((Object)mEditorTipStrategy, (String)"Tip strategy cannot be null.");
        Validate.notNull((Object)rectangle, (String)"Tip target bounds cannot be null.");
        Validate.notNull(list, (String)"Tip messages cannot be null.");
        this.fParent = SwingUtilities.windowForComponent(component);
        this.fStrategy = mEditorTipStrategy;
        this.fTargetBounds = rectangle;
        this.fMessages = Collections.unmodifiableList(list);
        this.fToolTipCornerLocation = point;
    }

    public void updateTip(List<? extends EditorMessage> list) {
        this.fMessages = Collections.unmodifiableList(list);
        if (this.fBalloon != null) {
            this.fBalloon.setNewContent(this.makeWholeTipComponentWithoutExtendedMessage(), true, true);
        }
    }

    private void setupBalloonTip() {
        assert (this.fBalloon == null) : "Only one balloon per tip.";
        Component component = this.makeWholeTipComponentWithoutExtendedMessage();
        if (this.fParent instanceof Frame) {
            this.fBalloon = new EditorTipBalloon((Frame)this.fParent, component);
        } else if (this.fParent instanceof Dialog) {
            this.fBalloon = new EditorTipBalloon((Dialog)this.fParent, component);
        }
        this.fBalloon.getDialog().setName(TIP_DIALOG_NAME);
    }

    private Component makeWholeTipComponentWithoutExtendedMessage() {
        Component component = this.makeWholeTipComponent(false);
        this.fPreviousSize = component.getPreferredSize();
        return component;
    }

    private Component makeWholeTipComponent(boolean bl) {
        assert (this.fMessages.size() >= 1) : "Can't build a Tooltip message box with no messages.";
        MJPanel mJPanel = new MJPanel();
        mJPanel.setOpaque(false);
        FormLayout formLayout = this.makeFormLayoutForTip();
        this.fWholeTipContentPanelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        this.fWholeTipContentPanelBuilder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.addShortMessageComponentsToPanel();
        if (bl) {
            this.addExtendedMessageComponentsToPanel((JPanel)mJPanel);
        }
        mJPanel.setOpaque(true);
        mJPanel.setBackground(TooltipUtils.getTooltipBackground());
        return mJPanel;
    }

    private void addShortMessageComponentsToPanel() {
        int n = this.fMessages.size();
        for (int i = 0; i < n; ++i) {
            this.makeSingleMessageRow(i);
        }
    }

    private FormLayout makeFormLayoutForTip() {
        String string = this.fSelectedMessage != null ? this.makeRowSpecWithExtendedMessage() : this.makeRowSpecForShortMessages();
        return new FormLayout(TIP_COL_SPEC, string);
    }

    private String makeRowSpecWithExtendedMessage() {
        return this.makeRowSpecForShortMessages() + ", " + EXTENDED_MESSAGE_ROW_SPEC;
    }

    private String makeRowSpecForShortMessages() {
        int n = this.fMessages.size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.repeat((String)SHORT_ROW_SPEC, (int)(n - 1)));
        stringBuilder.append(LAST_SHORT_ROW_SPEC);
        return stringBuilder.toString();
    }

    private void addExtendedMessageComponentsToPanel(JPanel jPanel) {
        int n = this.fMessages.size() * 2 + 2;
        this.addSeparator(n - 1);
        this.addExtendedMessage(jPanel, n);
    }

    private void highlightSelectedRow(int n) {
        MJLabel mJLabel = new MJLabel();
        mJLabel.setOpaque(true);
        mJLabel.setBackground(UIManager.getColor("Table.selectionBackground"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fWholeTipContentPanelBuilder.add((Component)mJLabel, cellConstraints.xyw(1, n, 9, "fill,fill"));
    }

    private boolean isSelectedMessage(int n) {
        return this.fSelectedMessage != null && this.fSelectedMessage.equals(n);
    }

    private void addExtendedMessage(JPanel jPanel, int n) {
        assert (this.isExpanded()) : "The hyperlink text label should be non-null to display";
        int n2 = this.fPreviousSize.width - 2 * Sizes.dialogUnitXAsPixel((int)2, (Component)jPanel);
        int n3 = this.fPreviousSize.height;
        Rectangle rectangle = WindowUtils.getScreenBounds();
        int n4 = Math.min(EditorTip.MAX_EXTENDED_CONTENT_SIZE.height, rectangle.height - n3);
        this.fExpandedMessageContainer.constrainSize(n2, n4);
        CellConstraints cellConstraints = new CellConstraints();
        this.fWholeTipContentPanelBuilder.add((Component)this.fExpandedMessageContainer.getComponent(), cellConstraints.xyw(1, n, 9, "fill, fill"));
    }

    private void addSeparator(int n) {
        JSeparator jSeparator = new JSeparator();
        CellConstraints cellConstraints = new CellConstraints();
        this.fWholeTipContentPanelBuilder.add((Component)jSeparator, cellConstraints.xyw(1, n, 9, "fill, fill"));
    }

    private void makeSingleMessageRow(int n) {
        EditorMessage editorMessage = this.fMessages.get(n);
        Font font = TooltipUtils.getTooltipFont();
        Icon icon = editorMessage.getIcon(font.getSize());
        JLabel jLabel = new JLabel(icon);
        FontMetrics fontMetrics = jLabel.getFontMetrics(font);
        jLabel.setPreferredSize(new Dimension(jLabel.getPreferredSize().width, fontMetrics.getHeight()));
        CellConstraints cellConstraints = new CellConstraints();
        int n2 = n * 2 + 1;
        this.fWholeTipContentPanelBuilder.add((Component)jLabel, cellConstraints.xy(2, n2, "fill,top"));
        this.fWholeTipContentPanelBuilder.add((Component)this.makeMessageText(editorMessage, n), cellConstraints.xy(4, n2, "fill,fill"));
        this.makeButtonPanel(editorMessage, n, n2);
        if (this.isSelectedMessage(n) && this.hasMultipleMessages()) {
            this.highlightSelectedRow(n2);
        }
    }

    private void makeButtonPanel(EditorMessage editorMessage, final int n, int n2) {
        if (editorMessage.isExtendable()) {
            final boolean bl = this.isSelectedMessage(n);
            LightButton lightButton = new LightButton();
            lightButton.setName(TIP_DETAILS_BUTTON + n);
            MJAbstractAction mJAbstractAction = new MJAbstractAction(BUNDLE.getString("tooltip.details")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl) {
                        EditorTip.this.shrink();
                    } else {
                        EditorTip.this.doExpand(n);
                    }
                }
            };
            mJAbstractAction.setButtonOnlyIcon((Icon)(bl ? MiscellaneousIcon.OPEN_ARROW.getIcon() : MiscellaneousIcon.CLOSE_ARROW.getIcon()));
            lightButton.setAction((Action)mJAbstractAction);
            lightButton.setToolTipText(null);
            this.addButtonToTipPanel((JComponent)((Object)lightButton), editorMessage.hasExtendedInformation(), n2, 6);
        }
        if (editorMessage.isActionable()) {
            JComponent jComponent = this.getActionButton(editorMessage);
            jComponent.setName(TIP_ACTION_BUTTON + n);
            this.addButtonToTipPanel(jComponent, editorMessage.hasTooltipAction(), n2, 8);
        }
    }

    private void addButtonToTipPanel(JComponent jComponent, boolean bl, int n, int n2) {
        jComponent.setEnabled(bl);
        if (jComponent.isEnabled() || this.hasMultipleMessages()) {
            this.fWholeTipContentPanelBuilder.add((Component)jComponent, new CellConstraints().xy(n2, n, "fill,fill"));
        }
    }

    public static void preInit() {
        MJFrame mJFrame = new MJFrame();
        mJFrame.setPreferredSize(new Dimension(100, 100));
        BalloonToolTip balloonToolTip = new BalloonToolTip((Frame)mJFrame, (Component)new MJLabel(""), BalloonToolTip.EAST_WEST, new Dimension(10, 10), mJFrame.getBounds());
        balloonToolTip.show();
        mJFrame.dispose();
    }

    private JComponent getActionButton(EditorMessage editorMessage) {
        assert (editorMessage.getTooltipAction() != null) : "Should not call getActionButton unless message supports an action.";
        LightButton lightButton = new LightButton((Action)new ChildAction(editorMessage.getTooltipAction()){

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                EditorTip.this.cleanup();
            }
        });
        ((JComponent)((Object)lightButton)).setFont(TooltipUtils.getTooltipFont());
        return lightButton;
    }

    private JComponent makeMessageText(EditorMessage editorMessage, int n) {
        String string = this.fStrategy.formatMessage(editorMessage);
        MJLabel mJLabel = new MJLabel("<html>" + string + "</html>", false);
        mJLabel.setName(TIP_DIALOG_STRING);
        mJLabel.setFont(TooltipUtils.getTooltipFont());
        boolean bl = this.isSelectedMessage(n) && this.hasMultipleMessages();
        Color color = bl ? UIManager.getColor("Table.selectionForeground") : TooltipUtils.getTooltipFontColor();
        mJLabel.setForeground(color);
        return mJLabel;
    }

    private static void installStatusBarHandler(HyperlinkTextLabel hyperlinkTextLabel) {
        if (sSBHandler != null) {
            hyperlinkTextLabel.setStatusBarHandler(sSBHandler);
        }
    }

    private boolean hasMultipleMessages() {
        return this.fMessages.size() > 1;
    }

    public List<EditorMessage> getMessages() {
        return new ArrayList<EditorMessage>(this.fMessages);
    }

    public static void setCommandHelper(CommandHelper commandHelper) {
        sCommandHelper = commandHelper;
    }

    public void show() {
        this.setupBalloonTip();
        assert (this.fBalloon != null) : "Once again, the tip should be valid";
        this.fBalloon.show();
    }

    public void hide() {
        assert (this.fBalloon != null) : "Once again, the tip should be valid";
        this.fBalloon.hide();
    }

    public void cleanup() {
        if (this.fBalloon != null) {
            this.fBalloon.cleanup();
        }
    }

    public boolean containsScreenPoint(Point point) {
        boolean bl = false;
        if (this.fBalloon != null) {
            Rectangle rectangle = this.fBalloon.getBounds();
            rectangle.x -= 8;
            rectangle.y -= 8;
            rectangle.height += 16;
            rectangle.width += 16;
            bl = rectangle.contains(point);
        }
        return bl;
    }

    public void expand() {
        if (!this.isExpanded()) {
            for (int i = 0; i < this.fMessages.size(); ++i) {
                if (!this.fMessages.get(i).hasExtendedInformation()) continue;
                this.doExpand(i);
                break;
            }
        }
    }

    public void shrink() {
        if (!this.isExpanded()) {
            throw new IllegalStateException("Tip must be expanded before shrinking");
        }
        this.fSelectedMessage = null;
        this.fExpandedMessageContainer = null;
        this.fBalloon.setNewContent(this.makeWholeTipComponentWithoutExtendedMessage(), true);
    }

    public boolean forwardStroke(ActionEvent actionEvent, String string) {
        boolean bl = false;
        for (EditorMessage object : this.fMessages) {
            if (!object.hasTooltipAction() || !string.equals(object.getTooltipAction().getValue("Name"))) continue;
            object.getTooltipAction().actionPerformed(actionEvent);
            bl = true;
        }
        if (this.isExpanded() && !bl) {
            JTextComponent jTextComponent = this.fExpandedMessageContainer.getHTMLPane();
            if (string.equals("caret-up")) {
                string = "page-up";
            }
            if (string.equals("caret-down")) {
                string = "page-down";
            }
            actionEvent.setSource(jTextComponent);
            Action action = jTextComponent.getActionMap().get(string);
            if (action != null) {
                action.actionPerformed(actionEvent);
                bl = true;
            }
        }
        return bl;
    }

    public boolean isExpanded() {
        return this.fSelectedMessage != null;
    }

    public Window getTipFrame() {
        return this.fBalloon.getDialog();
    }

    public boolean isScrolling() {
        return this.fButtonDown;
    }

    public static void setStatusBarHelper(HyperlinkTextLabel.HyperlinkStatusBarHandler hyperlinkStatusBarHandler) {
        sSBHandler = hyperlinkStatusBarHandler;
    }

    private void doExpand(int n) {
        this.makeExpandedHTMLMessageBox(n);
        this.fSelectedMessage = n;
        this.fBalloon.setNewContent(this.makeWholeTipComponent(true));
    }

    private void makeExpandedHTMLMessageBox(int n) {
        String string = this.fMessages.get(n).getExtendedInformation();
        if (string == null) {
            string = BUNDLE.getString("tooltip.noExpandedMessage");
        }
        this.fExpandedMessageContainer = new HyperlinkTextLabel(string, new ExpandedTipHyperlinkHelper(), true){

            @Override
            protected JEditorPane makeEditorPane() {
                MJEditorPane mJEditorPane = new MJEditorPane();
                MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)mJEditorPane, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABEditor");
                mJEditorPane.setName(EditorTip.TIP_EXPANDED_MESSAGE_PANE_NAME);
                return mJEditorPane;
            }

            @Override
            protected JScrollPane makeScrollPane(JComponent jComponent) {
                return new LightScrollPane(jComponent){

                    @Override
                    public JScrollBar createVerticalScrollBar() {
                        JScrollBar jScrollBar = super.createVerticalScrollBar();
                        jScrollBar.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mousePressed(MouseEvent mouseEvent) {
                                super.mousePressed(mouseEvent);
                                EditorTip.this.fButtonDown = true;
                            }

                            @Override
                            public void mouseReleased(MouseEvent mouseEvent) {
                                super.mouseReleased(mouseEvent);
                                EditorTip.this.fButtonDown = false;
                            }
                        });
                        return jScrollBar;
                    }
                };
            }
        };
        this.fExpandedMessageContainer.scrollToTop();
        this.fExpandedMessageContainer.setFont(TooltipUtils.getTooltipHtmlFont());
        this.fExpandedMessageContainer.setFontColor(TooltipUtils.getTooltipFontColor());
        int n2 = 3;
        this.fExpandedMessageContainer.getScrollPane().setBorder(BorderFactory.createEmptyBorder(n2, n2, 0, 0));
        EditorTip.installStatusBarHandler(this.fExpandedMessageContainer);
    }

    public void notifyMouseWheelListeners(MouseWheelEvent mouseWheelEvent) {
        if (this.isExpanded()) {
            for (MouseWheelListener mouseWheelListener : this.fExpandedMessageContainer.getComponent().getMouseWheelListeners()) {
                mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
            }
        }
    }

    public void clickedInside(MouseEvent mouseEvent) {
        if (this.isExpanded()) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.fExpandedMessageContainer.getComponent());
            if (this.fExpandedMessageContainer.getComponent().getBounds().contains(point)) {
                this.fBalloon.setFocusableWindowState(true);
            }
        }
    }

    public static interface MEditorTipStrategy {
        public String formatMessage(EditorMessage var1);

        public List<BalloonToolTip.ArrowDirection> getPossiblePositions();
    }

    public static interface CommandHelper {
        public void runMatlabCommand(String var1);
    }

    private class EditorTipBalloon
    extends BalloonToolTip {
        private EditorTipBalloon(Frame frame, Component component) {
            super(frame, component, EditorTip.this.fStrategy.getPossiblePositions(), MAX_EXTENDED_CONTENT_SIZE, EditorTip.this.fTargetBounds, EditorTip.this.fToolTipCornerLocation);
        }

        private EditorTipBalloon(Dialog dialog, Component component) {
            super(dialog, component, EditorTip.this.fStrategy.getPossiblePositions(), MAX_EXTENDED_CONTENT_SIZE, EditorTip.this.fTargetBounds, EditorTip.this.fToolTipCornerLocation);
        }

        @Override
        public void cleanup() {
            super.cleanup();
            EditorTip.this.fBalloon = null;
            EditorTip.this.cleanup();
        }
    }

    private class ExpandedTipHyperlinkHelper
    implements HyperlinkTextLabel.HyperlinkHandler {
        private ExpandedTipHyperlinkHelper() {
        }

        @Override
        public void processHyperlink(String string) {
            String[] stringArray = string.split(":");
            assert (stringArray.length > 1 && stringArray[0].equals(EditorTip.MATLAB_COMMAND)) : "Command text should be of the form matlab:<command>";
            sCommandHelper.runMatlabCommand(string.substring(EditorTip.MATLAB_COMMAND.length() + 1));
            EditorTip.this.cleanup();
        }
    }
}

