/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.format;

import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.data.ComplexFloatingPointScalar;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarDouble;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarFactory;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarFloat;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;
import java.util.HashMap;
import java.util.Locale;

class PrintMat {
    private static final int FORMAT_SHORT = 0;
    private static final int FORMAT_LONG = 1;
    private static final int FORMAT_SHORT_E = 2;
    private static final int FORMAT_LONG_E = 3;
    private static final int FORMAT_SHORT_G = 4;
    private static final int FORMAT_LONG_G = 5;
    private static final int FORMAT_BANK = 7;
    private static final int FORMAT_SHORT_ENG = 11;
    private static final int FORMAT_LONG_ENG = 12;
    private static final int TYPE_SHORT_INT = 0;
    private static final int TYPE_LONG_INT = 1;
    private static final int TYPE_NON_COMPLEX = 2;
    private static final int TYPE_REAL = 3;
    private static final int TYPE_IMAG = 4;
    private static final int TYPE_SINGLE = 5;
    private static final int TYPE_SINGLE_REAL = 6;
    private static final int TYPE_SINGLE_IMAG = 7;
    private static final int TYPE_SINGLE_UNIX = 8;
    private static final int TYPE_SINGLE_REAL_UNIX = 9;
    private static final int TYPE_SINGLE_IMAG_UNIX = 10;
    private static final String[][] FTABLE = new String[][]{{"%6d", "%12d", "%10.4f", "%9.4f", "%7.4f", "%10.4f", "%9.4f", "%7.4f", "%10.4f", "%9.4f", "%7.4f"}, {"%6d", "%12d", "%20.15f", "%19.15f", "%18.15f", "%12.7f", "%11.7f", "%10.7f", "%12.7f", "%11.7f", "%10.7f"}, {"%6d", "%12d", "%13.4e", "%13.4e", "%11.4e", "%13.4e", "%13.4e", "%11.4e", "%12.4e", "%12.4e", "%10.4e"}, {"%6d", "%12d", "%26.15e", "%27.15e", "%22.15e", "%17.7e", "%16.7e", "%15.7e", "%16.7e", "%15.7e", "%14.7e"}, {"%6d", "%12d", "%13.5g", "%13.5g", "%11.5g", "%14.5g", "%13.5g", "%12.5g", "%13.5g", "%12.5g", "%11.5g"}, {"%6d", "%12d", "%26.15g", "%27.15g", "%22.15g", "%18.8g", "%15.7g", "%14.7g", "%17.8g", "%14.7g", "%13.7g"}, {"   %08lx%08lx", "   %08lx%08lx", "   %08lx%08lx", "   %08lx%08lx", "   %08lx%08lx", "", "", "", "", "", ""}, {" %13.2f", " %13.2f", " %13.2f", " %13.2f", "", " %13.2f", " %13.2f", "", " %13.2f", " %13.2f", ""}, {"", "", "", "", "", "", "", "", "", "", ""}, {"%6d", "%12d", "%13.4e", "%13.4e", "%11.4e", "%13.4e", "%13.4e", "%11.4e", "%13.4e", "%13.4e", "%10.4e"}, {"%6d", "%12d", "%10.4f", "%9.4f", "%7.4f", "%10.4f", "%9.4f", "%7.4f", "%10.4f", "%9.4f", "%7.4f"}, {"", "", "", "", "", "", "", "", "", "", ""}, {"", "", "", "", "", "", "", "", "", "", ""}};
    private static final int TABLE_LENGTH = FTABLE[0].length;
    private static final String[] short_int_format_string = new String[TABLE_LENGTH];
    private static final String[] long_int_format_string = new String[TABLE_LENGTH];
    private static final String[] non_complex_format_string = new String[TABLE_LENGTH];
    private static final String[] complex_real_format_string = new String[TABLE_LENGTH];
    private static final String[] complex_imag_format_string = new String[TABLE_LENGTH];
    private static final String[] single_non_complex_string = new String[TABLE_LENGTH];
    private static final String[] single_complex_real_string = new String[TABLE_LENGTH];
    private static final String[] single_complex_imag_string = new String[TABLE_LENGTH];
    private static HashMap<ScalarFormatPair, String> sFormatPairStringHashMap;

    private PrintMat() {
    }

    public static String format(Number number, FormatIdentifier formatIdentifier) {
        if (!FormatUtils.isFloatingPointType(number)) {
            return FormatUtils.formatAsIntegral(number);
        }
        return PrintMat.format(ComplexScalarFactory.valueOf(number), formatIdentifier);
    }

    public static String format(ComplexScalar complexScalar, FormatIdentifier formatIdentifier) {
        return PrintMat.format(complexScalar, PrintMat.getFormatKey(formatIdentifier));
    }

    private static int getFormatKey(FormatIdentifier formatIdentifier) {
        switch (formatIdentifier) {
            case SHORT: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case SHORT_E: {
                return 2;
            }
            case LONG_E: {
                return 3;
            }
            case SHORT_G: {
                return 4;
            }
            case LONG_G: {
                return 5;
            }
            case BANK: {
                return 7;
            }
            case SHORT_ENG: {
                return 11;
            }
            case LONG_ENG: {
                return 12;
            }
            case RATIONAL: 
            case PLUS: {
                throw new IllegalArgumentException("Cannot pass FormatIdentifier " + (Object)((Object)formatIdentifier) + " to format()");
            }
        }
        return -1;
    }

    private static String format(ComplexScalar complexScalar, int n) {
        ScalarFormatPair scalarFormatPair = new ScalarFormatPair(complexScalar, n);
        String string = null;
        if (scalarFormatPair.willCache() && sFormatPairStringHashMap.containsKey(scalarFormatPair)) {
            string = sFormatPairStringHashMap.get(scalarFormatPair);
        }
        if (string == null) {
            string = PrintMat.doFormat(complexScalar, n);
        }
        if (scalarFormatPair.willCache() && !sFormatPairStringHashMap.containsKey(scalarFormatPair)) {
            sFormatPairStringHashMap.put(scalarFormatPair, string);
        }
        return string;
    }

    private static String doFormat(ComplexScalar complexScalar, int n) {
        int n2;
        if (n == 11 || n == 12) {
            return PrintMat.formatEng(complexScalar, n);
        }
        int n3 = n + 1;
        int n4 = n3 - 1;
        boolean bl = !complexScalar.isReal();
        double d = Math.abs(complexScalar.doubleValueReal());
        if (bl) {
            d = Math.max(d, Math.abs(complexScalar.doubleValueImaginary()));
        }
        int n5 = 2;
        if (bl) {
            n5 = 3;
        } else if (Math.floor(complexScalar.doubleValueReal()) == complexScalar.doubleValueReal()) {
            n5 = 1;
        }
        if (d != 0.0) {
            d = Math.log10(d);
        }
        if ((n2 = (int)d) >= -2 && n2 <= 1 || n2 == 2 && n3 == 1 && n5 == 2) {
            n2 = 0;
        }
        int n6 = 0;
        if (n5 == 1 && n2 > 8) {
            n5 = 2;
        }
        if ((n6 = n4) == 10) {
            n6 = 0;
        }
        if (n2 != 0 && n6 < 2 && n5 != 1) {
            n6 += 2;
        }
        String string = "";
        String string2 = "";
        switch (n5) {
            case 1: {
                if (n6 == 0) {
                    string = short_int_format_string[n6];
                    break;
                }
                string = long_int_format_string[n6];
                break;
            }
            case 2: {
                if (!(complexScalar instanceof ComplexScalarFloat)) {
                    string = non_complex_format_string[n6];
                    break;
                }
                string = single_non_complex_string[n6];
                break;
            }
            case 3: {
                if (!(complexScalar instanceof ComplexScalarFloat)) {
                    string = complex_real_format_string[n6];
                    string2 = complex_imag_format_string[n6];
                    break;
                }
                string = single_complex_real_string[n6];
                string2 = single_complex_imag_string[n6];
            }
        }
        if (complexScalar instanceof ComplexScalarDouble) {
            ComplexScalarDouble complexScalarDouble = (ComplexScalarDouble)complexScalar;
            if (complexScalarDouble.isReal()) {
                return FormatUtils.format(complexScalarDouble.doubleValueReal(), string).trim();
            }
            return FormatUtils.format(complexScalarDouble.doubleValueReal(), string, complexScalarDouble.doubleValueImaginary(), string2).trim();
        }
        if (complexScalar instanceof ComplexScalarFloat) {
            ComplexScalarFloat complexScalarFloat = (ComplexScalarFloat)complexScalar;
            if (complexScalarFloat.isReal()) {
                return FormatUtils.format(Float.valueOf(complexScalarFloat.floatValueReal()), string).trim();
            }
            return FormatUtils.format(Float.valueOf(complexScalarFloat.floatValueReal()), string, Float.valueOf(complexScalarFloat.floatValueImaginary()), string2).trim();
        }
        throw new IllegalArgumentException("Unexpected ComplexScalar type received.");
    }

    private static String formatEng(ComplexScalar complexScalar, int n) {
        if (complexScalar instanceof ComplexFloatingPointScalar) {
            if (complexScalar.isReal()) {
                return PrintMat.eng_fcn(complexScalar.doubleValueReal(), n, false, complexScalar instanceof ComplexScalarFloat).trim();
            }
            String string = PrintMat.eng_fcn(complexScalar.doubleValueReal(), n, false, complexScalar instanceof ComplexScalarFloat).trim();
            String string2 = PrintMat.eng_fcn(Math.abs(complexScalar.doubleValueImaginary()), n, true, complexScalar instanceof ComplexScalarFloat).trim();
            return FormatUtils.combineRealAndImagStrings(string, string2, complexScalar.doubleValueImaginary() < 0.0);
        }
        if (complexScalar.isReal()) {
            return PrintMat.eng_fcn(complexScalar.longValueReal(), n, false).trim();
        }
        String string = PrintMat.eng_fcn(complexScalar.longValueReal(), n, false).trim();
        String string3 = PrintMat.eng_fcn(Math.abs(complexScalar.longValueImaginary()), n, true).trim();
        return FormatUtils.combineRealAndImagStrings(string, string3, complexScalar.longValueImaginary() < 0L);
    }

    private static String eng_fcn(long l, int n, boolean bl) {
        String string;
        long l2 = 1000L;
        int n2 = n - 11;
        long l3 = 0L;
        int n3 = 0;
        long l4 = Math.abs(l);
        if ((double)l4 != 0.0) {
            if ((double)l4 > 1.0) {
                l3 = l2;
                while (l3 <= l4) {
                    l3 *= l2;
                    l /= l2;
                    n3 += 3;
                }
            } else {
                l3 = 1L;
                while (l3 > l4) {
                    l3 /= l2;
                    l *= l2;
                    n3 -= 3;
                }
            }
        }
        if ((string = n2 == 0 ? String.format(Locale.US, "%.4f", l) : String.format(Locale.US, "%.12f", l)).charAt(0) == '1' && string.charAt(1) == string.charAt(2) && string.charAt(3) == string.charAt(2) && string.charAt(3) == '0') {
            l /= l2;
            n3 += 3;
        } else if (string.charAt(0) == '0' && string.charAt(1) == '.') {
            l *= l2;
            n3 -= 3;
        }
        StringBuilder stringBuilder = n2 == 0 ? (bl ? new StringBuilder("%8.4fe") : new StringBuilder("%11.4fe")) : (bl ? ((double)Math.abs(l) < 10.0 ? new StringBuilder("%17.14fe") : ((double)Math.abs(l) < 100.0 ? new StringBuilder("%17.13fe") : new StringBuilder("%17.12fe"))) : ((double)Math.abs(l) < 10.0 ? new StringBuilder("%20.14fe") : ((double)Math.abs(l) < 100.0 ? new StringBuilder("%20.13fe") : new StringBuilder("%20.12fe"))));
        if (n3 >= 0) {
            stringBuilder.append('+');
        } else {
            stringBuilder.append('-');
            n3 = -n3;
        }
        if (l == 0L) {
            l = 0L;
        }
        if (n3 < 10) {
            stringBuilder.append("00%d");
        } else if (n3 < 100) {
            stringBuilder.append("0%d");
        } else {
            stringBuilder.append("%d");
        }
        return String.format(Locale.US, stringBuilder.toString(), l, n3);
    }

    private static String eng_fcn(double d, int n, boolean bl, boolean bl2) {
        String string;
        double d2 = 1000.0;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        int n2 = n - 11;
        int n3 = 0;
        double d3 = Math.abs(d);
        if (d3 != 0.0) {
            if (d3 > 1.0) {
                double d4 = d2;
                while (d4 <= d3) {
                    d4 *= d2;
                    d /= d2;
                    n3 += 3;
                }
            } else {
                double d5 = 1.0;
                while (d5 > d3) {
                    d5 /= d2;
                    d *= d2;
                    n3 -= 3;
                }
            }
        }
        if ((string = n2 == 0 ? String.format(Locale.US, "%.4f", d) : (bl2 ? String.format(Locale.US, "%.4f", d) : String.format(Locale.US, "%.12f", d))).charAt(0) == '1' && string.charAt(1) == string.charAt(2) && string.charAt(3) == string.charAt(2) && string.charAt(3) == '0') {
            d /= d2;
            n3 += 3;
        } else if (string.charAt(0) == '0' && string.charAt(1) == '.') {
            d *= d2;
            n3 -= 3;
        }
        StringBuilder stringBuilder = n2 == 0 ? (bl ? new StringBuilder("%8.4fe") : new StringBuilder("%11.4fe")) : (bl2 ? (bl ? (Math.abs(d) < 10.0 ? new StringBuilder("%9.6fe") : (Math.abs(d) < 100.0 ? new StringBuilder("%9.5fe") : new StringBuilder("%9.4fe"))) : (Math.abs(d) < 10.0 ? new StringBuilder("%11.6fe") : (Math.abs(d) < 100.0 ? new StringBuilder("%11.5fe") : new StringBuilder("%11.4fe")))) : (bl ? (Math.abs(d) < 10.0 ? new StringBuilder("%17.14fe") : (Math.abs(d) < 100.0 ? new StringBuilder("%17.13fe") : new StringBuilder("%17.12fe"))) : (Math.abs(d) < 10.0 ? new StringBuilder("%20.14fe") : (Math.abs(d) < 100.0 ? new StringBuilder("%20.13fe") : new StringBuilder("%20.12fe")))));
        if (n3 >= 0) {
            stringBuilder.append('+');
        } else {
            stringBuilder.append('-');
            n3 = -n3;
        }
        if (d == -0.0) {
            d = 0.0;
        }
        if (n3 < 10) {
            stringBuilder.append("00%d");
        } else if (n3 < 100) {
            stringBuilder.append("0%d");
        } else {
            stringBuilder.append("%d");
        }
        return String.format(Locale.US, stringBuilder.toString(), d, n3);
    }

    static {
        for (int i = 0; i < TABLE_LENGTH; ++i) {
            PrintMat.short_int_format_string[i] = FTABLE[i][0];
            PrintMat.long_int_format_string[i] = FTABLE[i][1];
            PrintMat.non_complex_format_string[i] = FTABLE[i][2];
            PrintMat.complex_real_format_string[i] = FTABLE[i][3];
            PrintMat.complex_imag_format_string[i] = FTABLE[i][4];
            PrintMat.single_non_complex_string[i] = PlatformInfo.isWindows() ? FTABLE[i][5] : FTABLE[i][8];
            PrintMat.single_complex_real_string[i] = PlatformInfo.isWindows() ? FTABLE[i][6] : FTABLE[i][9];
            PrintMat.single_complex_imag_string[i] = PlatformInfo.isWindows() ? FTABLE[i][7] : FTABLE[i][10];
        }
        sFormatPairStringHashMap = new HashMap();
    }

    private static class ScalarFormatPair {
        final double value;
        final boolean cache;
        final int formatKey;

        ScalarFormatPair(ComplexScalar complexScalar, int n) {
            this.value = complexScalar.doubleValueReal();
            this.cache = complexScalar instanceof ComplexScalarDouble && complexScalar.isReal() && (this.isNaN() || this.value == 0.0);
            this.formatKey = n;
        }

        public int hashCode() {
            return Double.valueOf(this.value).hashCode() + this.formatKey;
        }

        public boolean isNaN() {
            return Double.valueOf(this.value).isNaN();
        }

        public boolean willCache() {
            return this.cache;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ScalarFormatPair) {
                ScalarFormatPair scalarFormatPair = (ScalarFormatPair)object;
                return this.formatKey == scalarFormatPair.formatKey && (this.value == 0.0 && scalarFormatPair.value == 0.0 || this.isNaN() && scalarFormatPair.isNaN());
            }
            return false;
        }
    }
}

