/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.data.ComplexIntegralScalar;
import com.mathworks.widgets.spreadsheet.format.FormatUtils;

public final class ComplexScalarInteger
extends ComplexIntegralScalar {
    private final int fR;
    private final int fI;
    private static final long UNSIGNED_INTEGER_MAX = 0x100000000L;
    private static final ComplexScalarInteger ZERO_REAL_SIGNED = new ComplexScalarInteger(0, true);
    private static final ComplexScalarInteger ONE_REAL_SIGNED = new ComplexScalarInteger(1, true);
    private static final ComplexScalarInteger ZERO_COMPLEX_SIGNED = new ComplexScalarInteger(0, 0, true);
    private static final ComplexScalarInteger ONE_COMPLEX_SIGNED = new ComplexScalarInteger(1, 0, true);
    private static final ComplexScalarInteger I_COMPLEX_SIGNED = new ComplexScalarInteger(0, 1, true);
    private static final ComplexScalarInteger ZERO_REAL_UNSIGNED = new ComplexScalarInteger(0, false);
    private static final ComplexScalarInteger ONE_REAL_UNSIGNED = new ComplexScalarInteger(1, false);
    private static final ComplexScalarInteger ZERO_COMPLEX_UNSIGNED = new ComplexScalarInteger(0, 0, false);
    private static final ComplexScalarInteger ONE_COMPLEX_UNSIGNED = new ComplexScalarInteger(1, 0, false);
    private static final ComplexScalarInteger I_COMPLEX_UNSIGNED = new ComplexScalarInteger(0, 1, false);

    public static ComplexScalarInteger valueOf(int n) {
        return ComplexScalarInteger.valueOf(n, true);
    }

    public static ComplexScalarInteger valueOf(int n, boolean bl) {
        if (n == 0) {
            return bl ? ZERO_REAL_SIGNED : ZERO_REAL_UNSIGNED;
        }
        if (n == 1) {
            return bl ? ONE_REAL_SIGNED : ONE_REAL_UNSIGNED;
        }
        return new ComplexScalarInteger(n, bl);
    }

    public static ComplexScalarInteger valueOf(int n, int n2) {
        return ComplexScalarInteger.valueOf(n, n2, true);
    }

    public static ComplexScalarInteger valueOf(int n, int n2, boolean bl) {
        if (n == 0) {
            if (n2 == 1) {
                return bl ? I_COMPLEX_SIGNED : I_COMPLEX_UNSIGNED;
            }
            if (n2 == 0) {
                return bl ? ZERO_COMPLEX_SIGNED : ZERO_COMPLEX_UNSIGNED;
            }
        }
        if (n == 1 && n2 == 0) {
            return bl ? ONE_COMPLEX_SIGNED : ONE_COMPLEX_UNSIGNED;
        }
        return new ComplexScalarInteger(n, n2, bl);
    }

    private ComplexScalarInteger(int n, boolean bl) {
        super(true, bl);
        this.fR = n;
        this.fI = 0;
    }

    private ComplexScalarInteger(int n, int n2, boolean bl) {
        super(false, bl);
        this.fR = n;
        this.fI = n2;
    }

    @Override
    public long longValueReal() {
        return this.fR;
    }

    @Override
    public long longValueImaginary() {
        return this.fI;
    }

    @Override
    public double doubleValueReal() {
        return this.fR;
    }

    @Override
    public double doubleValueImaginary() {
        return this.fI;
    }

    @Override
    public String formatAsIntegral() {
        int n = this.intValueReal();
        int n2 = this.intValueImaginary();
        Number number = this.isSigned() || n > -1 ? (Number)n : (Number)((long)n + 0x100000000L);
        if (this.isReal()) {
            return FormatUtils.formatAsIntegral(number);
        }
        Number number2 = this.isSigned() || n2 > -1 ? (Number)n2 : (Number)((long)n2 + 0x100000000L);
        return FormatUtils.formatAsIntegral(number, number2);
    }
}

