/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarLong;
import java.util.Arrays;

public final class ComplexArrayLong
extends ComplexArray {
    private final long[][] fR;
    private final long[][] fI;

    public static ComplexArrayLong valueOf(long[][] lArray) {
        return ComplexArrayLong.valueOf(lArray, true);
    }

    public static ComplexArrayLong valueOf(long[][] lArray, boolean bl) {
        if (lArray == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!ArrayUtils.isRectangular((Object)lArray)) {
            throw new IllegalArgumentException("Array argument must be rectangular.");
        }
        return new ComplexArrayLong(lArray, bl);
    }

    public static ComplexArrayLong valueOf(long[][] lArray, long[][] lArray2) {
        return ComplexArrayLong.valueOf(lArray, lArray2, true);
    }

    public static ComplexArrayLong valueOf(long[][] lArray, long[][] lArray2, boolean bl) {
        if (lArray == null || lArray2 == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!Arrays.equals(ArrayUtils.getLengths((long[][])lArray), ArrayUtils.getLengths((long[][])lArray2))) {
            throw new IllegalArgumentException("Real and imaginary array arguments must have the same size.");
        }
        return new ComplexArrayLong(lArray, lArray2, bl);
    }

    private ComplexArrayLong(long[][] lArray, boolean bl) {
        super(bl);
        this.fR = lArray;
        this.fI = null;
    }

    private ComplexArrayLong(long[][] lArray, long[][] lArray2, boolean bl) {
        super(bl);
        this.fR = lArray;
        this.fI = lArray2;
    }

    public long[][] longValueReal() {
        return this.fR;
    }

    public long[][] longValueImaginary() {
        return this.fI;
    }

    @Override
    public boolean isReal() {
        return this.fI == null;
    }

    @Override
    public int[] getLengths() {
        return ArrayUtils.getLengths((long[][])this.fR);
    }

    @Override
    public ComplexScalarLong getValueAt(int n, int n2) {
        if (this.isReal()) {
            return ComplexScalarLong.valueOf(this.fR[n][n2], this.isSigned());
        }
        return ComplexScalarLong.valueOf(this.fR[n][n2], this.fI[n][n2], this.isSigned());
    }
}

