/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexScalarFloat;
import java.util.Arrays;

public final class ComplexArrayFloat
extends ComplexArray {
    private final float[][] fR;
    private final float[][] fI;

    public static ComplexArrayFloat valueOf(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!ArrayUtils.isRectangular((Object)fArray)) {
            throw new IllegalArgumentException("Array argument must be rectangular.");
        }
        return new ComplexArrayFloat(fArray);
    }

    public static ComplexArrayFloat valueOf(float[][] fArray, float[][] fArray2) {
        if (fArray == null || fArray2 == null) {
            throw new IllegalArgumentException("null arrays are not permitted");
        }
        if (!Arrays.equals(ArrayUtils.getLengths((float[][])fArray), ArrayUtils.getLengths((float[][])fArray2))) {
            throw new IllegalArgumentException("Real and imaginary array arguments must have the same size.");
        }
        return new ComplexArrayFloat(fArray, fArray2);
    }

    private ComplexArrayFloat(float[][] fArray) {
        super(true);
        this.fR = fArray;
        this.fI = null;
    }

    private ComplexArrayFloat(float[][] fArray, float[][] fArray2) {
        super(true);
        this.fR = fArray;
        this.fI = fArray2;
    }

    public float[][] floatValueReal() {
        return this.fR;
    }

    public float[][] floatValueImaginary() {
        return this.fI;
    }

    @Override
    public boolean isReal() {
        return this.fI == null;
    }

    @Override
    public int[] getLengths() {
        return ArrayUtils.getLengths((float[][])this.fR);
    }

    @Override
    public ComplexScalarFloat getValueAt(int n, int n2) {
        if (this.isReal()) {
            return ComplexScalarFloat.valueOf(this.fR[n][n2]);
        }
        return ComplexScalarFloat.valueOf(this.fR[n][n2], this.fI[n][n2]);
    }
}

