/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.color;

import com.mathworks.util.ArrayUtils;
import com.mathworks.widgets.spreadsheet.color.ColorTableModel;
import java.awt.Color;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SingleColorTableModel
implements ColorTableModel {
    private Color fColor;
    private boolean[][] fIndexes;
    private int fRows;
    private int fColumns;
    private List<ChangeListener> fChangeListeners;

    public SingleColorTableModel(Color color, boolean[][] blArray) {
        this.privateSetColor(color);
        this.privateSetIndexes(blArray);
        this.fChangeListeners = new Vector<ChangeListener>();
    }

    @Override
    public Color getColorAt(int n, int n2) {
        if (n < this.fRows && n2 < this.fColumns && this.fIndexes[n][n2]) {
            return this.fColor;
        }
        return null;
    }

    @Override
    public void addColorTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    @Override
    public void removeColorTableModelListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void privateSetColor(Color color) {
        this.fColor = color;
    }

    private void privateSetIndexes(boolean[][] blArray) {
        this.fIndexes = SingleColorTableModel.arrayCopy2D(blArray);
        int[] nArray = ArrayUtils.getLengths((boolean[][])blArray);
        this.fRows = nArray[0];
        this.fColumns = nArray[1];
    }

    public void setColor(Color color) {
        this.privateSetColor(color);
        this.fireChangeEvent();
    }

    public void setIndexes(boolean[][] blArray) {
        this.privateSetIndexes(blArray);
        this.fireChangeEvent();
    }

    public void setColorAndIndexes(Color color, boolean[][] blArray) {
        this.privateSetColor(color);
        this.privateSetIndexes(blArray);
        this.fireChangeEvent();
    }

    private static boolean[][] arrayCopy2D(boolean[][] blArray) {
        int n = blArray.length;
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            boolean[] blArray2 = blArray[i];
            boolean[] blArray3 = new boolean[blArray2.length];
            System.arraycopy(blArray2, 0, blArray3, 0, blArray[i].length);
            blArrayArray[i] = blArray3;
        }
        return blArrayArray;
    }
}

