/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.SpreadsheetActions;
import javax.swing.SwingUtilities;

public class SpreadsheetToolBar
extends MJToolBar {
    protected MJButton fSaveButton = null;
    protected MJButton fCutButton = null;
    protected MJButton fCopyButton = null;
    protected MJButton fPasteButton = null;
    protected MJButton fPrintButton = null;

    public SpreadsheetToolBar(Object object, IClipboardOpProvider iClipboardOpProvider) {
        this.setFloatable(false);
        this.fSaveButton = (MJButton)this.add(SpreadsheetActions.getSaveAction(object));
        this.addSeparator();
        this.fCutButton = (MJButton)this.add(SpreadsheetActions.getCutAction(iClipboardOpProvider));
        this.fCopyButton = (MJButton)this.add(SpreadsheetActions.getCopyAction(iClipboardOpProvider));
        this.fPasteButton = (MJButton)this.add(SpreadsheetActions.getPasteAction(iClipboardOpProvider));
        if (SpreadsheetActions.getPrintAction(object) != null) {
            this.addSeparator();
            this.fPrintButton = (MJButton)this.add(SpreadsheetActions.getPrintAction(object));
        }
        this.reassociateActions(object, iClipboardOpProvider);
    }

    public void reassociateActions(Object object, IClipboardOpProvider iClipboardOpProvider) {
        this.fSaveButton.setAction(SpreadsheetActions.getSaveAction(object));
        this.fCutButton.setAction(SpreadsheetActions.getCutAction(iClipboardOpProvider));
        this.fCopyButton.setAction(SpreadsheetActions.getCopyAction(iClipboardOpProvider));
        this.fPasteButton.setAction(SpreadsheetActions.getPasteAction(iClipboardOpProvider));
        if (SpreadsheetActions.getPrintAction(object) != null) {
            this.fPrintButton.setAction(SpreadsheetActions.getPrintAction(object));
        }
    }

    public void cleanup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cleanupOnDispatch();
        } else {
            SwingUtilities.invokeLater(new CR());
        }
    }

    private void cleanupOnDispatch() {
        this.removeAll();
        this.fSaveButton.setAction(null);
        this.fCutButton.setAction(null);
        this.fCopyButton.setAction(null);
        this.fPasteButton.setAction(null);
        if (this.fPrintButton != null) {
            this.fPrintButton.setAction(null);
            this.fPrintButton = null;
        }
        this.fSaveButton = null;
        this.fCutButton = null;
        this.fCopyButton = null;
        this.fPasteButton = null;
    }

    private class CR
    implements Runnable {
        private CR() {
        }

        @Override
        public void run() {
            SpreadsheetToolBar.this.cleanupOnDispatch();
        }
    }
}

