/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.text.DecimalFormatSymbols;

public class SpreadsheetPrefs {
    private static DecimalFormatSymbols sDFS;
    public static final String SPREADSHEET = "Spreadsheet";
    private static final String DECIMAL_SEPARATOR = "DecimalSeparator";
    private static final String DECIMAL_SEPARATOR_KEY = "Spreadsheet.DecimalSeparator";

    private SpreadsheetPrefs() {
    }

    public static void setDecimalSeparator(char c) {
        if (sDFS == null) {
            SpreadsheetPrefs.initDFS();
        }
        SpreadsheetPrefs.stashAndCacheDecimalSeparator(c);
    }

    public static char getDecimalSeparator() {
        if (sDFS == null) {
            SpreadsheetPrefs.initDFS();
        }
        SpreadsheetPrefs.fetchAndCacheDecimalSeparator();
        return sDFS.getDecimalSeparator();
    }

    private static void initDFS() {
        sDFS = new DecimalFormatSymbols();
        String string = DECIMAL_SEPARATOR_KEY;
        Prefs.addListener((PrefListener)new DecimalSeparatorListener(), (String)string);
    }

    private static void fetchAndCacheDecimalSeparator() {
        sDFS.setDecimalSeparator((char)Prefs.getIntegerPref((String)DECIMAL_SEPARATOR_KEY, (int)sDFS.getDecimalSeparator()));
    }

    private static void stashAndCacheDecimalSeparator(char c) {
        sDFS.setDecimalSeparator(c);
        Prefs.setIntegerPref((String)DECIMAL_SEPARATOR_KEY, (int)c);
    }

    public static String getDecimalSeparatorKey() {
        return DECIMAL_SEPARATOR_KEY;
    }

    static class DecimalSeparatorListener
    implements PrefListener {
        DecimalSeparatorListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            SpreadsheetPrefs.fetchAndCacheDecimalSeparator();
        }
    }
}

