/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.IReadOnlyData;
import com.mathworks.widgets.spreadsheet.SelectionHider;
import com.mathworks.widgets.spreadsheet.SpreadsheetCellBorder;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import com.mathworks.widgets.spreadsheet.SpreadsheetTable;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import com.mathworks.widgets.spreadsheet.color.CompositeColorArrayTableModel;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SpreadsheetCellRenderer
extends DefaultTableCellRenderer {
    private Formatter fFormat;
    private SpreadsheetColor fSpreadsheetColor = null;
    public static final Color dataValueColor = Color.decode("#176097");

    public SpreadsheetCellRenderer() {
        this(FormatIdentifier.getDefaultInstance());
    }

    public SpreadsheetCellRenderer(FormatIdentifier formatIdentifier) {
        this.fFormat = formatIdentifier.getFormatter();
    }

    private void initSpreadsheetColor(JTable jTable) {
        if (this.fSpreadsheetColor == null) {
            this.fSpreadsheetColor = new SpreadsheetColor(jTable);
            this.fSpreadsheetColor.registerColorInterests();
        }
    }

    private void cleanupSpreadsheetColor() {
        if (this.fSpreadsheetColor != null) {
            this.fSpreadsheetColor.unregisterColorInterests();
        }
        this.fSpreadsheetColor = null;
    }

    public void cleanup() {
        this.cleanupSpreadsheetColor();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.initSpreadsheetColor(jTable);
        SelectionHider selectionHider = null;
        if (jTable instanceof SelectionHider) {
            selectionHider = (SelectionHider)((Object)jTable);
            bl = bl && !selectionHider.isSelectionHidden();
        }
        String string = this.fFormat.format(object);
        JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
        boolean bl3 = false;
        if (bl) {
            boolean bl4 = jTable.getSelectionModel().getLeadSelectionIndex() == n;
            boolean bl5 = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex() == n2;
            bl3 = bl4 && bl5;
        }
        Color color = this.fSpreadsheetColor.getCellBackground(bl, bl3);
        Color color2 = this.fSpreadsheetColor.getCellForeground(bl, bl3);
        if (jTable.isPaintingForPrint() && PlatformInfo.isMacintosh() && PlatformInfo.isVersion17()) {
            this.setForeground(new Color(color2.getRGB() & 0xFEFFFFFF, true));
            this.setBackground(new Color(color.getRGB() & 0xFEFFFFFF, true));
        } else {
            this.setForeground(color2);
            this.setBackground(color);
        }
        this.setColorsFromColormap(jTable, n, n2);
        this.setHorizontalAlignment(SpreadsheetUtils.getTextAlignment(object));
        jComponent.setFont(this.getFont());
        if (object instanceof IReadOnlyData && ((IReadOnlyData)object).isReadOnly()) {
            jComponent.setForeground(SpreadsheetCellRenderer.getContrastingColor(jComponent));
            jComponent.setFont(jComponent.getFont().deriveFont(2));
        }
        if (selectionHider == null || !selectionHider.isSelectionHidden()) {
            this.setSelectionBorders(jTable, jComponent, bl, n, n2);
        }
        return jComponent;
    }

    private void setSelectionBorders(JTable jTable, JComponent jComponent, boolean bl, int n, int n2) {
        Color color;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        Color color5 = null;
        if (jTable instanceof SpreadsheetTable) {
            CompositeColorArrayTableModel compositeColorArrayTableModel = ((SpreadsheetTable)((Object)jTable)).getBorderColorArrayTableModel();
            color2 = SpreadsheetCellRenderer.combineColors(SpreadsheetUtils.colorsOnCellEdge(compositeColorArrayTableModel, n, n2, 1));
            color3 = SpreadsheetCellRenderer.combineColors(SpreadsheetUtils.colorsOnCellEdge(compositeColorArrayTableModel, n, n2, 3));
            color4 = SpreadsheetCellRenderer.combineColors(SpreadsheetUtils.colorsOnCellEdge(compositeColorArrayTableModel, n, n2, 2));
            color5 = SpreadsheetCellRenderer.combineColors(SpreadsheetUtils.colorsOnCellEdge(compositeColorArrayTableModel, n, n2, 4));
        }
        boolean bl2 = jTable instanceof SpreadsheetTable && ((SpreadsheetTable)((Object)jTable)).isPrimaryFocusOwner();
        Color color6 = color = bl2 ? this.fSpreadsheetColor.getSelectionBorder() : this.fSpreadsheetColor.getSecondarySelectionBorder();
        if (color2 == null && SpreadsheetCellRenderer.isBorderSideNeeded(jTable, n, n2, 1, bl)) {
            color2 = color;
        }
        if (color3 == null && SpreadsheetCellRenderer.isBorderSideNeeded(jTable, n, n2, 3, bl)) {
            color3 = color;
        }
        if (color4 == null && SpreadsheetCellRenderer.isBorderSideNeeded(jTable, n, n2, 2, bl)) {
            color4 = color;
        }
        if (color5 == null && SpreadsheetCellRenderer.isBorderSideNeeded(jTable, n, n2, 4, bl)) {
            color5 = color;
        }
        jComponent.setBorder(new SpreadsheetCellBorder(color2, color4, color3, color5, this.fSpreadsheetColor.getCellUnselectedBackground()));
    }

    private void setColorsFromColormap(JTable jTable, int n, int n2) {
        Color color;
        if (jTable instanceof SpreadsheetTable && (color = SpreadsheetCellRenderer.combineColors(((SpreadsheetTable)((Object)jTable)).getCellColorArrayTableModel().getColorsAt(n, n2))) != null) {
            this.setBackground(color);
            boolean bl = ColorUtils.isDark((Color)color);
            boolean bl2 = ColorUtils.isDark((Color)this.getForeground());
            if (bl) {
                if (bl2) {
                    this.setForeground(Color.white);
                }
            } else if (!bl2) {
                this.setForeground(Color.black);
            }
        }
    }

    private static boolean isBorderSideNeeded(JTable jTable, int n, int n2, int n3, boolean bl) {
        return SpreadsheetUtils.selectionEdgeIntAbutsCellEdge(jTable, n, n2, n3, bl) || PlatformInfo.isMacintosh() && SpreadsheetUtils.selectionEdgeExtAbutsCellEdge(jTable, n, n2, n3, bl);
    }

    private static Color combineColors(Color[] colorArray) {
        if (colorArray.length == 0) {
            return null;
        }
        if (colorArray.length == 1) {
            return colorArray[0];
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Color color : colorArray) {
            if (color == null) continue;
            ++n;
            n2 += color.getRed();
            n3 += color.getGreen();
            n4 += color.getBlue();
        }
        if (n == 0) {
            return null;
        }
        return new Color(n2 / n, n3 / n, n4 / n);
    }

    public static Color getContrastingColor(JComponent jComponent) {
        if (jComponent.getBackground().equals(Color.WHITE)) {
            return dataValueColor;
        }
        double d = 1.0 - (0.299 * (double)jComponent.getBackground().getRed() + 0.587 * (double)jComponent.getBackground().getGreen() + 0.114 * (double)jComponent.getBackground().getBlue()) / 255.0;
        if (d < 0.5) {
            return dataValueColor;
        }
        return Color.WHITE;
    }
}

