/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.recordlist;

import com.mathworks.widgets.recordlist.IRecordFilter;
import com.mathworks.widgets.recordlist.RecordlistResources;

public class RecordFilterFactory {
    private static final int AND = 0;
    private static final int OR = -1;
    private static final int NOT = -2;
    private static final int CONSTANT = -3;
    private static final RecordFilterFactory sThis = new RecordFilterFactory();
    private static IRecordFilter sTrueFilter;
    private static IRecordFilter sFalseFilter;

    private RecordFilterFactory() {
    }

    public static IRecordFilter getConstantFilter(boolean bl) {
        if (sTrueFilter == null) {
            sTrueFilter = RecordFilterFactory.getConstantFilterBootstrap(true);
            sFalseFilter = RecordFilterFactory.getConstantFilterBootstrap(false);
        }
        return bl ? sTrueFilter : sFalseFilter;
    }

    public static IRecordFilter getAndFilter(IRecordFilter iRecordFilter, IRecordFilter iRecordFilter2) {
        RecordFilterFactory.validateArguments(iRecordFilter, iRecordFilter2, 0);
        RecordFilterFactory recordFilterFactory = sThis;
        recordFilterFactory.getClass();
        return recordFilterFactory.new InternalImpl(iRecordFilter, iRecordFilter2, true, 0);
    }

    public static IRecordFilter getOrFilter(IRecordFilter iRecordFilter, IRecordFilter iRecordFilter2) {
        RecordFilterFactory.validateArguments(iRecordFilter, iRecordFilter2, -1);
        RecordFilterFactory recordFilterFactory = sThis;
        recordFilterFactory.getClass();
        return recordFilterFactory.new InternalImpl(iRecordFilter, iRecordFilter2, true, -1);
    }

    public static IRecordFilter getNotFilter(IRecordFilter iRecordFilter) {
        RecordFilterFactory.validateArguments(iRecordFilter, null, -2);
        RecordFilterFactory recordFilterFactory = sThis;
        recordFilterFactory.getClass();
        return recordFilterFactory.new InternalImpl(iRecordFilter, null, true, -2);
    }

    private static void validateArguments(IRecordFilter iRecordFilter, IRecordFilter iRecordFilter2, int n) {
        if (n == 0 | n == -1) {
            if (iRecordFilter == null | iRecordFilter2 == null) {
                throw new IllegalArgumentException(RecordlistResources.getContribFilterError());
            }
        } else if (iRecordFilter == null) {
            throw new IllegalArgumentException(RecordlistResources.getNegatedFilterError());
        }
    }

    private static IRecordFilter getConstantFilterBootstrap(boolean bl) {
        RecordFilterFactory recordFilterFactory = sThis;
        recordFilterFactory.getClass();
        return recordFilterFactory.new InternalImpl(null, null, bl, -3);
    }

    class InternalImpl
    implements IRecordFilter {
        private IRecordFilter fFilter1;
        private IRecordFilter fFilter2;
        private boolean fConstant;
        private int fSense;

        private InternalImpl(IRecordFilter iRecordFilter, IRecordFilter iRecordFilter2, boolean bl, int n) {
            this.fFilter1 = iRecordFilter;
            this.fFilter2 = iRecordFilter2;
            this.fConstant = bl;
            this.fSense = n;
        }

        @Override
        public boolean accept(Object object) {
            boolean bl = false;
            switch (this.fSense) {
                case -3: {
                    bl = this.fConstant;
                    break;
                }
                case 0: {
                    bl = this.fFilter1.accept(object) & this.fFilter2.accept(object);
                    break;
                }
                case -1: {
                    bl = this.fFilter1.accept(object) | this.fFilter2.accept(object);
                    break;
                }
                case -2: {
                    bl = !this.fFilter1.accept(object);
                }
            }
            return bl;
        }
    }
}

