/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.internal.loginws.client.v2.ArrayOfMWMessage;
import com.mathworks.internal.loginws.client.v2.ClientConfiguration;
import com.mathworks.internal.loginws.client.v2.LoginReturn;
import com.mathworks.internal.loginws.client.v2.LoginServiceAxis2ClientImpl;
import com.mathworks.internal.loginws.client.v2.LoginServiceClient;
import com.mathworks.internal.loginws.client.v2.MWMessage;
import com.mathworks.internal.loginws.client.v2.ValidateReturn;
import com.mathworks.widgets.login.LoginResultWrapper;
import com.mathworks.widgets.login.LoginUtils;
import com.mathworks.widgets.login.ProxySettings;
import com.mathworks.widgets.login.UniversalLoginComponent;
import com.mathworks.widgets.login.ValidateResultWrapper;
import com.mathworks.widgets.login.WebServiceError;
import com.mathworks.widgets.login.logging.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.axis2.AxisFault;

public class LoginServiceWrapper {
    private static LoginServiceWrapper sInstance;
    private LoginServiceClient fLoginService;

    static synchronized LoginServiceWrapper getInstance() {
        if (sInstance == null) {
            sInstance = new LoginServiceWrapper();
        }
        return sInstance;
    }

    private LoginServiceWrapper() {
    }

    LoginResultWrapper getToken(String string, String string2, String string3, String string4, ProxySettings proxySettings) {
        if (this.fLoginService == null) {
            this.setLoginServiceClient(LoginServiceWrapper.getDefaultLoginService(string3, string4, proxySettings));
        }
        return this.getToken(string, string2);
    }

    ValidateResultWrapper validateToken(String string, String string2, String string3, String string4, ProxySettings proxySettings) {
        if (this.fLoginService == null) {
            this.setLoginServiceClient(LoginServiceWrapper.getDefaultLoginService(string4, string3, proxySettings));
        }
        return this.validate(string, string2, string3);
    }

    private void setLoginServiceClient(LoginServiceClient loginServiceClient) {
        this.fLoginService = loginServiceClient;
    }

    static LoginServiceClient getDefaultLoginService(String string, String string2, ProxySettings proxySettings) {
        try {
            ClientConfiguration clientConfiguration = LoginServiceWrapper.getClientConfiguration(string, proxySettings);
            LoginServiceAxis2ClientImpl loginServiceAxis2ClientImpl = new LoginServiceAxis2ClientImpl(string, clientConfiguration);
            loginServiceAxis2ClientImpl.setClientString(string2);
            loginServiceAxis2ClientImpl.setLocale(Locale.getDefault().toString());
            return loginServiceAxis2ClientImpl;
        }
        catch (AxisFault axisFault) {
            Log.getInstance().getLogger().fine(string2 + ": " + ((Object)((Object)axisFault)).getClass().getName() + " creating web service client " + axisFault.getMessage());
            return null;
        }
    }

    private static ClientConfiguration getClientConfiguration(String string, ProxySettings proxySettings) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setEndpoint(string);
        if (proxySettings != null && proxySettings.hasValidProxySettings()) {
            clientConfiguration.setProxyHost(proxySettings.getHost());
            clientConfiguration.setProxyPort(proxySettings.getPort());
            if (proxySettings.hasValidAuthenticationSettings()) {
                clientConfiguration.setProxyUser(proxySettings.getUsername());
                clientConfiguration.setProxyPassword(proxySettings.getPassword());
            }
        }
        return clientConfiguration;
    }

    LoginResultWrapper getToken(String string, String string2, LoginServiceClient loginServiceClient) {
        this.fLoginService = loginServiceClient;
        return this.getToken(string, string2);
    }

    private LoginResultWrapper getToken(String string, String string2) {
        if (this.fLoginService == null) {
            Log.getInstance().getLogger().fine(LoginUtils.getClientVersion(UniversalLoginComponent.DEFAULT_CLIENT_STRING) + ": Web service client not initialized.");
            return new LoginResultWrapper(LoginServiceWrapper.getGeneralExceptionError());
        }
        try {
            MWMessage[] mWMessageArray;
            LoginReturn loginReturn = this.fLoginService.getLoginToken(string, string2);
            int n = loginReturn.getResult();
            if (n == 0) {
                return new LoginResultWrapper(loginReturn.getToken());
            }
            ArrayList<WebServiceError> arrayList = new ArrayList<WebServiceError>();
            ArrayOfMWMessage arrayOfMWMessage = loginReturn.getMessages();
            if (arrayOfMWMessage != null && (mWMessageArray = arrayOfMWMessage.getMessage()) != null) {
                for (MWMessage mWMessage : mWMessageArray) {
                    WebServiceError webServiceError = new WebServiceError();
                    webServiceError.setCode(mWMessage.getCode());
                    webServiceError.setDescription(mWMessage.getDescription());
                    webServiceError.setName(mWMessage.getName());
                    webServiceError.setSeverity(mWMessage.getSeverity());
                    arrayList.add(webServiceError);
                }
            }
            return new LoginResultWrapper(arrayList);
        }
        catch (Exception exception) {
            Log.getInstance().getLogger().fine(LoginUtils.getClientVersion(UniversalLoginComponent.DEFAULT_CLIENT_STRING) + ": " + exception.getClass().getName() + " accessing web service client " + exception.getMessage());
            return new LoginResultWrapper(LoginServiceWrapper.getGeneralExceptionError());
        }
    }

    ValidateResultWrapper validateToken(String string, String string2, String string3, LoginServiceClient loginServiceClient) {
        this.fLoginService = loginServiceClient;
        return this.validate(string, string2, string3);
    }

    private ValidateResultWrapper validate(String string, String string2, String string3) {
        return this.validate(string, string2, string3, Locale.getDefault().toString());
    }

    private ValidateResultWrapper validate(String string, String string2, String string3, String string4) {
        if (this.fLoginService == null) {
            Log.getInstance().getLogger().fine(string3 + ": Web service client not initialized.");
            return new ValidateResultWrapper(string, LoginServiceWrapper.getGeneralExceptionError());
        }
        try {
            MWMessage[] mWMessageArray;
            ValidateReturn validateReturn = this.fLoginService.validate(string, string2, string4, string3);
            if (validateReturn.getResult() == 0 && validateReturn.getIsValid()) {
                return new ValidateResultWrapper(string);
            }
            ArrayList<WebServiceError> arrayList = new ArrayList<WebServiceError>();
            ArrayOfMWMessage arrayOfMWMessage = validateReturn.getMessages();
            if (arrayOfMWMessage != null && (mWMessageArray = arrayOfMWMessage.getMessage()) != null) {
                for (MWMessage mWMessage : mWMessageArray) {
                    WebServiceError webServiceError = new WebServiceError();
                    webServiceError.setCode(mWMessage.getCode());
                    webServiceError.setDescription(mWMessage.getDescription());
                    webServiceError.setName(mWMessage.getName());
                    webServiceError.setSeverity(mWMessage.getSeverity());
                    arrayList.add(webServiceError);
                }
            }
            return new ValidateResultWrapper(string, arrayList);
        }
        catch (Exception exception) {
            Log.getInstance().getLogger().fine(string3 + ": " + exception.getClass().getName() + " accessing web service client " + exception.getMessage());
            return new ValidateResultWrapper(string, LoginServiceWrapper.getGeneralExceptionError());
        }
    }

    private static List<WebServiceError> getGeneralExceptionError() {
        ArrayList<WebServiceError> arrayList = new ArrayList<WebServiceError>();
        WebServiceError webServiceError = new WebServiceError();
        webServiceError.setDescription(LoginUtils.getString("universalLogin.general.execption"));
        arrayList.add(webServiceError);
        return arrayList;
    }
}

