/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.widgets.login.AuthenticationException;
import com.mathworks.widgets.login.AuthenticationListener;
import com.mathworks.widgets.login.AuthenticationResponse;
import com.mathworks.widgets.login.AuthorizationListener;
import com.mathworks.widgets.login.AuthorizationResponse;
import com.mathworks.widgets.login.AuthorizationStrategy;
import com.mathworks.widgets.login.DefaultPersistenceStrategy;
import com.mathworks.widgets.login.LoginPersistenceStrategy;

public class AuthorizationWorkFlow {
    private AuthorizationStrategy fAuthorizationStrategy;
    private LoginPersistenceStrategy fPersistenceStrategy;

    public AuthorizationWorkFlow(AuthorizationStrategy authorizationStrategy) {
        this(authorizationStrategy, new DefaultPersistenceStrategy());
    }

    public AuthorizationWorkFlow(AuthorizationStrategy authorizationStrategy, LoginPersistenceStrategy loginPersistenceStrategy) {
        this.setAuthorizationStrategy(authorizationStrategy);
        this.setLoginPersistenceStrategy(loginPersistenceStrategy);
    }

    public void startWorkFlow() {
        AuthenticationResponse authenticationResponse;
        try {
            authenticationResponse = this.checkAuthenticatedAlready();
        }
        catch (AuthenticationException authenticationException) {
            this.fAuthorizationStrategy.doConsumerAuthenticationFailure(new WorkFlowAuthenticationListener());
            return;
        }
        this.doAuthorization(authenticationResponse);
    }

    protected void setAuthorizationStrategy(AuthorizationStrategy authorizationStrategy) {
        this.fAuthorizationStrategy = authorizationStrategy;
    }

    protected AuthorizationStrategy getAuthorizationStrategy() {
        return this.fAuthorizationStrategy;
    }

    protected void setLoginPersistenceStrategy(LoginPersistenceStrategy loginPersistenceStrategy) {
        this.fPersistenceStrategy = loginPersistenceStrategy;
    }

    private AuthenticationResponse checkAuthenticatedAlready() throws AuthenticationException {
        String string = this.fPersistenceStrategy.readLoginToken();
        if (string != null && string.length() > 0) {
            return new AuthenticationResponse(string, this.fPersistenceStrategy.readMwaUserName());
        }
        throw new AuthenticationException();
    }

    private void doAuthorization(AuthenticationResponse authenticationResponse) {
        this.fAuthorizationStrategy.doConsumerAuthorization(authenticationResponse, this.getAuthorizationListener());
    }

    protected void doAfterAuthorization(AuthorizationResponse authorizationResponse) {
        this.fAuthorizationStrategy.doConsumerAuthorizationSuccess(authorizationResponse);
    }

    AuthorizationListener getAuthorizationListener() {
        return new WorkFlowAuthorizationListener();
    }

    private class WorkFlowAuthorizationListener
    implements AuthorizationListener {
        private WorkFlowAuthorizationListener() {
        }

        @Override
        public void authorized(AuthorizationResponse authorizationResponse) {
            AuthorizationWorkFlow.this.doAfterAuthorization(authorizationResponse);
        }
    }

    private class WorkFlowAuthenticationListener
    implements AuthenticationListener {
        private WorkFlowAuthenticationListener() {
        }

        @Override
        public void authenticated(AuthenticationResponse authenticationResponse) {
            AuthorizationWorkFlow.this.doAuthorization(authenticationResponse);
        }

        @Override
        public void notAuthenticated() {
        }
    }
}

