/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public final class RightClickSelectionHandler {
    private final Component fComponent;
    private final MouseListener fMouseListener;

    public RightClickSelectionHandler(Component component) {
        assert (component instanceof JTable || component instanceof JTree);
        this.fComponent = component;
        this.fMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (MJUtilities.isRightMouseButton((MouseEvent)mouseEvent)) {
                    int n = RightClickSelectionHandler.this.rowAtPoint(mouseEvent.getPoint());
                    int n2 = RightClickSelectionHandler.this.columnAtPoint(mouseEvent.getPoint());
                    if (n == -1 || n2 == -1) {
                        RightClickSelectionHandler.this.clearSelection();
                    } else if (!RightClickSelectionHandler.this.isRowSelected(n)) {
                        boolean bl;
                        Rectangle rectangle = RightClickSelectionHandler.this.getCellRect(n, n2);
                        if (RightClickSelectionHandler.this.fComponent instanceof GroupingTable) {
                            NonRectangularCellRenderer nonRectangularCellRenderer = ((GroupingTable)((Object)RightClickSelectionHandler.this.fComponent)).setupRenderer(n, n2);
                            Point point = mouseEvent.getPoint();
                            int n3 = 0;
                            if (n2 < 1) {
                                n3 = (((GroupingTable)((Object)RightClickSelectionHandler.this.fComponent)).getRowAt(n).getLevel() + 1) * ((GroupingTable)((Object)RightClickSelectionHandler.this.fComponent)).getIndent();
                            }
                            point.setLocation(point.getX() - rectangle.getX() - (double)n3, (double)((int)(point.getY() - rectangle.getY())));
                            bl = nonRectangularCellRenderer.allowRightClickSelection(point);
                        } else {
                            Component component = RightClickSelectionHandler.this.getRendererComponent(n, n2);
                            rectangle.setSize((int)Math.min(rectangle.getWidth(), component.getPreferredSize().getWidth()), (int)rectangle.getHeight());
                            RightClickSelectionHandler.this.clearSelection();
                            bl = rectangle.contains(mouseEvent.getPoint());
                        }
                        RightClickSelectionHandler.this.clearSelection();
                        if (bl) {
                            RightClickSelectionHandler.this.addSelectionInterval(n);
                        }
                    }
                } else if (RightClickSelectionHandler.this.rowAtPoint(mouseEvent.getPoint()) == -1) {
                    RightClickSelectionHandler.this.clearSelection();
                }
            }
        };
        this.fComponent.addMouseListener(this.fMouseListener);
    }

    public void destroy() {
        this.fComponent.removeMouseListener(this.fMouseListener);
    }

    private int rowAtPoint(Point point) {
        if (this.fComponent instanceof JTable) {
            return ((JTable)this.fComponent).rowAtPoint(point);
        }
        return ((JTree)this.fComponent).getRowForLocation((int)point.getX(), (int)point.getY());
    }

    private boolean isRowSelected(int n) {
        if (this.fComponent instanceof JTable) {
            return ((JTable)this.fComponent).isRowSelected(n);
        }
        return ((JTree)this.fComponent).isRowSelected(n);
    }

    private void clearSelection() {
        if (this.fComponent instanceof JTable) {
            ((JTable)this.fComponent).clearSelection();
        } else {
            ((JTree)this.fComponent).clearSelection();
        }
    }

    private int columnAtPoint(Point point) {
        if (this.fComponent instanceof JTable) {
            return ((JTable)this.fComponent).columnAtPoint(point);
        }
        return 0;
    }

    private Component getRendererComponent(int n, int n2) {
        if (this.fComponent instanceof JTable) {
            TableCellRenderer tableCellRenderer = ((JTable)this.fComponent).getCellRenderer(n, n2);
            return tableCellRenderer.getTableCellRendererComponent((JTable)this.fComponent, ((JTable)this.fComponent).getValueAt(n, n2), false, true, n, n2);
        }
        JTree jTree = (JTree)this.fComponent;
        TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
        TreePath treePath = jTree.getPathForRow(n);
        return treeCellRenderer.getTreeCellRendererComponent((JTree)this.fComponent, treePath.getLastPathComponent(), false, jTree.isExpanded(treePath), jTree.getModel().isLeaf(treePath.getLastPathComponent()), n, true);
    }

    private Rectangle getCellRect(int n, int n2) {
        if (this.fComponent instanceof JTable) {
            return ((JTable)this.fComponent).getCellRect(n, n2, true);
        }
        return ((JTree)this.fComponent).getRowBounds(n);
    }

    private void addSelectionInterval(int n) {
        if (this.fComponent instanceof JTable) {
            ((JTable)this.fComponent).getSelectionModel().addSelectionInterval(n, n);
        } else {
            ((JTree)this.fComponent).getSelectionModel().addSelectionPath(((JTree)this.fComponent).getPathForRow(n));
        }
    }
}

