/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Disposable;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTableModel;
import com.mathworks.widgets.grouptable.GroupingTableResources;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ColumnActions<T>
implements Disposable {
    private final GroupingTableModel<T> fModel;
    private final MJAbstractAction fStopGroupingAction;
    private final MJCheckBoxMenuItem fSortAscendingItem;
    private final MJCheckBoxMenuItem fSortDescendingItem;
    private final Map<GroupingMode<T>, MJCheckBoxMenuItem> fGroupItems;
    private final Map<GroupingTableColumn<T>, MJCheckBoxMenuItem> fSortItems;
    private final Map<GroupingTableColumn<T>, MJCheckBoxMenuItem> fShowColumnItems;
    private final Map<VerticalAttribute<T>, MJCheckBoxMenuItem> fShowVerticalAttributeItems;
    private final MulticastChangeListener fChangeListeners;
    private final PropertyChangeListener fPropertyChangeListener;

    public ColumnActions(GroupingTableModel<T> groupingTableModel) {
        this.fModel = groupingTableModel;
        this.fSortItems = new LinkedHashMap<GroupingTableColumn<T>, MJCheckBoxMenuItem>();
        this.fShowColumnItems = new LinkedHashMap<GroupingTableColumn<T>, MJCheckBoxMenuItem>();
        this.fShowVerticalAttributeItems = new LinkedHashMap<VerticalAttribute<T>, MJCheckBoxMenuItem>();
        this.fGroupItems = new LinkedHashMap<GroupingMode<T>, MJCheckBoxMenuItem>();
        this.fStopGroupingAction = new MJAbstractAction(GroupingTableResources.getString("table.stopGrouping")){

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnActions.this.fModel.getConfiguration().ungroup();
            }
        };
        this.fStopGroupingAction.setComponentName("StopGrouping");
        this.fSortAscendingItem = new MJCheckBoxMenuItem((Action)new MJAbstractAction(GroupingTableResources.getString("table.sortAscending")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupingTableConfiguration groupingTableConfiguration = ColumnActions.this.fModel.getConfiguration();
                if (groupingTableConfiguration.getSortColumn() != null && groupingTableConfiguration.isSortedDescending()) {
                    groupingTableConfiguration.setSortColumnOrToggleDirection(groupingTableConfiguration.getSortColumn());
                }
            }
        });
        this.fSortAscendingItem.setName("sort.ascending");
        this.fSortDescendingItem = new MJCheckBoxMenuItem((Action)new MJAbstractAction(GroupingTableResources.getString("table.sortDescending")){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupingTableConfiguration groupingTableConfiguration = ColumnActions.this.fModel.getConfiguration();
                if (groupingTableConfiguration.getSortColumn() != null && !groupingTableConfiguration.isSortedDescending()) {
                    groupingTableConfiguration.setSortColumnOrToggleDirection(groupingTableConfiguration.getSortColumn());
                }
            }
        });
        this.fSortDescendingItem.setName("sort.descending");
        this.fChangeListeners = new MulticastChangeListener();
        this.initializeColumnSpecificActions();
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ColumnActions.this.updateStates();
                if (propertyChangeEvent.getPropertyName().equals("all-columns") || propertyChangeEvent.getPropertyName().equals("all-vertical-attributes")) {
                    ColumnActions.this.initializeColumnSpecificActions();
                }
            }
        };
        this.fModel.getConfiguration().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void dispose() {
        this.fModel.getConfiguration().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.removeChangeListener(changeListener);
    }

    private void initializeColumnSpecificActions() {
        String string;
        this.fSortItems.clear();
        this.fShowColumnItems.clear();
        this.fGroupItems.clear();
        this.fShowVerticalAttributeItems.clear();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        GroupingTableConfiguration<T> groupingTableConfiguration = this.fModel.getConfiguration();
        for (final GroupingTableColumn<T> groupingTableColumn : groupingTableConfiguration.getAllColumnsInDefaultOrder()) {
            MJCheckBoxMenuItem mJCheckBoxMenuItem;
            if (groupingTableConfiguration.isVerticalAttributeColumn(groupingTableColumn)) continue;
            string = groupingTableColumn.getName();
            if (groupingTableColumn.getGroupingModes().size() == 1) {
                string = groupingTableColumn.getGroupingModes().get(0).getName();
            }
            if (treeSet.add(string)) {
                mJCheckBoxMenuItem = new MJCheckBoxMenuItem((Action)new MJAbstractAction(string){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ColumnActions.this.fModel.getConfiguration().setSortColumnOrToggleDirection(groupingTableColumn);
                    }
                });
                mJCheckBoxMenuItem.setName("Sort" + groupingTableColumn.getKey());
                this.fSortItems.put(groupingTableColumn, mJCheckBoxMenuItem);
            }
            if (groupingTableColumn.canHide()) {
                mJCheckBoxMenuItem = new MJCheckBoxMenuItem((Action)new MJAbstractAction(groupingTableColumn.getName()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GroupingTableConfiguration groupingTableConfiguration;
                        groupingTableConfiguration.setColumnVisible(groupingTableColumn, !(groupingTableConfiguration = ColumnActions.this.fModel.getConfiguration()).isColumnVisible(groupingTableColumn));
                    }
                });
                mJCheckBoxMenuItem.setName("Show" + groupingTableColumn.getKey());
                this.fShowColumnItems.put(groupingTableColumn, mJCheckBoxMenuItem);
            }
            for (final GroupingMode groupingMode : groupingTableColumn.getGroupingModes()) {
                if (!treeSet2.add(groupingMode.getKey())) continue;
                MJCheckBoxMenuItem mJCheckBoxMenuItem2 = new MJCheckBoxMenuItem((Action)new MJAbstractAction(groupingMode.getName()){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ColumnActions.this.fModel.getConfiguration().setGroupMode(groupingTableColumn, groupingMode);
                    }
                });
                mJCheckBoxMenuItem2.setName("Group" + groupingTableColumn.getKey());
                this.fGroupItems.put(groupingMode, mJCheckBoxMenuItem2);
            }
        }
        for (final VerticalAttribute verticalAttribute : groupingTableConfiguration.getAllVerticalAttributes()) {
            string = new MJCheckBoxMenuItem((Action)new MJAbstractAction(verticalAttribute.getName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    GroupingTableConfiguration groupingTableConfiguration;
                    groupingTableConfiguration.setVerticalAttributeVisible(verticalAttribute, !(groupingTableConfiguration = ColumnActions.this.fModel.getConfiguration()).isVerticalAttributeOrColumnVisible(verticalAttribute));
                }
            });
            string.setName("Show" + verticalAttribute.getKey());
            this.fShowVerticalAttributeItems.put(verticalAttribute, (MJCheckBoxMenuItem)string);
        }
        this.fChangeListeners.stateChanged(new ChangeEvent(this));
    }

    public MJMenu createGroupingMenu() {
        MJMenu mJMenu = new MJMenu(GroupingTableResources.getString("table.groupByMenu"));
        mJMenu.setName("menu.group");
        this.updateStates();
        mJMenu.add((Action)this.fStopGroupingAction);
        mJMenu.addSeparator();
        for (MJCheckBoxMenuItem mJCheckBoxMenuItem : this.fGroupItems.values()) {
            mJMenu.add((JMenuItem)mJCheckBoxMenuItem);
        }
        return mJMenu;
    }

    public MJMenu createSortingMenu() {
        MJMenu mJMenu = new MJMenu(GroupingTableResources.getString("table.sortByMenu"));
        mJMenu.setName("menu.sort");
        this.updateStates();
        for (MJCheckBoxMenuItem mJCheckBoxMenuItem : this.fSortItems.values()) {
            mJMenu.add((JMenuItem)mJCheckBoxMenuItem);
        }
        mJMenu.addSeparator();
        mJMenu.add((JMenuItem)this.fSortAscendingItem);
        mJMenu.add((JMenuItem)this.fSortDescendingItem);
        return mJMenu;
    }

    public MJMenu createShowMenu() {
        MJMenu mJMenu = new MJMenu(GroupingTableResources.getString("table.chooseColumns"));
        mJMenu.setName("menu.show");
        this.addShowItems(mJMenu);
        return mJMenu;
    }

    public void addShowItems(MJMenu mJMenu) {
        this.updateStates();
        for (MJCheckBoxMenuItem mJCheckBoxMenuItem : this.fShowColumnItems.values()) {
            mJMenu.add((JMenuItem)mJCheckBoxMenuItem);
        }
        for (MJCheckBoxMenuItem mJCheckBoxMenuItem : this.fShowVerticalAttributeItems.values()) {
            mJMenu.add((JMenuItem)mJCheckBoxMenuItem);
        }
    }

    public void addShowItems(MJPopupMenu mJPopupMenu) {
        this.updateStates();
        for (MJCheckBoxMenuItem mJCheckBoxMenuItem : this.fShowColumnItems.values()) {
            mJPopupMenu.add((JMenuItem)mJCheckBoxMenuItem);
        }
        for (MJCheckBoxMenuItem mJCheckBoxMenuItem : this.fShowVerticalAttributeItems.values()) {
            mJPopupMenu.add((JMenuItem)mJCheckBoxMenuItem);
        }
    }

    private void updateStates() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTableConfiguration groupingTableConfiguration = ColumnActions.this.fModel.getConfiguration();
                GroupingMode groupingMode = groupingTableConfiguration.getGroupMode();
                GroupingTableColumn groupingTableColumn = groupingTableConfiguration.getSortColumn();
                List list = groupingTableConfiguration.getVisibleColumns();
                ColumnActions.this.fStopGroupingAction.setEnabled(groupingTableConfiguration.getGroupMode() != null);
                for (Map.Entry entry : ColumnActions.this.fGroupItems.entrySet()) {
                    ((MJCheckBoxMenuItem)entry.getValue()).setSelected(groupingMode != null && groupingMode.equals(entry.getKey()));
                }
                for (Map.Entry entry : ColumnActions.this.fSortItems.entrySet()) {
                    ((MJCheckBoxMenuItem)entry.getValue()).setSelected(groupingTableColumn != null && groupingTableColumn.equals(entry.getKey()));
                }
                for (Map.Entry entry : ColumnActions.this.fShowColumnItems.entrySet()) {
                    ((MJCheckBoxMenuItem)entry.getValue()).setSelected(list.contains(entry.getKey()));
                }
                for (Map.Entry entry : ColumnActions.this.fShowVerticalAttributeItems.entrySet()) {
                    ((MJCheckBoxMenuItem)entry.getValue()).setSelected(groupingTableConfiguration.isVerticalAttributeOrColumnVisible((VerticalAttribute)entry.getKey()));
                }
                ColumnActions.this.fSortAscendingItem.setEnabled(groupingTableColumn != null);
                ColumnActions.this.fSortDescendingItem.setEnabled(groupingTableColumn != null);
                ColumnActions.this.fSortAscendingItem.setSelected(!groupingTableConfiguration.isSortedDescending());
                ColumnActions.this.fSortDescendingItem.setSelected(groupingTableConfiguration.isSortedDescending());
            }
        });
    }
}

