/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.fonts;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.FontSize;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.widgets.AutoCompletionList;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.fonts.FontSamplePanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang.Validate;

public final class AutoCompletionFontPanel
implements ComponentBuilder {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(AutoCompletionFontPanel.class.getPackage().getName() + ".resources.RES_Fonts");
    private final AutoCompletionList fNames;
    private final AutoCompletionList fStyles;
    private final AutoCompletionList fSizes;
    private final JPanel fPanel;
    private int fSize;

    public AutoCompletionFontPanel() {
        this(FontUtils.getFontNames(), null);
    }

    public AutoCompletionFontPanel(Font font) {
        this(FontUtils.getFontNames(), font);
    }

    public AutoCompletionFontPanel(List<String> list, Font font) {
        Validate.notNull(list, (String)"'fontNames' cannot be null");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p, 4dlu, p, 4dlu, p", "p, 2dlu, p, 2dlu, p"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(AutoCompletionFontPanel.lookup("fontTitle"), cellConstraints.xy(1, 1));
        final FontSamplePanel fontSamplePanel = new FontSamplePanel();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fontSamplePanel.setSampleFont(AutoCompletionFontPanel.this.getSelectedFont());
            }
        };
        this.fNames = new AutoCompletionList(list, "FontName");
        this.fNames.addActionListener(actionListener);
        List list2 = FontUtils.getFontStyles();
        this.fStyles = new AutoCompletionList(list2, "FontStyle");
        this.fStyles.addActionListener(actionListener);
        this.fSizes = new AutoCompletionList(FontUtils.getStandardSizes(), "FontSize");
        this.fSizes.setStrict(false);
        this.fSizes.addActionListener(actionListener);
        panelBuilder.add((Component)this.fNames.getComponent(), cellConstraints.xy(1, 3));
        panelBuilder.addLabel(AutoCompletionFontPanel.lookup("styleTitle"), cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.fStyles.getComponent(), cellConstraints.xy(3, 3));
        panelBuilder.addLabel(AutoCompletionFontPanel.lookup("sizeTitle"), cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.fSizes.getComponent(), cellConstraints.xy(5, 3));
        panelBuilder.add((Component)fontSamplePanel.getPanel(), cellConstraints.xywh(1, 5, 5, 1));
        this.fPanel = panelBuilder.getPanel();
        if (font != null) {
            this.setSelectedFont(font);
        }
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("'font' cannot be null");
        }
        this.fNames.setSelectedValue(font.getName());
        this.fStyles.setSelectedValue(FontUtils.styleToString((Font)font));
        this.fSizes.setSelectedValue(FontSize.createFromJavaFont((Font)font).getDisplaySize());
    }

    public Font getSelectedFont() {
        String string = this.fNames.getSelectedValue();
        int n = FontUtils.stringToStyle((String)this.fStyles.getSelectedValue());
        String string2 = this.fSizes.getSelectedValue();
        FontSize fontSize = FontSize.createFromPointSize((String)string2);
        if (fontSize != null) {
            this.fSize = fontSize.getJavaSize();
            this.fSizes.setRevertOnFocusLost(string2);
        }
        return new Font(string, n, this.fSize);
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    private static String lookup(String string) {
        return BUNDLE.getString("AutoCompletionFontPanel." + string);
    }
}

