/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.find;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MComponentInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.FocusTraversalPolicyBuilder;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindClientRegistryListener;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindRunnable;
import com.mathworks.widgets.find.LookinItem;
import com.mathworks.widgets.find.SafeX11Caret;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public final class FindPanel
implements ComponentBuilder {
    private final MJButton fFindButton;
    private final MJButton fFindBackButton;
    private final MJButton fReplaceButton;
    private final MJButton fReplaceAllButton;
    private final MJButton fCloseButton;
    private final MJCheckBox fMatchCase;
    private final MJCheckBox fWrapAround;
    private final MJCheckBox fWholeWord;
    private final MJCheckBox fSelectedSearch;
    private final MJComboBox fSearchText;
    private final MJComboBox fReplaceText;
    private final MJComboBox fLookInCombo;
    private final MJLabel fReplaceLabel;
    private final MJLabel fFindLabel;
    private final MJLabel fLookinLabel;
    private final MJPanel fPanel;
    private final PropertyChangeSupport fPropertySupport = new PropertyChangeSupport(this);
    private MJButton fDefaultButton;
    private int fCurrentOptions;
    private boolean fDisableComboBoxReactions;
    private LookinItem fLastLookIn;
    private FindClientRegistryListener fRegistryListener;
    static final String DEFAULT_BUTTON_PROPERTY = "default-button";
    static final String REPLACE_ALLOWED_PROPERTY = "replace-allowed";
    static final String LIMIT_SEARCH_TO_SELECTION_PROPERTY = "search-selection";
    static final String CLIENT_PROPERTY = "client";
    static final String LOOKIN_PROPERTY = "look-in";
    static final String OPTIONS_PROPERTY = "options";
    public static final String FIND_TOOL_CONTEXT = "FindTools";

    FindPanel() {
        this.fFindButton = FindPanel.createFindNextButton();
        this.fFindBackButton = FindPanel.createFindPreviousButton();
        this.fReplaceButton = FindPanel.createButton("Replace", "Replace Button", new FindRunnable(){

            @Override
            public void run(FindClientInterface findClientInterface, FindEvent findEvent) {
                findClientInterface.replace(findEvent);
            }
        });
        this.fReplaceAllButton = FindPanel.createButton("ReplaceAll", "ReplaceAll Button", new FindRunnable(){

            @Override
            public void run(FindClientInterface findClientInterface, FindEvent findEvent) {
                findClientInterface.replaceAll(findEvent);
            }
        });
        this.fDefaultButton = this.fCloseButton = FindPanel.createButtonWithRunnable("Close", "Close Button", new Runnable(){

            @Override
            public void run() {
                FindDialog.getInstance().close();
            }
        });
        this.fSearchText = this.createSearchTextCombo();
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fSearchText, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)FIND_TOOL_CONTEXT);
        this.fReplaceText = FindPanel.createReplaceTextCombo();
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fReplaceText, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)FIND_TOOL_CONTEXT);
        this.fLookInCombo = this.createLookInCombo();
        this.refreshLookInCombo(null, null);
        this.fMatchCase = this.createCheckBox("Matchcase", "Match Case Checkbox", 1);
        this.fWholeWord = this.createCheckBox("Wholeword", "Whole Word Checkbox", 4);
        this.fWrapAround = this.createCheckBox("Wraparound", "Wrap Around Checkbox", 2);
        this.fSelectedSearch = this.createCheckBox("Selectedsearch", "Selected Search Checkbox", 16);
        this.fFindLabel = new MJLabel(FindDialog.BUNDLE.getString("label.Findwhat"));
        this.fReplaceLabel = new MJLabel(FindDialog.BUNDLE.getString("label.Replacewith"));
        this.fLookinLabel = new MJLabel(FindDialog.BUNDLE.getString("label.Lookin"));
        this.fPanel = new MJPanel();
        this.fPanel.setName("Dialog Panel");
        this.layoutPanel();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(FindPanel.REPLACE_ALLOWED_PROPERTY) || propertyChangeEvent.getPropertyName().equals(FindPanel.LIMIT_SEARCH_TO_SELECTION_PROPERTY)) {
                    FindPanel.this.layoutPanel();
                }
            }
        });
        this.fRegistryListener = this.createFindClientRegistryListener();
        FindClientRegistry.addListener(this.fRegistryListener);
        this.fLastLookIn = (LookinItem)this.fLookInCombo.getSelectedItem();
    }

    private FindClientRegistryListener createFindClientRegistryListener() {
        return new FindClientRegistryListener(){

            @Override
            public void lookinsChanged(FindClientInterface findClientInterface, List<LookinItem> list) {
                FindPanel.this.refreshLookInCombo(findClientInterface, list);
            }
        };
    }

    void dispose() {
        if (this.fRegistryListener != null) {
            FindClientRegistry.removeListener(this.fRegistryListener);
        }
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    int getOptions() {
        return this.fCurrentOptions;
    }

    void setOptions(int n) {
        int n2 = this.fCurrentOptions;
        this.fCurrentOptions = n;
        this.fPropertySupport.firePropertyChange(OPTIONS_PROPERTY, n2, this.fCurrentOptions);
    }

    String getSearchText() {
        return FindPanel.getCurrentText(this.fSearchText);
    }

    void setSearchText(String string) {
        this.fSearchText.setSelectedItem((Object)FindPanel.getFirstNonBlankLine(string));
    }

    List<String> getSearchHistory() {
        return FindPanel.getHistory(this.fSearchText);
    }

    void setSearchHistory(List<String> list) {
        FindPanel.setHistory(this.fSearchText, list);
    }

    String getReplaceText() {
        return FindPanel.getCurrentText(this.fReplaceText);
    }

    void setReplaceText(String string) {
        this.fReplaceText.setSelectedItem((Object)string);
    }

    List<String> getReplaceHistory() {
        return FindPanel.getHistory(this.fReplaceText);
    }

    void setReplaceHistory(List<String> list) {
        FindPanel.setHistory(this.fReplaceText, list);
    }

    boolean isReplaceAllowed() {
        return this.getLookIn() != null && this.getLookIn().isReplaceAllowed();
    }

    boolean isLimitSearchToSelection() {
        return this.getLookIn() != null && this.getLookIn().isLimitSearchToSelection();
    }

    LookinItem getLookIn() {
        return (LookinItem)this.fLookInCombo.getSelectedItem();
    }

    void setLookIn(LookinItem lookinItem) {
        this.fLookInCombo.setSelectedItem((Object)lookinItem);
    }

    void setLookIn(FindClientInterface findClientInterface) {
        this.setLookIn(FindClientRegistry.getLookins(findClientInterface).get(0));
    }

    void notifyInvokeOrRun() {
        this.updateComboBox(this.fSearchText);
        this.updateComboBox(this.fReplaceText);
    }

    private void changeDefaultButton(MJButton mJButton) {
        MJButton mJButton2 = this.fDefaultButton;
        this.fDefaultButton = mJButton;
        this.fPropertySupport.firePropertyChange(DEFAULT_BUTTON_PROPERTY, mJButton2, this.fDefaultButton);
    }

    private MJComboBox createSearchTextCombo() {
        MJComboBox mJComboBox = new MJComboBox(new DefaultComboBoxModel<String>(new String[]{""}));
        mJComboBox.setName("Find Field");
        mJComboBox.getAccessibleContext().setAccessibleName(FindDialog.BUNDLE.getString("label.Findwhat"));
        mJComboBox.setActionCommand("FindWhat");
        mJComboBox.setEditable(true);
        this.updateEnabledStatesOnChange(mJComboBox);
        FindPanel.fixCaret(mJComboBox);
        return mJComboBox;
    }

    private static MJComboBox createReplaceTextCombo() {
        MJComboBox mJComboBox = new MJComboBox(new DefaultComboBoxModel<String>(new String[]{""}));
        mJComboBox.setName("Replace Field");
        mJComboBox.getAccessibleContext().setAccessibleName(FindDialog.BUNDLE.getString("label.Replacewith"));
        mJComboBox.setActionCommand("ReplaceWith");
        mJComboBox.setEditable(true);
        FindPanel.fixCaret(mJComboBox);
        return mJComboBox;
    }

    private MJComboBox createLookInCombo() {
        LookinItem[] lookinItemArray = new LookinItem[]{new LookinItem("", null, false)};
        final MJComboBox mJComboBox = new MJComboBox(new DefaultComboBoxModel<LookinItem>(lookinItemArray));
        mJComboBox.setName("Look In Field");
        mJComboBox.getAccessibleContext().setAccessibleName(FindDialog.BUNDLE.getString("label.Lookin"));
        mJComboBox.setActionCommand("LookIn");
        mJComboBox.setEditable(false);
        mJComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!FindPanel.this.fDisableComboBoxReactions) {
                    LookinItem lookinItem = FindPanel.this.fLastLookIn;
                    FindPanel.this.fLastLookIn = (LookinItem)mJComboBox.getSelectedItem();
                    FindPanel.this.fPropertySupport.firePropertyChange(FindPanel.LOOKIN_PROPERTY, lookinItem, FindPanel.this.fLastLookIn);
                    FindPanel.this.fPropertySupport.firePropertyChange(FindPanel.CLIENT_PROPERTY, lookinItem == null ? null : lookinItem.getClient(), FindPanel.this.fLastLookIn == null ? null : FindPanel.this.fLastLookIn.getClient());
                    FindPanel.this.fPropertySupport.firePropertyChange(FindPanel.REPLACE_ALLOWED_PROPERTY, lookinItem != null && lookinItem.isReplaceAllowed(), FindPanel.this.fLastLookIn != null && FindPanel.this.fLastLookIn.isReplaceAllowed());
                    FindPanel.this.fPropertySupport.firePropertyChange(FindPanel.LIMIT_SEARCH_TO_SELECTION_PROPERTY, lookinItem != null && lookinItem.isLimitSearchToSelection(), FindPanel.this.fLastLookIn != null && FindPanel.this.fLastLookIn.isLimitSearchToSelection());
                }
            }
        });
        return mJComboBox;
    }

    private static MJButton createButton(String string, String string2, final FindRunnable findRunnable) {
        return FindPanel.createButtonWithRunnable(string, string2, new Runnable(){

            @Override
            public void run() {
                FindDialog.runWithCurrentSettings(findRunnable);
            }
        });
    }

    private static MJButton createButtonWithKeybindings(String string, String string2, final FindRunnable findRunnable, String string3) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.runWithCurrentSettings(findRunnable);
            }
        };
        MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(FIND_TOOL_CONTEXT, string3, (ExtendedAction)mJAbstractAction);
        MJButton mJButton = FindPanel.createButtonFromAction(mJAbstractAction, string2);
        mJButton.setText(FindDialog.BUNDLE.getString("button." + string));
        MatlabKeyBindings.getManager().addKeyBindings((ExtendedAction)mJAbstractAction, FindPanel.getButtonInputMap(mJButton));
        MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)mJAbstractAction, mJButton.getActionMap());
        return mJButton;
    }

    private static void fixCaret(MJComboBox mJComboBox) {
        if (PlatformInfo.isXWindows()) {
            ((JTextComponent)mJComboBox.getEditor().getEditorComponent()).setCaret(new SafeX11Caret());
        }
    }

    private static ExtendedInputMap getButtonInputMap(MJButton mJButton) {
        InputMap inputMap = mJButton.getInputMap(2);
        if (!(inputMap instanceof ExtendedInputMap)) {
            MComponentInputMap mComponentInputMap = new MComponentInputMap((JComponent)mJButton);
            mComponentInputMap.setParent(inputMap);
            mJButton.setInputMap(2, (InputMap)mComponentInputMap);
            inputMap = mComponentInputMap;
        }
        return (ExtendedInputMap)inputMap;
    }

    private static MJButton createButtonWithRunnable(String string, String string2, final Runnable runnable) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(FindDialog.BUNDLE.getString("button." + string)){

            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        };
        return FindPanel.createButtonFromAction(mJAbstractAction, string2);
    }

    private static MJButton createButtonFromAction(MJAbstractAction mJAbstractAction, String string) {
        mJAbstractAction.setTip(null);
        MJButton mJButton = new MJButton((Action)mJAbstractAction);
        mJButton.setName(string);
        return mJButton;
    }

    private MJCheckBox createCheckBox(String string, String string2, final int n) {
        final MJCheckBox mJCheckBox = new MJCheckBox(FindDialog.BUNDLE.getString("option." + string));
        final Semaphore semaphore = new Semaphore(1);
        mJCheckBox.setSelected((this.fCurrentOptions & n) != 0);
        mJCheckBox.setName(string2);
        mJCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (semaphore.tryAcquire()) {
                    if (mJCheckBox.isSelected()) {
                        FindPanel.this.setOptions(FindPanel.this.getOptions() | n);
                    } else {
                        FindPanel.this.setOptions(FindPanel.this.getOptions() & ~n);
                    }
                    semaphore.release();
                }
            }
        });
        this.addPropertyChangeListener(OPTIONS_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (semaphore.tryAcquire()) {
                    mJCheckBox.setSelected((FindPanel.this.getOptions() & n) != 0);
                    semaphore.release();
                }
            }
        });
        return mJCheckBox;
    }

    private void layoutPanel() {
        this.fPanel.removeAll();
        boolean bl = this.isReplaceAllowed();
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p, 3dlu, 140dlu:grow, 10dlu, p", bl ? "p, 4dlu, p, 4dlu, p, 4dlu, p, 10dlu, p" : "p, 4dlu, p, 4dlu, p, 4dlu, p"), (JPanel)this.fPanel);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fFindLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fSearchText, cellConstraints.xy(3, 1));
        int n = bl ? 2 : 0;
        panelBuilder.add((Component)this.fLookinLabel, cellConstraints.xy(1, n + 3));
        panelBuilder.add((Component)this.fLookInCombo, cellConstraints.xy(3, n + 3));
        panelBuilder.add((Component)this.fFindButton, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)this.fFindBackButton, cellConstraints.xy(5, 3));
        panelBuilder.add((Component)this.fCloseButton, cellConstraints.xy(5, n + 7));
        if (bl) {
            panelBuilder.add((Component)this.fReplaceLabel, cellConstraints.xy(1, 3));
            panelBuilder.add((Component)this.fReplaceText, cellConstraints.xy(3, 3));
            panelBuilder.add((Component)this.fReplaceButton, cellConstraints.xy(5, 5));
            panelBuilder.add((Component)this.fReplaceAllButton, cellConstraints.xy(5, 7));
        }
        PanelBuilder panelBuilder2 = !this.isLimitSearchToSelection() ? new PanelBuilder(new FormLayout("p, 3dlu, p, 3dlu, p", "p")) : new PanelBuilder(new FormLayout("p, 3dlu, p, 3dlu, p", "p, 3dlu, p, 3dlu, p"));
        panelBuilder2.getPanel().setName("Options Panel");
        panelBuilder2.add((Component)this.fMatchCase, cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)this.fWholeWord, cellConstraints.xy(3, 1));
        panelBuilder2.add((Component)this.fWrapAround, cellConstraints.xy(5, 1));
        if (this.isLimitSearchToSelection()) {
            panelBuilder2.add((Component)this.fSelectedSearch, cellConstraints.xy(1, 3));
        }
        panelBuilder.add((Component)panelBuilder2.getPanel(), cellConstraints.xywh(1, n + 7, 3, 1));
        this.fPanel.revalidate();
        this.fPanel.repaint();
    }

    FocusTraversalPolicy createFocusTraversalPolicy() {
        FocusTraversalPolicyBuilder focusTraversalPolicyBuilder = new FocusTraversalPolicyBuilder((Component)this.fSearchText, (Component)this.fCloseButton);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fReplaceText);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fLookInCombo);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fMatchCase);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fWholeWord);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fWrapAround);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fFindButton);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fFindBackButton);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fReplaceButton);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fReplaceAllButton);
        focusTraversalPolicyBuilder.addNextStep((Component)this.fCloseButton);
        return focusTraversalPolicyBuilder.getPolicy();
    }

    private void updateEnabledStatesOnChange(MJComboBox mJComboBox) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!FindPanel.this.fDisableComboBoxReactions) {
                    boolean bl = !FindPanel.getCurrentText(FindPanel.this.fSearchText).isEmpty();
                    FindPanel.this.fFindButton.setEnabled(bl);
                    FindPanel.this.fFindBackButton.setEnabled(bl);
                    FindPanel.this.fReplaceButton.setEnabled(bl);
                    FindPanel.this.fReplaceAllButton.setEnabled(bl);
                    if (!bl) {
                        FindPanel.this.changeDefaultButton(FindPanel.this.fCloseButton);
                    } else if (FindPanel.this.fDefaultButton == FindPanel.this.fCloseButton) {
                        FindPanel.this.changeDefaultButton(FindPanel.this.fFindButton);
                    }
                }
            }
        };
        mJComboBox.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    runnable.run();
                }
            }
        });
        JTextComponent jTextComponent = (JTextComponent)mJComboBox.getEditor().getEditorComponent();
        jTextComponent.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                runnable.run();
            }
        });
        mJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        });
    }

    private static String getCurrentText(MJComboBox mJComboBox) {
        return ((JTextComponent)mJComboBox.getEditor().getEditorComponent()).getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithoutReactingToComboBoxChange(Runnable runnable) {
        this.fDisableComboBoxReactions = true;
        try {
            runnable.run();
        }
        finally {
            this.fDisableComboBoxReactions = false;
        }
    }

    private void refreshLookInCombo(FindClientInterface findClientInterface, List<LookinItem> list) {
        LookinItem lookinItem = (LookinItem)this.fLookInCombo.getSelectedItem();
        final ArrayList arrayList = new ArrayList();
        this.runWithoutReactingToComboBoxChange(new Runnable(){

            @Override
            public void run() {
                FindPanel.this.fLookInCombo.removeAllItems();
                arrayList.addAll(FindClientRegistry.getAllLookins());
                for (LookinItem lookinItem : arrayList) {
                    FindPanel.this.fLookInCombo.addItem((Object)lookinItem);
                }
            }
        });
        if (findClientInterface != null && lookinItem != null && !arrayList.contains(lookinItem) && !list.isEmpty()) {
            lookinItem = list.get(0);
        }
        this.fLookInCombo.setSelectedItem((Object)lookinItem);
    }

    public void requestFocus() {
        this.fSearchText.requestFocus();
    }

    public void requestFocusInWindow() {
        this.fSearchText.requestFocusInWindow();
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    public MJButton getDefaultButton() {
        return this.fDefaultButton;
    }

    private void updateComboBox(final MJComboBox mJComboBox) {
        this.runWithoutReactingToComboBoxChange(new Runnable(){

            @Override
            public void run() {
                String string = FindPanel.getCurrentText(mJComboBox);
                if (string.isEmpty()) {
                    return;
                }
                mJComboBox.removeItem((Object)string);
                mJComboBox.insertItemAt((Object)string, 0);
                mJComboBox.setSelectedIndex(0);
                mJComboBox.removeItem((Object)"");
                if (mJComboBox.getItemCount() > 20) {
                    mJComboBox.removeItemAt(20);
                }
            }
        });
    }

    private static List<String> getHistory(MJComboBox mJComboBox) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(FindPanel.getCurrentText(mJComboBox));
        for (int i = 0; i < mJComboBox.getItemCount(); ++i) {
            linkedHashSet.add(mJComboBox.getItemAt(i).toString());
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private static void setHistory(MJComboBox mJComboBox, List<String> list) {
        mJComboBox.removeAllItems();
        if (!list.isEmpty()) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list);
            for (String string : linkedHashSet) {
                mJComboBox.addItem((Object)string);
            }
            mJComboBox.removeItem((Object)"");
            mJComboBox.setSelectedItem((Object)list.get(0));
        }
    }

    private static String getFirstNonBlankLine(String string) {
        return string == null ? "" : StringUtils.stripEnd((String)StringUtils.stripStart((String)string, (String)"\n"), (String)"\n").split("\n")[0];
    }

    public static MJButton createFindNextButton() {
        return FindPanel.createButtonWithKeybindings("Next", "Find Button", new FindRunnable(){

            @Override
            public void run(FindClientInterface findClientInterface, FindEvent findEvent) {
                findClientInterface.findForward(findEvent);
            }
        }, "find-next");
    }

    public static MJButton createFindPreviousButton() {
        return FindPanel.createButtonWithKeybindings("Previous", "Find Back Button", new FindRunnable(){

            @Override
            public void run(FindClientInterface findClientInterface, FindEvent findEvent) {
                findClientInterface.findBack(findEvent);
            }
        }, "find-previous");
    }
}

