/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.FixedIcon;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJScrollStrip;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.ResizableIcon;
import com.mathworks.mwswing.border.FocusBorderFactory;
import com.mathworks.mwswing.checkboxtree.CheckBoxTree;
import com.mathworks.mwswing.checkboxtree.CheckBoxTreeListener;
import com.mathworks.mwswing.checkboxtree.DefaultCheckBoxNode;
import com.mathworks.mwswing.checkboxtree.Selectable;
import com.mathworks.mwswing.checkboxtree.SelectionState;
import com.mathworks.toolstrip.accessories.QuickAccessToolBar;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.ComponentIcon;
import com.mathworks.widgets.desk.DTComponentBar;
import com.mathworks.widgets.desk.DTToolbarLayoutController;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class QuickAccessToolBarCustomizationPanel
extends MJPanel {
    public static final String QATB_CB_TREE_NAME = "QATB_CB_TREE";
    static final String QAB_LAYOUT_CONTROLLER_NAME = "QuickAccess";
    private static final String QATB_ROOT_NODE_TITLE = Desktop.sRes.getString("title.QuickAccessToolbar");
    private static final String COMMON_TOOLS = Desktop.sRes.getString("label.CommonToolsTab");
    private static final String NO_TOOLS_LABEL = Desktop.sRes.getString("label.NoToolsInQuickAccessToolBar");
    private static final String NO_TOOLS_LABEL_NAME = "No_Tools";
    private static final int DEFAULT_ICON_WIDTH = 16;
    private static final int DEFAULT_ICON_HEIGHT = 16;
    private List<DefaultMutableTreeNode> fNodes;
    private Map<DefaultMutableTreeNode, TSToolPath> fToolPathMap;
    private CheckBoxTree fCBTree;
    private MJScrollStrip fDummyQATB;
    private QuickAccessComponentBar fComponentBar;
    private QuickAccessConfiguration fQuickAccessConfig;
    private QuickAccessConfiguration fDefaultQuickAccessConfig;
    private TSRegistry fToolstripRegistry;
    private DTToolbarLayoutController fLayoutController;
    private static boolean sIsInitialized;
    private QuickAccessToolBar fQuickAccessToolbar;
    private boolean fIsSavingUpdates;

    public void init(QuickAccessConfiguration quickAccessConfiguration, QuickAccessConfiguration quickAccessConfiguration2, TSRegistry tSRegistry, QuickAccessToolBar quickAccessToolBar) {
        this.fQuickAccessConfig = quickAccessConfiguration;
        this.fDefaultQuickAccessConfig = quickAccessConfiguration2;
        this.fToolstripRegistry = tSRegistry;
        this.fQuickAccessToolbar = quickAccessToolBar;
        this.fNodes = new ArrayList<DefaultMutableTreeNode>();
        this.fToolPathMap = new HashMap<DefaultMutableTreeNode, TSToolPath>();
        this.fComponentBar = new QuickAccessComponentBar();
        this.fDummyQATB = new MJScrollStrip(0, (Component)((Object)this.fComponentBar), true){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 0;
                return dimension;
            }
        };
        this.fDummyQATB.setScrollOnMouseOver(true);
        this.fDummyQATB.setBorder(FocusBorderFactory.create());
        this.fLayoutController = new DTToolbarLayoutController(this.fComponentBar, this.fComponentBar, true, QAB_LAYOUT_CONTROLLER_NAME);
        this.fToolstripRegistry.addCoalescingListener(new TSRegistry.Listener(){

            public void registryUpdated(TSRegistry.UpdateEvent updateEvent) {
                QuickAccessToolBarCustomizationPanel.this.configureTree();
                QuickAccessToolBarCustomizationPanel.this.fCBTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)QuickAccessToolBarCustomizationPanel.this.fNodes.get(0)));
                QuickAccessToolBarCustomizationPanel.this.expandNode(COMMON_TOOLS);
                QuickAccessToolBarCustomizationPanel.this.fComponentBar.createTools(QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig);
            }
        });
        this.fQuickAccessConfig.addListener(new QuickAccessConfiguration.ChangeListener(){

            public void configurationChanged(QuickAccessConfiguration.ChangeEvent changeEvent) {
                QuickAccessConfiguration.ChangeType changeType = changeEvent.getType();
                if (changeType.equals((Object)QuickAccessConfiguration.ChangeType.OTHER)) {
                    if (!QuickAccessToolBarCustomizationPanel.this.fIsSavingUpdates) {
                        QuickAccessToolBarCustomizationPanel.this.fComponentBar.refresh();
                    }
                    return;
                }
                TSToolPath tSToolPath = changeEvent.getTool().getPath();
                if (changeType.equals((Object)QuickAccessConfiguration.ChangeType.ADD)) {
                    this.updateNode(SelectionState.SELECTED, tSToolPath);
                } else if (changeType.equals((Object)QuickAccessConfiguration.ChangeType.REMOVE)) {
                    this.updateNode(SelectionState.NOT_SELECTED, tSToolPath);
                }
            }

            private void updateNode(SelectionState selectionState, TSToolPath tSToolPath) {
                for (Map.Entry entry : QuickAccessToolBarCustomizationPanel.this.fToolPathMap.entrySet()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)entry.getKey();
                    TSToolPath tSToolPath2 = (TSToolPath)entry.getValue();
                    if (!tSToolPath2.equals((Object)tSToolPath) || !(defaultMutableTreeNode instanceof DefaultCheckBoxNode)) continue;
                    ((Selectable)defaultMutableTreeNode).setSelectionState(selectionState);
                    QuickAccessToolBarCustomizationPanel.this.fCBTree.repaint();
                    break;
                }
            }
        });
        this.configureTree();
        this.setLayout(new BorderLayout());
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.fNodes.get(0));
        this.fCBTree = new CheckBoxTree((TreeModel)defaultTreeModel, false);
        this.fCBTree.setCellRenderer((TreeCellRenderer)new QATBTreeCellRenderer());
        this.fCBTree.setReadOnly(false);
        this.fCBTree.setName(QATB_CB_TREE_NAME);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fCBTree, 20, 30);
        this.add((Component)mJScrollPane);
        this.fCBTree.addCheckBoxListener((CheckBoxTreeListener)this.fComponentBar);
        this.expandNode(COMMON_TOOLS);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.fCBTree);
        this.fCBTree.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = QuickAccessToolBarCustomizationPanel.this.fCBTree.getRowForPath(QuickAccessToolBarCustomizationPanel.this.fCBTree.getPathForLocation(point.x, point.y));
                if (n <= 0) {
                    QuickAccessToolBarCustomizationPanel.this.fCBTree.setToolTipText("");
                }
            }
        });
        sIsInitialized = true;
    }

    public boolean isInitialized() {
        return sIsInitialized;
    }

    public MJScrollStrip getToolbarProxy() {
        return this.fDummyQATB;
    }

    public DTToolbarLayoutController getLayoutController() {
        return this.fLayoutController;
    }

    public void expandNode(String string) {
        for (DefaultMutableTreeNode defaultMutableTreeNode : this.fNodes) {
            if (!(defaultMutableTreeNode instanceof QATBHeaderNode) || !(defaultMutableTreeNode.getUserObject() instanceof String) || !((String)defaultMutableTreeNode.getUserObject()).equals(string)) continue;
            this.fCBTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private void configureTree() {
        this.fNodes.clear();
        this.fToolPathMap.clear();
        QATBHeaderNode qATBHeaderNode = new QATBHeaderNode(null);
        this.fNodes.add(qATBHeaderNode);
        List list = this.fToolstripRegistry.getTabConfigurations();
        for (TSTabConfiguration tSTabConfiguration : list) {
            Object object;
            String string;
            String string2 = tSTabConfiguration.getLabel();
            if (string2.length() == 0) {
                string2 = COMMON_TOOLS;
            }
            if ((string = tSTabConfiguration.getContextName()) != null && (object = this.fToolstripRegistry.getTabContextLabel(string)) != null && !((String)object).equals(string2)) {
                string2 = (String)object + " - " + string2;
            }
            object = new QATBHeaderNode((Object)string2);
            List list2 = tSTabConfiguration.getSections();
            for (TSTabConfiguration.Section section : list2) {
                List list3 = section.getTools();
                for (TSTabConfiguration.Tool tool : list3) {
                    String string3;
                    String string4 = string3 = tSTabConfiguration.getContributeToName() != null ? tSTabConfiguration.getContributeToName() : tSTabConfiguration.getName();
                    TSToolSetContents tSToolSetContents = this.fToolstripRegistry.getToolSetContents(tool.getToolSetName());
                    if (tSToolSetContents == null) continue;
                    TSToolSetContents.Tool tool2 = tSToolSetContents.getTool(tool.getName());
                    TSToolPath tSToolPath = new TSToolPath(string3, section.getName());
                    this.addTool(tool2, (DefaultMutableTreeNode)object, tSToolPath);
                }
            }
            if (((DefaultMutableTreeNode)object).isLeaf()) continue;
            qATBHeaderNode.add((MutableTreeNode)object);
            this.fNodes.add((DefaultMutableTreeNode)object);
        }
    }

    private void addTool(TSToolSetContents.Tool tool, DefaultMutableTreeNode defaultMutableTreeNode, TSToolPath tSToolPath) {
        try {
            if (tool != null) {
                if (!tool.isQuickAccessEligible() && !tool.hasChildren()) {
                    return;
                }
                TSToolPath tSToolPath2 = tSToolPath.appendTool(tool.getName(), tool.getToolSetName(), tool.isCommon());
                SelectionState selectionState = this.getSelectionState(tSToolPath2);
                Icon icon = tool.getIcon();
                if (icon == null) {
                    icon = QuickAccessToolBarCustomizationPanel.getIcon(tool.getType());
                }
                Icon icon2 = icon;
                if (icon instanceof ResizableIcon) {
                    int n = ((ResizableIcon)icon).getSmallestIconWidth();
                    if (n <= 0) {
                        n = 16;
                    }
                    icon2 = new FixedIcon((ResizableIcon)icon, n, 16);
                }
                DefaultCheckBoxNode defaultCheckBoxNode = null;
                if (tool.isQuickAccessEligible() && !tool.hasChildren()) {
                    defaultCheckBoxNode = new DefaultCheckBoxNode((Object)new MnemonicsFreeLabel(tool.getLabel(), icon2, tool.getDescription()), false, selectionState);
                    this.fToolPathMap.put((DefaultMutableTreeNode)defaultCheckBoxNode, tSToolPath2);
                    defaultMutableTreeNode.add((MutableTreeNode)defaultCheckBoxNode);
                } else if (tool.hasChildren()) {
                    QATBHeaderNode qATBHeaderNode = null;
                    TSToolSetContents.ToolType toolType = tool.getType();
                    TSToolSetContents.HeaderType headerType = tool.getHeaderType();
                    if (toolType.equals((Object)TSToolSetContents.ToolType.GROUP) && (headerType.equals((Object)TSToolSetContents.HeaderType.SEPARATOR) || headerType.equals((Object)TSToolSetContents.HeaderType.NONE))) {
                        List list = tool.getChildren();
                        for (TSToolSetContents.Tool tool2 : list) {
                            this.addTool(tool2, defaultMutableTreeNode, tSToolPath);
                        }
                        return;
                    }
                    if (!tool.isQuickAccessEligible()) {
                        if (this.areAnyChildrenQuickAccessEligible(tool)) {
                            qATBHeaderNode = new QATBHeaderNode((Object)tool.getLabel());
                        }
                    } else {
                        qATBHeaderNode = new DefaultCheckBoxNode((Object)new MnemonicsFreeLabel(tool.getLabel(), icon2, tool.getDescription()), true, selectionState);
                    }
                    if (qATBHeaderNode != null) {
                        this.fToolPathMap.put(qATBHeaderNode, tSToolPath.appendTool(tool.getName(), tool.getToolSetName(), tool.isCommon()));
                        defaultMutableTreeNode.add(qATBHeaderNode);
                        List list = tool.getChildren();
                        for (TSToolSetContents.Tool tool3 : list) {
                            if (tool3.getName() == null || tool3.getToolSetName() == null) continue;
                            this.addTool(tool3, qATBHeaderNode, tSToolPath.appendTool(tool3.getName(), tool3.getToolSetName(), tool.isCommon()));
                        }
                        this.fNodes.add(qATBHeaderNode);
                    }
                }
                this.fNodes.add((DefaultMutableTreeNode)defaultCheckBoxNode);
            }
        }
        catch (AssertionError assertionError) {
            Log.logThrowable((Throwable)((Object)assertionError));
        }
    }

    private boolean areAnyChildrenQuickAccessEligible(TSToolSetContents.Tool tool) {
        boolean bl = false;
        for (TSToolSetContents.Tool tool2 : tool.getChildren()) {
            if (tool2.isQuickAccessEligible()) {
                bl = true;
                break;
            }
            if (bl || !tool2.hasChildren()) continue;
            bl = this.areAnyChildrenQuickAccessEligible(tool2);
        }
        return bl;
    }

    private static Icon getIcon(TSToolSetContents.ToolType toolType) {
        ImageIcon imageIcon = null;
        switch (toolType) {
            case BUTTON: {
                imageIcon = ComponentIcon.RADIO_BUTTON.getIcon(16);
                break;
            }
            case TOGGLE_BUTTON: {
                imageIcon = ComponentIcon.RADIO_BUTTON.getIcon(16);
                break;
            }
            case RADIO_BUTTON: {
                imageIcon = ComponentIcon.RADIO_BUTTON.getIcon(16);
                break;
            }
            case CHECK_BOX: {
                imageIcon = ComponentIcon.CHECK_BOX.getIcon(16);
                break;
            }
            case DROP_DOWN: {
                imageIcon = ComponentIcon.COMBO_BOX.getIcon(16);
                break;
            }
            case SPLIT_BUTTON: {
                imageIcon = ComponentIcon.COMBO_BOX.getIcon(16);
                break;
            }
            case COMBO_BOX: {
                imageIcon = ComponentIcon.COMBO_BOX.getIcon(16);
                break;
            }
            case TEXT_FIELD: {
                imageIcon = ComponentIcon.TEXT_FIELD.getIcon(16);
                break;
            }
            case LABEL: {
                imageIcon = ComponentIcon.TEXT_FIELD.getIcon(16);
                break;
            }
            case GALLERY: {
                imageIcon = ComponentIcon.RADIO_BUTTON.getIcon(16);
                break;
            }
            case GROUP: {
                imageIcon = ComponentIcon.RADIO_BUTTON.getIcon(16);
                break;
            }
            case SEPARATOR: {
                imageIcon = ComponentIcon.SEPARATOR.getIcon(16);
                break;
            }
            case CUSTOM: {
                imageIcon = ComponentIcon.RADIO_BUTTON.getIcon(16);
            }
        }
        return imageIcon;
    }

    private SelectionState getSelectionState(TSToolPath tSToolPath) {
        SelectionState selectionState = SelectionState.NOT_SELECTED;
        if (this.fQuickAccessConfig.containsTool(tSToolPath)) {
            selectionState = SelectionState.SELECTED;
        }
        return selectionState;
    }

    private DefaultMutableTreeNode[] getCheckBox(TSToolPath tSToolPath) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        for (Map.Entry<DefaultMutableTreeNode, TSToolPath> entry : this.fToolPathMap.entrySet()) {
            if (!entry.getValue().equals((Object)tSToolPath)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new DefaultMutableTreeNode[arrayList.size()]);
    }

    public void discardModifications() {
        this.fComponentBar.discardModifications();
    }

    public void applyModifications() {
        this.fComponentBar.applyModifications();
    }

    public boolean hasModifications() {
        return this.fComponentBar.hasModifications();
    }

    public void updateRestoreDefaultAction() {
        this.fComponentBar.updateRestoreDefaultAction();
    }

    private class QuickAccessComponentBar
    extends DTComponentBar
    implements CheckBoxTreeListener,
    DTComponentBar.ItemAccess {
        private static final String LABEL_PROPERTY_KEY = "LABEL_PROPERTY_KEY";
        private List<Tool> fTools;
        private QuickAccessConfiguration fUpdatedQuickAccessConfig;
        private JComponent fSelectedItem;
        private Integer fPreferredHeight;
        private JLabel fNoTools;

        private QuickAccessComponentBar() {
            super(0);
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    QuickAccessToolBarCustomizationPanel.this.fDummyQATB.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    QuickAccessToolBarCustomizationPanel.this.fDummyQATB.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    QuickAccessComponentBar.this.requestFocusInWindow();
                }
            });
            this.fUpdatedQuickAccessConfig = new QuickAccessConfiguration(QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig);
            this.fTools = new ArrayList<Tool>();
            this.fPreferredHeight = (int)super.getPreferredSize().getHeight();
            this.fNoTools = new JLabel(NO_TOOLS_LABEL);
            this.fNoTools.setName(QuickAccessToolBarCustomizationPanel.NO_TOOLS_LABEL_NAME);
            this.createTools(QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig);
            this.addLayoutListener(new DTComponentBar.LayoutListener(){

                @Override
                public void componentMoved(DTComponentBar dTComponentBar, Component component, int n, int n2) {
                    QuickAccessToolBarCustomizationPanel.this.fComponentBar.handleComponentDragged(n, n2);
                    QuickAccessComponentBar.this.updateRestoreDefaultAction();
                    QuickAccessToolBarCustomizationPanel.this.fLayoutController.updateSelectionDependentActions();
                }
            });
            this.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent containerEvent) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QuickAccessComponentBar.this.updateRestoreDefaultAction();
                        }
                    });
                }

                @Override
                public void componentRemoved(ContainerEvent containerEvent) {
                    QuickAccessComponentBar.this.updateRestoreDefaultAction();
                }
            });
            QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig.addListener(new QuickAccessConfiguration.ChangeListener(){

                public void configurationChanged(QuickAccessConfiguration.ChangeEvent changeEvent) {
                    Tool tool;
                    QuickAccessConfiguration.ChangeType changeType = changeEvent.getType();
                    if (changeType.equals((Object)QuickAccessConfiguration.ChangeType.OTHER)) {
                        return;
                    }
                    TSToolPath tSToolPath = changeEvent.getTool().getPath();
                    if (changeType.equals((Object)QuickAccessConfiguration.ChangeType.ADD)) {
                        if (QuickAccessComponentBar.this.getComponentCount() == 1 && QuickAccessComponentBar.this.getComponentAtLayoutIndex(0).getName() != null && QuickAccessComponentBar.this.getComponentAtLayoutIndex(0).getName().equals(QuickAccessToolBarCustomizationPanel.NO_TOOLS_LABEL_NAME)) {
                            QuickAccessComponentBar.this.remove(QuickAccessComponentBar.this.fNoTools);
                        }
                        Tool tool2 = new Tool();
                        tool2.iToolPath = tSToolPath;
                        tool2.iTool = QuickAccessComponentBar.this.getTSTool(tool2.iToolPath);
                        if (tool2.iTool != null) {
                            tool2.iToolLabel = QuickAccessComponentBar.this.createComponentBarComponent(tool2.iTool, tool2.iToolPath);
                            QuickAccessComponentBar.this.fTools.add(tool2);
                            int n = QuickAccessComponentBar.this.getIndexToAdd();
                            QuickAccessComponentBar.this.addToLayout(tool2.iToolLabel, n);
                            QuickAccessComponentBar.this.fUpdatedQuickAccessConfig.insertTool(n, tSToolPath);
                            QuickAccessComponentBar.this.setSelectedItem((JComponent)tool2.iToolLabel);
                        }
                    } else if (changeType.equals((Object)QuickAccessConfiguration.ChangeType.REMOVE)) {
                        Tool tool3 = QuickAccessComponentBar.this.getTool(tSToolPath);
                        if (tool3 != null) {
                            QuickAccessComponentBar.this.setSelectedItem((JComponent)tool3.iToolLabel);
                            QuickAccessComponentBar.this.removeItem(tool3);
                        }
                    } else if (changeType.equals((Object)QuickAccessConfiguration.ChangeType.LABEL_VISIBILITY) && (tool = QuickAccessComponentBar.this.getTool(tSToolPath)) != null) {
                        MJLabel mJLabel = (MJLabel)tool.iToolLabel;
                        if (changeEvent.getTool().isLabelVisible()) {
                            mJLabel.setText((String)mJLabel.getClientProperty((Object)QuickAccessComponentBar.LABEL_PROPERTY_KEY));
                        } else {
                            mJLabel.setText("");
                        }
                        QuickAccessComponentBar.this.fUpdatedQuickAccessConfig.setLabelVisible(changeEvent.getTool().getPath(), changeEvent.getTool().isLabelVisible());
                        if (QuickAccessComponentBar.this.fSelectedItem != null && tool == QuickAccessComponentBar.this.getTool(QuickAccessComponentBar.this.fSelectedItem)) {
                            QuickAccessToolBarCustomizationPanel.this.fLayoutController.setToggleLabelCheckBoxSelected(changeEvent.getTool().isLabelVisible());
                        }
                    }
                    QuickAccessComponentBar.this.updateRestoreDefaultAction();
                    QuickAccessComponentBar.this.revalidate();
                    QuickAccessComponentBar.this.repaint();
                }
            });
            this.setName("ToolBarProxy_QuickAccess");
        }

        private void createTools(QuickAccessConfiguration quickAccessConfiguration) {
            this.fTools.clear();
            this.removeAll();
            for (int i = 0; i < quickAccessConfiguration.getTools().size(); ++i) {
                QuickAccessConfiguration.Tool tool = (QuickAccessConfiguration.Tool)quickAccessConfiguration.getTools().get(i);
                if (tool.isSeparator()) {
                    this.addSeparator(false, i);
                    continue;
                }
                Tool tool2 = new Tool();
                tool2.iToolPath = tool.getPath();
                tool2.iTool = this.getTSTool(tool2.iToolPath);
                tool2.iToolLabel = tool2.iTool == null ? this.createComponentBarPlaceHolder(tool2.iToolPath) : this.createComponentBarComponent(tool2.iTool, tool2.iToolPath);
                this.fTools.add(tool2);
                this.add(tool2.iToolLabel);
                int n = (int)tool2.iToolLabel.getPreferredSize().getHeight();
                this.fPreferredHeight = Math.max(this.fPreferredHeight, n);
            }
            if (this.fTools.isEmpty()) {
                this.add(this.fNoTools);
                this.fPreferredHeight = (int)this.fNoTools.getPreferredSize().getHeight();
            }
        }

        private JComponent createComponentBarComponent(TSToolSetContents.Tool tool, TSToolPath tSToolPath) {
            Icon icon = tool.getIcon();
            if (icon == null) {
                icon = QuickAccessToolBarCustomizationPanel.getIcon(tool.getType());
            }
            DTComponentBar.ItemProxy itemProxy = new DTComponentBar.ItemProxy(icon, this);
            itemProxy.setName(tool.getName());
            itemProxy.putClientProperty(LABEL_PROPERTY_KEY, MJUtilities.exciseBracketMnemonic((String)tool.getLabel()));
            QuickAccessConfiguration.Tool tool2 = this.fUpdatedQuickAccessConfig.getTool(tSToolPath);
            if (tool2 != null && tool2.isLabelVisible()) {
                itemProxy.setText(MJUtilities.exciseBracketMnemonic((String)tool.getLabel()));
            }
            itemProxy.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            return itemProxy;
        }

        private JComponent createComponentBarPlaceHolder(TSToolPath tSToolPath) {
            DTComponentBar.ItemProxy itemProxy = new DTComponentBar.ItemProxy(null, this);
            itemProxy.setName(tSToolPath.getToolName());
            itemProxy.setVisible(false);
            return itemProxy;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return this.fPreferredHeight == null ? dimension : new Dimension((int)dimension.getWidth(), this.fPreferredHeight);
        }

        public void itemsChanged(Set set) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)set.toArray()[0];
            if (defaultMutableTreeNode instanceof DefaultCheckBoxNode) {
                if (this.getComponentCount() == 1 && this.getComponentAtLayoutIndex(0).getName() != null && this.getComponentAtLayoutIndex(0).getName().equals(QuickAccessToolBarCustomizationPanel.NO_TOOLS_LABEL_NAME)) {
                    this.remove(this.fNoTools);
                }
                boolean bl = this.getTool((TSToolPath)QuickAccessToolBarCustomizationPanel.this.fToolPathMap.get(defaultMutableTreeNode)) != null;
                DefaultCheckBoxNode defaultCheckBoxNode = (DefaultCheckBoxNode)defaultMutableTreeNode;
                SelectionState selectionState = defaultCheckBoxNode.getSelectionState();
                int n = this.getIndexToAdd();
                if (!bl) {
                    Tool tool = new Tool();
                    tool.iToolPath = (TSToolPath)QuickAccessToolBarCustomizationPanel.this.fToolPathMap.get(defaultMutableTreeNode);
                    tool.iTool = this.getTSTool(tool.iToolPath);
                    tool.iToolLabel = this.createComponentBarComponent(tool.iTool, tool.iToolPath);
                    this.fTools.add(tool);
                    if (n > 0) {
                        ++n;
                    }
                    this.addToLayout(tool.iToolLabel, n);
                    this.fUpdatedQuickAccessConfig.insertTool(n, tool.iToolPath);
                    this.setSelectedItem((JComponent)tool.iToolLabel);
                } else {
                    Tool[] toolArray;
                    for (Tool tool : toolArray = this.getTools((TSToolPath)QuickAccessToolBarCustomizationPanel.this.fToolPathMap.get(defaultMutableTreeNode))) {
                        if (selectionState.equals(SelectionState.SELECTED)) {
                            this.addToLayout(tool.iToolLabel, n);
                            this.fUpdatedQuickAccessConfig.insertTool(n, tool.iToolPath);
                            this.setSelectedItem((JComponent)tool.iToolLabel);
                            continue;
                        }
                        if (!selectionState.equals(SelectionState.NOT_SELECTED)) continue;
                        this.setSelectedItem((JComponent)tool.iToolLabel);
                        this.removeItem(tool);
                    }
                }
                this.updateRestoreDefaultAction();
                this.revalidate();
                this.repaint();
            }
        }

        private int getIndexToAdd() {
            int n = this.fTools.size() - 1;
            if (QuickAccessToolBarCustomizationPanel.this.fQuickAccessToolbar.getGrowthEnd() == 2) {
                n = 0;
            }
            return n;
        }

        private TSToolSetContents.Tool getTSTool(TSToolPath tSToolPath) {
            TSToolSetContents.Tool tool = null;
            TSToolSetContents tSToolSetContents = QuickAccessToolBarCustomizationPanel.this.fToolstripRegistry.getToolSetContents(tSToolPath.getToolSetName());
            if (tSToolSetContents != null) {
                tool = tSToolSetContents.getTool(tSToolPath.getToolName());
            }
            return tool;
        }

        private Tool getTool(TSToolPath tSToolPath) {
            Tool tool = null;
            for (Tool tool2 : this.fTools) {
                if (tool2.iToolPath == null || !tool2.iToolPath.equals((Object)tSToolPath)) continue;
                tool = tool2;
                break;
            }
            return tool;
        }

        private Tool[] getTools(TSToolPath tSToolPath) {
            ArrayList<Tool> arrayList = new ArrayList<Tool>();
            for (Tool tool : this.fTools) {
                if (tool.iToolPath == null || !tool.iToolPath.equals((Object)tSToolPath)) continue;
                arrayList.add(tool);
            }
            return arrayList.toArray(new Tool[arrayList.size()]);
        }

        private Tool getTool(JComponent jComponent) {
            Tool tool = null;
            for (Tool tool2 : this.fTools) {
                if (tool2.iToolLabel != jComponent) continue;
                tool = tool2;
                break;
            }
            return tool;
        }

        public void updateRestoreDefaultAction() {
            ((QuickAccessToolBarCustomizationPanel)QuickAccessToolBarCustomizationPanel.this).fLayoutController.fRestoreDefaultAction.setEnabled(!this.fUpdatedQuickAccessConfig.equals((Object)QuickAccessToolBarCustomizationPanel.this.fDefaultQuickAccessConfig));
        }

        private boolean hasModifications() {
            return !QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig.equals((Object)this.fUpdatedQuickAccessConfig);
        }

        private void applyModifications() {
            if (this.fUpdatedQuickAccessConfig.equals((Object)QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig)) {
                return;
            }
            QuickAccessToolBarCustomizationPanel.this.fIsSavingUpdates = true;
            QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig.updateFrom(this.fUpdatedQuickAccessConfig);
            QuickAccessToolBarCustomizationPanel.this.fIsSavingUpdates = false;
        }

        private void discardModifications() {
            this.removeAll();
            this.updateTree(SelectionState.NOT_SELECTED);
            this.fTools.clear();
            this.createTools(QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig);
            this.updateTree(SelectionState.SELECTED);
            this.fUpdatedQuickAccessConfig.updateFrom(QuickAccessToolBarCustomizationPanel.this.fQuickAccessConfig);
            this.setSelectedItem(null);
            this.revalidate();
            this.repaint();
        }

        private void refresh() {
            this.discardModifications();
        }

        @Override
        public void setSelectedItem(JComponent jComponent) {
            Tool tool;
            if (this.fSelectedItem == jComponent) {
                return;
            }
            JComponent jComponent2 = this.fSelectedItem;
            this.fSelectedItem = jComponent;
            if (jComponent2 != null) {
                jComponent2.repaint();
            }
            QuickAccessToolBarCustomizationPanel.this.fLayoutController.updateSelectionDependentActions();
            this.ensureSelectionVisible();
            boolean bl = false;
            if (this.fSelectedItem != null) {
                bl = !((JLabel)this.fSelectedItem).getText().isEmpty();
            }
            QuickAccessToolBarCustomizationPanel.this.fLayoutController.setToggleLabelCheckBoxSelected(bl);
            QuickAccessToolBarCustomizationPanel.this.fLayoutController.setToggleLabelCheckBoxEnabled(this.fSelectedItem != null);
            if (this.fSelectedItem != null && (tool = this.getTool(this.fSelectedItem)) != null) {
                DefaultMutableTreeNode[] defaultMutableTreeNodeArray;
                if (tool.isSeparator()) {
                    QuickAccessToolBarCustomizationPanel.this.fLayoutController.setToggleLabelCheckBoxEnabled(false);
                }
                for (DefaultMutableTreeNode defaultMutableTreeNode : defaultMutableTreeNodeArray = QuickAccessToolBarCustomizationPanel.this.getCheckBox(tool.iToolPath)) {
                    if (!(defaultMutableTreeNode instanceof DefaultCheckBoxNode)) continue;
                    ((Selectable)defaultMutableTreeNode).setSelectionState(SelectionState.SELECTED);
                }
            }
            this.firePropertyChange("AccessibleSelection", null, null);
            this.firePropertyChange("AccessibleActiveDescendant", jComponent2, this.fSelectedItem);
            this.firePropertyChange("AccessibleVisibleData", jComponent2, this.fSelectedItem);
        }

        @Override
        public JComponent getSelectedItem() {
            return this.fSelectedItem;
        }

        private void ensureSelectionVisible() {
            if (this.fSelectedItem != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (QuickAccessComponentBar.this.fSelectedItem == null) {
                            return;
                        }
                        QuickAccessToolBarCustomizationPanel.this.fDummyQATB.ensureVisible((Component)QuickAccessComponentBar.this.fSelectedItem);
                    }
                });
            }
        }

        public void handleComponentDragged(int n, int n2) {
            this.fUpdatedQuickAccessConfig.moveTool(n, n2);
        }

        @Override
        public void selectFirst() {
            if (this.getComponentCount() > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(0));
                this.repaint();
            }
        }

        @Override
        public void selectPrevious() {
            if (this.fSelectedItem != null) {
                int n = this.layoutIndexOf(this.fSelectedItem);
                if (n > 0) {
                    this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(n - 1));
                    this.repaint();
                }
            } else if (this.getComponentCount() > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(this.getComponentCount() - 1));
                this.repaint();
            }
        }

        @Override
        public void selectNext() {
            int n = this.getComponentCount();
            if (this.fSelectedItem != null) {
                int n2 = this.layoutIndexOf(this.fSelectedItem);
                if (n2 < n - 1) {
                    this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(n2 + 1));
                    this.repaint();
                }
            } else if (n > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(0));
                this.repaint();
            }
        }

        @Override
        public void selectLast() {
            int n = this.getComponentCount();
            if (n > 0) {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(n - 1));
                this.repaint();
            }
        }

        @Override
        public void moveSelectedItemToLeft() {
            if (this.fSelectedItem == null) {
                return;
            }
            int n = this.layoutIndexOf(this.fSelectedItem);
            if (n > 0) {
                Component component;
                int n2;
                for (n2 = n - 1; n2 > 0 && !(component = this.getComponentAtLayoutIndex(n2)).isVisible(); --n2) {
                }
                this.moveComponentNoEvent(n, n2);
                this.ensureSelectionVisible();
                this.fUpdatedQuickAccessConfig.moveTool(n, n2);
            }
        }

        @Override
        public void moveSelectedItemToRight() {
            if (this.fSelectedItem == null) {
                return;
            }
            int n = this.layoutIndexOf(this.fSelectedItem);
            if (n < this.getComponentCount() - 1) {
                Component component;
                int n2;
                for (n2 = n + 1; n2 < this.getComponentCount() - 1 && !(component = this.getComponentAtLayoutIndex(n2)).isVisible(); ++n2) {
                }
                this.moveComponentNoEvent(n, n2);
                this.ensureSelectionVisible();
                this.fUpdatedQuickAccessConfig.moveTool(n, n2);
            }
        }

        @Override
        public void moveSelectedItemToBegin() {
            if (this.fSelectedItem == null) {
                return;
            }
            int n = this.layoutIndexOf(this.fSelectedItem);
            if (n > 0) {
                this.moveComponentNoEvent(n, 0);
                this.ensureSelectionVisible();
                Tool tool = this.getTool(this.fSelectedItem);
                if (tool.isSeparator()) {
                    this.fUpdatedQuickAccessConfig.moveTool(n, 0);
                } else {
                    this.fUpdatedQuickAccessConfig.moveTool(tool.iToolPath, QuickAccessConfiguration.Movement.TO_BEGINNING);
                }
            }
        }

        @Override
        public void moveSelectedItemToEnd() {
            int n;
            if (this.fSelectedItem == null) {
                return;
            }
            int n2 = this.layoutIndexOf(this.fSelectedItem);
            if (n2 < (n = this.getComponentCount()) - 1) {
                this.moveComponentNoEvent(n2, n - 1);
                this.ensureSelectionVisible();
                Tool tool = this.getTool(this.fSelectedItem);
                if (tool.isSeparator()) {
                    this.fUpdatedQuickAccessConfig.moveTool(n2, this.fTools.size() - 1);
                } else {
                    this.fUpdatedQuickAccessConfig.moveTool(tool.iToolPath, QuickAccessConfiguration.Movement.TO_END);
                }
            }
        }

        @Override
        public void addSeparator() {
            this.addSeparator(true, -1);
        }

        private void addSeparator(boolean bl, int n) {
            DTComponentBar.ItemProxy itemProxy = new DTComponentBar.ItemProxy(ComponentIcon.SEPARATOR.getIcon(), this);
            itemProxy.setName("Separator");
            itemProxy.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            int n2 = n;
            if (n2 == -1) {
                n2 = this.fSelectedItem == null ? this.getIndexToAdd() : this.layoutIndexOf(this.fSelectedItem) + 1;
            }
            this.addToLayout((Component)((Object)itemProxy), n2);
            Tool tool = new Tool();
            tool.iToolLabel = (Component)((Object)itemProxy);
            this.fTools.add(tool);
            if (bl) {
                this.fUpdatedQuickAccessConfig.insertSeparator(n2);
                this.setSelectedItem((JComponent)((Object)itemProxy));
                this.updateRestoreDefaultAction();
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void removeSelectedItem() {
            if (this.fSelectedItem != null) {
                this.removeItem(this.getTool(this.fSelectedItem));
            }
        }

        @Override
        public boolean toggleLabelVisibility() {
            boolean bl = false;
            if (this.fSelectedItem != null) {
                Tool tool = this.getTool(this.fSelectedItem);
                if (((JLabel)this.fSelectedItem).getText().isEmpty()) {
                    ((JLabel)this.fSelectedItem).setText(MJUtilities.exciseBracketMnemonic((String)((String)this.fSelectedItem.getClientProperty(LABEL_PROPERTY_KEY))));
                    this.fUpdatedQuickAccessConfig.setLabelVisible(tool.iToolPath, true);
                    bl = true;
                } else {
                    ((JLabel)this.fSelectedItem).setText("");
                    this.fUpdatedQuickAccessConfig.setLabelVisible(tool.iToolPath, false);
                }
            }
            return bl;
        }

        private void removeItem(Tool tool) {
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = QuickAccessToolBarCustomizationPanel.this.getCheckBox(tool.iToolPath);
            if (defaultMutableTreeNodeArray != null && defaultMutableTreeNodeArray.length > 0) {
                for (DefaultMutableTreeNode defaultMutableTreeNode : defaultMutableTreeNodeArray) {
                    if (!(defaultMutableTreeNode instanceof DefaultCheckBoxNode)) continue;
                    ((Selectable)defaultMutableTreeNode).setSelectionState(SelectionState.NOT_SELECTED);
                    QuickAccessToolBarCustomizationPanel.this.fCBTree.repaint();
                }
            }
            int n = this.layoutIndexOf(this.fSelectedItem);
            if (tool.isSeparator()) {
                this.fUpdatedQuickAccessConfig.removeTool(n);
            } else {
                this.fUpdatedQuickAccessConfig.removeTool(tool.iToolPath);
            }
            ((JLabel)this.fSelectedItem).setText("");
            this.remove(this.fSelectedItem);
            int n2 = this.getComponentCount();
            if (n >= n2) {
                n = n2 - 1;
            }
            if (n < 0) {
                this.setSelectedItem(null);
            } else {
                this.setSelectedItem((JComponent)this.getComponentAtLayoutIndex(n));
            }
            if (n2 == 0) {
                this.add(this.fNoTools);
            }
            ((JLabel)tool.iToolLabel).setText("");
            this.fTools.remove(tool);
            this.revalidate();
            this.repaint();
        }

        @Override
        public void restoreDefault() {
            this.removeAll();
            this.updateTree(SelectionState.NOT_SELECTED);
            this.fTools.clear();
            this.createTools(QuickAccessToolBarCustomizationPanel.this.fDefaultQuickAccessConfig);
            this.updateTree(SelectionState.SELECTED);
            this.revalidate();
            this.repaint();
            this.fUpdatedQuickAccessConfig.updateFrom(QuickAccessToolBarCustomizationPanel.this.fDefaultQuickAccessConfig);
            this.updateRestoreDefaultAction();
            this.setSelectedItem(null);
        }

        private void updateTree(SelectionState selectionState) {
            for (Tool tool : this.fTools) {
                DefaultMutableTreeNode[] defaultMutableTreeNodeArray = QuickAccessToolBarCustomizationPanel.this.getCheckBox(tool.iToolPath);
                if (defaultMutableTreeNodeArray == null || defaultMutableTreeNodeArray.length <= 0) continue;
                for (DefaultMutableTreeNode defaultMutableTreeNode : defaultMutableTreeNodeArray) {
                    if (!(defaultMutableTreeNode instanceof DefaultCheckBoxNode)) continue;
                    ((Selectable)defaultMutableTreeNode).setSelectionState(selectionState);
                }
            }
            QuickAccessToolBarCustomizationPanel.this.fCBTree.repaint();
        }

        private class Tool {
            private TSToolSetContents.Tool iTool;
            private Component iToolLabel;
            private TSToolPath iToolPath;

            private Tool() {
            }

            public boolean isSeparator() {
                return this.iToolPath == null;
            }
        }
    }

    public static class MnemonicsFreeLabel
    extends MJLabel {
        public MnemonicsFreeLabel(String string, Icon icon, String string2) {
            super(MJUtilities.exciseBracketMnemonic((String)string.replace("\n", " ")), icon, 0);
            super.setToolTipText(string2);
        }
    }

    public static class QATBHeaderNode
    extends DefaultMutableTreeNode {
        private QATBHeaderNode(Object object) {
            super(object, true);
        }
    }

    private static class QATBTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private QATBTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof QATBHeaderNode && ((DefaultMutableTreeNode)object).isRoot()) {
                JLabel jLabel = new JLabel(QATB_ROOT_NODE_TITLE);
                jLabel.setFont(jLabel.getFont().deriveFont(1));
                jTree.setToolTipText("");
                return jLabel;
            }
            if (object instanceof DefaultCheckBoxNode) {
                MJLabel mJLabel = (MJLabel)((DefaultMutableTreeNode)object).getUserObject();
                this.setText(mJLabel.getText());
                this.setIcon(mJLabel.getIcon());
                this.setToolTipText(mJLabel.getToolTipText());
                jTree.setToolTipText(mJLabel.getToolTipText());
            } else {
                this.setText(MJUtilities.exciseMnemonic((String)this.getText()));
                this.setToolTipText("");
            }
            return this;
        }
    }
}

