/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.MoveIcon;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleDOMUtils;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.toolstrip.accessories.QuickAccessToolBar;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.desk.DTBorderContainer;
import com.mathworks.widgets.desk.DTBorderLocation;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTCloseTransaction;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFloatingPane;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGlobalActionManager;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.DTLayoutSaveManager;
import com.mathworks.widgets.desk.DTLayoutToolSetFactory;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMainToolBarSupplier;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTMnemonicsProvider;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTNotifyingList;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTOnTopWindow;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTSelectionManager;
import com.mathworks.widgets.desk.DTShutdownExcludedCloser;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.DTTabbedPane;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.DTToolBar;
import com.mathworks.widgets.desk.DTToolBarCustomizationPanel;
import com.mathworks.widgets.desk.DTToolBarRegistry;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DTWindowRegistry;
import com.mathworks.widgets.desk.DefaultViewTabFactory;
import com.mathworks.widgets.desk.DeferredDesktopFacade;
import com.mathworks.widgets.desk.DeferredFacadeMethod;
import com.mathworks.widgets.desk.DeferredRunnable;
import com.mathworks.widgets.desk.MacScreenMenuProxy;
import com.mathworks.widgets.desk.RecentFiles;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Desktop
implements DTWindowActivator {
    protected static final String RESOURCE_PATH = "com.mathworks.widgets.desk.resources.RES_Desktop";
    @Deprecated
    public static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.widgets.desk.resources.RES_Desktop");
    private static ResourceBundle sEnglishResources;
    protected String fDTName;
    protected final Vector<DTClient> fClients = new Vector();
    protected final Map<Component, DTClient> fComponentToClientMap = new Hashtable<Component, DTClient>();
    protected final Vector<DTGroup> fGroups = new Vector();
    protected DTMultipleClientFrame fMainFrame;
    protected final List<DTFrame> fFrames = new ArrayList<DTFrame>();
    protected final DTNotifyingList<DTClient> fSingletons = new DTNotifyingList();
    protected final DTNotifyingList<DTGroup> fNotifyingGroups = new DTNotifyingList();
    protected final DTSelectionManager fSelectionManager = new DTSelectionManager(this);
    protected final DTLayoutSaveManager fLayoutSaveManager = new DTLayoutSaveManager(this);
    protected final DTGlobalActionManager fActionManager = new DTGlobalActionManager(this);
    protected DTLayoutLibrary fLayoutLibrary;
    protected DTToolstripFactory fToolstripFactory;
    protected TSRegistry fToolstripRegistry;
    protected RecentFiles fRecentFiles;
    protected DefaultViewTabFactory fViewTabFactory;
    protected QuickAccessConfiguration fQuickAccessConfiguration;
    protected final DTToolBarRegistry fToolBarRegistry = new DTToolBarRegistry();
    protected final List<ClientListenerData> fPendingClientListeners = Collections.synchronizedList(new ArrayList());
    private DTClient fClientBeingCreated;
    private final Set<DTClient> fFormerClients = new HashSet<DTClient>();
    private final Set<DTGroup> fFormerGroups = new HashSet<DTGroup>();
    protected boolean fInitializingMain;
    protected boolean fRestoringLayout;
    protected boolean fUndockingGroup;
    protected boolean fUndockingGroups;
    protected boolean fAutoShowMain = true;
    protected boolean fIsClearingLayout;
    protected boolean fIsAttemptingClose;
    protected volatile boolean fIsClosing;
    protected int fDocumentContainment = 2;
    protected int fUnopenedFrameCount;
    protected boolean fThreadSafeGetMethods;
    protected LayoutSavePolicy fLayoutSavePolicy = LayoutSavePolicy.UPON_CHANGE;
    private boolean fLastLayoutSaveFailed;
    private boolean fUnfurlFurlInstantly;
    protected boolean fLocalizeUIElements = true;
    protected boolean fRetainLastDocumentToolstripTabs = true;
    private int fUntitledClientCount;
    protected int fMajorVersionBeingRestored;
    protected int fMinorVersionBeingRestored;
    private boolean fIsLayoutLocked;
    private boolean fIsTesting;
    private DeferredDesktopFacade fDeferredFacade = DeferredFacadeProxy.newInstance(this);
    public static final int MAXIMIZED = 1;
    public static final int TILED = 2;
    public static final int FLOATING = 3;
    public static final int HIDE_DOCUMENT_BAR = -1;
    public static final int NONE = 0;
    public static final int PER_FRAME = 1;
    public static final int PER_GROUP = 2;
    public static final String VIEW_TAB_NAME = "view";
    public static final String UNDOCKED_CONTROLS_HOST = "desktop client undocked controls host";
    static final Icon DOCK_ICON;
    static final Icon DOCK_ALL_ICON;
    static final Icon UNDOCK_ICON;
    static final Icon CLOSE_ICON;
    static final Icon MINIMIZE_ICON;
    static final Icon MAXIMIZE_ICON;
    static final Icon RESTORE_ICON;
    static final Icon MINIMIZE_TO_NORTH_ICON;
    static final Icon MINIMIZE_TO_SOUTH_ICON;
    static final Icon MINIMIZE_TO_EAST_ICON;
    static final Icon MINIMIZE_TO_WEST_ICON;
    static final Icon RESTORE_TO_DOCKED_ICON;
    static final Icon ANCHOR_ICON;
    static final Icon DETACH_ICON;
    static final Icon MOVE_ICON;
    static final Icon RESIZE_ICON;
    protected static final String LAYOUT_TAG = "Layout";
    protected static final String VERSION_TAG = "Version";
    protected static final String MAJOR_ATTRIBUTE = "Major";
    protected static final String MINOR_ATTRIBUTE = "Minor";
    protected static final String ANY_GROUP = "AnyGroup";
    public static final int NEAREST_EDGE = -1;
    static final String XML_ENCODING = "utf-8";
    protected static final DTLocation DEFAULT_GROUP_DOCK_LOCATION;
    static final boolean DEBUG = false;
    protected long fMainStartTime;

    private static Icon createContrastingIcon(String string) {
        return DTUtilities.createContrastingIcon(new ImageIcon(Desktop.class.getResource("resources/" + string)));
    }

    public Desktop(String string, boolean bl) {
        this.fDTName = string;
        if (bl) {
            this.initMainFrame(true);
        }
    }

    public void setIsTesting(boolean bl) {
        this.fIsTesting = bl;
    }

    public boolean isTesting() {
        return this.fIsTesting;
    }

    public void initMainFrame(boolean bl) {
        this.initMainFrame(bl, true);
    }

    public void initMainFrame(boolean bl, boolean bl2) {
        this.initMainFrame(bl, bl2, false);
    }

    public void initMainFrame(boolean bl, boolean bl2, boolean bl3) {
        if (this.fMainFrame != null) {
            return;
        }
        if (PlatformInfo.getVersion() < 5 && PlatformInfo.getVersion() != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = new Object[]{Desktop.this.fDTName, System.getProperty("java.version")};
                    String string = MessageFormat.format(Desktop.this.getString("error.IncompatibleJavaVersion"), objectArray);
                    String string2 = Desktop.this.getString("error.ErrorStartingDesktop");
                    MJOptionPane.showMessageDialog(null, (Object)string, (String)string2, (int)0);
                    Desktop.this.abortMainFrameInit();
                }
            });
            return;
        }
        this.fInitializingMain = true;
        if (bl) {
            this.startSplash();
        }
        this.getWindowRegistry().addDesktop(this);
        this.clearLayout();
        this.fMainFrame = this.createMainFrame();
        this.fLayoutSaveManager.setMainFrameLocation(this.fMainFrame.getLocationToUpdate());
        for (DTGroup object : this.fGroups) {
            if (object.getContainingFrame() != null || !object.isDockable()) continue;
            object.setContainingFrame(this.fMainFrame);
        }
        boolean bl4 = false;
        if (bl2) {
            bl4 = this.restorePreviousLayout();
        }
        if (!bl4) {
            this.setDefaultDesktop();
        }
        for (DTFrame dTFrame : this.fFrames) {
            if (dTFrame.isMainFrame()) continue;
            dTFrame.mainFrameCreated();
        }
        if (bl) {
            this.stopSplash();
        }
        if (bl3) {
            this.fMainFrame.setExtendedState(1);
        }
        if (this.fAutoShowMain) {
            this.showFrames();
        }
        this.fSelectionManager.setEnabled(true);
        this.fLayoutSaveManager.setSaveEnabled(true);
        this.fInitializingMain = false;
    }

    protected void abortMainFrameInit() {
    }

    protected void showFrames() {
        if (PlatformInfo.isMacintosh() && this.fFrames.size() > 1) {
            this.fMainFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    Desktop.this.showUndockedFrames();
                    windowEvent.getWindow().removeWindowListener(this);
                }
            });
        }
        if (this.fFrames.size() > 1 && PlatformInfo.isLinux64()) {
            this.fMainFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    Desktop.this.fMainFrame.toFront();
                    windowEvent.getWindow().removeWindowListener(this);
                }
            });
        }
        this.fMainFrame.setVisible(true);
        if (this.fFrames.size() > 1 && !PlatformInfo.isMacintosh()) {
            this.showUndockedFrames();
        }
    }

    private void showUndockedFrames() {
        for (DTFrame dTFrame : this.fFrames) {
            if (dTFrame.isMainFrame()) continue;
            dTFrame.setVisible(true);
        }
        this.fMainFrame.toFront();
    }

    public void enableThreadSafeGetMethods() {
        this.fThreadSafeGetMethods = true;
    }

    public void disableThreadSafeGetMethods() {
        this.fThreadSafeGetMethods = false;
    }

    public boolean areThreadSafeGetMethodsEnabled() {
        return this.fThreadSafeGetMethods;
    }

    public void setUnfurlFurlInstantly(boolean bl) {
        this.fUnfurlFurlInstantly = bl;
    }

    public boolean unfurlFurlInstantly() {
        return this.fUnfurlFurlInstantly;
    }

    public String getDesktopName() {
        return this.fDTName;
    }

    public void attemptClose() {
        this.fIsAttemptingClose = true;
        Desktop.deferredCall(new DesktopCloseTransaction());
        this.fIsAttemptingClose = false;
    }

    public void attemptMainFrameClose() {
        this.fIsAttemptingClose = true;
        Desktop.deferredCall(new MainFrameCloseTransaction());
        this.fIsAttemptingClose = false;
    }

    public DTCloseTransaction getCloseTransaction() {
        return new DesktopCloseTransaction();
    }

    public void addClient(Component component, String string) {
        this.addClient(component, string, true, null, true);
    }

    public void addClient(Component component, String string, boolean bl, DTLocation dTLocation, boolean bl2) {
        this.addClient(component, string, bl, dTLocation, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(Component component, String string, boolean bl, DTLocation dTLocation, boolean bl2, DTClientListener dTClientListener) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        boolean bl3 = false;
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null) {
            dTClient = new DTClient(this, component, string);
            if (dTClient.isSingleton()) {
                DTClient dTClient2 = this.getDTClient(dTClient.getName(), dTClient.getGroupName());
                if (dTClient2 != null) {
                    if (dTClient2.getComponent() != null && !dTClient2.hasSurrogateComponent()) {
                        throw new IllegalStateException("Attempting to replace component for " + string);
                    }
                    dTClient.flush();
                    dTClient = dTClient2;
                    this.registerClientComponent(dTClient, component);
                    dTClient.setComponent(component);
                } else {
                    DTClient dTClient3 = this.getFormerClient(dTClient.getName(), dTClient.getGroupName());
                    if (dTClient3 != null) {
                        dTClient.updateFrom(dTClient3);
                        Set<DTClient> set = this.fFormerClients;
                        synchronized (set) {
                            this.fFormerClients.remove(dTClient3);
                        }
                    }
                    this.fClients.add(dTClient);
                    bl3 = true;
                }
            } else {
                this.fClients.add(dTClient);
                bl3 = true;
            }
            if (bl3) {
                this.registerClientComponent(dTClient);
            }
        }
        if (dTClientListener != null) {
            dTClient.addClientListener(dTClientListener);
        }
        if (dTLocation != null) {
            dTLocation = DTLocation.clone(dTLocation);
        }
        if (bl3) {
            this.fDeferredFacade.addClient(dTClient, bl, dTLocation, bl2);
        } else if (bl && !this.fRestoringLayout) {
            this.fDeferredFacade.setClientShowing(dTClient, true, dTLocation, bl2);
        }
    }

    public void removeClient(Component component) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.fDeferredFacade.removeClient(dTClient);
    }

    public void removeClient(String string) {
        this.removeClient(string, ANY_GROUP);
    }

    public void removeClient(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.removeClient(dTClient);
    }

    public void addClientListener(Component component, DTClientListener dTClientListener) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient != null) {
            dTClient.addClientListener(dTClientListener);
        } else {
            this.addPendingListener(dTClientListener, component, null);
        }
    }

    public void removeClientListener(Component component, DTClientListener dTClientListener) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient != null) {
            dTClient.removeClientListener(dTClientListener);
        } else {
            this.removePendingListener(dTClientListener, component, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(String string, DTClientListener dTClientListener) {
        DTClient dTClient = this.getDTClient(string);
        if (dTClient != null) {
            dTClient.addClientListener(dTClientListener);
        } else {
            DTGroup dTGroup = this.getGroup(string);
            if (dTGroup != null) {
                Vector<DTClient> vector = this.fClients;
                synchronized (vector) {
                    for (DTClient dTClient2 : this.fClients) {
                        if (dTClient2.getGroup() != dTGroup) continue;
                        dTClient2.addClientListener(dTClientListener);
                    }
                }
            }
            this.addPendingListener(dTClientListener, null, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientListener(String string, DTClientListener dTClientListener) {
        DTClient dTClient = this.getDTClient(string);
        if (dTClient != null) {
            dTClient.removeClientListener(dTClientListener);
        } else {
            DTGroup dTGroup = this.getGroup(string);
            if (dTGroup != null) {
                Vector<DTClient> vector = this.fClients;
                synchronized (vector) {
                    for (DTClient dTClient2 : this.fClients) {
                        if (dTClient2.getGroup() != dTGroup) continue;
                        dTClient2.removeClientListener(dTClientListener);
                    }
                }
            }
            this.removePendingListener(dTClientListener, null, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(DTClientListener dTClientListener) {
        Vector<DTClient> vector = this.fClients;
        synchronized (vector) {
            for (DTClient dTClient : this.fClients) {
                dTClient.addClientListener(dTClientListener);
            }
        }
        this.addPendingListener(dTClientListener, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientListener(DTClientListener dTClientListener) {
        Vector<DTClient> vector = this.fClients;
        synchronized (vector) {
            for (DTClient dTClient : this.fClients) {
                dTClient.removeClientListener(dTClientListener);
            }
        }
        this.removePendingListener(dTClientListener, null, null);
    }

    public static Component getClientComponentAncestor(final Component component) {
        return Desktop.staticSyncCall(new CallableWrapper<Component>(){

            @Override
            public Component call() {
                DTClientFrame dTClientFrame = (DTClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTClientFrame.class, component));
                return dTClientFrame == null ? null : dTClientFrame.getClient().getComponent();
            }
        });
    }

    public static Desktop getContainingDesktop(final Component component) {
        return Desktop.staticSyncCall(new CallableWrapper<Desktop>(){

            @Override
            public Desktop call() {
                DTClientFrame dTClientFrame = (DTClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTClientFrame.class, component));
                return dTClientFrame == null ? null : dTClientFrame.getClient().getDesktop();
            }
        });
    }

    public Component getClient(String string) {
        DTClient dTClient = this.getDTClient(string);
        if (dTClient != null && !dTClient.hasSurrogateComponent()) {
            return dTClient.getComponent();
        }
        return null;
    }

    public Component getClient(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        if (dTClient != null && !dTClient.hasSurrogateComponent()) {
            return dTClient.getComponent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getClientByName(String string) {
        Vector<DTClient> vector = this.fClients;
        synchronized (vector) {
            for (DTClient dTClient : this.fClients) {
                String string2;
                Component component = dTClient.getComponent();
                if (component == null || (string2 = component.getName()) == null || !string2.equals(string)) continue;
                return component;
            }
        }
        return null;
    }

    public Component getFirstClientDockedInGroup(String string) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null || dTGroup.getLocation() == null || !dTGroup.hasDocumentContainer()) {
            return null;
        }
        List<DTClient> list = dTGroup.getDocumentContainer().getDocumentsInTabOrder();
        return list.isEmpty() ? null : list.get(0).getComponent();
    }

    public Component getNextClientInGroup(Component component) {
        List<DTClient> list;
        int n;
        DTGroup dTGroup;
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient != null && (dTGroup = dTClient.getGroup()) != null && dTGroup.getLocation() != null && dTGroup.hasDocumentContainer() && 0 <= (n = (list = dTGroup.getDocumentContainer().getDocumentsInTabOrder()).indexOf(dTClient)) && n < list.size() - 1) {
            return list.get(n + 1).getComponent();
        }
        return null;
    }

    public Component getPrevClientInGroup(Component component) {
        List<DTClient> list;
        int n;
        DTGroup dTGroup;
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient != null && (dTGroup = dTClient.getGroup()) != null && dTGroup.getLocation() != null && dTGroup.hasDocumentContainer() && (n = (list = dTGroup.getDocumentContainer().getDocumentsInTabOrder()).indexOf(dTClient)) > 0) {
            return list.get(n - 1).getComponent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClientTitles() {
        Vector<DTClient> vector = this.fClients;
        synchronized (vector) {
            int n = this.fClients.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                DTClient dTClient = this.fClients.get(i);
                stringArray[i] = dTClient.getTitle();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClientShortTitles() {
        Vector<DTClient> vector = this.fClients;
        synchronized (vector) {
            int n = this.fClients.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                DTClient dTClient = this.fClients.get(i);
                stringArray[i] = dTClient.getShortTitle();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonTitles() {
        DTNotifyingList<DTClient> dTNotifyingList = this.fSingletons;
        synchronized (dTNotifyingList) {
            int n = this.fSingletons.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                DTClient dTClient = (DTClient)this.fSingletons.get(i);
                stringArray[i] = dTClient.getTitle();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonShortTitles() {
        DTNotifyingList<DTClient> dTNotifyingList = this.fSingletons;
        synchronized (dTNotifyingList) {
            int n = this.fSingletons.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                DTClient dTClient = (DTClient)this.fSingletons.get(i);
                stringArray[i] = dTClient.getShortTitle();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component[] getGroupMembers(String string) {
        Vector<DTClient> vector = this.fClients;
        synchronized (vector) {
            DTGroup dTGroup = string == null ? null : this.getGroup(string);
            int n = this.fClients.size();
            ArrayList<Component> arrayList = new ArrayList<Component>(n);
            for (int i = 0; i < n; ++i) {
                DTClient dTClient = this.fClients.get(i);
                Component component = dTClient.getComponent();
                if (component == null || dTClient.hasSurrogateComponent() || dTGroup != dTClient.getGroup()) continue;
                arrayList.add(component);
            }
            return arrayList.toArray(new Component[arrayList.size()]);
        }
    }

    public boolean isSingleton(String string) {
        DTClient dTClient = this.getDTClient(string);
        return dTClient != null && dTClient.isSingleton();
    }

    public boolean isDocument(String string) {
        DTClient dTClient = this.getDTClient(string);
        return dTClient != null && !dTClient.isSingleton();
    }

    public void showClient(Component component, DTLocation dTLocation, boolean bl) {
        if (this.fRestoringLayout) {
            return;
        }
        this.showClientHelper(component, dTLocation, bl, false);
    }

    public void showClientHidden(Component component, DTLocation dTLocation, boolean bl) {
        assert (!this.fRestoringLayout);
        this.showClientHelper(component, dTLocation, bl, true);
    }

    private void showClientHelper(Component component, DTLocation dTLocation, boolean bl, boolean bl2) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.showClient(dTClient, DTLocation.clone(dTLocation), bl, bl2);
    }

    public void showClient(String string) {
        this.showClient(string, ANY_GROUP);
    }

    public void showClient(String string, String string2) {
        this.showClient(string, string2, null, true);
    }

    public void showClient(String string, String string2, DTLocation dTLocation, boolean bl) {
        if (this.fRestoringLayout) {
            return;
        }
        DTClient dTClient = this.getDTClient(string, string2);
        this.showClient(dTClient, dTLocation, bl);
    }

    public boolean isClientShowing(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientShowing(dTClient);
    }

    public boolean isClientHidden(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientHidden(dTClient);
    }

    public boolean isClientShowing(String string) {
        DTClient dTClient = this.getDTClient(string);
        return this.isClientShowing(dTClient);
    }

    public boolean isClientShowing(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        return this.isClientShowing(dTClient);
    }

    protected boolean isClientShowing(final DTClient dTClient) {
        return this.syncCall(new CallableClientWrapper<Boolean>(dTClient, Boolean.valueOf(false)){

            @Override
            public Boolean call() {
                return dTClient != null && dTClient.isShowing();
            }
        });
    }

    protected boolean isClientHidden(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                return dTClient == null || dTClient.isHidden();
            }
        });
    }

    public void toFront(Component component) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.fDeferredFacade.toFront(dTClient, DTContainer.Scope.FRAME);
    }

    public void toFront(String string) {
        this.toFront(string, ANY_GROUP);
    }

    public void toFront(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.toFront(dTClient, DTContainer.Scope.FRAME);
    }

    public void toFrontOfGroup(Component component) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.fDeferredFacade.toFront(dTClient, DTContainer.Scope.GROUP);
    }

    public void toFrontDontFurl(Component component) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.fDeferredFacade.toFront(dTClient, DTContainer.Scope.NEST);
    }

    public void toFrontDontFurl(String string) {
        this.toFrontDontFurl(string, ANY_GROUP);
    }

    public void toFrontDontFurl(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.toFront(dTClient, DTContainer.Scope.NEST);
    }

    @DeferredFacadeMethod
    protected void toFront(DTOccupant dTOccupant, DTContainer.Scope scope) {
        DTFrame dTFrame;
        if (dTOccupant == null) {
            return;
        }
        DTLocation dTLocation = dTOccupant.getLocation();
        if (dTLocation != null && (dTFrame = dTLocation.getFrame()) instanceof DTMultipleClientFrame) {
            this.fSelectionManager.lock();
            if (dTOccupant instanceof DTClient) {
                ((DTMultipleClientFrame)dTFrame).moveToFront((DTClient)dTOccupant, scope);
            } else {
                ((DTMultipleClientFrame)dTFrame).moveToFront((DTGroup)dTOccupant, scope);
            }
            SwingUtilities.invokeLater(new DeferredRunnable(3){

                @Override
                public void doTask() {
                    Desktop.this.fSelectionManager.unlock();
                }
            });
        }
    }

    public void setClientSelected(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.fDeferredFacade.setClientSelected(dTClient, bl);
    }

    public void setClientSelected(String string, boolean bl) {
        this.setClientSelected(string, ANY_GROUP, bl);
    }

    public void setClientSelected(String string, String string2, boolean bl) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.setClientSelected(dTClient, bl);
    }

    @DeferredFacadeMethod
    protected void setClientSelected(DTClient dTClient, boolean bl) {
        if (dTClient.getLocation() != null) {
            dTClient.setSelected(bl);
        }
    }

    public boolean isClientSelected(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientSelected(dTClient);
    }

    public boolean isClientSelected(String string) {
        DTClient dTClient = this.getDTClient(string);
        return this.isClientSelected(dTClient);
    }

    public boolean isClientSelected(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        return this.isClientSelected(dTClient);
    }

    protected boolean isClientSelected(final DTClient dTClient) {
        return this.syncCall(new CallableClientWrapper<Boolean>(dTClient, Boolean.valueOf(false)){

            @Override
            public Boolean call() {
                return dTClient != null && dTClient.isSelected();
            }
        });
    }

    public void setClientDocked(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null && !this.fRestoringLayout) {
            dTClient = this.fClientBeingCreated;
        }
        this.fDeferredFacade.setClientDocked(dTClient, bl);
    }

    public void setClientDocked(String string, boolean bl) {
        this.setClientDocked(string, ANY_GROUP, bl);
    }

    public void setClientDocked(String string, String string2, boolean bl) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.setClientDocked(dTClient, bl);
    }

    @DeferredFacadeMethod
    protected void setClientDocked(DTClient dTClient, boolean bl) {
        DTLocation dTLocation = dTClient.getLocation();
        if (dTLocation == null) {
            if (bl) {
                dTClient.setLastLocation(dTClient.getLastDockedLocation());
            } else {
                DTLocation dTLocation2 = dTClient.getLastUndockedLocation();
                if (dTLocation2 == null) {
                    dTLocation2 = DTLocation.createExternal();
                }
                if (dTClient.isDockableTearOff()) {
                    ((DTFloatingLocation)dTLocation2).setAnchored(true);
                }
                dTClient.setLastLocation(dTLocation2);
            }
        } else if (bl) {
            if (dTLocation.isDocked()) {
                return;
            }
            dTClient.saveFocus();
            DTGroup dTGroup = dTClient.getGroup();
            if (dTGroup != null && dTGroup.isDockable() && dTGroup.getContainingFrame() == null) {
                dTGroup.setContainingFrame(this.fMainFrame);
            }
            dTClient.fireClientEvent(new DTClientEvent(dTClient.getComponent(), 4));
            dTLocation = dTClient.getLocation();
            if (dTLocation != null && dTLocation.isDocked()) {
                return;
            }
            this.setClientShowing(dTClient, false, null, false);
            DTLocation dTLocation3 = dTClient.getLastDockedLocation();
            if (dTLocation3 == null) {
                dTLocation3 = dTClient.isSingleton() ? new DTNestedLocation() : new DTFloatingLocation(false);
            } else if (dTLocation3.isMaximized()) {
                dTLocation3 = dTClient.getLastNestedLocation();
            }
            this.setClientShowing(dTClient, true, dTLocation3, false);
        } else {
            if (!dTLocation.isDocked()) {
                return;
            }
            dTClient.saveFocus();
            dTClient.fireClientEvent(new DTClientEvent(dTClient.getComponent(), 6));
            if (!this.fClients.contains(dTClient)) {
                return;
            }
            dTLocation = dTClient.getLocation();
            if (dTLocation != null && !dTLocation.isDocked()) {
                return;
            }
            this.setClientShowing(dTClient, false, null, false);
            DTFloatingLocation dTFloatingLocation = dTClient.getLastUndockedLocation();
            if (dTFloatingLocation == null) {
                dTFloatingLocation = new DTFloatingLocation(true);
            }
            this.setClientShowing(dTClient, true, dTFloatingLocation, false);
        }
    }

    public boolean isClientDocked(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientDocked(dTClient);
    }

    public boolean willDockNewDocumentInGroup(String string) {
        assert (EventQueue.isDispatchThread());
        DTGroup dTGroup = this.getGroup(string);
        return dTGroup == null ? false : this.shouldDockInGroup(dTGroup);
    }

    public boolean isClientDocked(String string) {
        DTClient dTClient = this.getDTClient(string);
        return this.isClientDocked(dTClient);
    }

    public boolean isClientDocked(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        return this.isClientDocked(dTClient);
    }

    protected boolean isClientDocked(final DTClient dTClient) {
        return this.syncCall(new CallableClientWrapper<Boolean>(dTClient, Boolean.valueOf(false)){

            @Override
            public Boolean call() {
                if (dTClient == null) {
                    return true;
                }
                DTLocation dTLocation = dTClient.getLocation();
                if (dTLocation == null) {
                    dTLocation = dTClient.getLastLocation();
                }
                return dTLocation == null || dTLocation.isDocked();
            }
        });
    }

    public void setClientMinimized(Component component, boolean bl) {
        this.setClientMinimized(component, bl, -1);
    }

    public void setClientMinimized(Component component, boolean bl, int n) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null && !this.fRestoringLayout) {
            dTClient = this.fClientBeingCreated;
        }
        this.fDeferredFacade.setClientMinimized(dTClient, bl, n);
    }

    public void setClientMinimized(String string, boolean bl) {
        this.setClientMinimized(string, ANY_GROUP, bl);
    }

    public void setClientMinimized(String string, String string2, boolean bl) {
        this.setClientMinimized(string, string2, bl, -1);
    }

    public void setClientMinimized(String string, String string2, boolean bl, int n) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.setClientMinimized(dTClient, bl, n);
    }

    @DeferredFacadeMethod
    protected void setClientMinimized(DTClient dTClient, boolean bl, int n) {
        if (dTClient.isSingleton()) {
            this.setOccupantMinimized(dTClient, bl, n);
        } else {
            DTFrame dTFrame;
            DTLocation dTLocation = dTClient.getLocation();
            if (!dTLocation.isDocked() && (dTFrame = dTLocation.getFrame()) != null) {
                boolean bl2;
                boolean bl3 = bl2 = dTFrame.getExtendedState() == 1;
                if (bl && !bl2) {
                    dTFrame.setExtendedState(1);
                } else if (!bl && bl2) {
                    dTFrame.setExtendedState(0);
                }
            }
        }
    }

    public boolean isClientMinimized(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientMinimized(dTClient);
    }

    public boolean isClientMinimized(String string) {
        DTClient dTClient = this.getDTClient(string);
        return this.isClientMinimized(dTClient);
    }

    public boolean isClientMinimized(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        return this.isClientMinimized(dTClient);
    }

    protected boolean isClientMinimized(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                if (dTClient == null) {
                    return true;
                }
                DTLocation dTLocation = dTClient.getLocation();
                if (dTLocation == null) {
                    dTLocation = dTClient.getLastLocation();
                }
                return dTLocation != null && dTLocation.isMinimized();
            }
        });
    }

    public void setClientMaximized(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null && !this.fRestoringLayout) {
            dTClient = this.fClientBeingCreated;
        }
        this.fDeferredFacade.setClientMaximized(dTClient, bl);
    }

    public void setClientMaximized(String string, boolean bl) {
        this.setClientMaximized(string, ANY_GROUP, bl);
    }

    public void setClientMaximized(String string, String string2, boolean bl) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.setClientMaximized(dTClient, bl);
    }

    @DeferredFacadeMethod
    protected void setClientMaximized(DTClient dTClient, boolean bl) {
        if (dTClient.isSingleton()) {
            this.setOccupantMaximized(dTClient, bl);
        } else {
            DTLocation dTLocation = dTClient.getLocation();
            if (dTLocation.isDocked()) {
                DTGroup dTGroup = dTClient.getGroup();
                if (dTGroup != null) {
                    DTDocumentContainer dTDocumentContainer = dTGroup.getDocumentContainer();
                    dTDocumentContainer.setArrangement(1, null);
                    dTDocumentContainer.toFront(dTClient, DTContainer.Scope.GROUP);
                }
            } else {
                DTFrame dTFrame = dTLocation.getFrame();
                if (dTFrame != null) {
                    boolean bl2;
                    int n = dTFrame.getExtendedState();
                    boolean bl3 = bl2 = n != -1 && (n & 6) == 6;
                    if (bl && !bl2) {
                        dTFrame.setExtendedState(6);
                    } else if (!bl && bl2) {
                        dTFrame.setExtendedState(0);
                    }
                }
            }
        }
    }

    public boolean isClientMaximized(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientMaximized(dTClient);
    }

    public boolean isClientMaximized(String string) {
        DTClient dTClient = this.getDTClient(string);
        return this.isClientMaximized(dTClient);
    }

    public boolean isClientMaximized(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        return this.isClientMaximized(dTClient);
    }

    protected boolean isClientMaximized(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                if (dTClient == null) {
                    return true;
                }
                DTLocation dTLocation = dTClient.getLocation();
                if (dTLocation == null) {
                    dTLocation = dTClient.getLastLocation();
                }
                return dTLocation != null && dTLocation.isMaximized();
            }
        });
    }

    public boolean isClientAnchored(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientAnchored(dTClient);
    }

    public boolean isClientAnchored(String string) {
        DTClient dTClient = this.getDTClient(string);
        return this.isClientAnchored(dTClient);
    }

    public boolean isClientAnchored(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        return this.isClientAnchored(dTClient);
    }

    protected boolean isClientAnchored(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                if (dTClient == null) {
                    return true;
                }
                DTLocation dTLocation = dTClient.getLocation();
                if (dTLocation == null) {
                    dTLocation = dTClient.getLastLocation();
                }
                return dTLocation != null && dTLocation.isAnchored();
            }
        });
    }

    public void showAnchoredClient(Component component) {
        assert (EventQueue.isDispatchThread());
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient != null) {
            this.showAnchoredClient(dTClient);
        }
    }

    public void hideAnchoredClient(Component component) {
        assert (EventQueue.isDispatchThread());
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient != null) {
            this.hideAnchoredClient(dTClient);
        }
    }

    public boolean isAnchoredClientShowing(Component component) {
        assert (EventQueue.isDispatchThread());
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return dTClient != null && this.isAnchoredClientShowing(dTClient);
    }

    protected void showAnchoredClient(DTClient dTClient) {
        Window window;
        if (dTClient.isDockableTearOff() && this.isClientAnchored(dTClient) && (window = SwingUtilities.windowForComponent(dTClient.getComponent())) != null) {
            window.setBounds(dTClient.getAnchoredBounds());
            window.setVisible(true);
        }
    }

    protected void hideAnchoredClient(DTClient dTClient) {
        Window window;
        if (dTClient.isDockableTearOff() && this.isClientAnchored(dTClient) && (window = SwingUtilities.windowForComponent(dTClient.getComponent())) != null) {
            window.setVisible(false);
        }
    }

    protected boolean isAnchoredClientShowing(DTClient dTClient) {
        Component component = null;
        if (dTClient.isDockableTearOff() && this.isClientAnchored(dTClient)) {
            component = SwingUtilities.windowForComponent(dTClient.getComponent());
        }
        return component != null && component.isVisible();
    }

    protected void setClientAnchored(DTClient dTClient, boolean bl) {
        boolean bl2;
        if (dTClient.isDockableTearOff() && dTClient.isShowing() && (bl2 = this.isClientAnchored(dTClient)) != bl) {
            if (dTClient.getLocation().isDocked()) {
                if (bl) {
                    this.setClientDocked(dTClient, false);
                }
            } else {
                Window window = SwingUtilities.windowForComponent(dTClient.getComponent());
                ((DTOnTopWindow)((Object)window)).setAnchored(bl);
            }
        }
    }

    public boolean isClientUnfurled(Component component) {
        if (component == null) {
            return false;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.isClientUnfurled(dTClient);
    }

    public boolean isClientUnfurled(String string) {
        DTClient dTClient = this.getDTClient(string);
        return this.isClientUnfurled(dTClient);
    }

    public boolean isClientUnfurled(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        return this.isClientUnfurled(dTClient);
    }

    protected boolean isClientUnfurled(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                if (dTClient == null) {
                    return false;
                }
                DTLocation dTLocation = dTClient.getLocation();
                return dTLocation != null && dTLocation.getContainer() instanceof DTBorderContainer && ((DTBorderContainer)dTLocation.getContainer()).getUnfurledOccupant() == dTClient;
            }
        });
    }

    public boolean hasClient(Component component) {
        return component != null && this.fComponentToClientMap.get(component) != null;
    }

    public boolean hasClient(String string) {
        return this.getDTClient(string) != null;
    }

    public boolean hasClient(String string, String string2) {
        return this.getDTClient(string, string2) != null;
    }

    public boolean hadClient(String string) {
        return this.getFormerClient(string, ANY_GROUP) != null;
    }

    public boolean hadClient(String string, String string2) {
        return this.getFormerClient(string, string2) != null;
    }

    public Component getSelected() {
        DTClient dTClient = this.getSelectedClient();
        return dTClient == null ? null : dTClient.getComponent();
    }

    public Component getSelectedInGroup(String string) {
        DTClient dTClient = this.getSelectedClient();
        return dTClient == null || dTClient.getGroup() != this.getGroup(string) ? null : dTClient.getComponent();
    }

    public Component getLastDocumentSelectedInGroup(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            return null;
        }
        return this.syncCall(new CallableWrapper<Component>(){

            @Override
            public Component call() {
                DTClient dTClient = dTGroup.getMostRecentlySelected(true);
                return dTClient == null ? null : dTClient.getComponent();
            }
        });
    }

    public DTFrame getContainingFrame(Component component) {
        if (component == null) {
            return null;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null) {
            return null;
        }
        DTLocation dTLocation = this.getClientLocation(dTClient);
        return dTLocation == null ? null : dTLocation.getFrame();
    }

    public String getTitle(Component component) {
        if (component == null) {
            return null;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return dTClient == null ? null : dTClient.getTitle();
    }

    public String getShortTitle(Component component) {
        if (component == null) {
            return null;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return dTClient == null ? null : dTClient.getShortTitle();
    }

    public void setClientLocation(Component component, DTLocation dTLocation) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null && !this.fRestoringLayout) {
            dTClient = this.fClientBeingCreated;
        }
        this.fDeferredFacade.setClientLocation(dTClient, DTLocation.clone(dTLocation));
    }

    public void setClientLocation(String string, DTLocation dTLocation) {
        this.setClientLocation(string, ANY_GROUP, dTLocation);
    }

    public void setClientLocation(String string, String string2, DTLocation dTLocation) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.setClientLocation(dTClient, DTLocation.clone(dTLocation));
    }

    public DTLocation getClientLocation(Component component) {
        if (component == null) {
            return null;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null) {
            return null;
        }
        return this.cloneLocation(this.getClientLocation(dTClient));
    }

    public DTLocation getClientLocation(String string) {
        DTClient dTClient = this.getDTClient(string);
        if (dTClient == null) {
            return null;
        }
        return this.cloneLocation(this.getClientLocation(dTClient));
    }

    private DTLocation cloneLocation(DTLocation dTLocation) {
        if (dTLocation != null) {
            dTLocation = DTLocation.clone(dTLocation);
            dTLocation.setFrame(null);
            dTLocation.setContainer(null);
        }
        return dTLocation;
    }

    DTLocation getClientLocation(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<DTLocation>(){

            @Override
            public DTLocation call() {
                return dTClient.getLocation();
            }
        });
    }

    public DTLocation getLastUndockedLocation(Component component) {
        if (component == null) {
            return null;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null) {
            return null;
        }
        return this.getLastUndockedLocation(dTClient);
    }

    DTLocation getLastUndockedLocation(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<DTLocation>(){

            @Override
            public DTLocation call() {
                return dTClient.getLastUndockedLocation();
            }
        });
    }

    public void setClientEnabled(Component component, boolean bl) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null) {
            return;
        }
        this.fDeferredFacade.setClientEnabled(dTClient, bl);
    }

    public void setClientEnabled(String string, boolean bl) {
        DTClient dTClient = this.getDTClient(string);
        if (dTClient == null) {
            return;
        }
        this.fDeferredFacade.setClientEnabled(dTClient, bl);
    }

    @DeferredFacadeMethod
    void setClientEnabled(DTClient dTClient, boolean bl) {
        if (dTClient.isSingleton()) {
            dTClient.setEnabled(bl);
        }
    }

    public boolean isClientEnabled(Component component) {
        DTClient dTClient = this.fComponentToClientMap.get(component);
        if (dTClient == null) {
            return false;
        }
        return this.isClientEnabled(dTClient);
    }

    public boolean isClientEnabled(String string) {
        DTClient dTClient = this.getDTClient(string);
        if (dTClient == null) {
            return false;
        }
        return this.isClientEnabled(dTClient);
    }

    boolean isClientEnabled(final DTClient dTClient) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                return dTClient.isEnabled();
            }
        });
    }

    public Insets getInternalFrameInsets(Component component) {
        if (component == null) {
            return null;
        }
        final DTClient dTClient = this.fComponentToClientMap.get(component);
        return this.syncCall(new CallableWrapper<Insets>(){

            @Override
            public Insets call() {
                return Desktop.this.getInternalFrameInsets(dTClient);
            }
        });
    }

    private Insets getInternalFrameInsets(DTClient dTClient) {
        if (dTClient == null) {
            return null;
        }
        DTInternalFrame dTInternalFrame = dTClient.getInternalFrame();
        if (dTInternalFrame == null) {
            return null;
        }
        Insets insets = dTInternalFrame.getInsets();
        if (dTInternalFrame.isTitleBarVisible()) {
            DTTitleBar dTTitleBar = dTInternalFrame.getTitleBar();
            assert (dTTitleBar != null);
            insets.top += dTTitleBar.getPreferredSize().height;
        }
        return insets;
    }

    public void hideClient(Component component) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.fDeferredFacade.hideClient(dTClient);
    }

    public void hideClient(String string) {
        this.hideClient(string, ANY_GROUP);
    }

    public void hideClient(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.hideClient(dTClient);
    }

    public void closeClient(Component component) {
        if (component == null) {
            return;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        this.fDeferredFacade.closeClient(dTClient);
    }

    public void closeClient(String string) {
        this.closeClient(string, ANY_GROUP);
    }

    public void closeClient(String string, String string2) {
        DTClient dTClient = this.getDTClient(string, string2);
        this.fDeferredFacade.closeClient(dTClient);
    }

    @DeferredFacadeMethod
    protected void closeClient(DTClient dTClient) {
        dTClient.attemptClose();
    }

    public String getGroup(Component component) {
        if (component == null) {
            return null;
        }
        DTClient dTClient = this.fComponentToClientMap.get(component);
        return dTClient == null ? null : dTClient.getGroupName();
    }

    public String getClientGroup(String string) {
        DTClient dTClient = this.getDTClient(string);
        return dTClient == null ? null : dTClient.getGroupName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroupTitles() {
        Vector<DTGroup> vector = this.fGroups;
        synchronized (vector) {
            int n = this.fGroups.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                DTGroup dTGroup = this.fGroups.get(i);
                stringArray[i] = dTGroup.getTitle();
            }
            return stringArray;
        }
    }

    public boolean hasGroup(String string) {
        return this.getGroup(string) != null;
    }

    public boolean hadGroup(String string) {
        return this.getFormerGroup(string) != null;
    }

    public void addGroup(DTGroupPropertyProvider dTGroupPropertyProvider) {
        DTGroup dTGroup;
        String string = (String)dTGroupPropertyProvider.getGroupProperty(DTGroupProperty.NAME);
        if (string == null) {
            string = (String)dTGroupPropertyProvider.getGroupProperty(DTGroupProperty.TITLE);
        }
        if ((dTGroup = this.getGroup(string)) == null) {
            dTGroup = new DTGroup(this, dTGroupPropertyProvider, (DTFrame)this.fMainFrame);
            this.addGroup(dTGroup);
        } else if (dTGroup.getPropertyProvider() == null) {
            dTGroup.setPropertyProvider(dTGroupPropertyProvider);
        }
    }

    public void showGroup(String string, boolean bl) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setGroupShowing(dTGroup, true, null, bl);
    }

    public void closeGroup(String string) {
        this.closeGroup(string, false, true);
    }

    public void closeGroup(String string, boolean bl, boolean bl2) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup != null) {
            this.fDeferredFacade.closeGroup(dTGroup, bl, bl2);
        }
    }

    @DeferredFacadeMethod
    void closeGroup(DTGroup dTGroup, boolean bl, boolean bl2) {
        DTCloseTransaction dTCloseTransaction;
        DTCloseTransaction dTCloseTransaction2 = dTCloseTransaction = bl ? dTGroup.getCloseDockedTransaction(bl2) : dTGroup.getCloseAllTransaction(bl2);
        if (bl2) {
            dTCloseTransaction.setDoneListener(new GroupCloseDoneListener(dTGroup));
        }
        dTCloseTransaction.start();
    }

    public void removeGroup(String string) {
        this.removeGroup(string, false);
    }

    public void removeGroup(String string, boolean bl) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup != null) {
            this.fDeferredFacade.removeGroup(dTGroup, bl);
        }
    }

    @DeferredFacadeMethod
    void removeGroup(DTGroup dTGroup, boolean bl) {
        DTCloseTransaction dTCloseTransaction = dTGroup.getCloseAllTransaction(true);
        GroupCloseDoneListener groupCloseDoneListener = new GroupCloseDoneListener(dTGroup, true);
        if (bl) {
            dTCloseTransaction.close();
            groupCloseDoneListener.closeTransactionDone(true);
        } else {
            dTCloseTransaction.setDoneListener(groupCloseDoneListener);
            dTCloseTransaction.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGroup(DTGroup dTGroup) {
        DTNotifyingList<DTClient> dTNotifyingList = dTGroup.getSingletons();
        DTClient[] dTClientArray = new DTClient[dTNotifyingList.size()];
        dTNotifyingList.toArray(dTClientArray);
        Object object = dTClientArray;
        int n = ((DTClient[])object).length;
        for (int i = 0; i < n; ++i) {
            DTClient dTClient = object[i];
            this.removeClient(dTClient);
        }
        this.fNotifyingGroups.remove(dTGroup);
        this.fLayoutSaveManager.removeGroup(dTGroup);
        if (this.useToolstrip()) {
            this.fActionManager.removeAction((Action)dTGroup.getSelectAction());
        }
        if (this.fToolstripRegistry != null) {
            this.fToolstripRegistry.removeTabContext(dTGroup.getName());
        }
        this.fGroups.remove(dTGroup);
        if (dTGroup.isGuest() && !dTGroup.isSessionGuest()) {
            object = this.fFormerGroups;
            synchronized (object) {
                this.fFormerGroups.add(dTGroup);
            }
        }
        if ((object = dTGroup.getGroupBase()) != null) {
            object.setParentDesktop(null);
        }
        this.removePendingListener(dTGroup);
        dTGroup.flush();
    }

    public boolean isGroupShowing(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                return dTGroup != null && dTGroup.getLocation() != null;
            }
        });
    }

    public void groupToFront(String string) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup != null) {
            this.fDeferredFacade.toFront(dTGroup, DTContainer.Scope.FRAME);
        }
    }

    public void setGroupDocked(String string, boolean bl) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setGroupDocked(dTGroup, bl);
    }

    public boolean isGroupDocked(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                return dTGroup == null || Desktop.this.isGroupDocked(dTGroup);
            }
        });
    }

    public void dockAllInGroup(String string) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.dockAllInGroup(dTGroup);
    }

    public void setGroupMinimized(String string, boolean bl) {
        this.setGroupMinimized(string, bl, -1);
    }

    public void setGroupMinimized(String string, boolean bl, int n) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setGroupMinimized(dTGroup, bl, n);
    }

    @DeferredFacadeMethod
    protected void setGroupMinimized(DTGroup dTGroup, boolean bl, int n) {
        this.setOccupantMinimized(dTGroup, bl, n);
        dTGroup.setOnTopSingletonsVisible(!bl);
    }

    public boolean isGroupMinimized(final String string) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                DTGroup dTGroup = Desktop.this.getGroup(string);
                return dTGroup != null && Desktop.this.isGroupMinimized(dTGroup);
            }
        });
    }

    protected boolean isGroupMinimized(DTGroup dTGroup) {
        DTLocation dTLocation = dTGroup.getLocation();
        if (dTLocation == null) {
            dTLocation = dTGroup.getLastLocation();
        }
        return dTLocation != null && dTLocation.isMinimized();
    }

    public void setGroupMaximized(String string, boolean bl) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setGroupMaximized(dTGroup, bl);
    }

    @DeferredFacadeMethod
    protected void setGroupMaximized(DTGroup dTGroup, boolean bl) {
        this.setOccupantMaximized(dTGroup, bl);
    }

    public boolean isGroupMaximized(final String string) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                DTGroup dTGroup = Desktop.this.getGroup(string);
                return dTGroup != null && Desktop.this.isGroupMaximized(dTGroup);
            }
        });
    }

    protected boolean isGroupMaximized(DTGroup dTGroup) {
        DTLocation dTLocation = dTGroup.getLocation();
        if (dTLocation == null) {
            dTLocation = dTGroup.getLastLocation();
        }
        return dTLocation != null && dTLocation.isMaximized();
    }

    public boolean isGroupUnfurled(final String string) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                DTGroup dTGroup = Desktop.this.getGroup(string);
                if (dTGroup == null) {
                    return false;
                }
                DTLocation dTLocation = dTGroup.getLocation();
                return dTLocation != null && dTLocation.getContainer() instanceof DTBorderContainer && ((DTBorderContainer)dTLocation.getContainer()).getUnfurledOccupant() == dTGroup;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectedGroup() {
        Vector<DTGroup> vector = this.fGroups;
        synchronized (vector) {
            for (DTGroup dTGroup : this.fGroups) {
                if (!dTGroup.isSelected()) continue;
                return dTGroup.getName();
            }
        }
        return null;
    }

    public boolean isGroupSelected(final String string) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                DTGroup dTGroup = Desktop.this.getGroup(string);
                return dTGroup != null && dTGroup.isSelected();
            }
        });
    }

    public void setGroupLocation(String string, DTLocation dTLocation) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setGroupLocation(dTGroup, DTLocation.clone(dTLocation));
    }

    @DeferredFacadeMethod
    void setGroupLocation(DTGroup dTGroup, DTLocation dTLocation) {
        DTLocation dTLocation2 = dTGroup.getLocation();
        if (dTLocation == null) {
            return;
        }
        if (dTLocation2 == null) {
            if (!dTLocation.isDocked() || !dTGroup.isDockable()) {
                dTGroup.setContainingFrame(null);
                dTGroup.setLastUndockedLocation(dTLocation);
            } else if (dTLocation instanceof DTNestedLocation || dTLocation instanceof DTBorderLocation) {
                dTGroup.setContainingFrame(this.fMainFrame);
                dTGroup.setLastDockedLocation(dTLocation);
            }
        } else if (dTLocation2.isDocked()) {
            if (!dTLocation.isDocked() || !dTGroup.isDockable()) {
                dTGroup.setLastUndockedLocation(dTLocation);
                this.setGroupDocked(dTGroup, false);
            } else if (dTLocation instanceof DTNestedLocation || dTLocation instanceof DTBorderLocation) {
                this.setGroupShowing(dTGroup, false, null, false);
                this.setGroupShowing(dTGroup, true, dTLocation, false);
            }
        } else if (!dTLocation.isDocked()) {
            DTFrame dTFrame = dTLocation2.getFrame();
            if (dTFrame != null) {
                dTFrame.setBounds(dTLocation.getFrameBounds());
            }
        } else if (dTLocation instanceof DTNestedLocation || dTLocation instanceof DTBorderLocation) {
            dTGroup.setLastDockedLocation(dTLocation);
            this.setGroupDocked(dTGroup, true);
        }
    }

    public DTLocation getGroupLocation(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            return null;
        }
        DTLocation dTLocation = this.syncCall(new CallableWrapper<DTLocation>(){

            @Override
            public DTLocation call() {
                return dTGroup.getLocation();
            }
        });
        return this.cloneLocation(dTLocation);
    }

    public void setGroupEnabled(String string, boolean bl) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            return;
        }
        this.fDeferredFacade.setGroupEnabled(dTGroup, bl);
    }

    @DeferredFacadeMethod
    void setGroupEnabled(DTGroup dTGroup, boolean bl) {
        if (!dTGroup.mayHaveHeavyContent()) {
            dTGroup.setEnabled(bl);
        }
    }

    public boolean isGroupEnabled(String string) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            return false;
        }
        return this.isGroupEnabled(dTGroup);
    }

    boolean isGroupEnabled(final DTGroup dTGroup) {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                return dTGroup.isEnabled();
            }
        });
    }

    public void closeGroupSingletons(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup != null) {
            Desktop.deferredCall(new Runnable(){

                @Override
                public void run() {
                    dTGroup.saveSingletonState();
                    dTGroup.closeSingletons();
                }
            });
        }
    }

    public void restoreGroupSingletons(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup != null) {
            Desktop.deferredCall(new Runnable(){

                @Override
                public void run() {
                    dTGroup.restoreSingletons();
                }
            });
        }
    }

    public void addGroupListener(String string, DTGroupListener dTGroupListener) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            dTGroup = this.addGroup(string);
        }
        dTGroup.addListener(dTGroupListener);
    }

    public void removeGroupListener(String string, DTGroupListener dTGroupListener) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup != null) {
            dTGroup.removeListener(dTGroupListener);
        }
    }

    public DTFrame getFrameContainingGroup(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null || dTGroup.getLocation() == null) {
            return null;
        }
        return this.syncCall(new CallableWrapper<DTFrame>(){

            @Override
            public DTFrame call() {
                return dTGroup.getContainingFrame();
            }
        });
    }

    public Container getGroupContainer(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null || dTGroup.getLocation() == null) {
            return null;
        }
        return this.syncCall(new CallableWrapper<Container>(){

            @Override
            public Container call() {
                return dTGroup.hasDocumentContainer() ? Desktop.this.getDocumentContainer(dTGroup) : null;
            }
        });
    }

    public Insets getGroupContainerInsets(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null || dTGroup.getLocation() == null) {
            return null;
        }
        DTDocumentContainer dTDocumentContainer = this.syncCall(new CallableWrapper<DTDocumentContainer>(){

            @Override
            public DTDocumentContainer call() {
                return dTGroup.hasDocumentContainer() ? Desktop.this.getDocumentContainer(dTGroup) : null;
            }
        });
        return dTDocumentContainer != null ? dTDocumentContainer.getTabsInsets() : null;
    }

    public Action getGroupCloseSelectAction(String string) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null || dTGroup.getLocation() == null) {
            return null;
        }
        return this.getGroupCloseSelectAction(dTGroup);
    }

    protected Action getGroupCloseSelectAction(DTGroup dTGroup) {
        return dTGroup.hasDocumentContainer() ? this.getDocumentContainer(dTGroup).getCloseSelectAction() : null;
    }

    public DropTarget getGroupDropTarget(String string) {
        DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null || dTGroup.getLocation() == null) {
            return null;
        }
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        return dTDocumentContainer != null ? dTDocumentContainer.getDropTarget() : null;
    }

    public int getDocumentArrangement(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            return 1;
        }
        return this.syncCall(new CallableWrapper<Integer>(){

            @Override
            public Integer call() {
                return Desktop.this.getDocumentArrangement(dTGroup);
            }
        });
    }

    public Dimension getDocumentTiledDimension(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            return new Dimension(1, 1);
        }
        return this.syncCall(new CallableWrapper<Dimension>(){

            @Override
            public Dimension call() {
                return Desktop.this.getDocumentTiledDimension(dTGroup);
            }
        });
    }

    public void setDocumentArrangement(String string, int n, Dimension dimension) {
        DTGroup dTGroup = null;
        if (string != null && (dTGroup = this.getGroup(string)) == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setDocumentArrangement(dTGroup, n, dimension);
    }

    @DeferredFacadeMethod
    protected void setDocumentArrangement(DTGroup dTGroup, int n, Dimension dimension) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.setArrangement(n, dimension);
        }
    }

    public void cascadeDockedDocuments(String string) {
        DTGroup dTGroup = null;
        if (string != null) {
            dTGroup = this.getGroup(string);
        }
        if (dTGroup != null) {
            this.fDeferredFacade.cascadeDockedDocuments(dTGroup);
        }
    }

    @DeferredFacadeMethod
    protected void cascadeDockedDocuments(DTGroup dTGroup) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.cascadeDocuments();
        }
    }

    public void minimizedDockedDocuments(String string) {
        DTGroup dTGroup = null;
        if (string != null) {
            dTGroup = this.getGroup(string);
        }
        if (dTGroup != null) {
            this.fDeferredFacade.minimizeDockedDocuments(dTGroup);
        }
    }

    @DeferredFacadeMethod
    protected void minimizeDockedDocuments(DTGroup dTGroup) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.minimizeDocuments();
        }
    }

    public void setDocumentColumnWidths(String string, float[] fArray) {
        DTGroup dTGroup = null;
        if (string != null && (dTGroup = this.getGroup(string)) == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setDocumentColumnWidths(dTGroup, fArray);
    }

    @DeferredFacadeMethod
    protected void setDocumentColumnWidths(DTGroup dTGroup, float[] fArray) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.setColumnWidths(fArray);
        }
    }

    public void setDocumentRowHeights(String string, float[] fArray) {
        DTGroup dTGroup = null;
        if (string != null && (dTGroup = this.getGroup(string)) == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setDocumentRowHeights(dTGroup, fArray);
    }

    @DeferredFacadeMethod
    protected void setDocumentRowHeights(DTGroup dTGroup, float[] fArray) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.setRowHeights(fArray);
        }
    }

    public void setDocumentColumnSpan(String string, int n, int n2, int n3) {
        DTGroup dTGroup = null;
        if (string != null && (dTGroup = this.getGroup(string)) == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setDocumentColumnSpan(dTGroup, n, n2, n3);
    }

    @DeferredFacadeMethod
    protected void setDocumentColumnSpan(DTGroup dTGroup, int n, int n2, int n3) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.setColumnSpan(n, n2, n3);
        }
    }

    public void setDocumentRowSpan(String string, int n, int n2, int n3) {
        DTGroup dTGroup = null;
        if (string != null && (dTGroup = this.getGroup(string)) == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setDocumentRowSpan(dTGroup, n, n2, n3);
    }

    @DeferredFacadeMethod
    protected void setDocumentRowSpan(DTGroup dTGroup, int n, int n2, int n3) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.setRowSpan(n, n2, n3);
        }
    }

    public int getDocumentBarPosition(String string) {
        final DTGroup dTGroup = this.getGroup(string);
        if (dTGroup == null) {
            return 1;
        }
        return this.syncCall(new CallableWrapper<Integer>(){

            @Override
            public Integer call() {
                return Desktop.this.getDocumentBarPosition(dTGroup);
            }
        });
    }

    protected int getDocumentBarPosition(DTGroup dTGroup) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer == null) {
            return 1;
        }
        return dTDocumentContainer.getTabsEdge();
    }

    public void setDocumentBarPosition(String string, int n) {
        DTGroup dTGroup = null;
        if (string != null && (dTGroup = this.getGroup(string)) == null) {
            dTGroup = this.addGroup(string);
        }
        this.fDeferredFacade.setDocumentBarPosition(dTGroup, n);
    }

    @DeferredFacadeMethod
    protected void setDocumentBarPosition(DTGroup dTGroup, int n) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer != null) {
            dTDocumentContainer.setTabsEdge(n);
        }
    }

    public void addAction(final Action action) {
        if (action != null) {
            Desktop.deferredCall(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.fActionManager.addAction(action);
                }
            });
        }
    }

    public void removeAction(final Action action) {
        if (action != null) {
            Desktop.deferredCall(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.fActionManager.removeAction(action);
                }
            });
        }
    }

    public void setLayoutLocked(final boolean bl) {
        Desktop.deferredCall(new Runnable(){

            @Override
            public void run() {
                Desktop.this.deferredSetLayoutLocked(bl);
            }
        });
    }

    public boolean isLayoutLocked() {
        return this.syncCall(new CallableWrapper<Boolean>(){

            @Override
            public Boolean call() {
                return Desktop.this.fIsLayoutLocked;
            }
        });
    }

    protected void deferredSetLayoutLocked(boolean bl) {
        if (this.fIsLayoutLocked != bl) {
            this.fIsLayoutLocked = bl;
            DTLayoutToolSetFactory.setLayoutDropDownsEnabled(!bl);
            ArrayList<DTOccupant> arrayList = new ArrayList<DTOccupant>(this.fSingletons.size() + this.fGroups.size());
            arrayList.addAll(this.fSingletons);
            arrayList.addAll(this.fGroups);
            for (DTOccupant dTOccupant : arrayList) {
                dTOccupant.forwardPropertyChange(new PropertyChangeEvent(dTOccupant, DTProperty.PERMIT_USER_CLOSE.toString(), bl, !bl));
                dTOccupant.forwardPropertyChange(new PropertyChangeEvent(dTOccupant, DTProperty.PERMIT_USER_UNDOCK.toString(), bl, !bl));
                dTOccupant.forwardPropertyChange(new PropertyChangeEvent(dTOccupant, DTProperty.PERMIT_USER_MAXIMIZE.toString(), bl, !bl));
                dTOccupant.forwardPropertyChange(new PropertyChangeEvent(dTOccupant, DTProperty.PERMIT_USER_MINIMIZE.toString(), bl, !bl));
            }
        }
    }

    public boolean saveLayout(final String string) {
        return Desktop.deferredCall(new CallableWrapper<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                DTLayoutLibrary dTLayoutLibrary = Desktop.this.getLayoutLibrary();
                boolean bl = string == null;
                boolean bl2 = Desktop.this.fMainFrame != null && Desktop.this.fMainFrame.isMaximized();
                File file = bl ? Desktop.this.getInitFile(true) : dTLayoutLibrary.getUserFile(string);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    Desktop.this.saveLayout(fileOutputStream, !bl || bl2, bl, bl, bl);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    if (bl) {
                        Desktop.this.fLastLayoutSaveFailed = false;
                    }
                }
                catch (Exception exception) {
                    if (!Desktop.this.fLastLayoutSaveFailed || !bl) {
                        Desktop.this.getErrorReportingStream().println(Desktop.this.getString("error.FailureDuringSave"));
                        Desktop.this.fLastLayoutSaveFailed = bl;
                    }
                    if (Desktop.this.fIsClosing) {
                        PrintStream printStream = null;
                        try {
                            String string2 = DTUtilities.getTempDirectory() + "MATLABDesktopSaveError.log";
                            FileOutputStream fileOutputStream = new FileOutputStream(string2);
                            printStream = new PrintStream(fileOutputStream);
                            exception.printStackTrace(printStream);
                        }
                        catch (Exception exception2) {
                        }
                        finally {
                            if (printStream != null) {
                                printStream.flush();
                                printStream.close();
                            }
                        }
                    }
                    return false;
                }
                if (string != null) {
                    dTLayoutLibrary.addUserLayout(string);
                }
                return true;
            }
        }, true);
    }

    public boolean restorePreviousLayout() {
        boolean bl = false;
        File file = this.getInitFile(false);
        if (file != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                bl = this.restoreLayout(fileInputStream);
                fileInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                this.getErrorReportingStream().println(this.getString("error.ReadingConfigFile"));
                this.getErrorReportingStream().println(this.getString("error.UsingDefaultConfig"));
            }
            if (!bl) {
                this.clearLayout();
            }
        }
        if (bl && this.fMainFrame == null) {
            for (DTFrame dTFrame : this.fFrames) {
                dTFrame.setVisible(true);
            }
        }
        return bl;
    }

    public void restoreLayout(final String string) {
        Desktop.deferredCall(new Runnable(){

            @Override
            public void run() {
                Desktop.this.restoreLayoutByIndex(Desktop.this.getLayoutLibrary().indexOf(string));
            }
        });
    }

    public void restoreLayout(final File file) {
        Desktop.deferredCall(new Runnable(){

            @Override
            public void run() {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Desktop.this.restoreLayout(fileInputStream);
                    fileInputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Desktop.this.getErrorReportingStream().println("Layout file " + file + " not found");
                }
                catch (IOException iOException) {
                    Desktop.this.getErrorReportingStream().println(Desktop.this.getString("error.ReadingConfigFile"));
                }
            }
        });
    }

    protected void restoreLayout(int n) {
        this.fDeferredFacade.restoreLayoutByIndex(n);
    }

    @DeferredFacadeMethod
    protected void restoreLayoutByIndex(int n) {
        URL uRL = this.getLayoutLibrary().getLayoutURL(n);
        if (uRL == null) {
            return;
        }
        try {
            InputStream inputStream = uRL.openStream();
            this.restoreLayout(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getErrorReportingStream().println(this.getString("error.CantFindLayout") + " " + uRL.toString());
        }
        catch (IOException iOException) {
            this.getErrorReportingStream().println(this.getString("error.ReadingConfigFile"));
        }
    }

    public boolean hasMainFrame() {
        return this.fMainFrame != null;
    }

    public DTFrame getMainFrame() {
        return this.fMainFrame;
    }

    public boolean canHaveMainFrame() {
        return true;
    }

    protected boolean mustHaveMainFrame() {
        return this.canHaveMainFrame();
    }

    public int getDocumentContainment() {
        return this.syncCall(new CallableWrapper<Integer>(){

            @Override
            public Integer call() {
                return Desktop.this.fDocumentContainment;
            }
        });
    }

    public void setDocumentContainment(final int n) {
        Desktop.deferredCall(new Runnable(){

            @Override
            public void run() {
                if (Desktop.this.fDocumentContainment != n) {
                    DTClient[] dTClientArray = null;
                    if (Desktop.this.fMainFrame != null) {
                        dTClientArray = new DTClient[Desktop.this.fClients.size()];
                        Desktop.this.fClients.toArray(dTClientArray);
                        for (int i = 0; i < dTClientArray.length; ++i) {
                            if (dTClientArray[i].isSingleton() || dTClientArray[i].getLocation() == null || dTClientArray[i].getLocation().getFrame() != Desktop.this.fMainFrame) {
                                dTClientArray[i] = null;
                                continue;
                            }
                            Desktop.this.setClientShowing(dTClientArray[i], false, null, false);
                        }
                        for (DTGroup dTGroup : Desktop.this.fGroups) {
                            if (!Desktop.this.fMainFrame.contains(dTGroup)) continue;
                            Desktop.this.fMainFrame.removeGroup(dTGroup);
                        }
                        if (Desktop.this.fMainFrame.contains(Desktop.this.fMainFrame.getSharedDocuments())) {
                            Desktop.this.fMainFrame.removeDocuments(Desktop.this.fMainFrame.getSharedDocuments());
                        }
                    }
                    Desktop.this.fDocumentContainment = n;
                    if (Desktop.this.fMainFrame != null) {
                        Desktop.this.fRestoringLayout = true;
                        for (DTClient dTClient : dTClientArray) {
                            if (dTClient == null) continue;
                            Desktop.this.setClientShowing(dTClient, true, DTLocation.createMaximized(false), false);
                        }
                        Desktop.this.fRestoringLayout = false;
                        Desktop.this.fMainFrame.endRestore();
                    }
                }
            }
        });
    }

    public static boolean isDockedMinMaxSupported() {
        return true;
    }

    public boolean isDockedMinMaxEnabled() {
        return false;
    }

    public boolean isWindowNavigationMenuEnabled() {
        return false;
    }

    public boolean accommodateHeavyweightClients() {
        return true;
    }

    final boolean isDockedMinMaxSupportedAndEnabled() {
        return Desktop.isDockedMinMaxSupported() && this.isDockedMinMaxEnabled();
    }

    public LayoutSavePolicy getLayoutSavePolicy() {
        return this.fLayoutSavePolicy;
    }

    public void setLayoutSavePolicy(LayoutSavePolicy layoutSavePolicy) {
        this.fLayoutSavePolicy = layoutSavePolicy;
    }

    public static boolean dragAndDropHintsEnabled() {
        return true;
    }

    public boolean retainLastDocumentToolstripTabs() {
        return this.fRetainLastDocumentToolstripTabs;
    }

    public void setRetainLastDocumentToolstripTabs(boolean bl) {
        this.fRetainLastDocumentToolstripTabs = bl;
    }

    public void setStatusText(String string) {
        this.setStatusText(string, false);
    }

    public void setStatusText(final String string, final boolean bl) {
        if (this.fMainFrame != null) {
            Desktop.deferredCall(new Runnable(){

                @Override
                public void run() {
                    if (Desktop.this.fMainFrame != null) {
                        Desktop.this.fMainFrame.setStatusText(string, bl);
                    }
                }
            });
        }
    }

    public final int getMajorVersion() {
        return 1 + this.getDocumentContainment();
    }

    public int getMinorVersion() {
        return 0;
    }

    protected boolean canRestoreLayout(int n, int n2) {
        return n <= this.getMajorVersion() && n2 <= this.getMinorVersion();
    }

    protected boolean ownsWindowRegistry() {
        return this.getWindowRegistry() != DTWindowRegistry.getInstance();
    }

    @Override
    public void activate() {
        if (this.hasMainFrame()) {
            this.getMainFrame().toFront();
        }
    }

    @Override
    public String getShortTitle() {
        return this.getDesktopName();
    }

    @Override
    public String getGroupName() {
        return "Desktop";
    }

    public boolean canClose() {
        this.fIsAttemptingClose = true;
        DesktopCloseTransaction desktopCloseTransaction = new DesktopCloseTransaction(){

            @Override
            protected void close() {
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            desktopCloseTransaction.start();
        } else {
            SwingUtilities.invokeLater(desktopCloseTransaction);
            while (!desktopCloseTransaction.isDone()) {
                if (FactoryUtils.processPendingEvents()) {
                    return false;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    Log.logException((Exception)interruptedException);
                }
            }
        }
        this.fIsAttemptingClose = false;
        return !desktopCloseTransaction.wasVetoed();
    }

    public void close() {
        this.close(this.getLayoutSavePolicy() != LayoutSavePolicy.NEVER && (this.hasMainFrame() || !this.canHaveMainFrame()));
    }

    public void close(boolean bl) {
        Object object;
        Object object3;
        DTClient[] dTClientArray;
        this.fIsClosing = true;
        if (!SwingUtilities.isEventDispatchThread()) {
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)new DeferredCloser(bl)));
            return;
        }
        this.fLayoutSaveManager.setSaveEnabled(false);
        if (bl) {
            dTClientArray = new DTClient[this.fSingletons.size()];
            this.fSingletons.toArray(dTClientArray);
            for (DTClient dTGroup : dTClientArray) {
                if (dTGroup.isGuest()) {
                    this.removeClient(dTGroup);
                    continue;
                }
                if (!dTGroup.isShowing() || dTGroup.isAutoReopenEnabled()) continue;
                dTGroup.close();
            }
            object3 = new DTGroup[this.fGroups.size()];
            this.fGroups.toArray((T[])object3);
            for (Object object2 : object3) {
                if (!((DTOccupant)object2).isGuest()) continue;
                this.removeGroup((DTGroup)object2, true);
            }
            this.saveLayout(null);
        }
        dTClientArray = new ArrayList();
        for (DTClient dTClient : this.fSingletons) {
            if (!dTClient.isShowing()) continue;
            dTClientArray.add(dTClient);
        }
        object3 = new ArrayList();
        for (DTGroup dTGroup : this.fGroups) {
            if (!dTGroup.isShowing()) continue;
            object3.add(dTGroup);
        }
        DTFrame[] dTFrameArray = new DTFrame[this.fFrames.size()];
        this.fFrames.toArray(dTFrameArray);
        for (DTFrame dTFrame : dTFrameArray) {
            if (dTFrame instanceof DTMultipleClientFrame) {
                ((DTMultipleClientFrame)dTFrame).beginClear();
            }
            dTFrame.dispose();
        }
        for (DTClient dTClient : dTClientArray) {
            dTClient.close();
        }
        if (this.ownsWindowRegistry()) {
            this.getWindowRegistry().closeAll();
        } else if (this.fClients.size() > 0) {
            object = new DTClient[this.fClients.size()];
            this.fClients.toArray((T[])object);
            for (Object object4 : object) {
                if (((DTClient)object4).isSingleton()) continue;
                ((DTClient)object4).close();
            }
        }
        object = object3.iterator();
        while (object.hasNext()) {
            DTGroup dTGroup = (DTGroup)object.next();
            if (dTGroup.isShowing()) {
                this.setGroupShowing(dTGroup, false, null, false);
            }
            dTGroup.setClosed();
        }
        this.fSelectionManager.setEnabled(false);
        this.clearMainFrame();
        this.getWindowRegistry().removeDesktop(this);
        this.fIsClosing = false;
    }

    private void clearMainFrame() {
        if (this.fMainFrame == null) {
            return;
        }
        for (DTGroup dTGroup : this.fGroups) {
            if (dTGroup.getContainingFrame() != this.fMainFrame) continue;
            dTGroup.setContainingFrame(null);
        }
        this.fMainFrame = null;
    }

    public void closeMainFrame() {
        if (!this.hasMainFrame()) {
            return;
        }
        this.closeMainFrame(this.getLayoutSavePolicy() != LayoutSavePolicy.NEVER);
    }

    public void closeMainFrame(boolean bl) {
        if (this.fMainFrame == null) {
            return;
        }
        this.fIsClosing = true;
        if (!SwingUtilities.isEventDispatchThread()) {
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)new DeferredMainFrameCloser(bl)));
            return;
        }
        this.fLayoutSaveManager.setSaveEnabled(false);
        if (bl) {
            this.saveLayout(null);
        }
        for (DTClient object : this.fSingletons) {
            DTLocation dTLocation = object.getLocation();
            if (dTLocation == null || !dTLocation.isDocked() || dTLocation.getFrame() != this.fMainFrame) continue;
            object.close();
        }
        if (this.fClients.size() > 0) {
            DTClient[] dTClientArray = new DTClient[this.fClients.size()];
            this.fClients.toArray(dTClientArray);
            for (Object object : dTClientArray) {
                DTLocation dTLocation = ((DTOccupant)object).getLocation();
                if (dTLocation == null || !dTLocation.isDocked() || dTLocation.getFrame() != this.fMainFrame) continue;
                ((DTClient)object).close();
            }
        }
        this.fMainFrame.dispose();
        this.clearMainFrame();
        for (DTFrame dTFrame : this.fFrames) {
            if (dTFrame.isMainFrame()) continue;
            dTFrame.mainFrameDestroyed();
        }
        this.getWindowRegistry().removeDesktop(this);
        this.fIsClosing = false;
    }

    protected void setDefaultDesktop() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(3 * dimension.width >> 2, 3 * dimension.height / 4);
        this.fMainFrame.setBounds(dimension.width - dimension2.width >> 1, dimension.height - dimension2.height >> 1, dimension2.width, dimension2.height);
    }

    protected DTLocation getDefaultGroupDockLocation() {
        return DTLocation.clone(DEFAULT_GROUP_DOCK_LOCATION);
    }

    protected void clearLayout() {
        this.fIsClearingLayout = true;
        if (this.fMainFrame != null) {
            this.fMainFrame.beginClear();
        }
        for (DTClient dTClient : this.fClients) {
            if (!dTClient.isSingleton() || !dTClient.isShowing() || !this.fInitializingMain && dTClient.getGroup() != null) continue;
            this.setClientShowing(dTClient, false, null, false);
            if (dTClient.permitCloseUponLayout()) continue;
            dTClient.setShowPending();
        }
        if (this.fMainFrame != null) {
            this.fMainFrame.endClear();
        }
        this.fIsClearingLayout = false;
    }

    protected void saveLayout(OutputStream outputStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(LAYOUT_TAG);
            document.appendChild(element);
            Element element2 = document.createElement(VERSION_TAG);
            element2.setAttribute(MAJOR_ATTRIBUTE, Integer.toString(this.getMajorVersion()));
            element2.setAttribute(MINOR_ATTRIBUTE, Integer.toString(this.getMinorVersion()));
            element.appendChild(element2);
            this.saveLayout(document, element, bl, bl2, bl3, bl4);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, XML_ENCODING);
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)XML_ENCODING);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.logException((Exception)parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Log.logException((Exception)transformerConfigurationException);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    protected void saveLayout(OutputStream outputStream, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.saveLayout(outputStream, bl, bl2, bl3, !bl);
    }

    protected void saveLayout(Document document, Element element, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object2;
        if (this.fMainFrame != null) {
            object2 = DTMultipleClientFrame.stateToXML(this.fMainFrame.getRecoverableState(bl, bl4), document);
            element.appendChild((Node)object2);
        }
        for (DTFrame object3 : this.fFrames) {
            if (object3.isMainFrame()) continue;
            object3.saveState();
        }
        for (DTGroup dTGroup : this.fGroups) {
            element.appendChild(dTGroup.toXML(document, bl3));
        }
        if (bl3) {
            for (DTGroup dTGroup : this.fFormerGroups) {
                element.appendChild(dTGroup.toXML(document, bl3));
            }
        }
        this.fSelectionManager.normalizeSelectionOrder(this.fClients);
        object2 = new ArrayList<DTGroup>(this.fGroups);
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>(this.fClients);
        for (DTClient dTClient : this.fSingletons) {
            if (dTClient.isShowing() || bl3) {
                element.appendChild(dTClient.toXML(document, bl3));
            }
            arrayList.remove(dTClient);
        }
        if (bl3) {
            for (DTClient dTClient : this.fFormerClients) {
                element.appendChild(dTClient.toXML(document, bl3));
            }
        }
        if (bl2) {
            Iterator<DTClient> iterator;
            DTGroup dTGroup;
            DTClient dTClient;
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                dTClient = (DTClient)object.next();
                if ((!bl3 || dTClient.isAutoReopenEnabled()) && dTClient.canReopen()) continue;
                object.remove();
            }
            if (this.fMainFrame != null && this.fMainFrame.contains(this.fMainFrame.getSharedDocuments())) {
                object = this.fMainFrame.getSharedDocumentContainer();
                Iterator<DTGroup> iterator2 = ((DTDocumentContainer)object).getGroupIterator();
                while (iterator2.hasNext()) {
                    dTGroup = iterator2.next();
                    iterator = dTGroup.getClientIterator();
                    while (iterator.hasNext()) {
                        dTClient = iterator.next();
                        if (!arrayList.contains(dTClient)) continue;
                        element.appendChild(dTClient.toXML(document));
                        arrayList.remove(dTClient);
                    }
                    object2.remove(dTGroup);
                }
            }
            object = object2.iterator();
            while (object.hasNext()) {
                DTGroup dTGroup2;
                dTGroup = dTGroup2 = (DTGroup)object.next();
                iterator = dTGroup.getClientIterator();
                while (iterator.hasNext()) {
                    dTClient = iterator.next();
                    if (!arrayList.contains(dTClient)) continue;
                    element.appendChild(dTClient.toXML(document));
                    arrayList.remove(dTClient);
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                DTClient dTClient2;
                dTClient = dTClient2 = (DTClient)object.next();
                element.appendChild(dTClient.toXML(document));
            }
        }
    }

    protected boolean restoreLayout(InputStream inputStream) throws IOException {
        boolean bl;
        block19: {
            if (!this.hasMainFrame()) {
                return false;
            }
            this.fRestoringLayout = true;
            bl = true;
            try {
                SimpleNodeList simpleNodeList;
                Object object;
                DTClient[] dTClientArray = null;
                int n = 0;
                if (!this.isInitializingMain()) {
                    dTClientArray = new DTClient[this.fSingletons.size()];
                    for (DTClient object22 : this.fSingletons) {
                        if (!object22.isShowing()) continue;
                        dTClientArray[n++] = object22;
                    }
                    object = this.fGroups.iterator();
                    while (object.hasNext()) {
                        DTGroup dTGroup = (DTGroup)object.next();
                        if (!dTGroup.isShowing() || !this.isGroupDocked(dTGroup) || !this.isGroupMaximized(dTGroup)) continue;
                        this.setGroupMaximized(dTGroup, false);
                        break;
                    }
                    this.clearLayout();
                }
                if ((simpleNodeList = (object = this.parseLayout(inputStream)).getChildrenByTagName(VERSION_TAG)).getLength() < 1) {
                    throw new DataFormatException("Missing Version tag");
                }
                SimpleElement simpleElement = (SimpleElement)simpleNodeList.item(0);
                this.fMajorVersionBeingRestored = -1;
                String string = simpleElement.getAttribute(MAJOR_ATTRIBUTE);
                try {
                    this.fMajorVersionBeingRestored = Integer.parseInt(string);
                }
                catch (NumberFormatException dTClient) {
                    throw new DataFormatException("Invalid Major: " + string);
                }
                this.fMinorVersionBeingRestored = -1;
                string = simpleElement.getAttribute(MINOR_ATTRIBUTE);
                try {
                    this.fMinorVersionBeingRestored = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DataFormatException("Invalid Minor: " + string);
                }
                if (!this.canRestoreLayout(this.fMajorVersionBeingRestored, this.fMinorVersionBeingRestored)) {
                    throw new DataFormatException(this.getString("error.ObsoleteConfigFile"));
                }
                this.restoreLayout((SimpleElement)object);
                if (this.isInitializingMain()) break block19;
                for (int i = 0; i < n; ++i) {
                    if (dTClientArray[i].isShowing()) continue;
                    if (dTClientArray[i].isSelected()) {
                        dTClientArray[i].setSelected(false);
                    }
                    dTClientArray[i].close();
                }
                DTClient dTClient = this.fSelectionManager.getSelectedClient();
                if (dTClient != null && dTClient.getComponent() != null && !dTClient.getComponent().isShowing()) {
                    dTClient.setSelected(false);
                }
                if (this.fSelectionManager.getSelectedClient() != null) break block19;
                int n2 = this.fSingletons.size();
                for (int i = 0; i < n2; ++i) {
                    DTClient dTClient2 = (DTClient)this.fSingletons.get(i);
                    if (!dTClient2.isShowing() || !dTClient2.getComponent().isShowing()) continue;
                    dTClient2.setSelected(true);
                    break;
                }
            }
            catch (DataFormatException dataFormatException) {
                this.getErrorReportingStream().println(this.getString("error.ConfigFileFormat"));
                this.getErrorReportingStream().println(dataFormatException.getMessage());
                throw new IOException(dataFormatException.getMessage());
            }
            finally {
                this.fRestoringLayout = false;
            }
        }
        return bl;
    }

    protected SimpleElement parseLayout(InputStream inputStream) throws IOException {
        SimpleElement simpleElement;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, XML_ENCODING));
        SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
        try {
            simpleElement = simpleDOMParser.parse((Reader)bufferedReader);
        }
        catch (IOException iOException) {
            throw new IOException("Problem parsing Desktop restore xml: " + iOException.getMessage());
        }
        return simpleElement;
    }

    protected void restoreLayout(SimpleElement simpleElement) throws DataFormatException {
        int n;
        int n2;
        DTOccupant dTOccupant;
        int n22;
        SimpleElement simpleElement2;
        ArrayList<DTFrame> arrayList = new ArrayList<DTFrame>(this.fFrames);
        Object object2 = null;
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName("Frame");
        if (simpleNodeList.getLength() > 0 && (simpleElement2 = (SimpleElement)simpleNodeList.item(0)).getParentNode() == simpleElement) {
            object2 = DTMultipleClientFrame.stateFromXML(simpleElement2);
        }
        simpleElement2 = new ArrayList();
        ArrayList<DTOccupant> arrayList2 = new ArrayList<DTOccupant>();
        simpleNodeList = simpleElement.getChildrenByTagName("Group");
        int n3 = simpleNodeList.getLength();
        for (n22 = 0; n22 < n3; ++n22) {
            ItemListener itemListener;
            SimpleElement simpleElement3 = (SimpleElement)simpleNodeList.item(n22);
            dTOccupant = new DTGroup(this, simpleElement3);
            int n4 = this.fGroups.indexOf(dTOccupant);
            if (this.fInitializingMain && n4 == -1 && dTOccupant.isGuest()) {
                this.fFormerGroups.add((DTGroup)dTOccupant);
                continue;
            }
            n2 = 0;
            boolean bl = false;
            boolean bl2 = dTOccupant.isDockable() && ((DTGroup)dTOccupant).getContainingFrame() == this.fMainFrame && this.fMainFrame != null;
            boolean bl3 = ((DTGroup)dTOccupant).wasShowing();
            if (n4 == -1) {
                if (dTOccupant.isGuest() || this.fFormerGroups.contains(dTOccupant)) {
                    bl3 = false;
                } else {
                    this.addGroup((DTGroup)dTOccupant);
                }
            } else {
                itemListener = this.fGroups.get(n4);
                n2 = itemListener.getContainingFrame() == this.fMainFrame && this.fMainFrame != null ? 1 : 0;
                boolean bl4 = bl = itemListener.isShowing() || n2 != 0 && itemListener.wasShowing();
                if (this.useToolstrip()) {
                    bl3 = bl;
                }
                if (this.fInitializingMain || bl3 || bl) {
                    itemListener.updateFrom((DTGroup)dTOccupant);
                }
                dTOccupant = itemListener;
            }
            if (bl3) {
                if (n2 == 0 && bl && bl2) {
                    if (this.getDocumentContainment() == 2) {
                        ((DTGroup)dTOccupant).getContainingFrame().dispose();
                        ((DTGroup)dTOccupant).setContainingFrame(this.fMainFrame);
                        continue;
                    }
                    simpleElement2.add(dTOccupant);
                    continue;
                }
                if (n2 != 0 && bl && !bl2) {
                    if (this.getDocumentContainment() == 2) {
                        itemListener = this.createUndockedFrame((DTGroup)dTOccupant);
                        ((DTGroup)dTOccupant).setContainingFrame((DTFrame)((Object)itemListener));
                        continue;
                    }
                    arrayList2.add(dTOccupant);
                    continue;
                }
                if (bl || bl2 || this.fInitializingMain || this.getDocumentContainment() != 2) continue;
                itemListener = this.createUndockedFrame((DTGroup)dTOccupant);
                ((DTGroup)dTOccupant).setContainingFrame((DTFrame)((Object)itemListener));
                continue;
            }
            if (!bl || n2 != 0) continue;
            ((DTGroup)dTOccupant).saveFrameState(null);
            ((DTGroup)dTOccupant).clearSavedSingletonState();
        }
        simpleNodeList = simpleElement.getChildrenByTagName("Client");
        int dTGroup = simpleNodeList.getLength();
        for (n22 = 0; n22 < dTGroup; ++n22) {
            SimpleElement simpleElement4 = (SimpleElement)simpleNodeList.item(n22);
            dTOccupant = new DTClient(this, simpleElement4);
            DTClient dTClient = null;
            if (((DTClient)dTOccupant).isSingleton()) {
                dTClient = this.getDTClient(dTOccupant.getName(), ((DTClient)dTOccupant).getGroupName());
                if (dTClient == null) {
                    dTClient = this.findClientOfClass(((DTClient)dTOccupant).getComponentClassName(), ((DTClient)dTOccupant).getGroupName());
                }
            } else {
                n2 = this.fClients.indexOf(dTOccupant);
                if (n2 != -1) {
                    dTClient = this.fClients.get(n2);
                }
            }
            if (dTClient == null) {
                if (this.fInitializingMain && ((DTClient)dTOccupant).isSingleton() && dTOccupant.isGuest()) {
                    this.fFormerClients.add((DTClient)dTOccupant);
                    continue;
                }
                this.addClient((DTClient)dTOccupant, false, null, false);
                continue;
            }
            dTClient.updateFrom((DTClient)dTOccupant);
        }
        if (this.fMainFrame != null && object2 != null) {
            this.fMainFrame.restoreState(object2);
        }
        if (this.getDocumentContainment() == 1) {
            for (DTGroup dTGroup2 : simpleElement2) {
                this.setGroupDocked(dTGroup2, true);
            }
            for (DTGroup dTGroup3 : arrayList2) {
                this.setGroupDocked(dTGroup3, false);
            }
        }
        for (DTGroup dTGroup4 : this.fGroups) {
            DTFrame dTFrame = dTGroup4.getContainingFrame();
            if (dTFrame == null || dTFrame == this.fMainFrame) continue;
            ((DTMultipleClientFrame)dTFrame).restoreState(dTGroup4.savedFrameState());
        }
        for (DTGroup dTGroup5 : this.fGroups) {
            if (!dTGroup5.singletonsWereShowing() || dTGroup5.getLocation() == null) continue;
            dTGroup5.restoreSingletons();
        }
        int n5 = 0;
        int n6 = this.fClients.size();
        while (n5 < n) {
            DTClient dTClient = this.fClients.get(n5);
            if (!(!dTClient.showPending() && (dTClient.isSingleton() || dTClient.getComponent() != null) || dTClient.isSingleton() && dTClient.getGroup() != null)) {
                this.setClientShowing(dTClient, true, dTClient.getLastLocation(), false);
            }
            if (this.fClients.size() < n) {
                n = this.fClients.size();
                continue;
            }
            ++n5;
        }
        n5 = 0;
        for (DTFrame dTFrame : this.fFrames) {
            if (dTFrame instanceof DTMultipleClientFrame) {
                ((DTMultipleClientFrame)dTFrame).endRestore();
            }
            if (this.fInitializingMain || dTFrame.isVisible() || dTFrame instanceof DTSingleClientFrame && arrayList.contains(dTFrame) && (((DTSingleClientFrame)dTFrame).getClient() == null || !((DTSingleClientFrame)dTFrame).getClient().isSingleton())) continue;
            dTFrame.setVisible(true);
            n5 = 1;
        }
        if (n5 != 0 && this.fMainFrame != null) {
            this.fMainFrame.toFront();
        }
    }

    protected void addGroups(SimpleElement simpleElement) {
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName("Group");
        int n = simpleNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            try {
                DTGroup dTGroup = new DTGroup(this, simpleElement2);
                int n2 = this.fGroups.indexOf(dTGroup);
                if (n2 != -1) continue;
                this.addGroup(dTGroup);
                continue;
            }
            catch (DataFormatException dataFormatException) {
                Log.logException((Exception)dataFormatException);
            }
        }
    }

    protected void addSingletons(SimpleElement simpleElement) {
        SimpleNodeList simpleNodeList = simpleElement.getChildrenByTagName("Client");
        int n = simpleNodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            try {
                DTClient dTClient = new DTClient(this, simpleElement2);
                if (!dTClient.isSingleton()) continue;
                DTClient dTClient2 = this.getDTClient(dTClient.getName(), dTClient.getGroupName());
                if (dTClient2 == null) {
                    dTClient2 = this.findClientOfClass(dTClient.getComponentClassName(), dTClient.getGroupName());
                }
                if (dTClient2 != null) continue;
                this.addClient(dTClient, false, null, false);
                continue;
            }
            catch (DataFormatException dataFormatException) {
                Log.logException((Exception)dataFormatException);
            }
        }
    }

    protected boolean isRestoringLayout() {
        return this.fRestoringLayout || this.fUnopenedFrameCount > 0;
    }

    protected int getMajorVersionBeingRestored() {
        return this.fMajorVersionBeingRestored;
    }

    protected int getMinorVersionBeingRestored() {
        return this.fMinorVersionBeingRestored;
    }

    boolean isUndockingGroup() {
        return this.fUndockingGroup;
    }

    boolean isClearingLayout() {
        return this.fIsClearingLayout;
    }

    public boolean isAttemptingClose() {
        return this.fIsAttemptingClose;
    }

    public boolean isClosing() {
        return this.fIsClosing;
    }

    boolean isInitializingMain() {
        return this.fInitializingMain;
    }

    void setUndockingGroups(boolean bl) {
        this.fUndockingGroups = bl;
    }

    boolean groupSelectionEnabled() {
        return !this.fUndockingGroups || this.fMainFrame == null || this.fMainFrame.getSharedDocumentContainer() == null || this.fMainFrame.getSharedDocumentContainer().getGroupCount() == 1;
    }

    int updateUntitledClientCount() {
        return ++this.fUntitledClientCount;
    }

    protected PrintStream getErrorReportingStream() {
        return System.out;
    }

    public String getString(String string) {
        return this.getResourceBundle().getString(string);
    }

    public static String getString(Desktop desktop, String string) {
        return desktop != null ? desktop.getString(string) : ResourceBundle.getBundle(RESOURCE_PATH).getString(string);
    }

    static String getString(Component component, String string) {
        Desktop desktop = Desktop.getDesktop(component);
        return Desktop.getString(desktop, string);
    }

    static Desktop getDesktop(Component component) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return null;
        }
        Window window = SwingUtilities.windowForComponent(component);
        return window instanceof DTFrame ? ((DTFrame)((Object)window)).getDesktop() : null;
    }

    protected ResourceBundle getResourceBundle() {
        if (!this.fLocalizeUIElements && sEnglishResources == null && PlatformInfo.getVersion() >= 7) {
            try {
                Class<?> clazz = Class.forName("java.util.ResourceBundle");
                Class<?> clazz2 = Class.forName("java.util.ResourceBundle$Control");
                Method method = clazz2.getMethod("getNoFallbackControl", List.class);
                Object object = method.invoke(null, Collections.singletonList("java.properties"));
                Method method2 = clazz.getMethod("getBundle", String.class, Locale.class, clazz2);
                Object object2 = method2.invoke(null, RESOURCE_PATH, Locale.ENGLISH, object);
                sEnglishResources = (ResourceBundle)object2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fLocalizeUIElements || sEnglishResources == null) {
            return ResourceBundle.getBundle(RESOURCE_PATH);
        }
        return sEnglishResources;
    }

    public void setLocalizeUIElements(boolean bl) {
        this.fLocalizeUIElements = bl;
    }

    protected File getInitFile(boolean bl) {
        String string = this.fDTName.toLowerCase().lastIndexOf("desktop") == -1 ? this.fDTName + "Desktop" : this.fDTName;
        string = System.getProperty("file.separator") + string + ".xml";
        File file = new File(FileUtils.getPreferencesDirectory() + string);
        if (!bl && !file.exists()) {
            return null;
        }
        return file;
    }

    protected void startSplash() {
    }

    protected void stopSplash() {
    }

    protected DTClient findClientOfClass(String string) {
        int n = this.fClients.size();
        for (int i = 0; i < n; ++i) {
            DTClient dTClient = this.fClients.get(i);
            if (!string.equals(dTClient.getComponentClassName())) continue;
            return dTClient;
        }
        return null;
    }

    protected DTClient findClientOfClass(String string, String string2) {
        int n = this.fClients.size();
        for (int i = 0; i < n; ++i) {
            DTClient dTClient = this.fClients.get(i);
            if (!string.equals(dTClient.getComponentClassName()) || string2 != dTClient.getGroupName() && (string2 == null || !string2.equals(dTClient.getGroupName()))) continue;
            return dTClient;
        }
        return null;
    }

    protected DTClient getDTClient(String string) {
        return this.getDTClient(string, ANY_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DTClient getDTClient(String string, String string2) {
        Vector<DTClient> vector = this.fClients;
        synchronized (vector) {
            for (DTClient dTClient : this.fClients) {
                if (!this.clientMatches(dTClient, string, string2)) continue;
                return dTClient;
            }
        }
        return null;
    }

    protected DTClient getDTClient(Component component) {
        return this.fComponentToClientMap.get(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DTClient getFormerClient(String string, String string2) {
        Set<DTClient> set = this.fFormerClients;
        synchronized (set) {
            for (DTClient dTClient : this.fFormerClients) {
                if (!this.clientMatches(dTClient, string, string2)) continue;
                return dTClient;
            }
        }
        return null;
    }

    protected DTClient getSingleton(String string) {
        return this.getSingleton(string, ANY_GROUP);
    }

    protected DTClient getSingleton(String string, String string2) {
        for (DTClient dTClient : this.fSingletons) {
            if (!this.clientMatches(dTClient, string, string2)) continue;
            return dTClient;
        }
        return null;
    }

    private boolean clientMatches(DTClient dTClient, String string, String string2) {
        if (string2 != ANY_GROUP && dTClient.getGroup() != this.getGroup(string2)) {
            return false;
        }
        String string3 = dTClient.getName();
        String string4 = dTClient.getTitle();
        String string5 = dTClient.getShortTitle();
        return string3 != null && (string3 == string || string3.equals(string)) || string4 != null && string4.equals(string) || string5 != string4 && string5.equals(string);
    }

    protected Component createClientComponent(DTClient dTClient) {
        return dTClient.createComponent();
    }

    Component createClientComponentWrapper(DTClient dTClient) {
        this.fClientBeingCreated = dTClient;
        Component component = this.createClientComponent(dTClient);
        this.fClientBeingCreated = null;
        return component;
    }

    void registerClientComponent(DTClient dTClient) {
        this.registerClientComponent(dTClient, dTClient.getComponent());
    }

    private void registerClientComponent(DTClient dTClient, Component component) {
        if (component != null) {
            this.fComponentToClientMap.put(component, dTClient);
            if (component instanceof DTClientBase) {
                ((DTClientBase)((Object)component)).setParentDesktop(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DTGroup getGroup(String string) {
        Vector<DTGroup> vector = this.fGroups;
        synchronized (vector) {
            for (DTGroup dTGroup : this.fGroups) {
                String string2 = dTGroup.getName();
                if (string2 != null && string2.equals(string)) {
                    return dTGroup;
                }
                String string3 = dTGroup.getTitle();
                if (string3 == null || !string3.equals(string)) continue;
                return dTGroup;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DTGroup getFormerGroup(String string) {
        Set<DTGroup> set = this.fFormerGroups;
        synchronized (set) {
            if (string == null) {
                return null;
            }
            for (DTGroup dTGroup : this.fFormerGroups) {
                if (!string.equals(dTGroup.getTitle()) && !string.equals(dTGroup.getName())) continue;
                return dTGroup;
            }
        }
        return null;
    }

    protected DTMultipleClientFrame createMainFrame() {
        return new DTMultipleClientFrame(this, this.fDTName, null, null, true);
    }

    protected DTMultipleClientFrame createUndockedFrame(DTGroup dTGroup) {
        return new DTMultipleClientFrame(this, dTGroup.getTitle(), dTGroup.getIcon(), dTGroup, false);
    }

    protected DTSingleClientFrame createUndockedFrame(DTClient dTClient) {
        Component component = dTClient.getComponent();
        if (component instanceof DTClientBase) {
            return ((DTClientBase)((Object)component)).createFrame(this, dTClient.getTitle());
        }
        return new DTSingleClientFrame(this, dTClient.getTitle());
    }

    protected DTOnTopWindow createOnTopWindow(DTClient dTClient, DTLocation dTLocation) {
        DTGroup dTGroup = dTClient.getGroup();
        return new DTOnTopWindow(this, dTGroup == null ? this.fMainFrame : dTGroup.getContainingFrame(), dTClient, dTLocation);
    }

    protected DTMenuBar createMenuBar(DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
        return new DTMenuBar(this, dTFrame, dTClient, dTGroup);
    }

    @Deprecated
    protected DTToolBar createToolBar(DTFrame dTFrame) {
        return new DTToolBar(this, dTFrame);
    }

    protected DTMainToolBarSupplier createMainToolBarSupplier() {
        return null;
    }

    public boolean useToolstrip() {
        return false;
    }

    public TSRegistry getToolstripRegistry() {
        if (this.fToolstripRegistry == null) {
            this.fToolstripRegistry = new TSRegistry();
            for (ToolstripInfoRegistrar toolstripInfoRegistrar : this.getToolstripRegistrars()) {
                toolstripInfoRegistrar.registerToolstripInfo(this.fToolstripRegistry);
            }
            this.fToolstripRegistry.addToolSetContents(this.getDefaultViewTabFactory().getToolSetContents());
            for (DTGroup dTGroup : this.fGroups) {
                this.fToolstripRegistry.addTabContext(dTGroup.getName(), dTGroup.getShortTitle());
            }
        }
        return this.fToolstripRegistry;
    }

    protected ToolstripInfoRegistrar[] getToolstripRegistrars() {
        return new ToolstripInfoRegistrar[0];
    }

    protected QuickAccessToolBar createQuickAccessBar(DTFrame dTFrame) {
        return new QuickAccessToolBar(dTFrame.getToolstrip(), this.getToolstripRegistry(), this.getQuickAccessConfiguration());
    }

    public QuickAccessConfiguration getQuickAccessConfiguration() {
        if (this.fQuickAccessConfiguration == null) {
            File file = this.getQuickAccessFile();
            if (file.exists()) {
                this.fQuickAccessConfiguration = this.readQuickAccessConfiguration(file);
            }
            if (this.fQuickAccessConfiguration == null) {
                this.fQuickAccessConfiguration = this.getDefaultQuickAccessConfiguration();
            }
            if (this.fQuickAccessConfiguration != null) {
                this.fQuickAccessConfiguration.addListener(new QuickAccessConfiguration.ChangeListener(){

                    public void configurationChanged(QuickAccessConfiguration.ChangeEvent changeEvent) {
                        Desktop.this.writeQuickAccessConfiguration(Desktop.this.fQuickAccessConfiguration, Desktop.this.getQuickAccessFile());
                    }
                });
            }
        }
        return this.fQuickAccessConfiguration;
    }

    public void saveQuickAccessConfiguration(String string) {
        this.saveQuickAccessConfiguration(new File(FileUtils.getPreferencesDirectory(), string + "QuickAccess.xml"));
    }

    public void saveQuickAccessConfiguration(final File file) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.saveQuickAccessConfiguration(file);
                }
            });
            return;
        }
        this.writeQuickAccessConfiguration(this.fQuickAccessConfiguration, file);
    }

    public void loadQuickAccessConfiguration(String string) {
        this.loadQuickAccessConfiguration(new File(FileUtils.getPreferencesDirectory(), string + "QuickAccess.xml"));
    }

    public void loadQuickAccessConfiguration(final File file) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.loadQuickAccessConfiguration(file);
                }
            });
            return;
        }
        QuickAccessConfiguration quickAccessConfiguration = this.readQuickAccessConfiguration(file);
        if (quickAccessConfiguration != null) {
            this.fQuickAccessConfiguration.updateFrom(quickAccessConfiguration);
        }
    }

    protected File getQuickAccessFile() {
        return new File(FileUtils.getPreferencesDirectory(), this.fDTName + "QuickAccess.xml");
    }

    protected QuickAccessConfiguration readQuickAccessConfiguration(File file) {
        try {
            return this.readQuickAccessConfiguration(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected QuickAccessConfiguration readQuickAccessConfiguration(URL uRL) {
        try {
            return new QuickAccessConfiguration(SimpleDOMUtils.read((URL)uRL));
        }
        catch (IOException iOException) {
            this.getErrorReportingStream().println(MessageFormat.format(this.getString("error.ReadingQuickAccess"), uRL.getPath()));
            return null;
        }
        catch (DataFormatException dataFormatException) {
            this.getErrorReportingStream().println(MessageFormat.format(this.getString("error.QuickAccessFormat"), uRL.getPath()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeQuickAccessConfiguration(QuickAccessConfiguration quickAccessConfiguration, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = quickAccessConfiguration.toXML(document);
            document.appendChild(element);
            fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, XML_ENCODING);
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)XML_ENCODING);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.logException((Exception)parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Log.logException((Exception)transformerConfigurationException);
        }
        catch (Exception exception) {
            this.getErrorReportingStream().println(MessageFormat.format(this.getString("error.QuickAccessSave"), file.getPath()));
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public QuickAccessConfiguration getDefaultQuickAccessConfiguration() {
        return new QuickAccessConfiguration();
    }

    protected Predicate<TSToolPath> getQuickAccessConfigurationFilter(DTFrame dTFrame) {
        return null;
    }

    public boolean condenseTitleActions() {
        return this.useToolstrip();
    }

    public boolean closeEmptyGroups() {
        return this.useToolstrip();
    }

    public boolean undockSingletonsOnTop() {
        return false;
    }

    public boolean supplyDefaultViewTabs() {
        return false;
    }

    protected DTToolstripFactory createToolstripFactory() {
        return new DTToolstripFactory(this);
    }

    protected final DTToolstripFactory getToolstripFactory() {
        if (this.fToolstripFactory == null) {
            this.getToolstripRegistry();
            this.fToolstripFactory = this.createToolstripFactory();
        }
        return this.fToolstripFactory;
    }

    protected DTMnemonicsProvider createMnemonicsProvider(DTFrame dTFrame) {
        return new DTMnemonicsProvider(dTFrame);
    }

    protected MacScreenMenuProxy createMacScreenMenuProxy(DTFrame dTFrame) {
        return new MacScreenMenuProxy(dTFrame);
    }

    public void showToolBarCustomizationPanel(final String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.showToolBarCustomizationPanel(string);
                }
            });
            return;
        }
        DTToolBarCustomizationPanel dTToolBarCustomizationPanel = new DTToolBarCustomizationPanel(this.fToolBarRegistry, this);
        dTToolBarCustomizationPanel.selectToolBar(string);
        int n = MJOptionPane.showOptionDialog((Component)((Object)this.fMainFrame), (Object)((Object)dTToolBarCustomizationPanel), (String)"Customize Toolbar", (int)2, (int)-1, null, null, null);
        if (n == 0) {
            dTToolBarCustomizationPanel.applyModifications();
        } else {
            dTToolBarCustomizationPanel.discardModifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DTGroup addGroup(String string) {
        DTGroup dTGroup;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Empty group titles are not permitted");
        }
        Vector<DTGroup> vector = this.fGroups;
        synchronized (vector) {
            dTGroup = this.getGroup(string);
            if (dTGroup == null) {
                dTGroup = new DTGroup(this, string, (DTFrame)this.fMainFrame);
                this.addGroup(dTGroup);
            }
        }
        return dTGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addGroup(DTGroup dTGroup) {
        DTGroup dTGroup2 = this.getFormerGroup(dTGroup.getName());
        if (dTGroup2 != null) {
            dTGroup.updateFrom(dTGroup2);
            Set<DTGroup> set = this.fFormerGroups;
            synchronized (set) {
                this.fFormerGroups.remove(dTGroup2);
            }
        }
        this.fGroups.add(dTGroup);
        this.fDeferredFacade.addGroupAndNotify(dTGroup);
        if (dTGroup2 != null) {
            this.addFormerGroupSingletons(dTGroup);
        }
        if (this.fToolstripRegistry != null) {
            this.fToolstripRegistry.addTabContext(dTGroup.getName(), dTGroup.getShortTitle());
        }
    }

    private void addFormerGroupSingletons(DTGroup dTGroup) {
        Iterator<DTClient> iterator = this.fFormerClients.iterator();
        while (iterator.hasNext()) {
            DTClient dTClient = iterator.next();
            if (!dTGroup.getName().equals(dTClient.getGroupName()) || this.getClient(dTClient.getName(), dTGroup.getName()) != null) continue;
            iterator.remove();
            this.addClient(dTClient, false, null, false);
        }
    }

    @DeferredFacadeMethod
    protected void addGroupAndNotify(DTGroup dTGroup) {
        this.fNotifyingGroups.add(dTGroup);
        this.fLayoutSaveManager.addGroup(dTGroup);
        if (this.useToolstrip()) {
            this.fActionManager.addAction((Action)dTGroup.getSelectAction());
        }
    }

    @DeferredFacadeMethod
    protected void addClient(DTClient dTClient, boolean bl, DTLocation dTLocation, boolean bl2) {
        this.addClient(dTClient, bl, dTLocation, bl2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClient(DTClient dTClient, boolean bl, DTLocation dTLocation, boolean bl2, int n) {
        if (!this.fClients.contains(dTClient)) {
            this.fClients.add(dTClient);
            this.registerClientComponent(dTClient);
        }
        this.fSelectionManager.add(dTClient);
        this.fLayoutSaveManager.addClient(dTClient);
        String string = dTClient.getGroupName();
        if (string != null || !dTClient.isSingleton() || dTLocation != null && dTLocation.isInDocumentContainer()) {
            DTGroup dTGroup = this.getGroup(string);
            if (dTGroup == null) {
                if (dTClient.getGroupPropertyProvider() != null) {
                    this.addGroup(dTClient.getGroupPropertyProvider());
                } else {
                    this.addGroup(string);
                }
                dTGroup = this.getGroup(string);
            }
            dTGroup.add(dTClient);
        }
        if (dTClient.isSingleton()) {
            if (this.useToolstrip()) {
                this.fActionManager.addAction((Action)dTClient.getSelectAction());
            }
            if (dTClient.getGroup() != null) {
                dTClient.setSingletonIndex(this.fSingletons.size());
                this.fSingletons.add(dTClient);
            } else {
                int n2 = n;
                if (n < 0 || n > this.fSingletons.size()) {
                    for (n2 = this.fSingletons.size(); n2 > 0 && ((DTClient)this.fSingletons.get(n2 - 1)).getGroup() != null; --n2) {
                    }
                }
                dTClient.setSingletonIndex(n2);
                this.fSingletons.add(n2, dTClient);
                while (n2 < this.fSingletons.size()) {
                    ((DTClient)this.fSingletons.get(n2)).setSingletonIndex(n2);
                    ++n2;
                }
            }
        }
        List<ClientListenerData> list = this.fPendingClientListeners;
        synchronized (list) {
            Iterator<ClientListenerData> iterator = this.fPendingClientListeners.iterator();
            while (iterator.hasNext()) {
                ClientListenerData clientListenerData = iterator.next();
                if (clientListenerData.fTargetComponent == null && clientListenerData.fTargetTitle == null) {
                    dTClient.addClientListener(clientListenerData.fListener);
                    continue;
                }
                if (clientListenerData.fTargetTitle != null && clientListenerData.fTargetTitle.equals(string)) {
                    dTClient.addClientListener(clientListenerData.fListener);
                    continue;
                }
                if ((clientListenerData.fTargetTitle == null || !clientListenerData.fTargetTitle.equals(dTClient.getTitle())) && (clientListenerData.fTargetComponent == null || clientListenerData.fTargetComponent != dTClient.getComponent())) continue;
                iterator.remove();
                dTClient.addClientListener(clientListenerData.fListener);
            }
        }
        if (bl) {
            this.setClientShowing(dTClient, true, dTLocation, bl2);
        } else if (dTLocation != null) {
            dTClient.setLastLocation(dTLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeferredFacadeMethod
    protected void removeClient(DTClient dTClient) {
        DTGroup dTGroup;
        this.fSelectionManager.remove(dTClient);
        this.fLayoutSaveManager.removeClient(dTClient);
        if (dTClient.getLocation() != null) {
            this.setClientShowing(dTClient, false, null, false);
        }
        this.fClients.remove(dTClient);
        Component component = dTClient.getComponent();
        if (component != null) {
            this.fComponentToClientMap.remove(component);
            if (component instanceof DTClientBase) {
                ((DTClientBase)((Object)component)).setParentDesktop(null);
            }
        }
        if (dTClient.isSingleton()) {
            if (this.useToolstrip()) {
                this.fActionManager.removeAction((Action)dTClient.getSelectAction());
            }
            this.fSingletons.remove(dTClient);
            for (int i = this.fSingletons.indexOf(dTClient); i < this.fSingletons.size(); ++i) {
                ((DTClient)this.fSingletons.get(i)).setSingletonIndex(i);
            }
            if (dTClient.isGuest() && !dTClient.isSessionGuest()) {
                Set<DTClient> set = this.fFormerClients;
                synchronized (set) {
                    this.fFormerClients.add(dTClient);
                }
            }
        }
        if ((dTGroup = dTClient.getGroup()) != null) {
            dTGroup.remove(dTClient);
        }
        dTClient.flush();
    }

    protected void showClient(DTClient dTClient, DTLocation dTLocation, boolean bl) {
        this.fDeferredFacade.setClientShowing(dTClient, true, dTLocation, bl);
    }

    protected void showClient(DTClient dTClient, DTLocation dTLocation, boolean bl, boolean bl2) {
        this.fDeferredFacade.setClientShowing(dTClient, true, dTLocation, bl, bl2);
    }

    @DeferredFacadeMethod
    protected void hideClient(DTClient dTClient) {
        this.setClientShowing(dTClient, false, null, false);
        dTClient.setSelected(false);
    }

    @DeferredFacadeMethod
    protected void setClientShowing(DTClient dTClient, boolean bl, DTLocation dTLocation, boolean bl2) {
        this.setClientShowing(dTClient, bl, dTLocation, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DeferredFacadeMethod
    protected void setClientShowing(DTClient dTClient, boolean bl, DTLocation dTLocation, boolean bl2, boolean bl3) {
        if (bl) {
            List<DTClient> list;
            Object object;
            Object object2;
            Serializable serializable;
            if (!this.hasMainFrame() && this.mustHaveMainFrame()) {
                return;
            }
            if (dTClient.getComponent() == null) {
                serializable = this.createClientComponentWrapper(dTClient);
                if (serializable == null) {
                    this.removeClient(dTClient);
                } else if (dTClient.getComponent() != serializable) {
                    dTClient.setComponent((Component)serializable);
                    this.registerClientComponent(dTClient);
                    if (dTClient.getGroup() != null && dTClient.getGroupPropertyProvider() != null) {
                        dTClient.getGroup().setPropertyProvider(dTClient.getGroupPropertyProvider());
                    }
                    object2 = this.fPendingClientListeners;
                    synchronized (object2) {
                        object = this.fPendingClientListeners.iterator();
                        while (object.hasNext()) {
                            ClientListenerData clientListenerData = (ClientListenerData)object.next();
                            if ((clientListenerData.fTargetTitle == null || !clientListenerData.fTargetTitle.equals(dTClient.getTitle())) && (clientListenerData.fTargetComponent == null || clientListenerData.fTargetComponent != dTClient.getComponent())) continue;
                            object.remove();
                            dTClient.addClientListener(clientListenerData.fListener);
                        }
                    }
                }
            }
            if (dTClient.getComponent() == null) {
                return;
            }
            if (dTClient.getLocation() != null && !dTClient.isHidden()) {
                if (bl2) {
                    dTClient.setSelected(true, false);
                    if (!this.fRestoringLayout) {
                        if (dTClient.getLocation().isMinimized()) {
                            dTClient.requestFocusLater();
                        } else if (dTClient.getLocation().isAnchored()) {
                            SwingUtilities.windowForComponent((Component)((Object)dTClient.getInternalFrame())).setVisible(true);
                        } else {
                            dTClient.requestFocus();
                        }
                    }
                }
                return;
            }
            if (!dTClient.isDockable() && (dTLocation == null || dTLocation.isDocked())) {
                dTLocation = new DTFloatingLocation(true);
            }
            serializable = null;
            object2 = null;
            object = dTClient.getGroup();
            if (object != null) {
                boolean bl4;
                if (dTLocation == null && (dTLocation = dTClient.getLastLocation()) != null && dTLocation.isDocked() && dTLocation.isMaximized()) {
                    dTLocation = dTClient.getLastNestedLocation();
                }
                boolean bl5 = bl4 = dTLocation != null ? dTLocation.isDocked() : this.shouldDock(dTClient);
                if (bl4) {
                    serializable = ((DTGroup)object).getContainingFrame();
                    if (serializable == null) {
                        serializable = this.createUndockedFrame((DTGroup)object);
                        ((DTGroup)object).setContainingFrame((DTFrame)serializable);
                        if (dTClient.getLocation() != null) {
                            return;
                        }
                    }
                } else {
                    if (dTLocation == null) {
                        list = ((DTGroup)object).getUndockedDocuments();
                        if (list.size() > 0) {
                            for (DTClient dTClient2 : list) {
                                dTLocation = dTClient2.getLocation();
                                if (!dTClient2.isSelected()) continue;
                                break;
                            }
                        } else {
                            dTLocation = ((DTGroup)object).getLastDocumentLocation();
                            if (dTLocation != null && dTLocation.isDocked()) {
                                dTLocation = null;
                            }
                        }
                        if (dTLocation != null && (dTLocation = DTLocation.clone(dTLocation)).isMinimized()) {
                            ((DTFloatingLocation)dTLocation).setMinimized(false);
                        }
                        if (((DTGroup)object).getDocumentCount() > 0 && dTLocation instanceof DTFloatingLocation) {
                            dTLocation.setFrameLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
                        }
                    }
                    if (dTClient.isSingleton()) {
                        if (((DTOccupant)object).getLocation() == null) {
                            this.setGroupShowing((DTGroup)object, true, null, false);
                        }
                        if (dTClient.getLocation() != null) {
                            return;
                        }
                    }
                    if (dTClient.isSingleton() && dTClient.onTopWhenUndocked() && ((DTGroup)object).getContainingFrame() != null) {
                        object2 = this.createOnTopWindow(dTClient, dTLocation);
                    } else {
                        serializable = this.createUndockedFrame(dTClient);
                    }
                }
            } else {
                if (dTLocation == null && (dTLocation = dTClient.getLastLocation()) != null && dTLocation.isDocked() && dTLocation.isMaximized()) {
                    dTLocation = dTClient.getLastNestedLocation();
                }
                if (dTLocation != null && dTLocation == dTClient.getLastUndockedLocation() && dTLocation.isMinimized() && !this.fRestoringLayout) {
                    ((DTFloatingLocation)dTLocation).setMinimized(false);
                }
                if (!(this.fMainFrame == null || dTLocation != null && !dTLocation.isDocked() || dTLocation == null && dTClient.isDockableTearOff())) {
                    serializable = this.fMainFrame;
                    if (dTLocation == null) {
                        dTLocation = dTClient.getLastDockedLocation();
                    }
                } else if (dTClient.isSingleton() && dTClient.onTopWhenUndocked() && this.fMainFrame != null) {
                    object2 = this.createOnTopWindow(dTClient, dTLocation);
                } else {
                    serializable = this.createUndockedFrame(dTClient);
                }
            }
            if (object2 != null) {
                if (bl2 && !dTClient.getLocation().isAnchored()) {
                    dTClient.setSelected(true, !this.fRestoringLayout);
                    if (!this.fRestoringLayout) {
                        dTClient.requestFocus();
                    }
                }
                ((Window)object2).setVisible(bl2 || !dTClient.getLocation().isAnchored());
                return;
            }
            if (serializable == null) {
                return;
            }
            if (!(this.fRestoringLayout || serializable == this.fMainFrame || serializable.isVisible() || bl2 || dTClient.isSelected() || dTClient.getLastLocation() != null && dTClient.getLastLocation().isDocked())) {
                serializable.setFocusableWindowState(false);
                DTFrame dTFrame = null;
                int n = this.fFrames.size();
                for (int i = 0; i < n && dTFrame == null; ++i) {
                    dTFrame = this.fFrames.get(i);
                    if (dTFrame.isActive()) continue;
                    dTFrame = null;
                }
                list = dTFrame;
                serializable.addWindowListener(new WindowAdapter((DTFrame)((Object)list)){
                    final /* synthetic */ DTFrame val$frameToReactivate;
                    {
                        this.val$frameToReactivate = dTFrame;
                    }

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        if (this.val$frameToReactivate != null) {
                            this.val$frameToReactivate.toFront();
                        }
                        windowEvent.getWindow().setFocusableWindowState(true);
                        windowEvent.getWindow().removeWindowListener(this);
                    }
                });
            }
            if (bl3) {
                ((DTFrame)serializable).addClientHidden(dTClient, dTLocation);
            } else {
                ((DTFrame)serializable).addClient(dTClient, dTLocation);
            }
            if (bl2 && !bl3) {
                boolean bl6;
                boolean bl7 = object != null && this.isGroupMinimized((DTGroup)object) && dTClient.getLocation() != null && dTClient.getLocation().isDocked();
                boolean bl8 = bl6 = !this.fRestoringLayout && (bl7 || SwingUtilities.getAncestorOfClass(DTTabbedPane.class, dTClient.getComponent()) != null);
                if (((DTFrame)serializable).isParticipantInDesktopSelection()) {
                    dTClient.setSelected(true, bl6);
                }
                if (!this.fRestoringLayout) {
                    dTClient.requestFocus();
                }
            }
            if (!(bl3 || this.fRestoringLayout || serializable.isVisible() || object != null && serializable == ((DTGroup)object).getContainingFrame() && (((DTGroup)object).isOpening() || ((DTGroup)object).isRestoringSingletons()))) {
                ((DTFrame)serializable).setVisible(true);
                if (!serializable.isVisible() && !dTClient.isSingleton()) {
                    this.getWindowRegistry().setVisible(dTClient, false);
                }
            }
        } else if (dTClient.getLocation() != null) {
            Window window = null;
            if (!dTClient.getLocation().isDocked()) {
                window = SwingUtilities.windowForComponent((Component)((Object)dTClient.getInternalFrame()));
            }
            if (window instanceof DTOnTopWindow) {
                window.dispose();
            } else {
                DTFrame dTFrame = dTClient.getLocation().getFrame();
                if (dTFrame != null) {
                    dTFrame.removeClient(dTClient);
                }
            }
        }
    }

    protected boolean shouldDock(DTClient dTClient) {
        if (dTClient.getLastLocation() != null) {
            return dTClient.getLastLocation().isDocked();
        }
        DTGroup dTGroup = dTClient.getGroup();
        if (dTGroup == null || dTClient.isSingleton()) {
            return true;
        }
        return this.shouldDockInGroup(dTGroup);
    }

    private boolean shouldDockInGroup(DTGroup dTGroup) {
        DTClient dTClient = this.fSelectionManager.getMostRecentlySelected();
        if (dTClient != null && dTClient.getGroup() == dTGroup && dTClient.getLocation() != null) {
            return dTClient.getLocation().isDocked();
        }
        return this.getDocumentContainment() == 2 && dTGroup.getLocation() != null || this.getDocumentContainment() == 1 && dTGroup.hasDockedDocuments() || dTGroup.getDocumentCount() == 1 && (dTGroup.getLastDocumentLocation() == null || dTGroup.getLastDocumentLocation().isDocked());
    }

    protected void showClientWithoutActivatingFrame(DTClient dTClient) {
        DTFrame dTFrame;
        if (!dTClient.isShowing()) {
            this.setClientShowing(dTClient, true, null, false);
        }
        if ((dTFrame = dTClient.getLocation().getFrame()) instanceof DTMultipleClientFrame && !dTFrame.isActive()) {
            dTClient.prepareToShow();
            ((DTMultipleClientFrame)dTFrame).mergeClient(dTClient);
        } else {
            dTClient.setSelected(true, false);
            dTClient.requestFocus();
        }
    }

    @DeferredFacadeMethod
    void setClientLocation(DTClient dTClient, DTLocation dTLocation) {
        DTLocation dTLocation2 = dTClient.getLocation();
        if (dTLocation == null) {
            return;
        }
        if (dTLocation2 == null) {
            dTClient.setLastLocation(dTLocation);
        } else if (!dTLocation2.isDocked() && !dTLocation.isDocked()) {
            DTFrame dTFrame = dTLocation2.getFrame();
            dTFrame.setBounds(dTLocation.getFrameBounds());
        } else if (dTLocation2.isDocked() && dTLocation2 instanceof DTFloatingLocation && dTLocation.isDocked() && dTLocation instanceof DTFloatingLocation) {
            DTFloatingPane dTFloatingPane = (DTFloatingPane)((Object)SwingUtilities.getAncestorOfClass(DTFloatingPane.class, (Component)((Object)dTClient.getInternalFrame())));
            if (dTFloatingPane != null) {
                DTFloatingLocation dTFloatingLocation;
                if (!(!dTLocation.isMinimized() && !dTLocation.isMaximized() || (dTFloatingLocation = (DTFloatingLocation)dTLocation).isLocationInitialized() || dTFloatingLocation.hasNormalizedLocation() || dTFloatingLocation.isSizeInitialized() || dTFloatingLocation.hasNormalizedSize())) {
                    dTFloatingLocation = (DTFloatingLocation)DTLocation.clone(dTLocation2);
                    dTFloatingLocation.setMinimized(dTLocation.isMinimized());
                    dTFloatingLocation.setMaximized(dTLocation.isMaximized());
                    dTLocation = dTFloatingLocation;
                }
                dTFloatingPane.setLocation(dTClient, dTLocation);
                dTFloatingPane.revalidate();
                dTFloatingPane.repaint();
            }
        } else {
            if (dTLocation2.isDocked() && !dTLocation.isDocked()) {
                dTClient.fireClientEvent(new DTClientEvent(dTClient.getComponent(), 6));
                if (!this.fClients.contains(dTClient)) {
                    return;
                }
                dTLocation2 = dTClient.getLocation();
                if (dTLocation2 != null && !dTLocation2.isDocked()) {
                    Rectangle rectangle = dTLocation2.getFrameBounds();
                    Rectangle rectangle2 = dTLocation.getFrameBounds();
                    if (rectangle.x != rectangle2.x || rectangle.y != rectangle2.y || rectangle.width != rectangle2.width || rectangle.height != rectangle2.height) {
                        DTFrame dTFrame = dTLocation2.getFrame();
                        dTFrame.setBounds(rectangle2);
                    }
                    return;
                }
            }
            this.setClientShowing(dTClient, false, null, false);
            this.setClientShowing(dTClient, true, dTLocation, false);
        }
    }

    @DeferredFacadeMethod
    void setGroupShowing(DTGroup dTGroup, boolean bl, DTLocation dTLocation, boolean bl2) {
        DTMultipleClientFrame dTMultipleClientFrame;
        if (bl) {
            if (!this.hasMainFrame() && this.mustHaveMainFrame()) {
                return;
            }
            if (dTGroup.getLocation() != null) {
                if (bl2) {
                    dTGroup.setSelected(true);
                }
            } else if (dTGroup.isDockable() && (dTLocation != null && dTLocation.isDocked() || dTLocation == null && this.fMainFrame != null && dTGroup.getContainingFrame() == this.fMainFrame)) {
                if (dTLocation == null && (dTLocation = dTGroup.getLastDockedLocation()) != null && dTLocation.isMaximized()) {
                    dTLocation = dTGroup.getLastNestedLocation();
                }
                this.fMainFrame.addGroup(dTGroup, dTLocation);
                if (bl2) {
                    dTGroup.setSelected(true);
                }
            } else {
                DTMultipleClientFrame dTMultipleClientFrame2 = this.createUndockedFrame(dTGroup);
                dTGroup.setContainingFrame(dTMultipleClientFrame2);
                if (dTLocation != null) {
                    dTMultipleClientFrame2.setBounds(dTLocation.getFrameBounds());
                }
                dTMultipleClientFrame2.setVisible(true);
            }
        } else if (dTGroup.isShowing() && (dTMultipleClientFrame = (DTMultipleClientFrame)dTGroup.getContainingFrame()) != null) {
            if (dTGroup.isClosing()) {
                dTGroup.closeSingletons();
            }
            if (dTMultipleClientFrame != this.fMainFrame) {
                dTMultipleClientFrame.dispose();
                dTGroup.setContainingFrame(null);
            } else if (dTGroup.hasDocumentContainer()) {
                dTMultipleClientFrame.removeGroup(dTGroup);
            }
            dTGroup.setLocation(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeferredFacadeMethod
    void setGroupDocked(DTGroup dTGroup, boolean bl) {
        Object object;
        if (this.fMainFrame == null || bl && !dTGroup.isDockable()) {
            return;
        }
        DTLocation dTLocation = dTGroup.getLocation();
        DTMultipleClientFrame dTMultipleClientFrame = (DTMultipleClientFrame)(dTLocation == null ? dTGroup.getContainingFrame() : dTLocation.getFrame());
        if (bl) {
            if (dTLocation == null || dTLocation.isDocked()) {
                dTGroup.setContainingFrame(this.fMainFrame);
                return;
            }
            if (!dTGroup.isDockable()) {
                return;
            }
        } else {
            if (dTLocation == null) {
                dTGroup.setContainingFrame(null);
                return;
            }
            if (!dTLocation.isDocked()) {
                return;
            }
        }
        if (!bl) {
            this.fUndockingGroup = true;
        }
        dTGroup.fireGroupEvent(new DTGroupEvent(dTGroup.getTitle(), bl ? 4 : 6));
        DTClient dTClient = this.fSelectionManager.getSelectedClient();
        if (dTClient != null && dTClient.getGroup() == dTGroup && dTClient.getLocation() != null && dTClient.getLocation().getFrame() == dTMultipleClientFrame) {
            dTClient.saveFocus();
            dTClient.setSelected(false);
        } else {
            dTClient = null;
        }
        DTNotifyingList<DTClient> dTNotifyingList = dTGroup.getSingletons();
        ArrayList<DTClient> arrayList = dTNotifyingList.size() > 0 ? new ArrayList<DTClient>() : null;
        for (DTClient itemListener : dTNotifyingList) {
            if (itemListener.getLocation() == null || itemListener.getLocation().isDocked() || !(SwingUtilities.windowForComponent((Component)((Object)itemListener.getInternalFrame())) instanceof DTOnTopWindow)) continue;
            arrayList.add(itemListener);
            this.setClientShowing(itemListener, false, null, false);
        }
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this.getDocumentContainer(dTGroup)));
        if (this.getDocumentContainment() == 2) {
            dTMultipleClientFrame.removeGroup(dTGroup);
            DTMultipleClientFrame n = bl ? this.fMainFrame : this.createUndockedFrame(dTGroup);
            dTGroup.setContainingFrame(n);
            if (bl) {
                DTLocation dTLocation2 = dTGroup.getLastDockedLocation();
                if (dTLocation2 != null && dTLocation2.isMaximized()) {
                    dTLocation2 = dTGroup.getLastNestedLocation();
                }
                n.addGroup(dTGroup, dTLocation2);
            }
        } else {
            int point2 = -1;
            int n = -2;
            Object object2 = null;
            Object object3 = this.fMainFrame.getSharedDocumentContainer();
            if (bl) {
                if (object3 == null || ((DTDocumentContainer)object3).isEmpty()) {
                    object2 = dTGroup.hasDocumentContainer() ? dTGroup.getDocumentContainer().getState() : dTGroup.savedDocumentState();
                }
            } else if (object3 != null) {
                if (!this.fUndockingGroups && dTGroup.getDockedDocuments().size() == ((DTDocumentContainer)object3).getDocumentCount()) {
                    dTGroup.saveDocumentState(((DTDocumentContainer)object3).getState());
                    dTGroup.disposeDocumentContainer();
                } else if (!dTGroup.hasDocumentContainer() && dTGroup.savedDocumentState() == null) {
                    n = ((DTDocumentContainer)object3).getTabsEdge();
                    if (((DTDocumentContainer)object3).getArrangement() == 3) {
                        int n2 = 3;
                    } else {
                        boolean bl2 = true;
                    }
                }
            }
            DTClient[] dTClientArray = new DTClient[dTGroup.getDockedDocuments().size()];
            dTGroup.getDockedDocuments().toArray(dTClientArray);
            for (DTClient dTClient2 : dTClientArray) {
                this.setClientShowing(dTClient2, false, null, false);
            }
            dTGroup.setContainingFrame(bl ? this.fMainFrame : this.createUndockedFrame(dTGroup));
            if (bl) {
                dTMultipleClientFrame.removeGroup(dTGroup);
                if (object2 != null) {
                    this.fMainFrame.createSharedDocuments(object2);
                } else {
                    object3 = this.fMainFrame.createSharedDocuments().getDocumentContainer();
                    if (n != -2) {
                        ((DTDocumentContainer)object3).setTabsEdge(n);
                    }
                }
                if (!this.fMainFrame.contains(this.fMainFrame.getSharedDocuments())) {
                    this.fMainFrame.addDocuments(this.fMainFrame.getSharedDocuments(), null);
                }
            } else {
                void var9_14;
                if (var9_14 != -1) {
                    dTGroup.getDocumentContainer().setArrangement((int)var9_14, null);
                }
                if (n != -2) {
                    dTGroup.getDocumentContainer().setTabsEdge(n);
                }
            }
            for (DTClient dTClient2 : dTClientArray) {
                this.setClientShowing(dTClient2, true, dTClient2.getLastDockedLocation(), false);
            }
            object = null;
            int n3 = -1;
            for (DTClient dTClient3 : dTClientArray) {
                if (dTClient3.isSingleton() || dTClient3.getSelectionOrder() <= n3) continue;
                object = dTClient3;
                n3 = dTClient3.getSelectionOrder();
            }
            if (object != null) {
                this.toFront((DTOccupant)object, DTContainer.Scope.FRAME);
                ((DTOccupant)object).setSelected(true);
            }
            if (!bl && this.getDocumentContainment() == 1 && object3 != null && ((DTDocumentContainer)object3).getDocumentCount() == 0 && ((DTDocumentContainer)object3).getArrangement() == 2) {
                ((DTDocumentContainer)object3).setArrangement(1, null);
            }
        }
        if (dTClient != null) {
            dTClient.setSelected(true);
        }
        dTGroup.setSelected(true);
        if (bl) {
            dTMultipleClientFrame.dispose();
        } else {
            dTGroup.getContainingFrame().setVisible(true);
            this.fUndockingGroup = false;
        }
        Point point2 = new Point();
        SwingUtilities.convertPointToScreen(point2, (Component)((Object)this.getDocumentContainer(dTGroup)));
        int n = point2.x - point.x;
        int n4 = point2.y - point.y;
        if (arrayList != null && arrayList.size() > 0) {
            for (DTClient dTClient4 : arrayList) {
                object = dTClient4.getLastUndockedLocation();
                DTLocation dTLocation3 = object == null ? null : DTLocation.createExternal(((DTLocation)object).getFrameX() + n, ((DTLocation)object).getFrameY() + n4, ((DTLocation)object).getFrameWidth(), ((DTLocation)object).getFrameHeight());
                this.setClientShowing(dTClient4, true, dTLocation3, false);
            }
        }
    }

    protected boolean isGroupDocked(DTGroup dTGroup) {
        DTLocation dTLocation = dTGroup.getLocation();
        if (dTLocation != null) {
            return dTLocation.isDocked();
        }
        return dTGroup.getContainingFrame() == this.fMainFrame;
    }

    @DeferredFacadeMethod
    void dockAllInGroup(DTGroup dTGroup) {
        dTGroup.dockAll();
    }

    protected int getDocumentArrangement(DTGroup dTGroup) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer == null) {
            return 1;
        }
        return dTDocumentContainer.getArrangement();
    }

    protected Dimension getDocumentTiledDimension(DTGroup dTGroup) {
        DTDocumentContainer dTDocumentContainer = this.getDocumentContainer(dTGroup);
        if (dTDocumentContainer == null || dTDocumentContainer.getArrangement() == 1) {
            return new Dimension(1, 1);
        }
        return dTDocumentContainer.getTiledDimension();
    }

    void setOccupantMinimized(DTOccupant dTOccupant, boolean bl, int n) {
        if (!Desktop.isDockedMinMaxSupported()) {
            throw new UnsupportedOperationException("Docked Minimize is not supported on this platform");
        }
        if (bl) {
            dTOccupant.setMinimizing(true);
        } else {
            dTOccupant.setRestoring(true);
        }
        DTLocation dTLocation = dTOccupant.getLocation();
        if (dTLocation == null) {
            DTLocation dTLocation2 = dTOccupant.getLastLocation();
            if (bl) {
                if (n == -1) {
                    DTNestedLocation dTNestedLocation = dTOccupant.getLastNestedLocation();
                    if (dTLocation2 != null && dTLocation2.isMinimized()) {
                        n = dTLocation2.getEdge();
                    } else if (dTNestedLocation != null) {
                        n = dTNestedLocation.getDirection(0);
                    }
                    if (n == 2 || n == -1) {
                        n = 7;
                    }
                }
                if (dTLocation2 == null) {
                    dTOccupant.setLastLocation(new DTBorderLocation(n));
                } else if (!dTLocation2.isDocked()) {
                    ((DTFloatingLocation)dTLocation2).setMinimized(true);
                } else if (!dTLocation2.isMinimized() || dTLocation2.getEdge() != n) {
                    dTOccupant.setLastLocation(new DTBorderLocation(n));
                }
            } else if (dTLocation2 != null) {
                if (!dTLocation2.isDocked()) {
                    ((DTFloatingLocation)dTLocation2).setMinimized(false);
                } else if (dTLocation2.isMinimized()) {
                    dTOccupant.setLastLocation(dTOccupant.getLastNestedLocation());
                }
            }
        } else if (!dTLocation.isDocked()) {
            DTFrame dTFrame = dTLocation.getFrame();
            if (dTFrame != null) {
                boolean bl2;
                boolean bl3 = bl2 = dTFrame.getExtendedState() == 1;
                if (bl && !bl2) {
                    dTFrame.setExtendedState(1);
                } else if (!bl && bl2) {
                    dTFrame.setExtendedState(0);
                }
            }
        } else {
            DTLocation dTLocation3 = null;
            if (bl) {
                if (n == -1) {
                    if (dTLocation.isMinimized()) {
                        n = dTLocation.getEdge();
                    } else if (dTLocation instanceof DTNestedLocation) {
                        n = ((DTNestedLocation)dTLocation).getDirection(0);
                    }
                    if (n == 2 || n == -1) {
                        n = 7;
                    }
                }
                if (!dTLocation.isMinimized() || dTLocation.getEdge() != n) {
                    dTLocation3 = new DTBorderLocation(n);
                }
            } else if (dTLocation.isMinimized() && (dTLocation3 = dTOccupant.getLastNestedLocation()) == null) {
                dTLocation3 = new DTNestedLocation(new int[]{dTLocation.getEdge()});
            }
            if (dTLocation3 != null) {
                this.relocateDockedOccupant(dTOccupant, dTLocation3);
            }
        }
        if (bl) {
            dTOccupant.setMinimizing(false);
        } else {
            dTOccupant.setRestoring(false);
        }
    }

    void setOccupantMaximized(DTOccupant dTOccupant, boolean bl) {
        if (!Desktop.isDockedMinMaxSupported()) {
            throw new UnsupportedOperationException("Docked Maximize is not supported on this platform");
        }
        if (bl) {
            dTOccupant.setMaximizing(true);
        } else {
            dTOccupant.setRestoring(true);
        }
        DTLocation dTLocation = dTOccupant.getLocation();
        if (dTLocation == null) {
            DTLocation dTLocation2 = dTOccupant.getLastLocation();
            if (bl) {
                if (dTLocation2 == null) {
                    dTOccupant.setLastLocation(new DTBorderLocation(0));
                } else if (!dTLocation2.isDocked()) {
                    ((DTFloatingLocation)dTLocation2).setMaximized(true);
                } else if (!dTLocation2.isMaximized()) {
                    dTOccupant.setLastLocation(new DTBorderLocation(0));
                }
            } else if (dTLocation2 != null) {
                if (!dTLocation2.isDocked()) {
                    ((DTFloatingLocation)dTLocation2).setMaximized(false);
                } else if (dTLocation2.isMaximized()) {
                    dTOccupant.setLastLocation(dTOccupant.getLastNestedLocation());
                }
            }
        } else if (!dTLocation.isDocked()) {
            DTFrame dTFrame = dTLocation.getFrame();
            if (dTFrame != null) {
                boolean bl2;
                int n = dTFrame.getExtendedState();
                boolean bl3 = bl2 = n != -1 && (n & 6) == 6;
                if (bl && !bl2) {
                    dTFrame.setExtendedState(6);
                } else if (!bl && bl2) {
                    dTFrame.setExtendedState(0);
                }
            }
        } else {
            DTLocation dTLocation3 = null;
            if (bl) {
                dTLocation3 = new DTBorderLocation(0);
            } else if (dTLocation.isMaximized() && (dTLocation3 = dTOccupant.getLastNestedLocation()) == null) {
                dTLocation3 = new DTNestedLocation();
            }
            if (dTLocation3 != null) {
                this.relocateDockedOccupant(dTOccupant, dTLocation3);
            }
        }
        if (bl) {
            dTOccupant.setMaximizing(false);
        } else {
            dTOccupant.setRestoring(false);
        }
    }

    private void relocateDockedOccupant(DTOccupant dTOccupant, DTLocation dTLocation) {
        if (dTOccupant instanceof DTClient) {
            DTClient dTClient = (DTClient)dTOccupant;
            this.setClientShowing(dTClient, false, null, false);
            this.setClientShowing(dTClient, true, dTLocation, false);
        } else if (dTOccupant instanceof DTGroup) {
            DTGroup dTGroup = (DTGroup)dTOccupant;
            this.setGroupShowing(dTGroup, false, null, false);
            this.setGroupShowing(dTGroup, true, dTLocation, false);
        }
    }

    private DTDocumentContainer getDocumentContainer(DTGroup dTGroup) {
        DTDocumentContainer dTDocumentContainer = null;
        if (dTGroup == null) {
            if (this.getDocumentContainment() == 1 && this.fMainFrame != null) {
                dTDocumentContainer = this.fMainFrame.getSharedDocumentContainer();
            }
        } else {
            dTDocumentContainer = dTGroup.getDocumentContainer();
        }
        return dTDocumentContainer;
    }

    void addFrame(DTFrame dTFrame) {
        this.fFrames.add(dTFrame);
        this.fActionManager.addActionsToFrame(dTFrame);
        if (this.fRestoringLayout) {
            ++this.fUnopenedFrameCount;
            dTFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    --Desktop.this.fUnopenedFrameCount;
                    windowEvent.getWindow().removeWindowListener(this);
                }
            });
        }
    }

    void removeFrame(DTFrame dTFrame) {
        this.fFrames.remove(dTFrame);
        this.fActionManager.removeActionsFromFrame(dTFrame);
    }

    List<DTFrame> getFrames() {
        return Collections.unmodifiableList(this.fFrames);
    }

    boolean isAnyFrameClosing() {
        for (DTFrame dTFrame : this.fFrames) {
            if (!dTFrame.isClosing()) continue;
            return true;
        }
        return false;
    }

    DTSelectionManager getSelectionManager() {
        return this.fSelectionManager;
    }

    protected DTClient getSelectedClient() {
        return this.syncCall(new CallableWrapper<DTClient>(){

            @Override
            public DTClient call() {
                return Desktop.this.fSelectionManager.getSelectedClient();
            }
        });
    }

    protected DTClient getPreviousSelectedClient() {
        return this.syncCall(new CallableWrapper<DTClient>(){

            @Override
            public DTClient call() {
                return Desktop.this.fSelectionManager.getPreviousSelected();
            }
        });
    }

    public DTWindowRegistry getWindowRegistry() {
        return DTWindowRegistry.getInstance();
    }

    public DTToolBarRegistry getToolBarRegistry() {
        return this.fToolBarRegistry;
    }

    protected DTLayoutLibrary getLayoutLibrary() {
        if (this.fLayoutLibrary == null) {
            this.fLayoutLibrary = new DTLayoutLibrary(this);
        }
        return this.fLayoutLibrary;
    }

    public RecentFiles getRecentFiles() {
        if (this.fRecentFiles == null) {
            this.fRecentFiles = this.createRecentFiles();
        }
        return this.fRecentFiles;
    }

    public DefaultViewTabFactory getDefaultViewTabFactory() {
        if (this.fViewTabFactory == null) {
            this.fViewTabFactory = new DefaultViewTabFactory(this);
        }
        return this.fViewTabFactory;
    }

    protected RecentFiles createRecentFiles() {
        return new RecentFiles();
    }

    DTNotifyingList<DTClient> getSingletons() {
        return this.fSingletons;
    }

    List<DTClient> getClients() {
        return Collections.unmodifiableList(this.fClients);
    }

    List<DTGroup> getGroups() {
        return Collections.unmodifiableList(this.fGroups);
    }

    DTNotifyingList<DTGroup> getNotifyingGroups() {
        return this.fNotifyingGroups;
    }

    private void addPendingListener(DTClientListener dTClientListener, Component component, String string) {
        ClientListenerData clientListenerData = new ClientListenerData();
        clientListenerData.fListener = dTClientListener;
        clientListenerData.fTargetComponent = component;
        clientListenerData.fTargetTitle = string;
        this.fPendingClientListeners.add(clientListenerData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingListener(DTClientListener dTClientListener, Component component, String string) {
        ClientListenerData clientListenerData = new ClientListenerData();
        clientListenerData.fListener = dTClientListener;
        clientListenerData.fTargetComponent = component;
        clientListenerData.fTargetTitle = string;
        List<ClientListenerData> list = this.fPendingClientListeners;
        synchronized (list) {
            int n = this.fPendingClientListeners.indexOf(clientListenerData);
            if (n >= 0) {
                this.fPendingClientListeners.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingListener(DTGroup dTGroup) {
        List<ClientListenerData> list = this.fPendingClientListeners;
        synchronized (list) {
            Iterator<ClientListenerData> iterator = this.fPendingClientListeners.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().fTargetTitle;
                if (string == null || !string.equals(dTGroup.getName()) && !string.equals(dTGroup.getTitle())) continue;
                iterator.remove();
            }
        }
    }

    private static void deferredCall(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static <T> T deferredCall(CallableWrapper<T> callableWrapper, T t) {
        if (SwingUtilities.isEventDispatchThread()) {
            return callableWrapper.call();
        }
        SwingUtilities.invokeLater(callableWrapper);
        return t;
    }

    private <T> T syncCall(CallableWrapper<T> callableWrapper) {
        if (SwingUtilities.isEventDispatchThread() || !this.fThreadSafeGetMethods) {
            return callableWrapper.call();
        }
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(callableWrapper));
        return callableWrapper.fResult;
    }

    private static <T> T staticSyncCall(CallableWrapper<T> callableWrapper) {
        if (SwingUtilities.isEventDispatchThread()) {
            return callableWrapper.call();
        }
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(callableWrapper));
        return callableWrapper.fResult;
    }

    static {
        DOCK_ICON = Desktop.createContrastingIcon("dock.gif");
        DOCK_ALL_ICON = Desktop.createContrastingIcon("dockall.gif");
        UNDOCK_ICON = Desktop.createContrastingIcon("undock.gif");
        CLOSE_ICON = Desktop.createContrastingIcon("closebox.gif");
        MINIMIZE_ICON = Desktop.createContrastingIcon("minimize.gif");
        MAXIMIZE_ICON = Desktop.createContrastingIcon("maximize.gif");
        RESTORE_ICON = Desktop.createContrastingIcon("restore.gif");
        MINIMIZE_TO_NORTH_ICON = Desktop.createContrastingIcon("minimizetonorth.gif");
        MINIMIZE_TO_SOUTH_ICON = Desktop.createContrastingIcon("minimizetosouth.gif");
        MINIMIZE_TO_EAST_ICON = Desktop.createContrastingIcon("minimizetoeast.gif");
        MINIMIZE_TO_WEST_ICON = Desktop.createContrastingIcon("minimizetowest.gif");
        RESTORE_TO_DOCKED_ICON = Desktop.createContrastingIcon("restoretodocked.gif");
        ANCHOR_ICON = Desktop.createContrastingIcon("anchor.gif");
        DETACH_ICON = Desktop.createContrastingIcon("detach.gif");
        MOVE_ICON = DTUtilities.createContrastingIcon(MoveIcon.MOVE.getIcon());
        RESIZE_ICON = Desktop.createContrastingIcon("resize.gif");
        DEFAULT_GROUP_DOCK_LOCATION = DTLocation.create("EN");
    }

    public static class DeferredFacadeProxy
    implements InvocationHandler {
        private final Desktop fDesktop;
        private final Set<Method> fClientsMethodsSet = new HashSet<Method>();
        private final Map<Method, Method> fMethodsMap = new HashMap<Method, Method>();

        public static DeferredDesktopFacade newInstance(Desktop desktop) {
            return (DeferredDesktopFacade)Proxy.newProxyInstance(desktop.getClass().getClassLoader(), new Class[]{DeferredDesktopFacade.class}, (InvocationHandler)new DeferredFacadeProxy(desktop));
        }

        private DeferredFacadeProxy(Desktop desktop) {
            this.fDesktop = desktop;
            Class<?> clazz = desktop.getClass();
            for (Method method : DeferredDesktopFacade.class.getDeclaredMethods()) {
                Method method2 = this.getDeclaredMethod(clazz, method);
                method2.setAccessible(true);
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length > 0 && classArray[0] == DTClient.class) {
                    this.fClientsMethodsSet.add(method);
                }
                this.fMethodsMap.put(method, method2);
            }
        }

        private Method getDeclaredMethod(Class clazz, Method method) {
            while (clazz != Object.class) {
                try {
                    return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2;
            if (objectArray.length > 0 && this.fClientsMethodsSet.contains(method) && ((object2 = (DTClient)objectArray[0]) == null || ((DTOccupant)object2).hasBeenFlushed())) {
                return null;
            }
            object2 = this.fMethodsMap.get(method);
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    return ((Method)object2).invoke((Object)this.fDesktop, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.logException(invocationTargetException.getTargetException());
                    throw invocationTargetException.getTargetException();
                }
            }
            SwingUtilities.invokeLater(new Runnable((Method)object2, objectArray){
                final /* synthetic */ Method val$desktopMethod;
                final /* synthetic */ Object[] val$args;
                {
                    this.val$desktopMethod = method;
                    this.val$args = objectArray;
                }

                @Override
                public void run() {
                    try {
                        this.val$desktopMethod.invoke((Object)DeferredFacadeProxy.this.fDesktop, this.val$args);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        DeferredFacadeProxy.this.logException(invocationTargetException.getTargetException());
                        throw new RuntimeException(invocationTargetException.getTargetException());
                    }
                    catch (Exception exception) {
                        DeferredFacadeProxy.this.logException(exception);
                        throw new RuntimeException(exception);
                    }
                }
            });
            return null;
        }

        private void logException(Throwable throwable) {
            System.out.println(throwable.getMessage());
            throwable.printStackTrace(System.out);
        }
    }

    private static abstract class CallableClientWrapper<T>
    extends CallableWrapper<T> {
        DTClient fClient;
        T fDefaultResult;

        protected CallableClientWrapper(DTClient dTClient, T t) {
            this.fClient = dTClient;
            this.fDefaultResult = t;
        }

        @Override
        public void run() {
            this.fResult = this.fClient != null && this.fClient.hasBeenFlushed() ? this.fDefaultResult : this.call();
        }
    }

    private static abstract class CallableWrapper<T>
    implements Runnable {
        T fResult;

        private CallableWrapper() {
        }

        public abstract T call();

        @Override
        public void run() {
            this.fResult = this.call();
        }
    }

    class ClientListenerData {
        DTClientListener fListener;
        Component fTargetComponent;
        String fTargetTitle;

        ClientListenerData() {
        }

        public boolean equals(Object object) {
            if (object instanceof ClientListenerData) {
                ClientListenerData clientListenerData = (ClientListenerData)object;
                return this.fListener == clientListenerData.fListener && this.fTargetComponent == clientListenerData.fTargetComponent && this.fTargetTitle == clientListenerData.fTargetTitle;
            }
            return false;
        }
    }

    class GroupCloseDoneListener
    implements DTCloseTransaction.DoneListener {
        private DTGroup fGroup;
        private boolean fRemove;

        GroupCloseDoneListener(DTGroup dTGroup) {
            this.fGroup = dTGroup;
        }

        GroupCloseDoneListener(DTGroup dTGroup, boolean bl) {
            this.fGroup = dTGroup;
            this.fRemove = bl;
        }

        @Override
        public void closeTransactionDone(boolean bl) {
            if (bl) {
                Desktop.this.setGroupShowing(this.fGroup, false, null, false);
                this.fGroup.setClosed();
                if (this.fRemove) {
                    Desktop.this.removeGroup(this.fGroup);
                }
            }
        }
    }

    protected class MainFrameCloseTransaction
    extends DTCloseTransaction
    implements Runnable {
        public MainFrameCloseTransaction() {
            super(null);
        }

        @Override
        public void start() {
            DTLocation dTLocation;
            for (DTGroup dTOccupant : Desktop.this.fGroups) {
                if (dTOccupant.getLocation() == null || !dTOccupant.getLocation().isDocked()) continue;
                dTOccupant.getDocumentContainer().saveShowingAndEmpty();
            }
            this.fClosers = new ArrayList();
            for (DTClient dTClient : Desktop.this.fSingletons) {
                dTLocation = dTClient.getLocation();
                if (dTLocation == null || !dTLocation.isDocked() || dTLocation.getFrame() != Desktop.this.fMainFrame) continue;
                this.fClosers.add(dTClient);
            }
            for (DTClient dTClient : Desktop.this.fClients) {
                dTLocation = dTClient.getLocation();
                if (dTClient.isSingleton() || dTLocation == null || !dTLocation.isDocked() || dTLocation.getFrame() != Desktop.this.fMainFrame) continue;
                this.fClosers.add(dTClient);
            }
            super.start();
        }

        @Override
        protected void close() {
            Desktop.this.closeMainFrame();
        }

        @Override
        public void run() {
            this.start();
        }
    }

    private class DeferredMainFrameCloser
    implements Runnable {
        boolean fSaveLayout;

        DeferredMainFrameCloser(boolean bl) {
            this.fSaveLayout = bl;
        }

        @Override
        public void run() {
            Desktop.this.closeMainFrame(this.fSaveLayout);
        }
    }

    protected class DesktopCloseTransaction
    extends DTCloseTransaction
    implements Runnable {
        public DesktopCloseTransaction() {
            super(null);
        }

        @Override
        public void start() {
            this.fClosers = new ArrayList();
            for (DTGroup object2 : Desktop.this.fGroups) {
                if (object2.isShowing()) {
                    this.fClosers.add(object2);
                }
                if (!object2.hasDocumentContainer()) continue;
                object2.getDocumentContainer().saveShowingAndEmpty();
            }
            Object object = null;
            if (Desktop.this.ownsWindowRegistry()) {
                object = Desktop.this.getWindowRegistry().getClosers();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof DTShutdownExcludedCloser)) continue;
                    iterator.remove();
                }
            }
            for (DTClient dTClient : Desktop.this.fSingletons) {
                if (!dTClient.isShowing()) continue;
                this.fClosers.add(dTClient);
            }
            if (Desktop.this.ownsWindowRegistry()) {
                this.fClosers.addAll(object);
            } else if (Desktop.this.fClients.size() > 0) {
                for (DTClient dTClient : Desktop.this.fClients) {
                    if (dTClient.isSingleton()) continue;
                    this.fClosers.add(dTClient);
                }
            }
            super.start();
        }

        @Override
        protected void close() {
            Desktop.this.close();
        }

        @Override
        public void run() {
            this.start();
        }
    }

    private class DeferredCloser
    implements Runnable {
        boolean fSaveLayout;

        DeferredCloser(boolean bl) {
            this.fSaveLayout = bl;
        }

        @Override
        public void run() {
            Desktop.this.close(this.fSaveLayout);
        }
    }

    public static enum LayoutSavePolicy {
        NEVER,
        UPON_EXIT,
        UPON_CHANGE;

    }
}

