/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DTWindowCloser;
import com.mathworks.widgets.desk.DTWindowRegistry;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DTWindowHandler
extends WindowAdapter
implements DTWindowActivator,
DTWindowCloser,
ComponentListener,
PropertyChangeListener {
    protected Window fWindow;

    public DTWindowHandler(Window window) {
        this.fWindow = window;
        if (window instanceof JDialog) {
            ((JDialog)window).setDefaultCloseOperation(0);
        } else if (window instanceof JFrame) {
            ((JFrame)window).setDefaultCloseOperation(0);
        }
        DTWindowRegistry.getInstance().addActivator(this);
        this.fWindow.addWindowListener(this);
        this.fWindow.addComponentListener(this);
        this.fWindow.addPropertyChangeListener(this);
        if (!window.isVisible()) {
            DTWindowRegistry.getInstance().setVisible(this, false);
        }
    }

    public void cleanup() {
        if (this.fWindow != null) {
            DTWindowRegistry.getInstance().removeActivator(this);
            this.fWindow.removeWindowListener(this);
            this.fWindow.removeComponentListener(this);
            this.fWindow.removePropertyChangeListener(this);
            this.fWindow = null;
        }
    }

    @Override
    public void activate() {
        if (this.fWindow == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.fWindow.toFront();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DTWindowHandler.this.activate();
                }
            });
        }
    }

    @Override
    public String getShortTitle() {
        if (this.fWindow == null) {
            return "removed";
        }
        if (this.fWindow instanceof MJDialog) {
            return ((MJDialog)this.fWindow).getSpecifiedTitle();
        }
        if (this.fWindow instanceof MJFrame) {
            return ((MJFrame)this.fWindow).getSpecifiedTitle();
        }
        if (this.fWindow instanceof Dialog) {
            return ((Dialog)this.fWindow).getTitle();
        }
        if (this.fWindow instanceof Frame) {
            return ((Frame)this.fWindow).getTitle();
        }
        return this.fWindow.toString();
    }

    @Override
    public String getGroupName() {
        return "";
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void close() {
        if (this.fWindow != null) {
            this.fWindow.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.canClose()) {
            this.close();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.cleanup();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("title".equals(propertyChangeEvent.getPropertyName())) {
            DTWindowRegistry.getInstance().nameChange(this);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        DTWindowRegistry.getInstance().setVisible(this, true);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        DTWindowRegistry.getInstance().setVisible(this, false);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }
}

