/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.MoveIcon;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.widgets.desk.DTComponentBar;
import com.mathworks.widgets.desk.DTToolBarCustomizationPanel;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;

class DTToolbarLayoutController {
    private DTComponentBar.ItemAccess fItemAccess;
    private Box fLayoutControls;
    private DTComponentBar fComponentBar;
    private String fLayoutName;
    private MJCheckBox fToggleLabelCheckBox;
    Action fMoveToBeginAction;
    Action fMoveToLeftAction;
    Action fMoveToRightAction;
    Action fMoveToEndAction;
    Action fAddSeparatorAction;
    Action fRemoveAction;
    Action fRestoreDefaultAction;
    Action fToggleLabelAction;

    DTToolbarLayoutController(DTComponentBar.ItemAccess itemAccess, DTComponentBar dTComponentBar, boolean bl, String string) {
        this.fItemAccess = itemAccess;
        this.fComponentBar = dTComponentBar;
        this.fLayoutName = string;
        this.fMoveToBeginAction = new MoveToBeginAction();
        this.fMoveToLeftAction = new MoveToLeftAction();
        this.fMoveToRightAction = new MoveToRightAction();
        this.fMoveToEndAction = new MoveToEndAction();
        this.fAddSeparatorAction = new AddSeparatorAction();
        this.fRemoveAction = new RemoveAction();
        this.fRestoreDefaultAction = new RestoreDefaultAction();
        this.fToggleLabelAction = new ToggleLabelAction();
        FocusForwarder focusForwarder = new FocusForwarder();
        this.fLayoutControls = Box.createHorizontalBox();
        if (string != null && string.equals("QuickAccess")) {
            this.fToggleLabelCheckBox = new MJCheckBox(this.fToggleLabelAction);
            this.fToggleLabelCheckBox.setText(Desktop.sRes.getString("label.ShowLabel"));
            this.fToggleLabelCheckBox.addFocusListener((FocusListener)focusForwarder);
            this.fLayoutControls.add((Component)this.fToggleLabelCheckBox);
            this.fLayoutControls.add(Box.createHorizontalStrut(3));
            this.fToggleLabelCheckBox.setEnabled(false);
        }
        JButton jButton = DTToolbarLayoutController.createActionButton(this.fMoveToBeginAction);
        this.fLayoutControls.add(jButton);
        this.fLayoutControls.add(Box.createHorizontalStrut(3));
        jButton = DTToolbarLayoutController.createActionButton(this.fMoveToLeftAction);
        jButton.addFocusListener(focusForwarder);
        this.fLayoutControls.add(jButton);
        this.fLayoutControls.add(Box.createHorizontalStrut(3));
        jButton = DTToolbarLayoutController.createActionButton(this.fMoveToRightAction);
        jButton.addFocusListener(focusForwarder);
        this.fLayoutControls.add(jButton);
        this.fLayoutControls.add(Box.createHorizontalStrut(3));
        jButton = DTToolbarLayoutController.createActionButton(this.fMoveToEndAction);
        jButton.addFocusListener(focusForwarder);
        this.fLayoutControls.add(jButton);
        this.fLayoutControls.add(Box.createHorizontalStrut(10));
        if (bl) {
            jButton = DTToolbarLayoutController.createActionButton(this.fAddSeparatorAction);
            jButton.addFocusListener(focusForwarder);
            this.fLayoutControls.add(jButton);
            this.fLayoutControls.add(Box.createHorizontalStrut(3));
        }
        jButton = DTToolbarLayoutController.createActionButton(this.fRemoveAction);
        jButton.addFocusListener(focusForwarder);
        jButton.setEnabled(false);
        this.fLayoutControls.add(jButton);
        this.fLayoutControls.add(Box.createHorizontalStrut(10));
        jButton = DTToolbarLayoutController.createActionButton(this.fRestoreDefaultAction);
        jButton.addFocusListener(focusForwarder);
        this.fLayoutControls.add(jButton);
        SelectFirstAction selectFirstAction = new SelectFirstAction();
        SelectPreviousAction selectPreviousAction = new SelectPreviousAction();
        SelectNextAction selectNextAction = new SelectNextAction();
        SelectLastAction selectLastAction = new SelectLastAction();
        InputMap inputMap = new InputMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 2), selectFirstAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(37, 0), selectPreviousAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(39, 0), selectNextAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(39, 2), selectLastAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(37, 8), this.fMoveToLeftAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(37, 10), this.fMoveToBeginAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(39, 8), this.fMoveToRightAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(39, 10), this.fMoveToEndAction.getValue("ActionCommandKey"));
        inputMap.put(KeyStroke.getKeyStroke(127, 0), this.fRemoveAction.getValue("ActionCommandKey"));
        this.fComponentBar.setInputMap(0, inputMap);
        ActionMap actionMap = this.fComponentBar.getActionMap();
        actionMap.put(selectFirstAction.getValue("ActionCommandKey"), (Action)((Object)selectFirstAction));
        actionMap.put(selectPreviousAction.getValue("ActionCommandKey"), (Action)((Object)selectPreviousAction));
        actionMap.put(selectNextAction.getValue("ActionCommandKey"), (Action)((Object)selectNextAction));
        actionMap.put(selectLastAction.getValue("ActionCommandKey"), (Action)((Object)selectLastAction));
        actionMap.put(this.fMoveToLeftAction.getValue("ActionCommandKey"), this.fMoveToLeftAction);
        actionMap.put(this.fMoveToBeginAction.getValue("ActionCommandKey"), this.fMoveToBeginAction);
        actionMap.put(this.fMoveToRightAction.getValue("ActionCommandKey"), this.fMoveToRightAction);
        actionMap.put(this.fMoveToEndAction.getValue("ActionCommandKey"), this.fMoveToEndAction);
        actionMap.put(this.fRemoveAction.getValue("ActionCommandKey"), this.fRemoveAction);
    }

    public Box getLayoutControls() {
        return this.fLayoutControls;
    }

    public void setToggleLabelCheckBoxSelected(boolean bl) {
        this.fToggleLabelCheckBox.setSelected(bl);
    }

    public void setToggleLabelCheckBoxEnabled(boolean bl) {
        this.fToggleLabelCheckBox.setEnabled(bl);
    }

    private static JButton createActionButton(Action action) {
        MJButton mJButton = new MJButton(action);
        if (mJButton.getText() == null) {
            Insets insets = mJButton.getMargin();
            insets.left = 2;
            insets.right = 2;
            mJButton.setMargin(insets);
        }
        mJButton.getAccessibleContext().setAccessibleName((String)action.getValue("ShortDescription"));
        return mJButton;
    }

    void updateSelectionDependentActions() {
        if (this.fItemAccess.getSelectedItem() == null) {
            this.fMoveToBeginAction.setEnabled(false);
            this.fMoveToLeftAction.setEnabled(false);
            this.fMoveToRightAction.setEnabled(false);
            this.fMoveToEndAction.setEnabled(false);
            this.fRemoveAction.setEnabled(false);
            this.fToggleLabelAction.setEnabled(false);
        } else {
            int n = this.fComponentBar.layoutIndexOf(this.fItemAccess.getSelectedItem());
            int n2 = this.fComponentBar.getComponentCount();
            this.fMoveToBeginAction.setEnabled(n > 0);
            this.fMoveToLeftAction.setEnabled(n > 0);
            this.fMoveToRightAction.setEnabled(n < n2 - 1);
            this.fMoveToEndAction.setEnabled(n < n2 - 1);
            this.fRemoveAction.setEnabled(true);
            this.fToggleLabelAction.setEnabled(true);
        }
    }

    private class ToggleLabelAction
    extends MJAbstractAction {
        ToggleLabelAction() {
            this.putValue("ShortDescription", Desktop.sRes.getString("tooltip.ShowHideLabel"));
            this.setComponentName("ToggleLabel" + DTToolbarLayoutController.this.fLayoutName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.toggleLabelVisibility();
        }
    }

    private class RestoreDefaultAction
    extends MJAbstractAction {
        RestoreDefaultAction() {
            super(Desktop.sRes.getString("tooltip.RestoreFactoryControls"));
            this.setComponentName("RestoreFactoryControls_" + DTToolbarLayoutController.this.fLayoutName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.restoreDefault();
        }
    }

    private class RemoveAction
    extends MJAbstractAction {
        RemoveAction() {
            super(null, (Icon)CommonIcon.DELETE.getIcon());
            this.putValue("ShortDescription", Desktop.sRes.getString("tooltip.RemoveSelectedItem"));
            this.putValue("ActionCommandKey", "Remove");
            this.setComponentName("Remove_" + DTToolbarLayoutController.this.fLayoutName);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.removeSelectedItem();
            DTToolbarLayoutController.this.updateSelectionDependentActions();
        }
    }

    private class AddSeparatorAction
    extends MJAbstractAction {
        AddSeparatorAction() {
            super(null, DTUtilities.createContrastingIcon(new ImageIcon(DTToolBarCustomizationPanel.class.getResource("resources/addseparator.gif"))));
            this.putValue("ShortDescription", Desktop.sRes.getString("tooltip.AddSeparator"));
            this.setComponentName("AddSeparator_" + DTToolbarLayoutController.this.fLayoutName);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.addSeparator();
        }
    }

    private class MoveToEndAction
    extends MJAbstractAction {
        MoveToEndAction() {
            super(null, DTUtilities.createContrastingIcon(MoveIcon.MOVE_END.getIcon()));
            this.putValue("ShortDescription", Desktop.sRes.getString("tooltip.MoveItemToEnd"));
            this.setComponentName("MoveItemToEnd_" + DTToolbarLayoutController.this.fLayoutName);
            this.putValue("ActionCommandKey", "MoveItemToEnd");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.moveSelectedItemToEnd();
            DTToolbarLayoutController.this.updateSelectionDependentActions();
        }
    }

    private class MoveToRightAction
    extends MJAbstractAction {
        MoveToRightAction() {
            super(null, DTUtilities.createContrastingIcon(MoveIcon.MOVE_RIGHT.getIcon()));
            this.putValue("ShortDescription", Desktop.sRes.getString("tooltip.MoveItemToRight"));
            this.setComponentName("MoveItemToRight_" + DTToolbarLayoutController.this.fLayoutName);
            this.putValue("ActionCommandKey", "MoveItemToRight");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.moveSelectedItemToRight();
            DTToolbarLayoutController.this.updateSelectionDependentActions();
        }
    }

    private class MoveToLeftAction
    extends MJAbstractAction {
        MoveToLeftAction() {
            super(null, DTUtilities.createContrastingIcon(MoveIcon.MOVE_LEFT.getIcon()));
            this.putValue("ShortDescription", Desktop.sRes.getString("tooltip.MoveItemToLeft"));
            this.setComponentName("MoveItemToLeft_" + DTToolbarLayoutController.this.fLayoutName);
            this.putValue("ActionCommandKey", "MoveItemToLeft");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.moveSelectedItemToLeft();
            DTToolbarLayoutController.this.updateSelectionDependentActions();
        }
    }

    private class MoveToBeginAction
    extends MJAbstractAction {
        MoveToBeginAction() {
            super(null, DTUtilities.createContrastingIcon(MoveIcon.MOVE_BEGIN.getIcon()));
            this.putValue("ShortDescription", Desktop.sRes.getString("tooltip.MoveItemToBegin"));
            this.setComponentName("MoveItemToBegin_" + DTToolbarLayoutController.this.fLayoutName);
            this.putValue("ActionCommandKey", "MoveItemToBegin");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.moveSelectedItemToBegin();
            DTToolbarLayoutController.this.updateSelectionDependentActions();
        }
    }

    private class SelectLastAction
    extends MJAbstractAction {
        SelectLastAction() {
            this.putValue("ActionCommandKey", "SelectLast");
            this.setComponentName("SelectLast_" + DTToolbarLayoutController.this.fLayoutName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.selectLast();
        }
    }

    private class SelectNextAction
    extends MJAbstractAction {
        SelectNextAction() {
            this.putValue("ActionCommandKey", "SelectNext");
            this.setComponentName("SelectNext_" + DTToolbarLayoutController.this.fLayoutName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.selectNext();
        }
    }

    private class SelectPreviousAction
    extends MJAbstractAction {
        SelectPreviousAction() {
            this.putValue("ActionCommandKey", "SelectPrevious");
            this.setComponentName("SelectPrevious_" + DTToolbarLayoutController.this.fLayoutName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.selectPrevious();
        }
    }

    private class SelectFirstAction
    extends MJAbstractAction {
        SelectFirstAction() {
            this.putValue("ActionCommandKey", "SelectFirst");
            this.setComponentName("SelectFirst_" + DTToolbarLayoutController.this.fLayoutName);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTToolbarLayoutController.this.fItemAccess.selectFirst();
        }
    }

    private class FocusForwarder
    extends FocusAdapter {
        private FocusForwarder() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof AbstractButton && !((AbstractButton)component).getAction().isEnabled()) {
                Container container = component.getFocusCycleRootAncestor();
                Component component2 = container.getFocusTraversalPolicy().getComponentAfter(container, component);
                if (component2 != null) {
                    component2.requestFocusInWindow();
                } else {
                    component.transferFocus();
                }
            }
        }
    }
}

