/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DTToolBarConfiguration {
    public static final String SEPARATOR_KEY = "Tool Bar Separator Key";
    private List<String> fVisibleKeys;
    private List<String> fHiddenKeys;
    private static final String TOOL_BAR_TAG = "ToolBar";
    private static final String VISIBLE_TAG = "Visible";
    private static final String HIDDEN_TAG = "Hidden";
    private static final String KEY_TAG = "Key";
    private static final String SEPARATOR_TAG = "Separator";

    public DTToolBarConfiguration(List<String> list) {
        this.fVisibleKeys = new ArrayList<String>(list);
        this.fHiddenKeys = Collections.emptyList();
    }

    public DTToolBarConfiguration(List<String> list, List<String> list2) {
        this.fVisibleKeys = new ArrayList<String>(list);
        this.fHiddenKeys = new ArrayList<String>(list2);
    }

    public List<String> getVisibleItemKeys() {
        return Collections.unmodifiableList(this.fVisibleKeys);
    }

    public List<String> getHiddenItemKeys() {
        return Collections.unmodifiableList(this.fHiddenKeys);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DTToolBarConfiguration)) {
            return false;
        }
        DTToolBarConfiguration dTToolBarConfiguration = (DTToolBarConfiguration)object;
        return this.fVisibleKeys.equals(dTToolBarConfiguration.fVisibleKeys);
    }

    public int hashCode() {
        return this.fVisibleKeys.hashCode();
    }

    public boolean equalsIncludingHidden(DTToolBarConfiguration dTToolBarConfiguration) {
        return this.fVisibleKeys.equals(dTToolBarConfiguration.fVisibleKeys) && this.fHiddenKeys.equals(dTToolBarConfiguration.fHiddenKeys);
    }

    public Element toXML(Document document, Element element) {
        Text text;
        Element element2;
        Element element3;
        if (element == null) {
            element = document.createElement(TOOL_BAR_TAG);
        }
        if (this.fVisibleKeys.size() > 0) {
            element3 = document.createElement(VISIBLE_TAG);
            for (String string : this.fVisibleKeys) {
                if (SEPARATOR_KEY.equals(string)) {
                    element3.appendChild(document.createElement(SEPARATOR_TAG));
                    continue;
                }
                element2 = document.createElement(KEY_TAG);
                text = document.createTextNode(string);
                element2.appendChild(text);
                element3.appendChild(element2);
            }
            element.appendChild(element3);
        }
        if (this.fHiddenKeys.size() > 0) {
            element3 = document.createElement(HIDDEN_TAG);
            for (String string : this.fHiddenKeys) {
                element2 = document.createElement(KEY_TAG);
                text = document.createTextNode(string);
                element2.appendChild(text);
                element3.appendChild(element2);
            }
            element.appendChild(element3);
        }
        return element;
    }

    public DTToolBarConfiguration(SimpleElement simpleElement) {
        SimpleNodeList simpleNodeList = simpleElement.getChildElements();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            SimpleElement simpleElement2;
            int n;
            SimpleNodeList simpleNodeList2;
            SimpleElement simpleElement3 = (SimpleElement)simpleNodeList.item(i);
            String string = simpleElement3.getNodeName();
            if (VISIBLE_TAG.equals(string)) {
                this.fVisibleKeys = new ArrayList<String>();
                simpleNodeList2 = simpleElement3.getChildElements();
                for (n = 0; n < simpleNodeList2.getLength(); ++n) {
                    simpleElement2 = (SimpleElement)simpleNodeList2.item(n);
                    String string2 = simpleElement2.getNodeName();
                    if (KEY_TAG.equals(string2)) {
                        this.fVisibleKeys.add(simpleElement2.getText());
                        continue;
                    }
                    if (!SEPARATOR_TAG.equals(string2)) continue;
                    this.fVisibleKeys.add(SEPARATOR_KEY);
                }
                continue;
            }
            if (!HIDDEN_TAG.equals(string)) continue;
            this.fHiddenKeys = new ArrayList<String>();
            simpleNodeList2 = simpleElement3.getChildElements();
            for (n = 0; n < simpleNodeList2.getLength(); ++n) {
                simpleElement2 = (SimpleElement)simpleNodeList2.item(n);
                if (!KEY_TAG.equals(simpleElement2.getNodeName())) continue;
                this.fHiddenKeys.add(simpleElement2.getText());
            }
        }
        if (this.fVisibleKeys == null) {
            this.fVisibleKeys = Collections.emptyList();
        }
        if (this.fHiddenKeys == null) {
            this.fHiddenKeys = Collections.emptyList();
        }
    }
}

