/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseLatch;
import com.mathworks.mwswing.SimpleStringTrimmer;
import com.mathworks.mwswing.StringTrimmer;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTBorderFactory;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTMenuContributor;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTTabbedPane;
import com.mathworks.widgets.desk.DTTitleButton;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;

public class DTTitleBar
extends JComponent
implements MouseListener,
Accessible,
UIResource {
    protected Icon fIcon;
    protected String fTargetName;
    protected String fTitle;
    protected String fShortTitle;
    protected String fTabTitle;
    protected String fTrimmedTitle;
    protected boolean fIsActive;
    protected boolean fIsConsideringActivation;
    protected boolean fIsSelectedTab;
    protected boolean fIsTitleShowing = true;
    protected boolean fShowActionsMenu;
    protected boolean fPromoteCloseButton;
    protected boolean fPromoteDockButton = true;
    protected boolean fPromoteRestoreButton;
    protected boolean fPromoteAnchorButton;
    protected int fTitleLowerLimit;
    protected int fTitleUpperLimit;
    protected int fFontHeight = -1;
    protected Font fTitleFont;
    protected Rectangle fIconRect;
    protected DTTitleButton fDockButton;
    protected DTTitleButton fMinimizeButton;
    protected DTTitleButton fMaximizeButton;
    protected DTTitleButton fAnchorButton;
    protected DTTitleButton fCloseButton;
    protected DTTitleButton fFurlButton;
    protected DTTitleButton fShowActionsButton;
    protected DTTitleButton fShowActionsButtonNoTitle;
    private DTTitleButton[] fButtons;
    protected final boolean fSingletonLook;
    protected final boolean fSubtle;
    protected final boolean fBrandedLook;
    protected boolean fActAsTab;
    protected Timer fContextDelayTimer;
    protected MouseEvent fPendingContextEvent;
    protected MouseAdapter fActionsMouseAdapter;
    protected StringTrimmer fTrimmer = new SimpleStringTrimmer();
    protected static final Color ALPHA_LIGHT_HIGHLIGHT = new Color(1.0f, 1.0f, 1.0f, 0.75f);
    protected static final Color ALPHA_HIGHLIGHT = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    protected static final Color ALPHA_SHADOW = new Color(0.0f, 0.0f, 0.0f, 0.2f);
    protected static final Color ALPHA_DARK_SHADOW = new Color(0.0f, 0.0f, 0.0f, 0.75f);
    protected static final Color BRANDED_ACTIVE_TITLE_TOP = new Color(42, 93, 147);
    protected static final Color BRANDED_ACTIVE_TITLE_BOTTOM = new Color(9, 58, 111);
    protected static final Color BRANDED_CONSIDERING_TOP = new Color(135, 160, 187);
    protected static final Color BRANDED_CONSIDERING_BOTTOM = new Color(126, 151, 178);
    protected static final Color TEAR_OFF_ROLL_OVER = new Color(175, 200, 235);
    protected static final Border SINGLETON_BORDER = new SingletonBorder();
    protected static final Border TAB_BORDER = new TabBorder();
    protected static final Border MAC_BORDER = new MacBorder();
    protected static final Border INTERNAL_BUTTON_BORDER = new BasicBorders.ButtonBorder(ALPHA_SHADOW, ALPHA_DARK_SHADOW, ALPHA_HIGHLIGHT, ALPHA_LIGHT_HIGHLIGHT);
    protected static final int MIN_UNTITLED_HEIGHT = 6;
    protected static final int MIN_SINGLETON_HEIGHT = 18;
    protected static final int MIN_TITLED_HEIGHT = 16;
    protected static final int MIN_BAR_HEIGHT = 18;
    static final int MIN_BAR_WIDTH = 100;
    protected static final int MIN_BUTTON_HEIGHT = 14;
    protected static final int TEAR_OFF_HEIGHT = 8;
    protected static final int TEAR_OFF_RIGHT_MARGIN = 14;
    protected static final int GRIP_BAR_COUNT = 8;
    protected static final int GRIP_BAR_HEIGHT = 3;
    protected static final Dimension SIZING_MINIMUM = new Dimension(60, 18);
    protected static final String ACTIVE_BACKGROUND = "InternalFrame.activeTitleBackground";
    protected static final String ACTIVE_TEXT = "InternalFrame.activeTitleForeground";
    protected static final String ACTIVE_GRADIENT = "InternalFrame.activeTitleGradient";
    protected static final String INACTIVE_BACKGROUND = "InternalFrame.inactiveTitleBackground";
    protected static final String INACTIVE_TEXT = "InternalFrame.inactiveTitleForeground";
    protected static final String INACTIVE_GRADIENT = "InternalFrame.inactiveTitleGradient";
    protected static final String TITLE_FONT = "InternalFrame.titleFont";
    protected static final String INTERNAL_UI_CLASS_ID = "InternalTitleBarUI";
    protected static final String MAC_UI_CLASS_ID = "MacTitleBarUI";
    protected static final String BRANDED_UI_CLASS_ID = "BrandedTitleBarUI";
    protected static final String TEAR_OFF_UI_CLASS_ID = "TearOffTitleBarUI";
    private static final boolean SHOW_SHORT_TITLE_WHEN_TAB = true;
    private static final String SHOW_ACTIONS_BUTTON_NO_TITLE_NAME = "ShowActionsButtonNoTItle";
    private static final String TEAR_OFF_CORNER_GRIP_KEY = "TearOffCornerGrip";
    private static BrandedUI sSharedBrandedUI;

    public DTTitleBar(boolean bl, boolean bl2, boolean bl3, String string) {
        this(null, null, null, null, bl, bl2, bl3, string);
    }

    public DTTitleBar(ActionListener actionListener, ActionListener actionListener2, ActionListener actionListener3, ActionListener actionListener4, boolean bl, boolean bl2, boolean bl3, String string) {
        this.fTargetName = string;
        this.setName("DesktopTitleBar");
        this.setLayout(null);
        this.fTitleFont = UIManager.getFont(TITLE_FONT);
        this.fSingletonLook = bl;
        this.fSubtle = bl2;
        this.fBrandedLook = bl3;
        this.setUI(UIManager.getUI(this));
        if (actionListener != null) {
            this.addDockButton(actionListener, false);
        }
        if (actionListener2 != null) {
            this.addMinimizeButton(actionListener2);
        }
        if (actionListener3 != null) {
            this.addMaximizeButton(actionListener3, false);
        }
        if (actionListener4 != null) {
            this.addCloseButton(actionListener4);
        }
        this.fActionsMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DTTitleBar.this.showContextMenu(mouseEvent);
            }
        };
        this.addMouseListener((MouseListener)new MouseLatch((MouseListener)this));
    }

    static DTTitleBar createSimilar(DTTitleBar dTTitleBar) {
        return new DTTitleBar(dTTitleBar.fSingletonLook, dTTitleBar.fSubtle, dTTitleBar.fBrandedLook, dTTitleBar.fTargetName);
    }

    @Override
    public BasicUI getUI() {
        return (BasicUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        if (this.fBrandedLook) {
            return BRANDED_UI_CLASS_ID;
        }
        if (PlatformInfo.isMacintosh()) {
            return MAC_UI_CLASS_ID;
        }
        return INTERNAL_UI_CLASS_ID;
    }

    @Override
    public void updateUI() {
    }

    void setTearOffUI(boolean bl) {
        boolean bl2 = this.getUI() instanceof TearOffUI;
        if (bl2 != bl) {
            if (bl) {
                this.setUI(TearOffUI.createUI(this));
            } else {
                this.setUI(UIManager.getUI(this));
            }
        }
    }

    JComponent getResizeGrip() {
        return (JComponent)this.getClientProperty(TEAR_OFF_CORNER_GRIP_KEY);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTitleBar();
        }
        return this.accessibleContext;
    }

    private DTTitleButton[] getButtons() {
        if (this.fButtons == null) {
            this.fButtons = new DTTitleButton[8];
        }
        this.fButtons[0] = this.fCloseButton;
        this.fButtons[1] = this.fDockButton;
        this.fButtons[2] = this.fMaximizeButton;
        this.fButtons[3] = this.fMinimizeButton;
        this.fButtons[4] = this.fAnchorButton;
        this.fButtons[5] = this.fFurlButton;
        this.fButtons[6] = this.fShowActionsButton;
        this.fButtons[7] = this.fShowActionsButtonNoTitle;
        return this.fButtons;
    }

    private void addDockButton(ActionListener actionListener, boolean bl) {
        this.fDockButton = bl ? this.getUI().createButton(this, 1, actionListener) : this.getUI().createButton(this, 0, actionListener);
        this.add((Component)((Object)this.fDockButton));
    }

    private void addMinimizeButton(ActionListener actionListener) {
        int n = actionListener instanceof Action ? 10 : 2;
        this.fMinimizeButton = this.getUI().createButton(this, n, actionListener);
        this.add((Component)((Object)this.fMinimizeButton));
    }

    private void addMaximizeButton(ActionListener actionListener, boolean bl) {
        int n = actionListener instanceof Action ? 10 : (bl ? 4 : 3);
        this.fMaximizeButton = this.getUI().createButton(this, n, actionListener);
        this.add((Component)((Object)this.fMaximizeButton));
    }

    private void addAnchorButton(ActionListener actionListener, boolean bl) {
        int n = bl ? 6 : 5;
        this.fAnchorButton = this.getUI().createButton(this, n, actionListener);
        this.add((Component)((Object)this.fAnchorButton));
    }

    private void addCloseButton(ActionListener actionListener) {
        this.fCloseButton = this.getUI().createButton(this, 7, actionListener);
        this.add((Component)((Object)this.fCloseButton));
    }

    private void addShowActionsButton() {
        this.fShowActionsButton = this.getUI().createButton(this, 8, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.fShowActionsButton.addMouseListener(this.fActionsMouseAdapter);
        this.add((Component)((Object)this.fShowActionsButton));
    }

    private void addShowActionsButtonNoTitle() {
        if (this.fShowActionsButtonNoTitle == null) {
            this.fShowActionsButtonNoTitle = this.getUI().createButton(this, 9, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            this.fShowActionsButtonNoTitle.addMouseListener(this.fActionsMouseAdapter);
            this.fShowActionsButtonNoTitle.setVisible(true);
            this.fShowActionsButtonNoTitle.setName(SHOW_ACTIONS_BUTTON_NO_TITLE_NAME);
        }
        this.add((Component)((Object)this.fShowActionsButtonNoTitle));
    }

    JButton createShowActionsButton() {
        DTTitleButton dTTitleButton = new DTTitleButton(8, this.fTargetName, this.fShortTitle);
        ((Component)((Object)dTTitleButton)).addMouseListener(this.fActionsMouseAdapter);
        return dTTitleButton;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    public void setIcon(Icon icon) {
        if (this.fIcon != icon) {
            Icon icon2 = this.fIcon;
            this.fIcon = icon;
            Rectangle rectangle = this.fIconRect = icon == null ? null : new Rectangle(2, 1, icon.getIconWidth(), icon.getIconHeight());
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, this.fIcon);
            }
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    boolean isOnIcon(int n, int n2) {
        return this.fIsTitleShowing && this.fIconRect != null && this.fIconRect.contains(n, n2);
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setTitle(String string) {
        if (this.fTitle == string) {
            return;
        }
        String string2 = this.accessibleContext == null ? null : this.accessibleContext.getAccessibleName();
        this.fTitle = string;
        this.fTrimmedTitle = null;
        this.setToolTipText(string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, this.accessibleContext.getAccessibleName());
        }
        if (this.isShowing()) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getShortTitle() {
        return this.fShortTitle;
    }

    public void setShortTitle(String string) {
        DTTitleButton[] dTTitleButtonArray;
        if (this.fShortTitle == string) {
            return;
        }
        this.fShortTitle = string;
        for (DTTitleButton dTTitleButton : dTTitleButtonArray = this.getButtons()) {
            if (dTTitleButton == null) continue;
            dTTitleButton.setTargetShortTitle(string);
        }
        if (this.isShowing() && this.fActAsTab && this.fTabTitle == null) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setTabTitle(String string) {
        this.fTabTitle = string;
        if (this.isShowing() && this.fActAsTab) {
            this.revalidate();
            this.repaint();
        }
    }

    public String getTabTitle() {
        return this.fTabTitle != null ? this.fTabTitle : this.fShortTitle;
    }

    public StringTrimmer getTrimmer() {
        return this.fTrimmer;
    }

    public void setTrimmer(StringTrimmer stringTrimmer) {
        if (stringTrimmer == null) {
            if (!(this.fTrimmer instanceof SimpleStringTrimmer) || ((SimpleStringTrimmer)this.fTrimmer).getDirection() != 1 || ((SimpleStringTrimmer)this.fTrimmer).getStartIndex() != -1) {
                this.fTrimmer = new SimpleStringTrimmer();
            }
        } else {
            this.fTrimmer = stringTrimmer;
        }
    }

    public void setActive(boolean bl) {
        if (this.fIsActive != bl && !this.fSubtle) {
            DTTitleButton[] dTTitleButtonArray;
            this.fIsActive = bl;
            for (DTTitleButton dTTitleButton : dTTitleButtonArray = this.getButtons()) {
                if (dTTitleButton == null) continue;
                dTTitleButton.setActive(bl);
            }
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public void setConsideringActivation(boolean bl) {
        if (bl != this.fIsConsideringActivation) {
            this.fIsConsideringActivation = bl;
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public void setIsSelectedTab(boolean bl) {
        if (this.fIsSelectedTab != bl) {
            this.fIsSelectedTab = bl;
            if (this.fActAsTab) {
                this.updateButtonVisibility();
                this.revalidate();
                this.repaint();
            }
        }
    }

    public boolean isSelected() {
        return this.fIsSelectedTab;
    }

    public void setTitleShowing(boolean bl) {
        if (this.fIsTitleShowing != bl) {
            DTTabbedPane dTTabbedPane;
            this.fIsTitleShowing = bl;
            if (!this.fIsTitleShowing) {
                this.addShowActionsButtonNoTitle();
            } else {
                this.remove((Component)((Object)this.fShowActionsButtonNoTitle));
            }
            this.updateButtonVisibility();
            this.revalidate();
            this.repaint();
            if (this.fActAsTab && (dTTabbedPane = (DTTabbedPane)((Object)SwingUtilities.getAncestorOfClass(DTTabbedPane.class, this))) != null) {
                dTTabbedPane.revalidate();
                dTTabbedPane.repaint();
            }
        }
    }

    public boolean isTitleShowing() {
        return this.fIsTitleShowing;
    }

    public void setShowActionMenu(boolean bl) {
        if (this.fShowActionsMenu != bl) {
            this.fShowActionsMenu = bl;
            if (bl && this.fShowActionsButton == null) {
                this.addShowActionsButton();
            }
            this.updateButtonVisibility();
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isShowingActionsMenu() {
        return this.fShowActionsMenu;
    }

    JButton getShowActionsButton() {
        if (this.fShowActionsButton != null && this.fShowActionsButton.isVisible()) {
            return this.fShowActionsButton;
        }
        if (this.fShowActionsButtonNoTitle != null && this.fShowActionsButtonNoTitle.isVisible()) {
            return this.fShowActionsButtonNoTitle;
        }
        return null;
    }

    public void setPromoteClose(boolean bl) {
        if (bl != this.fPromoteCloseButton) {
            this.fPromoteCloseButton = bl;
            this.updateButtonVisibility();
            this.revalidate();
            this.repaint();
        }
    }

    public void setPromoteDock(boolean bl) {
        if (bl != this.fPromoteDockButton) {
            this.fPromoteDockButton = bl;
            this.updateButtonVisibility();
            this.revalidate();
            this.repaint();
        }
    }

    public void setPromoteRestore(boolean bl) {
        if (bl != this.fPromoteRestoreButton) {
            this.fPromoteRestoreButton = bl;
            this.updateButtonVisibility();
            this.revalidate();
            this.repaint();
        }
    }

    public void setPromoteAnchor(boolean bl) {
        if (bl != this.fPromoteAnchorButton) {
            this.fPromoteAnchorButton = bl;
            this.updateButtonVisibility();
            this.revalidate();
            this.repaint();
        }
    }

    void setActAsTab(boolean bl) {
        if (this.fActAsTab != bl) {
            this.fActAsTab = bl;
            BasicUI basicUI = this.getUI();
            this.setBorder(bl ? basicUI.createTabBorder() : basicUI.createBorder());
            this.updateButtonVisibility();
            this.revalidate();
            this.repaint();
        }
    }

    private boolean hasTitle() {
        return !this.fActAsTab && this.fTitle != null || this.fActAsTab && this.getTabTitle() != null;
    }

    private boolean showButtons() {
        return this.fIsTitleShowing && (!this.fActAsTab || this.fIsSelectedTab);
    }

    private boolean showButtonType(DTTitleButton dTTitleButton) {
        boolean bl = dTTitleButton.getType() == 8;
        return this.fShowActionsMenu && bl || !this.fShowActionsMenu && !bl || dTTitleButton.getType() == 0 && this.fPromoteDockButton || dTTitleButton.getType() == 7 && this.fPromoteCloseButton || dTTitleButton.getType() == 5 && this.fPromoteAnchorButton || dTTitleButton.getCurrentType() == 4 && this.fPromoteRestoreButton;
    }

    private void updateButtonVisibility() {
        DTTitleButton[] dTTitleButtonArray;
        boolean bl = this.showButtons();
        for (DTTitleButton dTTitleButton : dTTitleButtonArray = this.getButtons()) {
            if (dTTitleButton == null || dTTitleButton.getName().equals(SHOW_ACTIONS_BUTTON_NO_TITLE_NAME)) continue;
            dTTitleButton.setVisible(bl && this.showButtonType(dTTitleButton));
        }
    }

    public void setIsDocked(boolean bl) {
        if (this.fDockButton != null) {
            this.fDockButton.setType(bl ? 1 : 0);
        }
    }

    public void setIsMaximized(boolean bl) {
        if (this.fMaximizeButton != null) {
            this.fMaximizeButton.setType(bl ? 4 : 3);
        }
    }

    public void setDockListener(ActionListener actionListener, boolean bl) {
        DTTitleButton dTTitleButton = this.fDockButton;
        if (this.fDockButton != null) {
            this.remove((Component)((Object)this.fDockButton));
        }
        if (actionListener == null) {
            this.fDockButton = null;
        } else {
            this.addDockButton(actionListener, bl);
        }
        if (dTTitleButton != this.fDockButton) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setMinimizeListener(ActionListener actionListener) {
        DTTitleButton dTTitleButton = this.fMinimizeButton;
        if (this.fMinimizeButton != null) {
            this.remove((Component)((Object)this.fMinimizeButton));
        }
        if (actionListener == null) {
            this.fMinimizeButton = null;
        } else {
            this.addMinimizeButton(actionListener);
        }
        if (dTTitleButton != this.fMinimizeButton) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setMaximizeListener(ActionListener actionListener, boolean bl) {
        DTTitleButton dTTitleButton = this.fMaximizeButton;
        if (this.fMaximizeButton != null) {
            this.remove((Component)((Object)this.fMaximizeButton));
        }
        if (actionListener == null) {
            this.fMaximizeButton = null;
        } else {
            this.addMaximizeButton(actionListener, bl);
        }
        if (dTTitleButton != this.fMaximizeButton) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setCloseListener(ActionListener actionListener) {
        DTTitleButton dTTitleButton = this.fCloseButton;
        if (this.fCloseButton != null) {
            this.remove((Component)((Object)this.fCloseButton));
        }
        if (actionListener == null) {
            this.fCloseButton = null;
        } else {
            this.addCloseButton(actionListener);
        }
        if (dTTitleButton != this.fCloseButton) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setAnchorListener(ActionListener actionListener, boolean bl) {
        DTTitleButton dTTitleButton = this.fAnchorButton;
        if (this.fAnchorButton != null) {
            this.remove((Component)((Object)this.fAnchorButton));
        }
        if (actionListener == null) {
            this.fAnchorButton = null;
        } else {
            this.addAnchorButton(actionListener, bl);
        }
        if (dTTitleButton != this.fAnchorButton) {
            this.revalidate();
            this.repaint();
        }
    }

    void setFurlAction(Action action) {
        DTTitleButton dTTitleButton = this.fFurlButton;
        if (action != null) {
            if (this.fFurlButton == null) {
                this.fFurlButton = this.getUI().createButton(this, 10, action);
                this.add((Component)((Object)this.fFurlButton));
            } else {
                this.fFurlButton.setAction(action);
            }
        } else if (this.fFurlButton != null) {
            this.remove((Component)((Object)this.fFurlButton));
            this.fFurlButton = null;
        }
        if (dTTitleButton != this.fCloseButton) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public String getToolTipText() {
        if (this.fActAsTab) {
            return this.fTitle != null && (!this.fIsTitleShowing || !this.fTitle.equals(this.fShortTitle)) ? this.fTitle : null;
        }
        return this.fTrimmedTitle != null && this.fTrimmedTitle != this.fTitle || !this.fIsTitleShowing ? this.fTitle : null;
    }

    private FontMetrics getTitleFontMetrics() {
        if (!this.isDisplayable()) {
            return null;
        }
        return this.getFontMetrics(this.fTitleFont);
    }

    @Override
    public void doLayout() {
        this.getUI().doLayout(this);
        this.fTrimmedTitle = null;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.fContextDelayTimer != null) {
                this.fContextDelayTimer.stop();
                this.fContextDelayTimer = null;
            }
            if (this.isOnIcon(mouseEvent.getX(), mouseEvent.getY())) {
                if (this.fCloseButton != null) {
                    ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), 1001, this.fCloseButton.getActionCommand(), mouseEvent.getModifiers());
                    this.fCloseButton.getActionListener().actionPerformed(actionEvent);
                    mouseEvent.consume();
                }
            } else if (this.fMaximizeButton != null) {
                ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), 1001, this.fMaximizeButton.getActionCommand(), mouseEvent.getModifiers());
                this.fMaximizeButton.getActionListener().actionPerformed(actionEvent);
                mouseEvent.consume();
            }
        } else {
            this.checkContextTriggers(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkContextTriggers(mouseEvent);
    }

    void checkContextTriggers(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (this.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.showContextMenu(mouseEvent);
                mouseEvent.consume();
            }
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.isOnIcon(mouseEvent.getX(), mouseEvent.getY())) {
            this.fPendingContextEvent = mouseEvent;
            this.fContextDelayTimer = new Timer(MJUtilities.getDoubleClickInterval(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DTTitleBar.this.fContextDelayTimer != null) {
                        DTTitleBar.this.showContextMenu(DTTitleBar.this.fPendingContextEvent);
                    }
                }
            });
            this.fContextDelayTimer.setRepeats(false);
            this.fContextDelayTimer.start();
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isMiddleMouseButton(mouseEvent) && this.fCloseButton != null) {
            ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), 1001, this.fCloseButton.getActionCommand(), mouseEvent.getModifiers());
            this.fCloseButton.getActionListener().actionPerformed(actionEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void showContextMenu(MouseEvent mouseEvent) {
        Object object;
        Component component = (Component)mouseEvent.getSource();
        if (!component.isShowing()) {
            return;
        }
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.setCleanupUponClose(true);
        Icon icon = null;
        if (this.fAnchorButton != null) {
            icon = this.fAnchorButton.getActionListener() instanceof Action ? (Icon)((Action)this.fAnchorButton.getActionListener()).getValue("SmallIcon") : Desktop.ANCHOR_ICON;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.fCloseButton != null && (icon == null || icon == Desktop.DETACH_ICON)) {
            object = DTTitleBar.createMenuItemFromButton(this.fCloseButton, Desktop.CLOSE_ICON, this.fShowActionsMenu, DTMenuMergeTag.CLOSE);
            if (icon == Desktop.DETACH_ICON) {
                ((AbstractButton)object).setText(MJUtilities.exciseMnemonic((String)Desktop.getString(this, "menuitem.Hide")));
            }
            arrayList.add(object);
        }
        if (this.fAnchorButton != null && icon == Desktop.ANCHOR_ICON) {
            arrayList.add(DTTitleBar.createMenuItemFromButton(this.fAnchorButton, icon, this.fShowActionsMenu, null));
        }
        if (this.fDockButton != null) {
            boolean bl = this.fDockButton.getType() == 0;
            arrayList.add(DTTitleBar.createMenuItemFromButton(this.fDockButton, bl ? Desktop.DOCK_ICON : Desktop.UNDOCK_ICON, this.fShowActionsMenu, bl ? DTMenuMergeTag.DOCK : DTMenuMergeTag.UNDOCK));
        }
        if (this.fAnchorButton != null && icon == Desktop.DETACH_ICON) {
            arrayList.add(DTTitleBar.createMenuItemFromButton(this.fAnchorButton, icon, this.fShowActionsMenu, null));
        }
        if (this.fMaximizeButton != null) {
            object = Desktop.MAXIMIZE_ICON;
            if (this.fMaximizeButton.getType() == 10 && this.fMaximizeButton.getActionListener() instanceof Action) {
                object = (Icon)((Action)this.fMaximizeButton.getActionListener()).getValue("SmallIcon");
            } else if (this.fMaximizeButton.getType() == 4) {
                object = Desktop.RESTORE_ICON;
            }
            arrayList.add(DTTitleBar.createMenuItemFromButton(this.fMaximizeButton, (Icon)object, this.fShowActionsMenu, DTMenuMergeTag.MAXIMIZE));
        }
        if (this.fMinimizeButton != null) {
            object = Desktop.MINIMIZE_ICON;
            if (this.fMinimizeButton.getType() == 10 && this.fMinimizeButton.getActionListener() instanceof Action) {
                object = (Icon)((Action)this.fMinimizeButton.getActionListener()).getValue("SmallIcon");
            }
            arrayList.add(DTTitleBar.createMenuItemFromButton(this.fMinimizeButton, (Icon)object, this.fShowActionsMenu, DTMenuMergeTag.MINIMIZE));
        }
        if (this.fShowActionsMenu) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                mJPopupMenu.add((JMenuItem)arrayList.get(i));
            }
        } else {
            for (JMenuItem jMenuItem : arrayList) {
                mJPopupMenu.add(jMenuItem);
            }
        }
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof DTMenuContributor)) continue;
            ((DTMenuContributor)((Object)container)).contributeToMenu((JPopupMenu)mJPopupMenu, mouseEvent);
        }
        if (mJPopupMenu.getComponentCount() > 0 && mJPopupMenu.getComponent(mJPopupMenu.getComponentCount() - 1) instanceof JSeparator) {
            mJPopupMenu.remove(mJPopupMenu.getComponentCount() - 1);
        }
        if (mJPopupMenu.getComponentCount() > 0) {
            mJPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static JMenuItem createMenuItemFromButton(DTTitleButton dTTitleButton, Icon icon, boolean bl, DTMenuMergeTag dTMenuMergeTag) {
        MJMenuItem mJMenuItem = new MJMenuItem(bl ? dTTitleButton.getGenericTip() : dTTitleButton.getToolTipText());
        ActionListener actionListener = dTTitleButton.getActionListener();
        mJMenuItem.addActionListener(actionListener);
        mJMenuItem.setActionCommand(dTTitleButton.getActionCommand());
        mJMenuItem.setIcon(icon);
        String string = dTTitleButton.getName();
        if (string.endsWith("Button")) {
            string = string.substring(0, string.length() - 6);
        }
        mJMenuItem.setName(string + "MenuItem");
        if (dTMenuMergeTag != null) {
            dTMenuMergeTag.setTag((JMenuItem)mJMenuItem);
        }
        if (actionListener instanceof MJAbstractAction) {
            mJMenuItem.setAccelerator(((ExtendedAction)actionListener).getAccelerator());
        }
        return mJMenuItem;
    }

    static Color darkenSlightly(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float f = 0.8f;
        if (PlatformInfo.isWindowsXPAppearance() && PlatformInfo.getWindowsColorScheme() == 2) {
            f = 0.88f;
        } else if (PlatformInfo.isMacintosh()) {
            f = 0.9f;
        }
        return Color.getHSBColor(fArray[0], fArray[1], f * fArray[2]);
    }

    static {
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.put(INTERNAL_UI_CLASS_ID, "com.mathworks.widgets.desk.DTTitleBar$InternalUI");
        uIDefaults.put(MAC_UI_CLASS_ID, "com.mathworks.widgets.desk.DTTitleBar$MacUI");
        uIDefaults.put(BRANDED_UI_CLASS_ID, "com.mathworks.widgets.desk.DTTitleBar$BrandedUI");
        uIDefaults.put(TEAR_OFF_UI_CLASS_ID, "com.mathworks.widgets.desk.DTTitleBar$TearOffUI");
    }

    private class AccessibleTitleBar
    extends JComponent.AccessibleJComponent {
        private AccessibleTitleBar() {
            super(DTTitleBar.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            String string = DTTitleBar.this.getTitle();
            if (string != null) {
                return string;
            }
            return super.getAccessibleName();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return new TitleBarRole("titlebar");
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleContext accessibleContext;
            Icon icon = DTTitleBar.this.getIcon();
            if (icon instanceof Accessible && (accessibleContext = ((Accessible)((Object)icon)).getAccessibleContext()) != null && accessibleContext instanceof AccessibleIcon) {
                return new AccessibleIcon[]{(AccessibleIcon)((Object)accessibleContext)};
            }
            return null;
        }

        @Override
        public AccessibleRelationSet getAccessibleRelationSet() {
            DTClientFrame dTClientFrame;
            AccessibleRelationSet accessibleRelationSet = super.getAccessibleRelationSet();
            if (!accessibleRelationSet.contains(AccessibleRelation.CONTROLLER_FOR) && (dTClientFrame = (DTClientFrame)((Object)SwingUtilities.getAncestorOfClass(DTClientFrame.class, DTTitleBar.this))) != null) {
                AccessibleRelation accessibleRelation = new AccessibleRelation(AccessibleRelation.CONTROLLER_FOR, dTClientFrame.getClient().getComponent());
                accessibleRelationSet.add(accessibleRelation);
            }
            return accessibleRelationSet;
        }
    }

    private class TitleBarRole
    extends AccessibleRole {
        TitleBarRole(String string) {
            super(string);
        }

        @Override
        public String toDisplayString() {
            return Desktop.getString(DTTitleBar.this, "accessibleRole.titlebar");
        }
    }

    private static class MacBorder
    extends AbstractBorder {
        private MacBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 1;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(0, n4 - 1, n + n3 - 1, n4 - 1);
            graphics.setColor(color);
        }
    }

    private static class TabBorder
    extends AbstractBorder {
        private TabBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 1;
            insets.left = 1;
            insets.bottom = 0;
            insets.top = 1;
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            DTTitleBar dTTitleBar = (DTTitleBar)component;
            Color color = graphics.getColor();
            Color color2 = DTBorderFactory.DockedFrameBorder.getLineColor(dTTitleBar.fIsActive, false, false);
            if (!dTTitleBar.fIsSelectedTab && !PlatformInfo.isWindowsClassicAppearance()) {
                color2 = DTTitleBar.darkenSlightly(color2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n + 1, n2, n + n3 - 1, n2);
            graphics.setColor(ALPHA_HIGHLIGHT);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.setColor(ALPHA_SHADOW);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(color);
        }
    }

    private static class SingletonBorder
    extends AbstractBorder {
        private SingletonBorder() {
        }

        static boolean needSeparator(Component component) {
            Container container = component.getParent();
            if (!(container instanceof DTInternalFrame)) {
                return true;
            }
            DTInternalFrame dTInternalFrame = (DTInternalFrame)((Object)container);
            if (dTInternalFrame.isAnyToolBarVisible()) {
                return true;
            }
            if (dTInternalFrame instanceof DTClientFrame && ((DTClientFrame)dTInternalFrame).getClient().wantsTopSeparator()) {
                return true;
            }
            if (dTInternalFrame.hasToolBar()) {
                return false;
            }
            return SingletonBorder.containsToolBar((Component)((Object)dTInternalFrame));
        }

        static boolean containsToolBar(Component component) {
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2 = container.getComponent(i);
                    if (!(component2 instanceof JToolBar) && !SingletonBorder.containsToolBar(component2)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(0, 0, 0, 0);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 0;
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            if (SingletonBorder.needSeparator(component)) {
                insets.bottom = 2;
            }
            return insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (SingletonBorder.needSeparator(component)) {
                Color color = graphics.getColor();
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                graphics.setColor(UIManager.getColor("controlLtHighlight"));
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                graphics.setColor(color);
            }
        }
    }

    private static class TearOffCornerGrip
    extends JComponent {
        private int fCursor = 0;

        private TearOffCornerGrip() {
            this.setOpaque(false);
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    int n;
                    Point point = mouseEvent.getPoint();
                    int n2 = n = point.y < point.x ? 7 : 0;
                    if (n != TearOffCornerGrip.this.fCursor) {
                        TearOffCornerGrip.this.setCursor(Cursor.getPredefinedCursor(n));
                        TearOffCornerGrip.this.fCursor = n;
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (TearOffCornerGrip.this.fCursor != 0) {
                        TearOffCornerGrip.this.setCursor(Cursor.getDefaultCursor());
                        TearOffCornerGrip.this.fCursor = 0;
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(ALPHA_SHADOW);
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n - n2;
            int n4 = 0;
            int n5 = n;
            int n6 = n2;
            while (n3 < n) {
                graphics.drawLine(n3, n4, n5, n6);
                n3 += 2;
                n6 -= 2;
            }
        }
    }

    public static class TearOffUI
    extends BasicUI {
        private MouseListener fRolloverListener;
        private boolean fIsMouseOver;

        public static ComponentUI createUI(JComponent jComponent) {
            return new TearOffUI();
        }

        @Override
        public void installUI(JComponent jComponent) {
            jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 14));
            this.fRolloverListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    TearOffUI.this.fIsMouseOver = true;
                    mouseEvent.getComponent().repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    TearOffUI.this.fIsMouseOver = false;
                    mouseEvent.getComponent().repaint();
                }
            };
            jComponent.addMouseListener(this.fRolloverListener);
            DTTitleBar dTTitleBar = (DTTitleBar)jComponent;
            dTTitleBar.setTitleShowing(false);
            dTTitleBar.fShowActionsButtonNoTitle.setVisible(false);
            for (DTTitleButton dTTitleButton : dTTitleBar.fButtons) {
                if (dTTitleButton == null) continue;
                dTTitleButton.setParentUsesActiveColor(false);
            }
            TearOffCornerGrip tearOffCornerGrip = new TearOffCornerGrip();
            jComponent.add(tearOffCornerGrip);
            jComponent.putClientProperty(DTTitleBar.TEAR_OFF_CORNER_GRIP_KEY, tearOffCornerGrip);
        }

        @Override
        public void uninstallUI(JComponent jComponent) {
            if (this.fRolloverListener != null) {
                jComponent.removeMouseListener(this.fRolloverListener);
                this.fRolloverListener = null;
            }
            ((DTTitleBar)jComponent).setTitleShowing(true);
            DTTitleBar dTTitleBar = (DTTitleBar)jComponent;
            dTTitleBar.setTitleShowing(true);
            for (DTTitleButton dTTitleButton : dTTitleBar.fButtons) {
                if (dTTitleButton == null) continue;
                dTTitleButton.setParentUsesActiveColor(true);
            }
            JComponent jComponent2 = (JComponent)jComponent.getClientProperty(DTTitleBar.TEAR_OFF_CORNER_GRIP_KEY);
            jComponent.remove(jComponent2);
            jComponent.putClientProperty(DTTitleBar.TEAR_OFF_CORNER_GRIP_KEY, null);
        }

        @Override
        protected Dimension calculateSize(JComponent jComponent, boolean bl) {
            return new Dimension(100, 8);
        }

        @Override
        void doLayout(DTTitleBar dTTitleBar) {
            int n = dTTitleBar.getWidth();
            int n2 = dTTitleBar.getHeight();
            JComponent jComponent = (JComponent)dTTitleBar.getClientProperty(DTTitleBar.TEAR_OFF_CORNER_GRIP_KEY);
            jComponent.setBounds(n - n2, 0, n2, n2);
            super.doLayout(dTTitleBar);
        }

        @Override
        public boolean contains(JComponent jComponent, int n, int n2) {
            Dimension dimension = jComponent.getSize();
            Insets insets = jComponent.getInsets();
            return n >= insets.left && n <= dimension.width - insets.right && n2 >= insets.top + 1 && n2 <= dimension.height - insets.bottom;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            graphics.setColor(this.fIsMouseOver ? TEAR_OFF_ROLL_OVER : UIManager.getColor("control"));
            graphics.fillRect(0, 0, n, n2);
            int n3 = 15;
            int n4 = (n - n3) / 2;
            int n5 = (n2 - 3) / 2;
            graphics.setColor(ALPHA_SHADOW);
            int n6 = 0;
            while (n6 < 8) {
                graphics.drawLine(n4, n5, n4, n5 + 3);
                ++n6;
                n4 += 2;
            }
        }
    }

    public static class BrandedUI
    extends InternalUI {
        public static ComponentUI createUI(JComponent jComponent) {
            if (sSharedBrandedUI == null) {
                sSharedBrandedUI = new BrandedUI();
            }
            return sSharedBrandedUI;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Paint paint;
            Color color;
            Color color2;
            Color color3;
            DTTitleBar dTTitleBar = (DTTitleBar)jComponent;
            Insets insets = jComponent.getInsets();
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            int n3 = insets.top;
            int n4 = n2 - n3;
            if (dTTitleBar.fIsActive && !dTTitleBar.fSubtle) {
                color3 = Color.white;
                color2 = BRANDED_ACTIVE_TITLE_TOP;
                color = BRANDED_ACTIVE_TITLE_BOTTOM;
            } else if (dTTitleBar.fIsConsideringActivation) {
                color3 = Color.white;
                color2 = BRANDED_CONSIDERING_TOP;
                color = BRANDED_CONSIDERING_BOTTOM;
            } else {
                paint = UIManager.getColor("control");
                color = ColorUtils.darker((Color)paint, (double)0.95);
                if (dTTitleBar.fActAsTab && !dTTitleBar.fIsSelectedTab) {
                    color3 = Color.gray;
                    color2 = ColorUtils.darker((Color)paint, (double)0.85);
                } else {
                    color3 = Color.darkGray;
                    color2 = Color.white;
                }
                if (dTTitleBar.isActive() && dTTitleBar.fSubtle) {
                    color3 = Color.black;
                }
            }
            if (!dTTitleBar.fSingletonLook && dTTitleBar.fIsActive) {
                color2 = ColorUtils.fade((Color)color2);
                color = ColorUtils.darker((Color)color2, (double)0.85);
            }
            paint = new GradientPaint(0.0f, n3, color2, 0.0f, n2, color, true);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint2 = graphics2D.getPaint();
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, n3, n, n4);
            graphics2D.setPaint(paint2);
            BrandedUI.drawTitleString(graphics, dTTitleBar, color3);
        }
    }

    public static class MacUI
    extends BasicUI {
        public static ComponentUI createUI(JComponent jComponent) {
            return new MacUI();
        }

        @Override
        public void installUI(JComponent jComponent) {
            jComponent.setBorder(MAC_BORDER);
        }

        @Override
        Border createBorder() {
            return MAC_BORDER;
        }

        @Override
        Border createTabBorder() {
            return TAB_BORDER;
        }

        @Override
        protected Dimension calculateSize(JComponent jComponent, boolean bl) {
            Dimension dimension = super.calculateSize(jComponent, bl);
            DTTitleBar dTTitleBar = (DTTitleBar)jComponent;
            if (dTTitleBar.hasTitle() && dTTitleBar.isTitleShowing()) {
                Insets insets = jComponent.getInsets();
                dimension.height = dTTitleBar.fFontHeight + insets.top + insets.bottom + 2;
                if (dimension.height < 18) {
                    dimension.height = 18;
                }
                dimension.width += 8;
            }
            return dimension;
        }

        @Override
        void doLayout(DTTitleBar dTTitleBar) {
            Dimension dimension = dTTitleBar.getSize();
            Insets insets = dTTitleBar.getInsets();
            int n = dimension.height - 4;
            int n2 = n + 2;
            int n3 = 6;
            int n4 = 2 - insets.bottom / 2;
            for (DTTitleButton dTTitleButton : new DTTitleButton[]{dTTitleBar.fCloseButton, dTTitleBar.fDockButton, dTTitleBar.fMinimizeButton, dTTitleBar.fFurlButton, dTTitleBar.fMaximizeButton, dTTitleBar.fAnchorButton, dTTitleBar.fShowActionsButton}) {
                if (dTTitleButton == null || !dTTitleButton.isVisible()) continue;
                dTTitleButton.setBounds(n3, n4, n2, n);
                n3 += n2;
            }
            dTTitleBar.fTitleLowerLimit = n3;
            dTTitleBar.fTitleUpperLimit = dimension.width - 4;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            int n;
            Object object;
            Color color;
            Object object2;
            Color color2;
            int n2;
            DTTitleBar dTTitleBar = (DTTitleBar)jComponent;
            Insets insets = jComponent.getInsets();
            int n3 = jComponent.getWidth();
            int n4 = jComponent.getHeight();
            int n5 = insets.top;
            int n6 = n4 - n5;
            int n7 = n2 = dTTitleBar.fIcon == null ? 0 : dTTitleBar.fIcon.getIconWidth();
            if (dTTitleBar.fIsActive) {
                color2 = ColorUtils.MAC_ACTIVE_MIDDLE_COLOR.darker();
                object2 = ColorUtils.MAC_ACTIVE_BOTTOM_COLOR.darker();
                color = Color.white;
            } else {
                color2 = ColorUtils.MAC_INACTIVE_MIDDLE_COLOR;
                object2 = ColorUtils.MAC_INACTIVE_BOTTOM_COLOR;
                color = UIManager.getColor("textInactiveText");
                if (dTTitleBar.fActAsTab && !dTTitleBar.fIsSelectedTab) {
                    object = color2;
                    color2 = object2;
                    object2 = object;
                    color = color.brighter();
                }
            }
            object = (Graphics2D)graphics;
            int n8 = 4 * n6 / 10;
            Paint paint = ((Graphics2D)object).getPaint();
            GradientPaint gradientPaint = new GradientPaint(0.0f, n5 + n8, color2, 0.0f, n5 + n4, (Color)object2, true);
            ((Graphics2D)object).setPaint(gradientPaint);
            ((Graphics)object).fillRect(0, n5, n3, n6);
            ((Graphics2D)object).setPaint(paint);
            if (!dTTitleBar.isTitleShowing()) {
                return;
            }
            if (dTTitleBar.fTitle == null) {
                n = (dTTitleBar.fTitleUpperLimit + dTTitleBar.fTitleLowerLimit - n2) / 2;
            } else {
                int n9;
                String string;
                Font font = graphics.getFont();
                MacUI.updateFont(dTTitleBar);
                graphics.setFont(dTTitleBar.fTitleFont);
                graphics.setColor(color);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n10 = (n6 - fontMetrics.getHeight() - 1) / 2 + fontMetrics.getLeading() + fontMetrics.getAscent();
                if (dTTitleBar.fActAsTab) {
                    string = dTTitleBar.getTabTitle();
                } else {
                    if (dTTitleBar.fTrimmedTitle == null) {
                        n9 = dTTitleBar.fTitleUpperLimit - dTTitleBar.fTitleLowerLimit - n2 - 4;
                        dTTitleBar.fTrimmedTitle = dTTitleBar.fTrimmer.shortenString(dTTitleBar.fTitle, fontMetrics, n9);
                    }
                    string = dTTitleBar.fTrimmedTitle;
                }
                n9 = fontMetrics.stringWidth(string);
                n = (n3 - n9) / 2;
                if (n < dTTitleBar.fTitleLowerLimit + n2 + 4) {
                    n = dTTitleBar.fTitleLowerLimit + n2 + 4;
                }
                graphics.drawString(string, n, n5 + n10);
                n -= n2 + 4;
                graphics.setFont(font);
            }
            if (dTTitleBar.fIcon != null) {
                dTTitleBar.fIcon.paintIcon(jComponent, graphics, n, n5 + 1);
            }
            MacUI.drawEnds(graphics, dTTitleBar);
        }
    }

    public static class InternalUI
    extends BasicUI {
        public static ComponentUI createUI(JComponent jComponent) {
            return new InternalUI();
        }

        @Override
        public void installUI(JComponent jComponent) {
            if (((DTTitleBar)jComponent).fSingletonLook) {
                jComponent.setBorder(this.createBorder());
            }
        }

        @Override
        DTTitleButton createButton(DTTitleBar dTTitleBar, int n, ActionListener actionListener) {
            DTTitleButton dTTitleButton = super.createButton(dTTitleBar, n, actionListener);
            if (!PlatformInfo.isMacintosh()) {
                dTTitleButton.setFlyOverAppearance(true);
            }
            dTTitleButton.setBackground(new Color(0, 0, 0, 0));
            dTTitleButton.setOpaque(false);
            dTTitleButton.setBorder(INTERNAL_BUTTON_BORDER);
            dTTitleButton.updateIcons();
            return dTTitleButton;
        }

        @Override
        Border createBorder() {
            return SINGLETON_BORDER;
        }

        @Override
        Border createTabBorder() {
            return TAB_BORDER;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Color color;
            DTTitleBar dTTitleBar = (DTTitleBar)jComponent;
            Insets insets = jComponent.getInsets();
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            int n3 = insets.top;
            int n4 = n2 - n3;
            if (dTTitleBar.fSingletonLook) {
                Paint paint;
                color = dTTitleBar.fIsActive ? (PlafUtils.isPlasticLookAndFeel() || PlatformInfo.isWindowsXPAppearance() && PlatformInfo.getWindowsColorScheme() == 2 ? Color.white : UIManager.getColor(DTTitleBar.ACTIVE_TEXT)) : UIManager.getColor("textInactiveText").darker();
                Color color2 = InternalUI.getTopColor(dTTitleBar.fIsActive);
                Color color3 = InternalUI.getBottomColor(dTTitleBar.fIsActive);
                if (dTTitleBar.fActAsTab && !dTTitleBar.fIsSelectedTab) {
                    if (MJUtilities.isHighContrast()) {
                        color = Color.gray;
                    } else {
                        paint = color2;
                        color2 = color3;
                        color3 = paint;
                        color = color.brighter();
                    }
                }
                paint = new GradientPaint(0.0f, n3, color2, 0.0f, n2, color3, true);
                Graphics2D graphics2D = (Graphics2D)graphics;
                Paint paint2 = graphics2D.getPaint();
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, n3, n, n4);
                graphics2D.setPaint(paint2);
            } else {
                color = UIManager.getColor(dTTitleBar.fIsActive ? DTTitleBar.ACTIVE_TEXT : DTTitleBar.INACTIVE_TEXT);
                Color color4 = UIManager.getColor(dTTitleBar.fIsActive ? DTTitleBar.ACTIVE_BACKGROUND : DTTitleBar.INACTIVE_BACKGROUND);
                Boolean bl = (Boolean)LookAndFeel.getDesktopPropertyValue("win.frame.captionGradientsOn", Boolean.FALSE);
                if (bl.booleanValue()) {
                    Color color5 = UIManager.getColor(dTTitleBar.fIsActive ? DTTitleBar.ACTIVE_GRADIENT : DTTitleBar.INACTIVE_GRADIENT);
                    color4 = new Color((color4.getRed() + color5.getRed()) / 2, (color4.getGreen() + color5.getGreen()) / 2, (color4.getBlue() + color5.getBlue()) / 2);
                } else if (dTTitleBar.fIsActive && !PlatformInfo.isMacintosh()) {
                    color4 = ColorUtils.fade((Color)color4);
                }
                graphics.setColor(color4);
                graphics.fillRect(0, n3, n, n4);
            }
            InternalUI.drawTitleString(graphics, dTTitleBar, color);
            InternalUI.drawEnds(graphics, dTTitleBar);
        }

        protected static void drawTitleString(Graphics graphics, DTTitleBar dTTitleBar, Color color) {
            if (dTTitleBar.isTitleShowing()) {
                int n = 2;
                int n2 = dTTitleBar.getInsets().top;
                int n3 = dTTitleBar.getHeight();
                int n4 = n3 - n2;
                if (dTTitleBar.fIcon != null) {
                    dTTitleBar.fIcon.paintIcon(dTTitleBar, graphics, n, n2 + 1);
                    n += dTTitleBar.fIcon.getIconWidth() + 2;
                }
                if (dTTitleBar.hasTitle()) {
                    Font font = graphics.getFont();
                    InternalUI.updateFont(dTTitleBar);
                    graphics.setFont(dTTitleBar.fTitleFont);
                    graphics.setColor(color);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n5 = (n4 - fontMetrics.getHeight()) / 2 + fontMetrics.getLeading() + fontMetrics.getAscent() - 1;
                    n += 3;
                    n += InternalUI.drawTitleString(dTTitleBar, graphics, fontMetrics, n, n2 + n5) + 4;
                    graphics.setFont(font);
                }
            }
        }

        static Color getBottomColor(boolean bl) {
            if (bl) {
                Color color = UIManager.getColor(DTTitleBar.ACTIVE_BACKGROUND);
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                return fArray[1] > 0.5f || fArray[2] < 0.65f ? color : ColorUtils.intensify((Color)color);
            }
            Color color = UIManager.getColor("control");
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            fArray[2] = 0.85f * fArray[2];
            return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        }

        static Color getTopColor(boolean bl) {
            if (bl) {
                Color color = UIManager.getColor(DTTitleBar.ACTIVE_BACKGROUND);
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                return fArray[1] > 0.5f || fArray[2] < 0.65f ? ColorUtils.fade((Color)color) : color;
            }
            Color color = UIManager.getColor("control");
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            fArray[2] = 1.25f * fArray[2];
            if (fArray[2] > 1.0f) {
                fArray[2] = 1.0f;
            }
            return Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        }
    }

    public static class BasicUI
    extends ComponentUI {
        DTTitleButton createButton(DTTitleBar dTTitleBar, int n, ActionListener actionListener) {
            DTTitleButton dTTitleButton;
            if (n == 10) {
                dTTitleButton = new DTTitleButton((Action)actionListener, dTTitleBar.fTargetName);
            } else {
                dTTitleButton = new DTTitleButton(n, dTTitleBar.fTargetName, dTTitleBar.fShortTitle);
                dTTitleButton.addActionListener(actionListener);
            }
            dTTitleButton.setActive(dTTitleBar.fIsActive);
            dTTitleButton.setVisible(dTTitleBar.showButtons() && dTTitleBar.showButtonType(dTTitleButton));
            return dTTitleButton;
        }

        Border createBorder() {
            return BorderFactory.createEmptyBorder();
        }

        Border createTabBorder() {
            return BorderFactory.createEmptyBorder();
        }

        @Override
        public Dimension getMinimumSize(JComponent jComponent) {
            return this.calculateSize(jComponent, true);
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            return this.calculateSize(jComponent, false);
        }

        protected Dimension calculateSize(JComponent jComponent, boolean bl) {
            int n;
            DTTitleBar dTTitleBar = (DTTitleBar)jComponent;
            Insets insets = jComponent.getInsets();
            int n2 = 100;
            if (!dTTitleBar.hasTitle() || !dTTitleBar.isTitleShowing()) {
                n = 6;
                if (dTTitleBar.fActAsTab) {
                    n2 = 0;
                }
            } else {
                int n3;
                BasicUI.updateFont(dTTitleBar);
                FontMetrics fontMetrics = dTTitleBar.getTitleFontMetrics();
                if (fontMetrics != null && (!bl || dTTitleBar.fActAsTab)) {
                    String string = dTTitleBar.fTitle;
                    if (dTTitleBar.fActAsTab && dTTitleBar.getTabTitle() != null) {
                        string = dTTitleBar.getTabTitle();
                    }
                    n2 = insets.left + insets.right + fontMetrics.stringWidth(string) + 6;
                    if (dTTitleBar.fIcon != null) {
                        n2 += dTTitleBar.fIcon.getIconWidth() + 2;
                    }
                    if (!dTTitleBar.fActAsTab || dTTitleBar.fIsSelectedTab) {
                        DTTitleButton[] dTTitleButtonArray;
                        int n4 = 0;
                        for (DTTitleButton dTTitleButton : dTTitleButtonArray = dTTitleBar.getButtons()) {
                            if (dTTitleButton == null || !dTTitleButton.isVisible()) continue;
                            n2 += dTTitleButton.getPreferredSize().width;
                            ++n4;
                        }
                        if (n4 > 0) {
                            n2 += 4;
                        }
                    } else if (dTTitleBar.fActAsTab) {
                        n2 += 6;
                    }
                }
                n = dTTitleBar.fFontHeight - 2;
                int n5 = n3 = dTTitleBar.fSingletonLook ? 18 : 16;
                if (n < n3) {
                    n = n3;
                }
            }
            if (dTTitleBar.fIcon != null && dTTitleBar.isTitleShowing() && (n += insets.top + insets.bottom) < dTTitleBar.fIcon.getIconHeight() + 3) {
                n = dTTitleBar.fIcon.getIconHeight() + 3;
            }
            return new Dimension(n2, n);
        }

        void doLayout(DTTitleBar dTTitleBar) {
            int n;
            Dimension dimension = dTTitleBar.getSize();
            Insets insets = dTTitleBar.getInsets();
            int n2 = n = PlatformInfo.isWindowsModernAppearance() ? dimension.height : dimension.height - 4;
            if (n < 14) {
                n = 14;
            }
            int n3 = dimension.width - insets.right - 2;
            int n4 = (dimension.height - n) / 2 - insets.bottom / 2;
            int n5 = 0;
            for (DTTitleButton dTTitleButton : dTTitleBar.getButtons()) {
                if (dTTitleButton == null || !dTTitleButton.isVisible()) continue;
                int n6 = dTTitleButton.getPreferredSize().width;
                dTTitleButton.setBounds(n3 -= n6, n4, n6, n);
                ++n5;
            }
            dTTitleBar.fTitleUpperLimit = n5 > 0 ? n3 - 1 : dimension.width - 3;
        }

        static void updateFont(DTTitleBar dTTitleBar) {
            Font font = UIManager.getFont(DTTitleBar.TITLE_FONT);
            if (dTTitleBar.isDisplayable() && (dTTitleBar.fFontHeight == -1 || !font.equals(dTTitleBar.fTitleFont))) {
                dTTitleBar.fTitleFont = font;
                dTTitleBar.fFontHeight = dTTitleBar.getTitleFontMetrics().getHeight();
            }
        }

        static int drawTitleString(DTTitleBar dTTitleBar, Graphics graphics, FontMetrics fontMetrics, int n, int n2) {
            int n3;
            String string;
            if (dTTitleBar.fActAsTab) {
                string = dTTitleBar.getTabTitle();
            } else {
                if (dTTitleBar.fTrimmedTitle == null) {
                    n3 = dTTitleBar.fTitleUpperLimit - n;
                    dTTitleBar.fTrimmedTitle = dTTitleBar.fTrimmer.shortenString(dTTitleBar.fTitle, fontMetrics, n3);
                }
                string = dTTitleBar.fTrimmedTitle;
            }
            n3 = fontMetrics.stringWidth(string);
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = null;
            RenderingHints renderingHints2 = GraphicsUtils.getAntialiasingRenderingHints();
            if (renderingHints2 != null) {
                renderingHints = graphics2D.getRenderingHints();
                graphics2D.addRenderingHints(renderingHints2);
            }
            graphics.drawString(string, n, n2);
            if (renderingHints != null) {
                graphics2D.setRenderingHints(renderingHints);
            }
            return n3;
        }

        static void drawEnds(Graphics graphics, DTTitleBar dTTitleBar) {
            int n = dTTitleBar.getInsets().top;
            int n2 = dTTitleBar.getHeight();
            int n3 = dTTitleBar.getWidth();
            graphics.setColor(new Color(255, 255, 255, 127));
            graphics.drawLine(0, 0, 0, n2);
            graphics.setColor(new Color(0, 0, 0, 47));
            graphics.drawLine(n3 - 1, n, n3 - 1, n2 - 1);
        }
    }
}

