/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

class DTSaveLayoutDialog {
    private final DTLayoutLibrary fLibrary;
    private final Desktop fDesktop;
    private final Frame fFrame;

    DTSaveLayoutDialog(DTLayoutLibrary dTLayoutLibrary, Desktop desktop, Frame frame) {
        this.fLibrary = dTLayoutLibrary;
        this.fDesktop = desktop;
        this.fFrame = frame;
    }

    void show() {
        String string;
        final MJComboBox mJComboBox = new MJComboBox();
        mJComboBox.setEditable(true);
        mJComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10 || n == 27 && !mJComboBox.isPopupVisible()) {
                    Component component;
                    for (component = (Component)keyEvent.getSource(); !(component instanceof JOptionPane) && component != null; component = component.getParent()) {
                    }
                    if (component != null) {
                        int n2 = n == 10 ? 0 : 2;
                        ((JOptionPane)component).setValue(n2);
                    }
                    keyEvent.consume();
                } else if (n == 38 && mJComboBox.isPopupVisible() && mJComboBox.getSelectedIndex() < 1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            mJComboBox.hidePopup();
                            mJComboBox.setSelectedIndex(-1);
                        }
                    });
                }
            }
        });
        int n = this.fLibrary.userLayoutCount();
        for (int i = 0; i < n; ++i) {
            mJComboBox.addItem((Object)this.fLibrary.getUserLayoutName(i));
        }
        mJComboBox.setSelectedIndex(-1);
        Component component = mJComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setDocument(new LayoutNameDocument());
        }
        Object[] objectArray = new Object[]{this.fDesktop.getString("message.EnterLayoutName"), mJComboBox};
        MJOptionPane mJOptionPane = new MJOptionPane(objectArray, -1, 2){

            public void setValue(Object object) {
                String string;
                if (object instanceof Integer && (Integer)object == 0 && (string = (String)mJComboBox.getEditor().getItem()) != null && DTSaveLayoutDialog.this.fLibrary.hasUserLayoutName(string)) {
                    Object[] objectArray = new Object[]{string};
                    String string2 = MessageFormat.format(DTSaveLayoutDialog.this.fDesktop.getString("message.OverwriteLayout"), objectArray);
                    int n = MJOptionPane.showConfirmDialog((Component)((Object)this), (Object)string2, (String)DTSaveLayoutDialog.this.fDesktop.getString("title.LayoutExists"), (int)0);
                    if (n == 1) {
                        return;
                    }
                }
                super.setValue(object);
            }
        };
        MJDialog mJDialog = (MJDialog)mJOptionPane.createDialog(this.fFrame, this.fDesktop.getString("title.SaveLayout"));
        mJDialog.setFocusTarget(mJComboBox.getEditor().getEditorComponent());
        mJDialog.show();
        Object object = mJOptionPane.getValue();
        if (object instanceof Integer && (Integer)object == 0 && (string = (String)mJComboBox.getEditor().getItem()) != null && string.length() > 0 && !this.fDesktop.saveLayout(string)) {
            MJOptionPane.showMessageDialog((Component)this.fFrame, (Object)this.fDesktop.getString("error.FailureDuringSave"), (String)this.fDesktop.getString("title.LayoutSaveError"), (int)0);
        }
    }

    private static class LayoutNameDocument
    extends PlainDocument {
        private LayoutNameDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c) || c == ' ' || c == '.' || c == '+' || c == '-' || c == '&') continue;
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

