/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTNestingContainer;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTNestedLocation
extends DTLocation {
    static final int NORTH = 1;
    static final int SOUTH = 5;
    static final int EAST = 3;
    static final int WEST = 7;
    static final int CENTER = 0;
    static final int TABBED = 2;
    static final int INVALID = 8;
    static final int MAX_DIRECTION_VALUE = Math.max(1, Math.max(5, Math.max(3, Math.max(7, Math.max(0, Math.max(2, 8))))));
    private int[] fPath;
    private int fTabIndex = -1;
    private int fParentWidth;
    private int fParentHeight;
    private Object fHierarchy;
    private static final String PATH_ATTRIBUTE = "Path";
    private static final String TAB_INDEX_ATTRIBUTE = "TabIndex";
    private static final String PARENT_WIDTH_ATTRIBUTE = "ParentWidth";
    private static final String PARENT_HEIGHT_ATTRIBUTE = "ParentHeight";
    private static final String HIERARCHY_TAG = "ReferenceHierarchy";

    DTNestedLocation() {
        this.fPath = new int[0];
    }

    DTNestedLocation(String string) {
        this.fPath = DTNestedLocation.pathFromString(string);
    }

    DTNestedLocation(int[] nArray) {
        this.fPath = nArray;
    }

    DTNestedLocation(DTNestedLocation dTNestedLocation) {
        super(dTNestedLocation);
        this.fPath = dTNestedLocation.fPath;
        this.fTabIndex = dTNestedLocation.fTabIndex;
        this.fParentWidth = dTNestedLocation.fParentWidth;
        this.fParentHeight = dTNestedLocation.fParentHeight;
        this.fHierarchy = dTNestedLocation.fHierarchy;
    }

    DTNestedLocation append(int n) {
        DTNestedLocation dTNestedLocation = new DTNestedLocation(this);
        dTNestedLocation.fPath = new int[this.fPath.length + 1];
        System.arraycopy(this.fPath, 0, dTNestedLocation.fPath, 0, this.fPath.length);
        dTNestedLocation.fPath[this.fPath.length] = n;
        return dTNestedLocation;
    }

    DTNestedLocation complement() {
        DTNestedLocation dTNestedLocation = new DTNestedLocation(this);
        dTNestedLocation.fPath = new int[this.fPath.length];
        System.arraycopy(this.fPath, 0, dTNestedLocation.fPath, 0, this.fPath.length);
        int n = this.fPath.length;
        if (n > 0) {
            switch (this.fPath[n - 1]) {
                case 1: {
                    dTNestedLocation.fPath[n - 1] = 5;
                    break;
                }
                case 5: {
                    dTNestedLocation.fPath[n - 1] = 1;
                    break;
                }
                case 3: {
                    dTNestedLocation.fPath[n - 1] = 7;
                    break;
                }
                case 7: {
                    dTNestedLocation.fPath[n - 1] = 3;
                }
            }
        }
        return dTNestedLocation;
    }

    int getDirection(int n) {
        return n >= this.fPath.length ? 2 : this.fPath[n];
    }

    int getPathLength() {
        return this.fPath.length;
    }

    @Override
    public String getPath() {
        return DTNestedLocation.pathToString(this.fPath);
    }

    @Override
    public boolean isTabbed() {
        return this.fPath.length > 0 && this.fPath[this.fPath.length - 1] == 2;
    }

    public int getTabIndex() {
        return this.fTabIndex;
    }

    public void setTabIndex(int n) {
        this.fTabIndex = n;
    }

    void setParentSize(int n, int n2) {
        this.fParentWidth = n;
        this.fParentHeight = n2;
    }

    Dimension getParentSize() {
        return new Dimension(this.fParentWidth, this.fParentHeight);
    }

    int getParentWidth() {
        return this.fParentWidth;
    }

    int getParentHeight() {
        return this.fParentHeight;
    }

    @Override
    void setFrameLocation(int n, int n2) {
        this.fX = n;
        this.fY = n2;
    }

    public String toString() {
        String string = DTNestedLocation.pathToString(this.fPath);
        if (this.isTabbed()) {
            string = string + ", tab = " + this.fTabIndex;
        }
        return string;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DTNestedLocation && super.equals(object) && Arrays.equals(this.fPath, ((DTNestedLocation)object).fPath);
    }

    void setHierarchy(Object object) {
        this.fHierarchy = object;
    }

    Object getHierarchy() {
        return this.fHierarchy;
    }

    public int hashCode() {
        int n = 17;
        for (int n2 : this.fPath) {
            n = 37 * n + n2;
        }
        return n;
    }

    static String pathToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(nArray.length);
        for (int n : nArray) {
            char c;
            switch (n) {
                case 1: {
                    c = 'N';
                    break;
                }
                case 5: {
                    c = 'S';
                    break;
                }
                case 3: {
                    c = 'E';
                    break;
                }
                case 7: {
                    c = 'W';
                    break;
                }
                default: {
                    c = 'T';
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static int[] pathFromString(String string) {
        int[] nArray = new int[string.length()];
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'N': {
                    nArray[i] = 1;
                    continue block6;
                }
                case 'S': {
                    nArray[i] = 5;
                    continue block6;
                }
                case 'E': {
                    nArray[i] = 3;
                    continue block6;
                }
                case 'W': {
                    nArray[i] = 7;
                    continue block6;
                }
                default: {
                    nArray[i] = 2;
                }
            }
        }
        return nArray;
    }

    @Override
    public Element toXML(Document document) {
        Element element = super.toXML(document);
        element.setAttribute("Type", "nested");
        element.setAttribute(PATH_ATTRIBUTE, DTNestedLocation.pathToString(this.fPath));
        if (this.fTabIndex >= 0) {
            element.setAttribute(TAB_INDEX_ATTRIBUTE, Integer.toString(this.fTabIndex));
        }
        if (this.fX > 0) {
            element.setAttribute("X", Integer.toString(this.fX));
        }
        if (this.fY > 0) {
            element.setAttribute("Y", Integer.toString(this.fY));
        }
        if (this.fWidth > 0) {
            element.setAttribute("Width", Integer.toString(this.fWidth));
        }
        if (this.fHeight > 0) {
            element.setAttribute("Height", Integer.toString(this.fHeight));
        }
        if (this.fParentWidth > 0) {
            element.setAttribute(PARENT_WIDTH_ATTRIBUTE, Integer.toString(this.fParentWidth));
        }
        if (this.fParentHeight > 0) {
            element.setAttribute(PARENT_HEIGHT_ATTRIBUTE, Integer.toString(this.fParentHeight));
        }
        if (this.fHierarchy != null) {
            Element element2 = document.createElement(HIERARCHY_TAG);
            element2.appendChild(DTNestingContainer.stateToXML(this.fHierarchy, document));
            element.appendChild(element2);
        }
        return element;
    }

    DTNestedLocation(SimpleElement simpleElement) throws DataFormatException {
        SimpleNodeList simpleNodeList;
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = simpleElement.getAttribute(PATH_ATTRIBUTE);
        this.fPath = DTNestedLocation.pathFromString(string5);
        String string6 = simpleElement.getAttribute(TAB_INDEX_ATTRIBUTE);
        if (string6 != null && string6.length() > 0) {
            try {
                this.fTabIndex = Integer.parseInt(string6);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid TabIndex: " + string6);
            }
        }
        if ((string4 = simpleElement.getAttribute("X")) != null && string4.length() > 0) {
            try {
                this.fX = Integer.parseInt(string4);
                if (this.fX == -1) {
                    this.fX = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid X: " + string4);
            }
        }
        if ((string3 = simpleElement.getAttribute("Y")) != null && string3.length() > 0) {
            try {
                this.fY = Integer.parseInt(string3);
                if (this.fY == -1) {
                    this.fY = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Y: " + string3);
            }
        }
        if ((string2 = simpleElement.getAttribute("Width")) != null && string2.length() > 0) {
            try {
                this.fWidth = Integer.parseInt(string2);
                if (this.fWidth == -1) {
                    this.fWidth = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Width: " + string2);
            }
        }
        if ((string = simpleElement.getAttribute("Height")) != null && string.length() > 0) {
            try {
                this.fHeight = Integer.parseInt(string);
                if (this.fHeight == -1) {
                    this.fHeight = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Height: " + string);
            }
        }
        if ((string2 = simpleElement.getAttribute(PARENT_WIDTH_ATTRIBUTE)) != null && string2.length() > 0) {
            try {
                this.fParentWidth = Integer.parseInt(string2);
                if (this.fParentWidth == -1) {
                    this.fParentWidth = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid ParentWidth: " + string2);
            }
        }
        if ((string = simpleElement.getAttribute(PARENT_HEIGHT_ATTRIBUTE)) != null && string.length() > 0) {
            try {
                this.fParentHeight = Integer.parseInt(string);
                if (this.fParentHeight == -1) {
                    this.fParentHeight = Integer.MIN_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid ParentHeight: " + string);
            }
        }
        if ((simpleNodeList = simpleElement.getChildrenByTagName(HIERARCHY_TAG)).getLength() > 0) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(0);
            SimpleElement simpleElement3 = (SimpleElement)simpleElement2.getFirstChild();
            this.fHierarchy = DTNestingContainer.stateFromXML(simpleElement3);
        }
    }
}

