/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Log;
import com.mathworks.widgets.desk.DTChildAction;
import com.mathworks.widgets.desk.DTMenuBoundary;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMenuOmission;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class DTMenu
extends MJMenu
implements MenuListener {
    protected boolean fHasBeenPopulated;
    protected boolean fHasBeenMerged;
    protected List<Action> fChildActionList;

    public DTMenu(String string) {
        this(string, false);
    }

    public DTMenu(String string, boolean bl) {
        super(string);
        this.setName("Desktop" + this.getText() + "Menu");
        if (bl) {
            this.addMenuListener(this);
        } else {
            this.populate();
            this.fHasBeenPopulated = true;
        }
    }

    protected void populate() {
    }

    void merge(JMenu jMenu) {
        this.populateIfNecessary();
        DTMenu.merge((JMenu)((Object)this), jMenu);
        this.fHasBeenMerged = true;
    }

    boolean hasBeenMerged() {
        return this.fHasBeenMerged;
    }

    public JMenuItem add(Action action) {
        if (action instanceof ChildAction) {
            if (this.fChildActionList == null) {
                this.fChildActionList = new ArrayList<Action>();
            }
            this.fChildActionList.add(action);
        }
        return super.add(action);
    }

    public void dispose() {
        if (this.fChildActionList != null) {
            int n = this.fChildActionList.size();
            for (int i = 0; i < n; ++i) {
                ((ChildAction)this.fChildActionList.get(i)).setParent(null);
            }
            this.fChildActionList.clear();
        }
        super.dispose();
    }

    public AccessibleContext getAccessibleContext() {
        this.populateIfNecessary();
        return super.getAccessibleContext();
    }

    public void ensurePopulated() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.populateIfNecessary();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DTMenu.this.populateIfNecessary();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Log.logException((Exception)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.logException((Exception)invocationTargetException);
            }
        }
    }

    protected void populateIfNecessary() {
        if (!this.fHasBeenPopulated) {
            this.populate();
            this.fHasBeenPopulated = true;
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        this.populateIfNecessary();
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    protected static void merge(JMenu jMenu, JMenu jMenu2) {
        MenuListener[] menuListenerArray;
        for (MenuListener object4 : menuListenerArray = jMenu2.getMenuListeners()) {
            jMenu.addMenuListener(object4);
        }
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < jMenu2.getMenuComponentCount(); ++i) {
            int n3;
            Object object;
            Object object2;
            Object object3;
            Component component = jMenu2.getMenuComponent(i);
            if (component instanceof JSeparator) {
                if (n == -1) {
                    jMenu.addSeparator();
                    ++n2;
                    continue;
                }
                jMenu.insertSeparator(n++);
                continue;
            }
            if (component instanceof DTMenuBoundary) {
                int jMenuItem;
                object3 = (DTMenuBoundary)((Object)component);
                object2 = object3.getTag();
                if (object2 == DTMenuMergeTag.START_OF_MENU) {
                    if (n2 > 0) {
                        DTMenu.moveBefore(jMenu, 0, n2);
                    }
                    n = 0;
                    n2 = 0;
                    continue;
                }
                if (object2 == DTMenuMergeTag.END_OF_MENU) {
                    n = -1;
                    continue;
                }
                int n4 = jMenuItem = object2 == null ? -1 : DTMenu.findItemIndex(jMenu, (DTMenuMergeTag)object2);
                if (jMenuItem == -1) continue;
                if (n2 > 0) {
                    DTMenu.moveBefore(jMenu, jMenuItem, n2);
                }
                n = jMenuItem + n2 + 1;
                n2 = 0;
                continue;
            }
            if (component instanceof DTMenuOmission) {
                int n5;
                object3 = (DTMenuOmission)component;
                object2 = ((DTMenuOmission)object3).getTag();
                int n6 = n5 = object2 == null ? -1 : DTMenu.findItemIndex(jMenu, (DTMenuMergeTag)object2);
                if (n5 == -1) continue;
                object = jMenu.getItem(n5);
                if (object instanceof MJMenu) {
                    ((MJMenu)object).dispose();
                } else {
                    MJUtilities.dispose((AbstractButton)object);
                }
                jMenu.remove(n5);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            object3 = (JMenuItem)component;
            object2 = ((AbstractButton)object3).getAction();
            JMenuItem jMenuItem = null;
            object = DTMenuMergeTag.getTag((JMenuItem)object3);
            int n7 = n3 = object == null ? -1 : DTMenu.findItemIndex(jMenu, (DTMenuMergeTag)object);
            if (object2 == null) {
                object2 = new ProxyAction((JMenuItem)object3);
            }
            if (n3 != -1) {
                jMenuItem = jMenu.getItem(n3);
                if (n2 > 0) {
                    DTMenu.moveBefore(jMenu, n3, n2);
                }
                n = n3 + n2 + 1;
                n2 = 0;
            }
            if (jMenuItem != null) {
                if (jMenuItem instanceof JMenu) {
                    if (object3 instanceof JMenu) {
                        if (jMenuItem instanceof DTMenu) {
                            ((DTMenu)((Object)jMenuItem)).merge((JMenu)object3);
                            continue;
                        }
                        DTMenu.merge((JMenu)jMenuItem, (JMenu)object3);
                        continue;
                    }
                    jMenu.remove(n3);
                    MJMenu.dispose((JMenu)((JMenu)jMenuItem));
                    jMenu.insert((Action)object2, n3);
                    continue;
                }
                if (object3 instanceof JMenu) {
                    jMenu.remove(n3);
                    MJUtilities.dispose((AbstractButton)jMenuItem);
                    jMenu.insert(DTMenu.clone((JMenu)object3), n3);
                    continue;
                }
                if (object2 instanceof DTChildAction) {
                    ((DTChildAction)((Object)object2)).setParent(jMenuItem.getAction());
                    if (jMenu instanceof DTMenu) {
                        DTMenu dTMenu = (DTMenu)((Object)jMenu);
                        if (dTMenu.fChildActionList == null) {
                            dTMenu.fChildActionList = new ArrayList<Action>();
                        }
                        dTMenu.fChildActionList.add((Action)object2);
                    }
                }
                jMenuItem.setAction((Action)object2);
                continue;
            }
            if (n == -1) {
                if (object3 instanceof JMenu) {
                    jMenu.add(DTMenu.clone((JMenu)object3));
                } else if (object3 instanceof JCheckBoxMenuItem) {
                    jMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)object2));
                } else if (object3 instanceof JRadioButtonMenuItem) {
                    jMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)object2));
                } else {
                    jMenu.add((Action)object2);
                }
                ++n2;
                continue;
            }
            if (object3 instanceof JMenu) {
                jMenu.insert(DTMenu.clone((JMenu)object3), n++);
                continue;
            }
            if (object3 instanceof JCheckBoxMenuItem) {
                jMenu.insert((JMenuItem)new MJCheckBoxMenuItem((Action)object2), n++);
                continue;
            }
            if (object3 instanceof JRadioButtonMenuItem) {
                jMenu.insert((JMenuItem)new MJRadioButtonMenuItem((Action)object2), n++);
                continue;
            }
            jMenu.insert((Action)object2, n++);
        }
        DTMenu.removeRedundantSeparators(jMenu);
    }

    public static JMenuItem findItem(JMenu jMenu, DTMenuMergeTag dTMenuMergeTag) {
        int n = DTMenu.findItemIndex(jMenu, dTMenuMergeTag);
        return n == -1 ? null : jMenu.getItem(n);
    }

    public static int findItemIndex(JMenu jMenu, DTMenuMergeTag dTMenuMergeTag) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || DTMenuMergeTag.getTag(jMenuItem) != dTMenuMergeTag) continue;
            return i;
        }
        return -1;
    }

    protected static JMenu clone(JMenu jMenu) {
        Object object;
        MJMenu mJMenu;
        Object object2 = jMenu.getAction();
        if (object2 != null) {
            mJMenu = new MJMenu(object2);
        } else {
            mJMenu = new MJMenu(jMenu.getText());
            mJMenu.setMnemonic(jMenu.getMnemonic());
            mJMenu.setName(jMenu.getName());
            object = DTMenuMergeTag.getTag(jMenu);
            if (object != null) {
                ((DTMenuMergeTag)object).setTag((JMenuItem)mJMenu);
            }
        }
        object = jMenu.getMenuListeners();
        Object[] objectArray = object;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            MenuListener menuListener = objectArray[i];
            mJMenu.addMenuListener(menuListener);
        }
        for (Object object3 : objectArray = jMenu.getMenuComponents()) {
            if (object3 instanceof JMenu) {
                if (object3 instanceof DTMenuBoundary) continue;
                mJMenu.add((JMenuItem)DTMenu.clone((JMenu)object3));
                continue;
            }
            if (object3 instanceof JMenuItem) {
                JMenuItem jMenuItem;
                JMenuItem jMenuItem2 = (JMenuItem)object3;
                object2 = jMenuItem2.getAction();
                if (object2 == null) {
                    object2 = new ProxyAction(jMenuItem2);
                }
                if ((jMenuItem = jMenuItem2 instanceof JCheckBoxMenuItem ? mJMenu.add((JMenuItem)new MJCheckBoxMenuItem(object2)) : (jMenuItem2 instanceof JRadioButtonMenuItem ? mJMenu.add((JMenuItem)new MJRadioButtonMenuItem(object2)) : mJMenu.add(object2))).getName() != null || jMenuItem2.getName() == null) continue;
                jMenuItem.setName(jMenuItem2.getName() + "2");
                continue;
            }
            if (!(object3 instanceof JSeparator) || mJMenu.getMenuComponentCount() <= 0) continue;
            mJMenu.addSeparator();
        }
        return mJMenu;
    }

    protected static void moveBefore(JMenu jMenu, int n, int n2) {
        while (n2 > 0) {
            int n3 = jMenu.getMenuComponentCount() - n2;
            Component component = jMenu.getMenuComponent(n3);
            jMenu.remove(n3);
            if (component instanceof JMenuItem) {
                jMenu.insert((JMenuItem)component, n);
            } else if (component instanceof JSeparator) {
                jMenu.insertSeparator(n);
            }
            ++n;
            --n2;
        }
    }

    protected static void removeRedundantSeparators(JMenu jMenu) {
        boolean bl = true;
        for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
            Component component = jMenu.getMenuComponent(i);
            if (component instanceof JSeparator) {
                if (bl || i == jMenu.getMenuComponentCount() - 1) {
                    jMenu.remove(i);
                    --i;
                }
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    protected static void removeRedundantSeparators(JPopupMenu jPopupMenu) {
        boolean bl = true;
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            Component component = jPopupMenu.getComponent(i);
            if (component instanceof JSeparator) {
                if (bl || i == jPopupMenu.getComponentCount() - 1) {
                    jPopupMenu.remove(i);
                    --i;
                }
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    static class ProxyAction
    extends MJAbstractAction {
        JMenuItem fMenuItem;

        ProxyAction(JMenuItem jMenuItem) {
            super(jMenuItem.getText(), jMenuItem.getIcon());
            this.fMenuItem = jMenuItem;
            this.setAccelerator(this.fMenuItem.getAccelerator());
            if (jMenuItem.getMnemonic() != 0) {
                this.putValue("MnemonicKey", new Integer(jMenuItem.getMnemonic()));
            }
            if (jMenuItem instanceof JCheckBoxMenuItem) {
                this.setSelected(jMenuItem.isSelected());
            }
            this.setEnabled(jMenuItem.isEnabled());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fMenuItem.doClick();
        }
    }
}

