/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.widgets.desk.DTBorderLocation;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTTiledLocation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DataFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DTLocation {
    protected DTFrame fFrame;
    protected DTContainer fContainer;
    protected int fX = Integer.MIN_VALUE;
    protected int fY = Integer.MIN_VALUE;
    protected int fWidth = Integer.MIN_VALUE;
    protected int fHeight = Integer.MIN_VALUE;
    private List<WeakReference<Listener>> fListeners;
    public static final int UNSPECIFIED = Integer.MIN_VALUE;
    static final String LOCATION_TAG = "Location";
    protected static final String TYPE_ATTRIBUTE = "Type";
    protected static final String TILED_VALUE = "tiled";
    protected static final String NESTED_VALUE = "nested";
    protected static final String FLOATING_VALUE = "floating";
    protected static final String BORDER_VALUE = "border";
    protected static final String X_ATTRIBUTE = "X";
    protected static final String Y_ATTRIBUTE = "Y";
    protected static final String WIDTH_ATTRIBUTE = "Width";
    protected static final String HEIGHT_ATTRIBUTE = "Height";

    protected DTLocation() {
    }

    protected DTLocation(DTLocation dTLocation) {
        this.fFrame = dTLocation.fFrame;
        this.fContainer = dTLocation.fContainer;
        this.fX = dTLocation.fX;
        this.fY = dTLocation.fY;
        this.fWidth = dTLocation.fWidth;
        this.fHeight = dTLocation.fHeight;
    }

    protected DTLocation(DTFrame dTFrame, DTContainer dTContainer) {
        this.fFrame = dTFrame;
        this.fContainer = dTContainer;
    }

    void setFrame(DTFrame dTFrame) {
        this.fFrame = dTFrame;
    }

    DTFrame getFrame() {
        return this.fFrame;
    }

    void setContainer(DTContainer dTContainer) {
        this.fContainer = dTContainer;
    }

    DTContainer getContainer() {
        return this.fContainer;
    }

    void addChangeListener(Listener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList<WeakReference<Listener>>();
        }
        if (this.findListener(listener) == -1) {
            this.fListeners.add(new WeakReference<Listener>(listener));
        }
    }

    void removeChangeListener(Listener listener) {
        int n = this.findListener(listener);
        if (n != -1) {
            this.fListeners.remove(n);
        }
    }

    static void transferListeners(DTLocation dTLocation, DTLocation dTLocation2) {
        if (dTLocation2.fListeners == null) {
            dTLocation2.fListeners = dTLocation.fListeners;
        } else if (dTLocation.fListeners != null) {
            dTLocation2.fListeners.addAll(dTLocation.fListeners);
        }
        dTLocation.fListeners = null;
    }

    public static DTLocation create(String string) {
        return new DTNestedLocation(string);
    }

    public static DTLocation createExternal(int n, int n2, int n3, int n4) {
        return new DTFloatingLocation(n, n2, Integer.MIN_VALUE, n3, n4, true);
    }

    public static DTLocation createExternal(int n, int n2) {
        return new DTFloatingLocation(n, n2, true);
    }

    public static DTLocation createExternal(float f, float f2, float f3, float f4) {
        return new DTFloatingLocation(f, f2, f3, f4, true);
    }

    public static DTLocation createExternal(float f, float f2) {
        return new DTFloatingLocation(f, f2, true);
    }

    public static DTLocation createExternal() {
        return new DTFloatingLocation(true);
    }

    public static DTLocation createInternal(int n, int n2, int n3, int n4, int n5) {
        return new DTFloatingLocation(n, n2, n3, n4, n5, false);
    }

    public static DTLocation createInternal(int n, int n2) {
        return new DTFloatingLocation(n, n2, false);
    }

    public static DTLocation createInternal(float f, float f2, float f3, float f4) {
        return new DTFloatingLocation(f, f2, f3, f4, false);
    }

    public static DTLocation createInternal(float f, float f2) {
        return new DTFloatingLocation(f, f2, false);
    }

    public static DTLocation createMaximized(boolean bl) {
        DTFloatingLocation dTFloatingLocation = new DTFloatingLocation(bl);
        dTFloatingLocation.setMaximized(true);
        return dTFloatingLocation;
    }

    public static DTLocation createMinimized(boolean bl) {
        DTFloatingLocation dTFloatingLocation = new DTFloatingLocation(bl);
        dTFloatingLocation.setMinimized(true);
        return dTFloatingLocation;
    }

    public static DTLocation create(int n) {
        return new DTTiledLocation(n);
    }

    public static DTLocation createAtEdge(int n) {
        return new DTBorderLocation(n);
    }

    public static DTLocation clone(DTLocation dTLocation) {
        if (dTLocation instanceof DTNestedLocation) {
            return new DTNestedLocation((DTNestedLocation)dTLocation);
        }
        if (dTLocation instanceof DTFloatingLocation) {
            return new DTFloatingLocation((DTFloatingLocation)dTLocation);
        }
        if (dTLocation instanceof DTTiledLocation) {
            return new DTTiledLocation((DTTiledLocation)dTLocation);
        }
        if (dTLocation instanceof DTBorderLocation) {
            return new DTBorderLocation((DTBorderLocation)dTLocation);
        }
        return null;
    }

    public int getTile() {
        return -1;
    }

    public int getEdge() {
        return -1;
    }

    public String getPath() {
        return "";
    }

    public boolean isTabbed() {
        return false;
    }

    public Point getFrameLocation() {
        return new Point(this.fX, this.fY);
    }

    public Dimension getFrameSize() {
        return new Dimension(this.fWidth, this.fHeight);
    }

    public Rectangle getFrameBounds() {
        return new Rectangle(this.fX, this.fY, this.fWidth, this.fHeight);
    }

    public int getFrameX() {
        return this.fX;
    }

    public int getFrameY() {
        return this.fY;
    }

    public int getFrameWidth() {
        return this.fWidth;
    }

    public int getFrameHeight() {
        return this.fHeight;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isMaximized() {
        return false;
    }

    public boolean isMinimized() {
        return false;
    }

    public boolean isIn(DTContainer dTContainer) {
        return this.fContainer == dTContainer;
    }

    public boolean isDocked() {
        return !(this instanceof DTFloatingLocation) || !this.isExternal();
    }

    public boolean isAnchored() {
        return false;
    }

    public boolean isInDocumentContainer() {
        return this instanceof DTTiledLocation || this instanceof DTFloatingLocation && !this.isExternal();
    }

    boolean isLocationInitialized() {
        return this.fX != Integer.MIN_VALUE && this.fY != Integer.MIN_VALUE;
    }

    boolean isSizeInitialized() {
        return this.fWidth != Integer.MIN_VALUE && this.fHeight != Integer.MIN_VALUE;
    }

    public boolean equals(Object object) {
        if (object instanceof DTLocation) {
            DTLocation dTLocation = (DTLocation)object;
            return this.fFrame == dTLocation.fFrame && this.fContainer == dTLocation.fContainer;
        }
        return false;
    }

    void setFrameLocation(int n, int n2) {
        if (n == this.fX && n2 == this.fY) {
            return;
        }
        this.fX = n;
        this.fY = n2;
        this.fireChangeEvent();
    }

    void setFrameLocation(Point point) {
        this.setFrameLocation(point.x, point.y);
    }

    void setFrameSize(int n, int n2) {
        if (n == this.fWidth && n2 == this.fHeight) {
            return;
        }
        this.fWidth = n;
        this.fHeight = n2;
        this.fireChangeEvent(ChangeType.RESIZE);
    }

    void setFrameSize(Dimension dimension) {
        this.setFrameSize(dimension.width, dimension.height);
    }

    void setFrameBounds(int n, int n2, int n3, int n4) {
        ChangeType changeType = ChangeType.NONE;
        if (n != this.fX || n2 != this.fY) {
            changeType = ChangeType.MOVE;
        } else if (n3 != this.fWidth || n4 != this.fHeight) {
            changeType = ChangeType.RESIZE;
        }
        if (changeType != ChangeType.NONE) {
            this.fX = n;
            this.fY = n2;
            this.fWidth = n3;
            this.fHeight = n4;
            this.fireChangeEvent(changeType);
        }
    }

    void setFrameBounds(Rectangle rectangle) {
        this.setFrameBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private int findListener(Listener listener) {
        if (this.fListeners == null) {
            return -1;
        }
        for (int i = 0; i < this.fListeners.size(); ++i) {
            if (listener != this.fListeners.get(i).get()) continue;
            return i;
        }
        return -1;
    }

    void fireChangeEvent() {
        this.fireChangeEvent(ChangeType.MOVE);
    }

    void fireChangeEvent(ChangeType changeType) {
        if (this.fListeners != null && this.fListeners.size() > 0) {
            Iterator<WeakReference<Listener>> iterator = this.fListeners.iterator();
            while (iterator.hasNext()) {
                Listener listener = (Listener)iterator.next().get();
                if (listener == null) {
                    iterator.remove();
                    continue;
                }
                listener.locationChanged(this, changeType);
            }
        }
    }

    public Element toXML(Document document) {
        return document.createElement(LOCATION_TAG);
    }

    public static DTLocation fromXML(SimpleElement simpleElement) throws DataFormatException {
        assert (LOCATION_TAG.equals(simpleElement.getTagName()));
        String string = simpleElement.getAttribute(TYPE_ATTRIBUTE);
        if (TILED_VALUE.equalsIgnoreCase(string)) {
            return new DTTiledLocation(simpleElement);
        }
        if (NESTED_VALUE.equalsIgnoreCase(string)) {
            return new DTNestedLocation(simpleElement);
        }
        if (FLOATING_VALUE.equalsIgnoreCase(string)) {
            return new DTFloatingLocation(simpleElement);
        }
        if (BORDER_VALUE.equalsIgnoreCase(string)) {
            return new DTBorderLocation(simpleElement);
        }
        throw new DataFormatException("Unrecognized Type: " + string);
    }

    static interface Listener {
        public void locationChanged(DTLocation var1, ChangeType var2);
    }

    static enum ChangeType {
        MOVE,
        RESIZE,
        NONE;

    }
}

