/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTDropTarget;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTLocation;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.event.MouseInputAdapter;

class DTDragger
extends MouseInputAdapter
implements WindowListener,
AWTEventListener {
    protected DTFrame fFrame;
    protected Object fLoad;
    protected Component fEventSource;
    protected Cursor fSaveCursor;
    protected DTDropTarget fTarget;
    protected DTDropTarget fExternalTarget;
    protected DTLocation fDropLocation;
    protected DTLocation fPreviousLocation;

    DTDragger(Object object, Component component) {
        this.fLoad = object;
        this.fFrame = (DTFrame)MJFrame.getFrame((Component)component);
        this.fFrame.addWindowListener(this);
        this.fEventSource = component;
        if (component.isCursorSet() && !DTDragUtilities.isDraggingWithKeys()) {
            this.fSaveCursor = component.getCursor();
        }
        this.fEventSource.addMouseListener(this);
        this.fEventSource.addMouseMotionListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 0x28L | (PlatformInfo.isMacintosh() ? 16L : 0L));
    }

    protected void endDrag() {
        this.fFrame.removeWindowListener(this);
        this.fEventSource.removeMouseListener(this);
        this.fEventSource.removeMouseMotionListener(this);
        this.fEventSource.setCursor(this.fSaveCursor);
        DTDragUtilities.getDropOutlinePainter().hide(true);
        DTDragUtilities.showHint(this.fFrame, null);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupSuccesor((MouseEvent)mouseEvent)) {
            return;
        }
        this.endDrag();
        if (this.fTarget != null && this.fDropLocation != null) {
            this.fTarget.drop(this.fLoad, this.fDropLocation);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.endDrag();
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 503 || aWTEvent.getID() == 401 && ((KeyEvent)aWTEvent).getKeyCode() == 27) {
            this.endDrag();
        }
        if (aWTEvent.getID() == 502 && aWTEvent.getSource() != this.fEventSource) {
            this.mouseReleased((MouseEvent)aWTEvent);
        }
    }
}

