/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.widgets.desk.DTLocation;
import java.util.zip.DataFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DTBorderLocation
extends DTLocation {
    private int fEdge;
    private static final String EDGE_ATTRIBUTE = "Edge";
    private static final String NORTH_VALUE = "top";
    private static final String SOUTH_VALUE = "bottom";
    private static final String EAST_VALUE = "right";
    private static final String WEST_VALUE = "left";
    private static final String CENTER_VALUE = "center";

    DTBorderLocation(int n) {
        this.fEdge = n;
    }

    DTBorderLocation(DTBorderLocation dTBorderLocation) {
        super(dTBorderLocation);
        this.fEdge = dTBorderLocation.fEdge;
    }

    @Override
    public int getEdge() {
        return this.fEdge;
    }

    void setEdge(int n) {
        if (n != this.fEdge) {
            this.fEdge = n;
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isMaximized() {
        return this.fEdge == 0;
    }

    @Override
    public boolean isMinimized() {
        return this.fEdge != 0;
    }

    public String toString() {
        String string;
        switch (this.fEdge) {
            case 1: {
                string = "North";
                break;
            }
            case 5: {
                string = "South";
                break;
            }
            case 3: {
                string = "East";
                break;
            }
            case 7: {
                string = "West";
                break;
            }
            case 0: {
                return "Center";
            }
            default: {
                string = "Undefined";
            }
        }
        return string + " Edge";
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DTBorderLocation && super.equals(object) && this.fEdge == ((DTBorderLocation)object).fEdge;
    }

    public int hashCode() {
        return this.fEdge;
    }

    @Override
    public Element toXML(Document document) {
        String string;
        Element element = super.toXML(document);
        element.setAttribute("Type", "border");
        switch (this.fEdge) {
            case 1: {
                string = NORTH_VALUE;
                break;
            }
            case 5: {
                string = SOUTH_VALUE;
                break;
            }
            case 3: {
                string = EAST_VALUE;
                break;
            }
            case 7: {
                string = WEST_VALUE;
                break;
            }
            case 0: {
                string = CENTER_VALUE;
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            element.setAttribute(EDGE_ATTRIBUTE, string);
        }
        if (this.fWidth > 0) {
            element.setAttribute("Width", Integer.toString(this.fWidth));
        }
        if (this.fHeight > 0) {
            element.setAttribute("Height", Integer.toString(this.fHeight));
        }
        return element;
    }

    DTBorderLocation(SimpleElement simpleElement) throws DataFormatException {
        String string;
        String string2 = simpleElement.getAttribute(EDGE_ATTRIBUTE);
        if (NORTH_VALUE.equals(string2)) {
            this.fEdge = 1;
        } else if (SOUTH_VALUE.equals(string2)) {
            this.fEdge = 5;
        } else if (EAST_VALUE.equals(string2)) {
            this.fEdge = 3;
        } else if (WEST_VALUE.equals(string2)) {
            this.fEdge = 7;
        } else if (CENTER_VALUE.equals(string2)) {
            this.fEdge = 0;
        } else {
            throw new DataFormatException("Invalid Edge: " + string2);
        }
        String string3 = simpleElement.getAttribute("Width");
        if (string3 != null && string3.length() > 0) {
            try {
                this.fWidth = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Width: " + string3);
            }
        }
        if ((string = simpleElement.getAttribute("Height")) != null && string.length() > 0) {
            try {
                this.fHeight = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid Height: " + string);
            }
        }
    }
}

