/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.color;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.color.ColorPicker;
import com.mathworks.widgets.color.ColorPickerUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.SwingUtilities;

public class ColorPickerPanel
extends MJPanel {
    private static final HighlightColorSwatch[] HIGHLIGHT_COLOR_SWATCHES;
    private static final HighlightColorSwatch[] ROLLOVER_COLOR_SWATCHES;
    protected Color fCurrentColor = Color.red;
    private final boolean fDismissOnMoreColors;
    private final MJPanel fColorPanel;
    private List<WeakReference<ActionListener>> fListeners = new Vector<WeakReference<ActionListener>>();

    public ColorPickerPanel() {
        this(true);
    }

    public ColorPickerPanel(boolean bl) {
        super((LayoutManager)new BorderLayout());
        this.fDismissOnMoreColors = bl;
        this.setName("ColorPickerPanel");
        this.fColorPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        for (int i = 0; i < ColorPickerPanel.getColors().length; ++i) {
            if (i % 8 == 0) {
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridx = 0;
                if (i == 16 || i == 32) {
                    ++gridBagConstraints.gridy;
                }
            } else {
                ++gridBagConstraints.gridx;
            }
            SwatchButton swatchButton = new SwatchButton(HIGHLIGHT_COLOR_SWATCHES[i], ROLLOVER_COLOR_SWATCHES[i]);
            swatchButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        ColorPickerPanel.this.fireAction();
                    }
                }
            });
            this.addSwatchSelectionListener(swatchButton);
            this.fColorPanel.add((Component)((Object)swatchButton), (Object)gridBagConstraints);
        }
        this.add((Component)this.fColorPanel, "Center");
        MJButton mJButton = new MJButton(ColorPickerUtils.getBundle().getString("label.morecolors"));
        mJButton.setMnemonic(77);
        this.addMoreColorsButtonListener(mJButton);
        this.add((Component)mJButton, "South");
    }

    protected void addSwatchSelectionListener(MJButton mJButton) {
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorPickerPanel.this.fCurrentColor = ((SwatchButton)((Object)actionEvent.getSource())).getColor();
                ColorPickerPanel.this.setMatlabColor(ColorPickerPanel.this.fCurrentColor);
            }
        });
    }

    protected void addMoreColorsButtonListener(MJButton mJButton) {
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorPickerPanel.this.showColorDialog();
            }
        });
    }

    protected void setMatlabColor(Color color) {
        this.fCurrentColor = color;
        this.setFocusOnColor(color);
    }

    private void fireAction() {
        ActionEvent actionEvent = new ActionEvent(this.fColorPanel, 0, ColorPickerUtils.colorToActionCommand(this.fCurrentColor));
        for (WeakReference<ActionListener> weakReference : this.fListeners) {
            ((ActionListener)weakReference.get()).actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.fListeners.add(new WeakReference<ActionListener>(actionListener));
    }

    public void removeActionListener(ActionListener actionListener) {
        WeakReference<ActionListener> weakReference = null;
        for (WeakReference<ActionListener> weakReference2 : this.fListeners) {
            if (weakReference2.get() != actionListener) continue;
            weakReference = weakReference2;
            break;
        }
        if (weakReference != null) {
            this.fListeners.remove(weakReference);
        }
    }

    private void setFocusOnColor(Color color) {
        SwatchButton swatchButton = this.findButtonForColor(color);
        if (swatchButton != null) {
            swatchButton.requestFocus();
        }
    }

    public SwatchButton findButtonForColor(Color color) {
        String string = ColorPickerUtils.createToolTipText(color);
        Component component = null;
        for (Component component2 : this.fColorPanel.getComponents()) {
            if (!component2.getName().equals(string)) continue;
            component = component2;
            break;
        }
        return (SwatchButton)((Object)component);
    }

    public Color getCurrentColor() {
        return this.fCurrentColor;
    }

    protected void showColorDialog() {
        if (this.fDismissOnMoreColors) {
            Container container = this.getParent();
            container.setVisible(false);
            this.fireAction();
        }
        this.createColorDialog();
    }

    protected void createColorDialog() {
        Color color = JColorChooser.showDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), ColorPickerUtils.getBundle().getString("label.morecolors"), this.fCurrentColor);
        if (color != null) {
            this.fCurrentColor = color;
            this.setMatlabColor(color);
        }
    }

    public static Color[] getColors() {
        return ColorPicker.getColors();
    }

    public static HighlightColorSwatch[] getSwatches() {
        return (HighlightColorSwatch[])Collections.unmodifiableList(Arrays.asList(HIGHLIGHT_COLOR_SWATCHES)).toArray();
    }

    static {
        int n;
        HIGHLIGHT_COLOR_SWATCHES = new HighlightColorSwatch[ColorPickerPanel.getColors().length];
        for (n = 0; n < ColorPickerPanel.getColors().length; ++n) {
            ColorPickerPanel.HIGHLIGHT_COLOR_SWATCHES[n] = new HighlightColorSwatch(ColorPickerPanel.getColors()[n]);
        }
        ROLLOVER_COLOR_SWATCHES = new HighlightColorSwatch[ColorPickerPanel.getColors().length];
        for (n = 0; n < ColorPickerPanel.getColors().length; ++n) {
            ColorPickerPanel.ROLLOVER_COLOR_SWATCHES[n] = new HighlightColorSwatch(ColorPickerPanel.getColors()[n]);
            ROLLOVER_COLOR_SWATCHES[n].setSelected(true);
        }
    }

    public static class HighlightColorSwatch
    extends ColorPicker.ColorSwatch {
        private boolean fSelected = false;

        HighlightColorSwatch(Color color) {
            super(color);
        }

        public void setSelected(boolean bl) {
            this.fSelected = bl;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.getColor() == null) {
                return;
            }
            super.paintIcon(component, graphics, n, n2);
            if (this.fSelected) {
                graphics.setColor(Color.blue);
                graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                graphics.drawRect(n - 1, n2 - 1, this.getIconWidth() + 1, this.getIconHeight() + 1);
            }
        }
    }

    public static class SwatchButton
    extends MJButton {
        protected Color fColor;

        private SwatchButton(HighlightColorSwatch highlightColorSwatch, HighlightColorSwatch highlightColorSwatch2) {
            super((Icon)highlightColorSwatch);
            this.fColor = highlightColorSwatch.getColor();
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setRolloverIcon(highlightColorSwatch2);
            this.setToolTipText(ColorPickerUtils.createToolTipText(this.fColor));
            this.setName(ColorPickerUtils.createToolTipText(this.fColor));
        }

        public Color getColor() {
            return this.fColor;
        }
    }
}

