/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.color;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.color.ColorPickerPanel;
import com.mathworks.widgets.color.ColorPickerUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ColorDialog {
    private MJDialog fBasicColorDialog;
    private Color fSelectedColor = null;
    private String fTitle;
    private boolean fApproved = false;
    private final ColorPickerPanel fColorSwatchPanel;
    private final JPanel fOkCancelButtonBar;
    private MJButton fOkButton;
    private Color fInitialColor = Color.WHITE;

    public ColorDialog() {
        this(ColorPickerUtils.getBundle().getString("moreColorsDialog.title"));
    }

    public ColorDialog(String string) {
        this.fTitle = string;
        this.fApproved = false;
        this.fColorSwatchPanel = new ColorPickerPanel(false);
        this.fColorSwatchPanel.setName("SwatchPanel");
        this.fOkCancelButtonBar = this.createOKCancelPanel();
        this.fOkCancelButtonBar.setName("ButtonBar");
        this.fColorSwatchPanel.setMatlabColor(this.fInitialColor);
    }

    public Color showDialog(Component component) {
        this.fBasicColorDialog = WindowUtils.createDialogToParent((Component)component, (String)this.fTitle, (boolean)true);
        this.fBasicColorDialog.setCloseOnEscapeEnabled(true);
        ColorPickerPanel.SwatchButton swatchButton = this.fColorSwatchPanel.findButtonForColor(this.fInitialColor);
        if (swatchButton != null) {
            this.fBasicColorDialog.setFocusTarget((Component)((Object)swatchButton));
        } else {
            this.fBasicColorDialog.setFocusTarget((Component)this.fOkButton);
        }
        this.fBasicColorDialog.setName("BasicColorDialog");
        this.fColorSwatchPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorDialog.this.setSelectedColor();
            }
        });
        this.fBasicColorDialog.setResizable(false);
        Container container = this.fBasicColorDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)((Object)this.fColorSwatchPanel));
        container.add((Component)this.fOkCancelButtonBar, "South");
        this.fBasicColorDialog.pack();
        WindowUtils.positionUnderneathParentTitle((Window)this.fBasicColorDialog.getOwner(), (Window)this.fBasicColorDialog);
        this.fBasicColorDialog.show();
        return this.fApproved ? this.fSelectedColor : null;
    }

    private JPanel createOKCancelPanel() {
        MJButton mJButton = new MJButton(MJUtilities.intlString((String)"labelOK"));
        mJButton.setName("OKButton");
        mJButton.requestFocusInWindow();
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorDialog.this.setSelectedColor();
            }
        });
        this.fOkButton = mJButton;
        MJButton mJButton2 = new MJButton(MJUtilities.intlString((String)"labelCancel"));
        mJButton2.setName("CancelButton");
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorDialog.this.close();
            }
        });
        return ButtonBarFactory.buildOKCancelBar((JButton)mJButton, (JButton)mJButton2);
    }

    private void close() {
        if (this.fBasicColorDialog == null) {
            return;
        }
        this.fBasicColorDialog.setVisible(false);
        this.fBasicColorDialog.dispose();
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public String getTitle() {
        return this.fTitle;
    }

    private void setSelectedColor() {
        this.fApproved = true;
        this.fSelectedColor = this.fColorSwatchPanel.getCurrentColor();
        this.close();
    }

    public void setInitialColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Input color cannot be null");
        }
        this.fInitialColor = color;
        this.fColorSwatchPanel.setMatlabColor(color);
    }

    public Color getCurrentColor() {
        return this.fColorSwatchPanel.getCurrentColor();
    }

    public MJPanel getPickerPanel() {
        return this.fColorSwatchPanel;
    }
}

