/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class WorkMonitor {
    private final List<Task> fTasks = new Vector<Task>();
    private final List<ChangeListener> fListeners = new Vector<ChangeListener>();
    private static final int LONG_WORK_ITEM_MIN = 1000;

    public void registerComponentForWaitCursor(final Component component) {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (WorkMonitor.this.shouldUseWaitCursor()) {
                    component.setCursor(Cursor.getPredefinedCursor(3));
                } else {
                    component.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public Task startTask(String string) {
        return this.startTask(string, false);
    }

    public Task startTask(final String string, final boolean bl) {
        final Task task = new Task(){

            @Override
            public String getDisplayName() {
                return string;
            }

            @Override
            public void finished() {
                WorkMonitor.this.fTasks.remove(this);
                WorkMonitor.this.fireChange();
            }

            @Override
            public boolean shouldUseWaitCursor() {
                return bl;
            }
        };
        this.fTasks.add(task);
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WorkMonitor.this.fTasks.contains(task)) {
                    WorkMonitor.this.fireChange();
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getLatestTask() {
        List<Task> list = this.fTasks;
        synchronized (list) {
            if (this.fTasks.isEmpty()) {
                return null;
            }
            return this.fTasks.get(this.fTasks.size() - 1);
        }
    }

    public List<Task> getTasks() {
        return new Vector<Task>(this.fTasks);
    }

    public boolean isBusy() {
        return !this.fTasks.isEmpty();
    }

    public boolean shouldUseWaitCursor() {
        for (Task task : new Vector<Task>(this.fTasks)) {
            if (!task.shouldUseWaitCursor()) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fListeners.remove(changeListener);
    }

    private void fireChange() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ChangeListener changeListener : new Vector(WorkMonitor.this.fListeners)) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        });
    }

    public Runnable createEdtFinisher(final Task task) {
        return new Runnable(){

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(this);
                } else {
                    task.finished();
                }
            }
        };
    }

    public static interface Task {
        public String getDisplayName();

        public void finished();

        public boolean shouldUseWaitCursor();
    }
}

