/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.text.DocumentReader;
import com.mathworks.util.Log;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.EditorLanguageUtils;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.PrintableDocument;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.STPViewInterface;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.simscape.SimscapeLanguage;
import com.mathworks.widgets.text.xml.XMLLanguage;
import com.mathworks.xml.XMLUtils;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtUtilities;

public class SyntaxTextPaneUtilities {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text");

    private SyntaxTextPaneUtilities() {
    }

    public static boolean findString(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FindSupport findSupport = FindSupport.getFindSupport();
        Map map = findSupport.getDefaultFindProperties();
        if (!string.equals(findSupport.getFindProperty("find-what"))) {
            findSupport.putFindProperty("find-what", (Object)string);
        }
        SyntaxTextPaneUtilities.setFindProperties(findSupport, bl2, bl3, bl4);
        JTextComponent jTextComponent = SyntaxTextPaneUtilities.getLastActiveComponent();
        boolean bl5 = false;
        if (jTextComponent != null) {
            int n;
            int n2 = jTextComponent.getSelectionStart();
            if (n2 != (n = jTextComponent.getSelectionEnd())) {
                if (bl && jTextComponent.getCaret().getMark() != n) {
                    jTextComponent.getCaret().setDot(n);
                    jTextComponent.getCaret().moveDot(n2);
                } else if (!bl && jTextComponent.getCaret().getMark() != n2) {
                    jTextComponent.getCaret().setDot(n2);
                    jTextComponent.getCaret().moveDot(n);
                }
            }
            bl5 = findSupport.find(findSupport.getFindProperties(), bl);
            findSupport.putFindProperties(map);
        }
        return bl5;
    }

    public static boolean replaceString(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FindSupport findSupport = FindSupport.getFindSupport();
        Map map = findSupport.getDefaultFindProperties();
        if (!string.equals(findSupport.getFindProperty("find-what"))) {
            findSupport.putFindProperty("find-what", (Object)string);
        }
        if (!string2.equals(findSupport.getFindProperty("find-replace-with"))) {
            findSupport.putFindProperty("find-replace-with", (Object)string2);
        }
        SyntaxTextPaneUtilities.setFindProperties(findSupport, bl2, bl3, bl4);
        try {
            JTextComponent jTextComponent = SyntaxTextPaneUtilities.getLastActiveComponent();
            if (jTextComponent != null) {
                if (bl) {
                    jTextComponent.setCaretPosition(jTextComponent.getSelectionEnd());
                } else {
                    jTextComponent.setCaretPosition(jTextComponent.getSelectionStart());
                }
            }
            boolean bl5 = findSupport.replace(findSupport.getFindProperties(), bl);
            findSupport.find(findSupport.getFindProperties(), bl);
            findSupport.putFindProperties(map);
            return bl5;
        }
        catch (BadLocationException badLocationException) {
            findSupport.putFindProperties(map);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceAll(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        JTextComponent jTextComponent = Utilities.getLastActiveComponent();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (baseDocument instanceof PrintableDocument) {
            ((PrintableDocument)baseDocument).startEditGrouping();
        }
        try {
            FindSupport findSupport = FindSupport.getFindSupport();
            Map map = findSupport.getDefaultFindProperties();
            if (!string.equals(findSupport.getFindProperty("find-what"))) {
                findSupport.putFindProperty("find-what", (Object)string);
            }
            if (!string2.equals(findSupport.getFindProperty("find-replace-with"))) {
                findSupport.putFindProperty("find-replace-with", (Object)string2);
            }
            SyntaxTextPaneUtilities.setFindProperties(findSupport, bl, bl2, bl3);
            findSupport.replaceAll(findSupport.getFindProperties(), true);
            findSupport.putFindProperties(map);
        }
        finally {
            if (baseDocument instanceof PrintableDocument) {
                try {
                    ((PrintableDocument)baseDocument).endEditGrouping();
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    private static void setFindProperties(FindSupport findSupport, boolean bl, boolean bl2, boolean bl3) {
        Boolean bl4 = false;
        if (!bl4.equals(findSupport.getFindProperty("find-highlight-search"))) {
            findSupport.putFindProperty("find-highlight-search", (Object)bl4);
        }
        if (!(bl4 = Boolean.valueOf(bl2)).equals(findSupport.getFindProperty("find-wrap-search"))) {
            findSupport.putFindProperty("find-wrap-search", (Object)bl4);
        }
        if (!(bl4 = Boolean.valueOf(bl3)).equals(findSupport.getFindProperty("find-match-case"))) {
            findSupport.putFindProperty("find-match-case", (Object)bl4);
        }
        if (!(bl4 = Boolean.valueOf(bl)).equals(findSupport.getFindProperty("find-whole-words"))) {
            findSupport.putFindProperty("find-whole-words", (Object)bl4);
        }
    }

    public static void setSelFocusOverride(STPViewInterface sTPViewInterface, boolean bl) {
        sTPViewInterface.setSelFocusOverride(bl);
    }

    public static void scrollSelToView(STPViewInterface sTPViewInterface, Rectangle rectangle) {
        try {
            Rectangle rectangle2 = sTPViewInterface.modelToView(sTPViewInterface.getSelectionDot());
            Rectangle rectangle3 = sTPViewInterface.modelToView(sTPViewInterface.getSelectionMark());
            rectangle2 = new Rectangle(rectangle2.createUnion(rectangle3).getBounds());
            Point point = sTPViewInterface.getLocationOnScreen();
            rectangle.translate(-point.x, -point.y);
            if (rectangle2.intersects(rectangle)) {
                int n;
                rectangle3 = sTPViewInterface.getExtentBounds(rectangle3);
                int n2 = rectangle.y + rectangle.height - rectangle2.y;
                if (rectangle2.y + rectangle2.height + n2 < rectangle3.y + rectangle3.height && rectangle3.y >= n2) {
                    n = n2;
                    n += Math.min(rectangle3.y - n2, rectangle2.height);
                } else {
                    int n3 = rectangle2.y - rectangle.y + rectangle2.height;
                    int n4 = sTPViewInterface.getBounds().height - (rectangle3.y + rectangle3.height);
                    if (rectangle2.y - n3 > rectangle3.y) {
                        n = -n3;
                        n -= Math.min(n4, 4);
                    } else {
                        return;
                    }
                }
                sTPViewInterface.getEditorUI().adjustWindow((int)((double)(rectangle2.y + n - rectangle3.y) / (double)rectangle3.height * 100.0));
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    public static JTextComponent getLastActiveComponent() {
        return Utilities.getLastActiveComponent();
    }

    public static void activate(JTextComponent jTextComponent) {
        if (!(jTextComponent.getUI() instanceof BaseTextUI)) {
            throw new IllegalArgumentException("Text component must be using a kit derived from BaseKit");
        }
        Registry.activate((JTextComponent)jTextComponent);
    }

    public static MWToolTipSupport getToolTipSupport(SyntaxTextPaneBase syntaxTextPaneBase) {
        if (!(syntaxTextPaneBase.getEditorUI() instanceof MWEditorUI)) {
            throw new IllegalArgumentException("Text component must be using a kit derived from MWKit");
        }
        return (MWToolTipSupport)ExtUtilities.getExtEditorUI((JTextComponent)syntaxTextPaneBase).getToolTipSupport();
    }

    public static String intlString(String string) {
        return sRes.getString(string);
    }

    public static boolean isMCode(STPInterface sTPInterface) {
        SyntaxTextPaneUtilities.checkSyntaxTextPaneNotNull(sTPInterface);
        return sTPInterface.getContentType().equals(MLanguage.M_MIME_TYPE);
    }

    public static boolean isSimscapeCode(STPInterface sTPInterface) {
        SyntaxTextPaneUtilities.checkSyntaxTextPaneNotNull(sTPInterface);
        return sTPInterface.getContentType().equals(SimscapeLanguage.INSTANCE.getMimeType());
    }

    public static boolean isXmlCode(STPInterface sTPInterface) {
        SyntaxTextPaneUtilities.checkSyntaxTextPaneNotNull(sTPInterface);
        return sTPInterface.getContentType().equals(XMLLanguage.INSTANCE.getMimeType());
    }

    public static Charset getDefaultFileEncoding() {
        return Charset.defaultCharset();
    }

    public static Charset getDefaultFileEncoding(File file) {
        SyntaxTextPaneUtilities.checkFileNotNull(file);
        String string = EditorLanguageUtils.getMimeTypeFromFilename(file.getName());
        Charset charset = SyntaxTextPaneUtilities.getDefaultFileEncoding();
        if (XMLLanguage.INSTANCE.getMimeType().equals(string)) {
            try {
                String string2 = XMLUtils.getEncoding((InputStream)new FileInputStream(file));
                charset = string2 == null ? charset : Charset.forName(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return charset;
    }

    public static Charset getContentBasedEncodingOrGivenDefault(STPInterface sTPInterface, Charset charset) {
        SyntaxTextPaneUtilities.checkSyntaxTextPaneNotNull(sTPInterface);
        SyntaxTextPaneUtilities.checkEnodingNotNull(charset);
        Charset charset2 = charset;
        if (SyntaxTextPaneUtilities.isXmlCode(sTPInterface)) {
            try {
                String string = XMLUtils.getEncoding((Reader)new DocumentReader(sTPInterface.getDocument()));
                charset2 = string == null ? charset2 : Charset.forName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return charset2;
    }

    private static void checkSyntaxTextPaneNotNull(STPInterface sTPInterface) {
        if (sTPInterface == null) {
            throw new IllegalArgumentException("The STPInterface cannot be null.");
        }
    }

    private static void checkEnodingNotNull(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("The encoding cannot be null.");
        }
    }

    private static void checkFileNotNull(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The file cannot be null.");
        }
    }
}

