/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FocusTraversalPolicyBuilder {
    private final Component fFirst;
    private final Component fLast;
    private final Map<Component, List<Step>> fForwardSteps;
    private final Map<Component, List<Step>> fBackwardSteps;
    private Component fLastDestination;

    public FocusTraversalPolicyBuilder(Component component, Component component2) {
        this.fFirst = component;
        this.fLast = component2;
        this.fLastDestination = component;
        this.fForwardSteps = new HashMap<Component, List<Step>>();
        this.fBackwardSteps = new HashMap<Component, List<Step>>();
    }

    public void addNextStep(Component component) {
        this.addStep(this.fLastDestination, component);
    }

    public void addNextStep(Component component, Condition condition) {
        this.addStep(this.fLastDestination, component, condition);
    }

    public void addStep(Component component, Component component2) {
        FocusTraversalPolicyBuilder.getSteps(this.fForwardSteps, component, true).add(new Step(component, component2));
        FocusTraversalPolicyBuilder.getSteps(this.fBackwardSteps, component2, true).add(new Step(component2, component));
        this.fLastDestination = component2;
    }

    public void addStep(Component component, Component component2, Condition condition) {
        FocusTraversalPolicyBuilder.getSteps(this.fForwardSteps, component, true).add(new Step(component, component2, condition));
        FocusTraversalPolicyBuilder.getSteps(this.fBackwardSteps, component2, true).add(new Step(component2, component, condition));
        this.fLastDestination = component2;
    }

    private static List<Step> getSteps(Map<Component, List<Step>> map, Component component, boolean bl) {
        List<Step> list = map.get(component);
        if (list == null) {
            list = new ArrayList<Step>();
            if (bl) {
                map.put(component, list);
            }
        }
        return list;
    }

    private static Component step(Map<Component, List<Step>> map, Component component, Component component2) {
        List<Step> list = FocusTraversalPolicyBuilder.getSteps(map, component, false);
        if (list.isEmpty()) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (FocusTraversalPolicyBuilder.getSteps(map, container, false).isEmpty()) continue;
                return FocusTraversalPolicyBuilder.step(map, container, component2);
            }
        } else {
            for (Step step : list) {
                if (!step.canBeTaken()) continue;
                return step.getDestination();
            }
            for (Step step : list) {
                if (!step.canBeSkipped()) continue;
                return FocusTraversalPolicyBuilder.step(map, step.getDestination(), component2);
            }
        }
        return component2;
    }

    public FocusTraversalPolicy getPolicy() {
        return new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container container, Component component) {
                return FocusTraversalPolicyBuilder.step(FocusTraversalPolicyBuilder.this.fForwardSteps, component, FocusTraversalPolicyBuilder.isUnder(FocusTraversalPolicyBuilder.this.fLast, component) ? FocusTraversalPolicyBuilder.this.fFirst : FocusTraversalPolicyBuilder.this.fLast);
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                return FocusTraversalPolicyBuilder.step(FocusTraversalPolicyBuilder.this.fBackwardSteps, component, FocusTraversalPolicyBuilder.isUnder(FocusTraversalPolicyBuilder.this.fFirst, component) ? FocusTraversalPolicyBuilder.this.fLast : FocusTraversalPolicyBuilder.this.fFirst);
            }

            @Override
            public Component getFirstComponent(Container container) {
                return FocusTraversalPolicyBuilder.this.fFirst;
            }

            @Override
            public Component getLastComponent(Container container) {
                return FocusTraversalPolicyBuilder.this.fLast;
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return FocusTraversalPolicyBuilder.this.fFirst;
            }
        };
    }

    private static boolean isUnder(Component component, Component component2) {
        return component != null && component2 != null && (component.equals(component2) || FocusTraversalPolicyBuilder.isUnder(component, component2.getParent()));
    }

    private static final class Step {
        private final Condition fCondition;
        private final Component fSource;
        private final Component fDestination;

        Step(Component component, Component component2) {
            this(component, component2, new Condition(){

                @Override
                public boolean evaluate() {
                    return true;
                }
            });
        }

        Step(Component component, Component component2, Condition condition) {
            this.fCondition = condition;
            this.fSource = component;
            this.fDestination = component2;
        }

        boolean canBeTaken() {
            return this.fCondition.evaluate() && this.fDestination.isShowing() && this.fDestination.isEnabled();
        }

        boolean canBeSkipped() {
            return this.fCondition.evaluate();
        }

        Component getSource() {
            return this.fSource;
        }

        Component getDestination() {
            return this.fDestination;
        }
    }

    public static interface Condition {
        public boolean evaluate();
    }
}

