/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.WidgetUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.apache.commons.lang.Validate;

public final class FileExtensionsPanel
implements ComponentBuilder {
    public static final String FILE_EXTENSIONS_PANEL_NAME_SUFFIX = "FileExtensionsPanel";
    public static final String EXTENSION_LIST_NAME_SUFFIX = "ExtensionList";
    public static final String SCROLLPANE_NAME_SUFFIX = "ExtensionScrollPane";
    public static final String ADD_BUTTON_NAME_SUFFIX = "AddButton";
    public static final String REMOVE_BUTTON_NAME_SUFFIX = "RemoveButton";
    private final MJPanel fPanel;
    private final DefaultListModel fModel;
    private final MJList fList;

    public FileExtensionsPanel(String string, List<String> list) {
        this(string, list.toArray(new String[list.size()]));
    }

    public FileExtensionsPanel(String string, String ... stringArray) {
        FileExtensionsPanel.validateExtensions(stringArray);
        this.fModel = FileExtensionsPanel.createModel(stringArray);
        this.fList = FileExtensionsPanel.createList(string, this.fModel);
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fList);
        mJScrollPane.setName(string + SCROLLPANE_NAME_SUFFIX);
        mJScrollPane.setPreferredSize(new Dimension(70, 50));
        this.fPanel = new MJPanel((LayoutManager)new FormLayout("3dlu, pref, 6dlu, pref", "pref, 2dlu"));
        this.fPanel.setName(string + FILE_EXTENSIONS_PANEL_NAME_SUFFIX);
        this.fPanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fPanel.setBorder((Border)BorderFactory.createTitledBorder(WidgetUtils.lookup("fileExtensions.title")));
        CellConstraints cellConstraints = new CellConstraints();
        this.fPanel.add((Component)mJScrollPane, (Object)cellConstraints.xy(2, 1));
        this.fPanel.add((Component)this.createAddRemoveButtonPanel(string), (Object)cellConstraints.xy(4, 1));
    }

    public void addExtension(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'newExtension' must not be null or empty");
        }
        if (string.startsWith(".")) {
            throw new IllegalArgumentException("extension should not begin with '.':" + string);
        }
        this.fModel.addElement(string);
        this.fList.setSelectedIndex(this.fModel.size() - 1);
        this.fList.ensureIndexIsVisible(this.fModel.size() - 1);
    }

    public List<String> getExtensions() {
        Object[] objectArray = new String[this.fModel.getSize()];
        this.fModel.copyInto(objectArray);
        return Arrays.asList(objectArray);
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    private static void validateExtensions(String ... stringArray) {
        Validate.notNull((Object)stringArray, (String)"'extensions' cannot be null");
    }

    private static DefaultListModel createModel(String ... stringArray) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : stringArray) {
            defaultListModel.addElement(string);
        }
        return defaultListModel;
    }

    private static MJList createList(String string, ListModel listModel) {
        MJList mJList = new MJList(listModel);
        mJList.setName(string + EXTENSION_LIST_NAME_SUFFIX);
        return mJList;
    }

    private JComponent createAddRemoveButtonPanel(String string) {
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addButtons(new JButton[]{this.createAddButton(string), this.createRemoveButton(string)});
        return buttonStackBuilder.getPanel();
    }

    private JButton createRemoveButton(String string) {
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(WidgetUtils.lookup("fileExtensions.removeButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Object object : FileExtensionsPanel.this.fList.getSelectedValues()) {
                    FileExtensionsPanel.this.fModel.removeElement(object);
                }
            }
        });
        mJButton.setName(string + REMOVE_BUTTON_NAME_SUFFIX);
        return mJButton;
    }

    private JButton createAddButton(String string) {
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(WidgetUtils.lookup("fileExtensions.addButton")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = MJOptionPane.showInputDialog((Component)FileExtensionsPanel.this.fPanel, (Object)WidgetUtils.lookup("fileExtensions.addExtension"), (String)WidgetUtils.lookup("fileExtensions.dialogTitle"), (int)3);
                if (string != null && (string = string.trim().replaceAll("^\\.*", "")).length() > 0) {
                    FileExtensionsPanel.this.addExtension(string);
                }
            }
        });
        mJButton.setName(string + ADD_BUTTON_NAME_SUFFIX);
        return mJButton;
    }
}

