/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.WidgetUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class Dialogs {
    public static void showOptionalMessageDialog(Component component, Object object, String string, int n, String string2, boolean bl) {
        if (Prefs.getBooleanPref((String)string2, (boolean)bl)) {
            MJCheckBox mJCheckBox = Dialogs.createDontShowCheckBox(WidgetUtils.lookup("message.DontShowMessage"));
            MJOptionPane.showMessageDialog((Component)component, (Object)Dialogs.createDontShowPanel(mJCheckBox, object), (String)string, (int)n);
            if (mJCheckBox.isSelected()) {
                Prefs.setBooleanPref((String)string2, (boolean)false);
            }
        }
    }

    public static int showOptionalConfirmDialog(Component component, Object object, String string, int n, int n2, String string2, int n3, boolean bl) {
        boolean bl2 = Prefs.getBooleanPref((String)string2, (boolean)bl);
        if (bl2) {
            MJCheckBox mJCheckBox = Dialogs.createDontShowCheckBox(WidgetUtils.lookup("message.DontShowPrompt"));
            int n4 = MJOptionPane.showConfirmDialog((Component)component, (Object)Dialogs.createDontShowPanel(mJCheckBox, object), (String)string, (int)n, (int)n2);
            if (n4 != 2 && n4 != -1 && mJCheckBox.isSelected()) {
                Prefs.setBooleanPref((String)string2, (boolean)false);
            }
            return n4;
        }
        return n3;
    }

    private static MJCheckBox createDontShowCheckBox(String string) {
        MJCheckBox mJCheckBox = new MJCheckBox(string, false);
        mJCheckBox.setBorder(BorderFactory.createEmptyBorder(12, 4, 8, 4));
        return mJCheckBox;
    }

    private static JComponent createDontShowPanel(MJCheckBox mJCheckBox, Object object) {
        AllowButtonHandlingPanel allowButtonHandlingPanel = new AllowButtonHandlingPanel(new BorderLayout());
        if (object instanceof Component) {
            allowButtonHandlingPanel.add((Component)object, "Center");
        } else {
            allowButtonHandlingPanel.add((Component)new MJMultilineLabel(object.toString()), "Center");
        }
        allowButtonHandlingPanel.add((Component)mJCheckBox, "South");
        return allowButtonHandlingPanel;
    }

    public static int showSaveDirtyFile(Component component, String string, String string2) {
        String string3 = MessageFormat.format(WidgetUtils.lookup("message.SaveChangesTo"), string);
        return Dialogs.showSaveCancelDontSaveDialog(component, string3, string2);
    }

    public static int showSaveCancelDontSaveDialog(Component component, String string, String string2) {
        int n;
        Window window = WindowUtils.getWindowForComponent((Component)component);
        if (PlatformInfo.isMacintosh()) {
            int n2 = MJOptionPane.showOptionDialog((Component)window, (Object)string, (String)string2, (int)1, (int)2, null, (Object[])new String[]{MJOptionPane.SAVE_STRING, MJOptionPane.CANCEL_STRING, MJOptionPane.DONT_SAVE_STRING}, (Object)MJOptionPane.SAVE_STRING);
            n = n2 == 0 ? 0 : (n2 == 1 || n2 == -1 ? 2 : 1);
        } else {
            n = MJOptionPane.showConfirmDialog((Component)window, (Object)string, (String)string2, (int)1, (int)2);
            if (n == -1) {
                n = 2;
            }
        }
        assert (n == 0 || n == 1 || n == 2);
        return n;
    }

    public static Option showOverwriteSaveAsCancel(Component component, String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Title cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Resource description cannot be null.");
        }
        String string3 = MessageFormat.format(WidgetUtils.lookup("message.ResourceIsReadOnly"), string);
        Option[] optionArray = new Option[]{Option.SAVE_AS, Option.OVERWRITE, Option.CANCEL};
        int n = MJOptionPane.showOptionDialog((Component)MJFrame.getFrame((Component)component), (Object)string3, (String)string2, (int)1, (int)2, null, (Object[])optionArray, (Object)((Object)Option.SAVE_AS));
        return n == -1 ? Option.CANCEL : optionArray[n];
    }

    private Dialogs() {
    }

    private static class AllowButtonHandlingPanel
    extends MJPanel
    implements MJOptionPane.EnhancedKeyHandling {
        AllowButtonHandlingPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public boolean allowMnemonicHandling() {
            return true;
        }

        public boolean allowArrowKeyTraversal() {
            return true;
        }
    }

    public static enum Option implements MJOptionPane.Option
    {
        SAVE_AS(WidgetUtils.lookup("button.SaveAs")),
        OVERWRITE(WidgetUtils.lookup("button.Overwrite")),
        CANCEL(MJOptionPane.CANCEL_STRING);

        private final String fText;

        private Option(String string2) {
            this.fText = string2;
        }

        public String getText() {
            return this.fText;
        }
    }
}

