/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ComponentUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang.Validate;

public class BusyAffordance
implements ComponentBuilder {
    public static final String BUSY_AFFORDANCE_TEST_NAME = "BusyAffordance";
    private static final int DELAY = 60;
    private static final int NUMBER_OF_POINTS = 8;
    private static final Color DARK_GRAY = new Color(69, 86, 106);
    private static final Color LIGHT_GRAY = new Color(181, 193, 205);
    private static final Color[] COLOR_ARRAY = ColorUtils.createGradientRange((Color)DARK_GRAY, (Color)LIGHT_GRAY, (int)8);
    private static final Color[] HIGH_CONTRAST_COLOR_ARRAY = ColorUtils.createGradientRange((Color)Color.WHITE, (Color)DARK_GRAY, (int)8);
    private String fBusyText;
    private boolean fPaintsWhenStopped;
    private boolean fSpinning = false;
    private boolean fWhiteOverride = false;
    private static boolean sStopAll;
    private final MJPanel fPanel;
    private final AffordanceSize fSize;
    private Timer fTimer;
    private int fIndex;

    public BusyAffordance() {
        this(AffordanceSize.SIZE_16x16, null);
    }

    public BusyAffordance(AffordanceSize affordanceSize) {
        this(affordanceSize, null);
    }

    public BusyAffordance(AffordanceSize affordanceSize, String string) {
        Validate.notNull((Object)((Object)affordanceSize));
        this.fSize = affordanceSize;
        this.fBusyText = string;
        this.fPanel = new MJPanel(){

            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                BusyAffordance.this.paintAffordance((Graphics2D)graphics);
            }

            public Dimension getPreferredSize() {
                Dimension dimension = BusyAffordance.this.fSize.getSquareSize();
                if (BusyAffordance.this.fBusyText != null) {
                    Rectangle2D rectangle2D = BusyAffordance.this.getStringRectangle(this.getGraphics());
                    dimension.setSize(Math.max(dimension.width, (int)rectangle2D.getWidth()), dimension.height + (int)rectangle2D.getHeight());
                }
                return dimension;
            }
        };
        this.fPanel.setOpaque(false);
        this.fPanel.setName(BUSY_AFFORDANCE_TEST_NAME);
        this.fPanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
    }

    public void setPaintsWhenStopped(boolean bl) {
        this.fPaintsWhenStopped = bl;
    }

    public void setBusyText(String string) {
        this.fBusyText = string;
    }

    public void start() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BusyAffordance.this.fTimer == null) {
                    BusyAffordance.this.fTimer = new Timer(60, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (sStopAll) {
                                BusyAffordance.this.stop();
                            } else {
                                BusyAffordance.this.incrementCounter();
                                BusyAffordance.this.repaintPanel();
                            }
                        }
                    });
                    BusyAffordance.this.fTimer.start();
                }
            }
        });
    }

    private void incrementCounter() {
        this.fIndex = (this.fIndex + 1) % 8;
    }

    private void setSpinStarted(boolean bl) {
        this.fSpinning = bl;
    }

    private void repaintPanel() {
        this.fPanel.revalidate();
        this.fPanel.repaint();
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    public void stop() {
        this.fSpinning = false;
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BusyAffordance.this.fTimer != null) {
                    BusyAffordance.this.fTimer.stop();
                    BusyAffordance.this.fTimer = null;
                }
                BusyAffordance.this.repaintPanel();
            }
        });
    }

    public static void stopAll() {
        sStopAll = true;
    }

    public void paintAffordance(Graphics2D graphics2D) {
        boolean bl;
        boolean bl2 = !this.isSpinning();
        boolean bl3 = this.fPaintsWhenStopped && bl2;
        boolean bl4 = !bl2 || bl3;
        boolean bl5 = bl = this.fBusyText != null;
        if (bl4) {
            this.paintDots(graphics2D, bl3);
            if (bl) {
                this.paintBusyText(graphics2D);
            }
        }
    }

    private boolean isSpinning() {
        return this.fTimer != null && this.fTimer.isRunning() || this.fSpinning;
    }

    private void paintDots(Graphics2D graphics2D, boolean bl) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < 8; ++i) {
            int n = bl ? 0 : (this.fIndex + i) % 8;
            this.paintEachDot(graphics2D, i, n);
        }
    }

    private Point2D.Double getPanelCenter() {
        double d = BusyAffordance.findCenter(this.fPanel.getWidth());
        double d2 = BusyAffordance.findCenter(this.fPanel.getHeight());
        return new Point2D.Double(d, d2);
    }

    private static double findCenter(int n) {
        return n % 2 == 0 ? n / 2 - 1 : (n - 1) / 2 - 1;
    }

    private void paintEachDot(Graphics2D graphics2D, int n, int n2) {
        Color color = this.getDotColor(n2);
        double d = this.fSize.getRadius(n2);
        graphics2D.setColor(color);
        Point2D.Double double_ = this.getPanelCenter();
        double d2 = this.fSize.getDotX(n) + double_.x - d / 2.0;
        double d3 = this.fSize.getDotY(n) + double_.y - d / 2.0;
        graphics2D.fill(new Ellipse2D.Double(d2, d3, d, d));
    }

    private Color getDotColor(int n) {
        return this.fWhiteOverride || ColorUtils.isDark((Color)ComponentUtils.getActualBackgroundColor((Component)this.getComponent())) ? HIGH_CONTRAST_COLOR_ARRAY[n] : COLOR_ARRAY[n];
    }

    public void useWhiteDots(boolean bl) {
        this.fWhiteOverride = bl;
    }

    private void paintBusyText(Graphics2D graphics2D) {
        Graphics graphics = graphics2D.create();
        Rectangle2D rectangle2D = this.getStringRectangle(graphics);
        graphics.setFont(UIManager.getFont("Label.font"));
        graphics.setColor(UIManager.getColor("TextField.inactiveForeground"));
        Point2D.Double double_ = this.getPanelCenter();
        graphics.drawString(this.fBusyText, (int)(double_.x - rectangle2D.getWidth() / 2.0), (int)(double_.y + this.fSize.getSquareSize().getHeight() / 2.0 + rectangle2D.getHeight()));
        graphics.dispose();
    }

    private Rectangle2D getStringRectangle(Graphics graphics) {
        FontMetrics fontMetrics = this.fPanel.getFontMetrics(this.fPanel.getFont());
        return fontMetrics.getStringBounds(this.fBusyText, graphics);
    }

    public static enum AffordanceSize {
        SIZE_16x16(8),
        SIZE_32x32(16);

        private final int fRadius;
        private final Point2D.Double[] fPoints;
        private final double fMinimumDotRadius;

        private AffordanceSize(int n2) {
            this.fRadius = n2;
            this.fPoints = new Point2D.Double[8];
            this.fMinimumDotRadius = (double)this.fRadius / 16.0;
            double d = (double)this.fRadius - 8.0 * this.fMinimumDotRadius / 2.0;
            double d2 = 0.7853981633974483;
            for (int i = 0; i < 8; ++i) {
                this.fPoints[i] = new Point2D.Double(d * Math.cos(d2 * (double)i), d * Math.sin(d2 * (double)i));
            }
        }

        public double getMinimumDotRadius() {
            return this.fMinimumDotRadius;
        }

        public double getDotX(int n) {
            return this.fPoints[n].getX();
        }

        public double getDotY(int n) {
            return this.fPoints[n].getY();
        }

        public Dimension getSquareSize() {
            return new Dimension(this.fRadius * 2, this.fRadius * 2);
        }

        public double getRadius(int n) {
            return (double)(8 - n) * this.getMinimumDotRadius();
        }
    }
}

