/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.mapreduce;

import com.mathworks.toolbox.parallel.mapreduce.Endpoint;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public final class PairSocket
implements Closeable {
    private static boolean initialized = false;
    private int fSocketHandle = PairSocket.nativeCreate();
    public static final int DEFAULT_TIMEOUT_IN_MILLISECONDS = 1000;
    public static final int INFINITE_TIMEOUT = -1;

    public static synchronized void initializeNativeLibrary() {
        if (!initialized) {
            System.loadLibrary("nativepairsocket");
            initialized = true;
        }
    }

    public PairSocket() throws IOException {
        this.setSendTimeout(1000L);
        this.setRecvTimeout(1000L);
    }

    public synchronized void bind(Endpoint endpoint) throws IOException {
        PairSocket.nativeBind(this.fSocketHandle, endpoint.toString());
    }

    public synchronized void connect(Endpoint endpoint) throws IOException {
        PairSocket.nativeConnect(this.fSocketHandle, endpoint.toString());
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed()) {
            PairSocket.nativeClose(this.fSocketHandle);
            this.fSocketHandle = -1;
        }
    }

    public synchronized boolean isClosed() {
        return this.fSocketHandle == -1;
    }

    public synchronized ByteBuffer recv(long l, TimeUnit timeUnit) throws IOException {
        if (l != 0L) {
            long l2 = timeUnit.toMillis(l);
            this.setRecvTimeout(l2);
        }
        byte[] byArray = PairSocket.nativeRecv(this.fSocketHandle, l != 0L);
        return byArray == null ? null : ByteBuffer.wrap(byArray);
    }

    public synchronized boolean send(ByteBuffer byteBuffer, long l, TimeUnit timeUnit) throws IOException {
        byte[] byArray;
        long l2 = timeUnit.toMillis(l);
        this.setSendTimeout(l2);
        byte[] byArray2 = null;
        if (byteBuffer.hasArray() && (byArray = byteBuffer.array()).length == byteBuffer.remaining()) {
            byArray2 = byArray;
        }
        if (byArray2 == null) {
            byArray2 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray2);
        }
        return PairSocket.nativeSend(this.fSocketHandle, byArray2);
    }

    private void setSendTimeout(long l) throws IOException {
        assert (l < Integer.MAX_VALUE);
        PairSocket.nativeSetSendTimeout(this.fSocketHandle, (int)l);
    }

    private void setRecvTimeout(long l) throws IOException {
        assert (l < Integer.MAX_VALUE);
        PairSocket.nativeSetRecvTimeout(this.fSocketHandle, (int)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static native int nativeCreate();

    private static native void nativeClose(int var0);

    private static native void nativeSetSendTimeout(int var0, int var1);

    private static native void nativeSetRecvTimeout(int var0, int var1);

    private static native void nativeBind(int var0, String var1);

    private static native void nativeConnect(int var0, String var1);

    private static native boolean nativeSend(int var0, byte[] var1);

    private static native byte[] nativeRecv(int var0, boolean var1);

    public static class OtherIOException
    extends IOException {
        public OtherIOException(String string) {
            super(string);
        }
    }

    public static class AddressInUseException
    extends IOException {
        public AddressInUseException(String string) {
            super(string);
        }
    }
}

