/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputText
extends TextField
implements EventListener,
ObjectPainter,
TextListener,
Movable {
    private DocView I;
    private DInputElement OEAB;
    private ObjectBox add;
    private int addEventListener = 10000;
    private String addTextListener;

    FormInputText(DocView docView, DElement dElement) {
        this.I = docView;
        this.OEAB = (DInputElement)dElement;
        this.OEAB.addEventListener("blur", this, false);
        this.I();
        int n = this.OEAB.getAttributeAsInt("size");
        if (n <= 0) {
            n = 20;
        }
        this.setColumns(n);
        this.setBackground(Color.white);
        this.enableEvents(28L);
        this.addTextListener(this);
    }

    private void I() {
        String string;
        this.setEditable(!this.OEAB.getReadOnly());
        this.setEnabled(!this.OEAB.getDisabled());
        int n = this.OEAB.getMaxLength();
        if (n > 0) {
            this.addEventListener = n;
        }
        if ((string = this.OEAB.getValue()) != null && !string.equals(this.getText())) {
            this.setText(string);
            try {
                this.setCaretPosition(string.length());
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        String string;
        String string2 = this.getText();
        if (string2.length() > this.addEventListener) {
            int n = this.getCaretPosition();
            if (n > this.addEventListener) {
                n = this.addEventListener;
            }
            string2 = string2.substring(0, this.addEventListener);
            this.setText(string2);
            try {
                this.setCaretPosition(n);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        if (!string2.equals(string = this.OEAB.getValue())) {
            this.OEAB.setValue(string2);
        }
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        this.I();
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.add = objectBox;
        this.I.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.add;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    void updateFont() {
        CSSAttribs cSSAttribs;
        Font font;
        if (this.add != null && !(font = (cSSAttribs = this.add.getCSSAttribs()).getFont()).equals(super.getFont())) {
            int n = this.getCaretPosition();
            Container container = this.getParent();
            container.remove(this);
            super.setFont(font);
            container.add(this);
            try {
                this.setCaretPosition(n);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        Object object;
        int n;
        FormInputText formInputText = null;
        int n2 = aWTEvent.getID();
        if (!(n2 != 401 && n2 != 402 || (n = ((KeyEvent)(object = (KeyEvent)aWTEvent)).getKeyCode()) != 39 && n != 37)) {
            formInputText = this;
        }
        if (this.I.onComponentEvent(this, aWTEvent, formInputText)) {
            super.processEvent(aWTEvent);
            if (1004 == n2) {
                if (this.addTextListener == null) {
                    this.addTextListener = this.getText();
                }
            } else if (1005 == n2 && !((FocusEvent)aWTEvent).isTemporary()) {
                object = this.getText();
                if (!((String)object).equals(this.addTextListener)) {
                    this.OEAB.dispatchChange();
                }
                this.addTextListener = null;
            }
        }
    }

    public void handleEvent(Event event) {
        if (((DOMEvent)event).getTypeId() == 22) {
            this.select(0, 0);
            return;
        }
        DOMUIEvent dOMUIEvent = (DOMUIEvent)event;
        int n = this.getCaretPosition();
        int n2 = this.getText().length();
        if (n == 0 && dOMUIEvent.getKeyCode() == 37L) {
            return;
        }
        if (n == n2 && dOMUIEvent.getKeyCode() == 39L) {
            return;
        }
        super.processEvent((AWTEvent)dOMUIEvent.getSystemEvent());
        dOMUIEvent.setDefaultDone();
    }

    public Dimension getPreferredSize() {
        String string = Defs.sysProperty((String)"ice.pilots.html4.colWidthChar");
        Dimension dimension = super.getPreferredSize();
        if (string == null || string.length() != 1) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = this.getColumns() * fontMetrics.charWidth(string.charAt(0));
            Dimension dimension2 = new Dimension(n, dimension.height);
            return dimension2;
        }
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        this.updateFont();
    }
}

