/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.ThePilot;
import ice.util.Defs;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

class ImageObjectPainter
implements ObjectPainter,
ImageObserver {
    private ObjectBox OEAB;
    private Image cssLayout;
    private Image currentTimeMillis;
    private int doImageAnimation = -1;
    private int doc = -1;
    private boolean draw3DRect = false;
    private boolean drawImage = false;
    private int drawLine = -1;
    private int fillRect = -1;
    private long getDomNode = System.currentTimeMillis();
    static final int NOTFOUND_WIDTH = 10;
    static final int NOTFOUND_HEIGHT = 10;
    private static boolean getHeight = !Defs.sysPropertyBoolean((String)"ice.pilots.html4.doNotReflowOnImages", (boolean)false);

    ImageObjectPainter(Image image) {
        this.cssLayout = image;
    }

    void setImage(Image image) {
        this.cssLayout = image;
        boolean bl = ThePilot.prepareImage(image, this);
        if (bl) {
            this.currentTimeMillis = image;
        }
        if (this.OEAB != null) {
            this.OEAB.reqRepaint();
        }
    }

    protected Image getImage() {
        return this.cssLayout;
    }

    public void dispose() {
    }

    public void setBox(ObjectBox objectBox) {
        this.OEAB = objectBox;
    }

    public ObjectBox getBox() {
        return this.OEAB;
    }

    public void setPainterSize(int n, int n2) {
        this.drawLine = n;
        this.fillRect = n2;
    }

    public int getPrefWidth() {
        if (this.cssLayout != null && this.doImageAnimation < 0) {
            this.doImageAnimation = this.cssLayout.getWidth(this);
        }
        if (this.doImageAnimation < 0) {
            return 10;
        }
        return this.doImageAnimation;
    }

    public int getPrefHeight() {
        if (this.cssLayout != null && this.doc < 0) {
            this.doc = this.cssLayout.getHeight(this);
        }
        if (this.doc < 0) {
            return 10;
        }
        return this.doc;
    }

    public void setForeground(Color color) {
    }

    public void setBackground(Color color) {
    }

    public void setBorderVisible(boolean bl) {
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
    }

    public void draw(Graphics graphics) {
        if (this.cssLayout == null || this.draw3DRect) {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 9, 9);
            if (this.drawLine > 0 && this.fillRect > 0) {
                graphics.setColor(Color.gray);
                graphics.draw3DRect(0, 0, this.drawLine - 1, this.fillRect - 1, false);
            }
            graphics.setColor(Color.red);
            graphics.drawLine(2, 2, 7, 7);
            graphics.drawLine(2, 7, 7, 2);
            return;
        }
        if (this.doImageAnimation < 0 && this.doc < 0) {
            return;
        }
        if (this.drawLine == 0 || this.fillRect == 0) {
            return;
        }
        if (this.currentTimeMillis != null && this.currentTimeMillis != this.cssLayout) {
            ImageObjectPainter.OEAB(graphics, this.currentTimeMillis, null, this.doImageAnimation, this.doc, this.drawLine, this.fillRect);
        } else {
            ImageObjectPainter.OEAB(graphics, this.cssLayout, this, this.doImageAnimation, this.doc, this.drawLine, this.fillRect);
        }
    }

    private static void OEAB(Graphics graphics, Image image, ImageObserver imageObserver, int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0 || n3 == n && n4 == n2) {
            graphics.drawImage(image, 0, 0, imageObserver);
        } else {
            graphics.drawImage(image, 0, 0, n3, n4, imageObserver);
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        block12: {
            try {
                ObjectBox objectBox = this.OEAB;
                if (image != this.cssLayout || objectBox == null) {
                    return (n & 0xF0) == 0;
                }
                if ((n & 0xC0) != 0) {
                    this.draw3DRect = true;
                    return false;
                }
                if (!((n & 3) == 0 || this.doImageAnimation >= 0 && this.doc >= 0 || this.drawImage)) {
                    ((CSSBox)objectBox).invalidate();
                    if (getHeight) {
                        ((CSSBox)objectBox).reqReflow();
                    }
                }
                if ((n & 0x20) != 0) {
                    DNode dNode = ((CSSBox)objectBox).getDomNode();
                    if (dNode != null) {
                        dNode.doc.processEvent(13, dNode);
                    }
                    this.drawImage = true;
                    ((CSSBox)objectBox).reqRepaint();
                    this.currentTimeMillis = this.cssLayout;
                }
                if ((n & 0x10) == 0) break block12;
                long l = System.currentTimeMillis() - this.getDomNode;
                if (l < 50L) {
                    try {
                        Thread.sleep(50L - l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.drawImage = true;
                this.currentTimeMillis = this.cssLayout;
                if (objectBox != null && objectBox.cssLayout != null && objectBox.cssLayout.doImageAnimation) {
                    ((CSSBox)objectBox).reqRepaint();
                }
                this.getDomNode = System.currentTimeMillis();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        int n = dAttr.nameId;
        if (n == 102 || n == 119 || n == 45) {
            String string;
            Image image;
            ObjectPool objectPool = dElement.getPilot().objectPool;
            String string2 = dAttr.getValue();
            if (string2 != null && (image = objectPool.loadImage(string = dElement.doc.resolveUrl(string2))) != null) {
                this.setImage(image);
            }
        }
    }
}

