/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.util;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.ResourceBundle;

public class RecordFileWriter {
    public static int LINE_NUMBER_PADDING = 7;
    private static final String FILESEP = File.separator;
    protected static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.util.resources.RES_INSTRUTIL");
    private static final int SIGNED = 1;
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] BYTE_ORDER_STR = new String[]{"little", "big"};
    protected static final String BLANKS = "                                         ";
    private static final String[] PRE_DATATYPE_STR = new String[]{"u", ""};
    protected static final String ZEROS = "00000000000000000000";
    private RandomAccessFile appendWriter;
    private Instrument object;
    protected int numCommandsWritten = 1;

    public void setObject(Instrument instrument) {
        this.object = instrument;
    }

    public final void open() throws TMException {
        try {
            this.appendWriter = new RandomAccessFile(this.object.getRecordName(), "rw");
            switch (this.object.getRecordMode()) {
                case 0: 
                case 2: {
                    this.appendWriter.setLength(0L);
                    break;
                }
                default: {
                    long l = this.appendWriter.length();
                    this.appendWriter.seek(l);
                }
            }
            if (this.appendWriter.length() == 0L) {
                this.appendLegendToFile();
            }
            Calendar calendar = Calendar.getInstance();
            this.appendToFile(this.numCommandsWritten + "      Recording on " + this.constructEventTime(calendar) + "." + " Binary data in " + BYTE_ORDER_STR[this.object.getByteOrder()] + " endian format.");
            ++this.numCommandsWritten;
        }
        catch (IOException iOException) {
            this.object.turnOffRecordStatus();
            Instrument.displayWarning(sResources.getString("RecordFile.ErrorDuringOpen"));
        }
    }

    public final void close() throws TMException {
        String string;
        int n = LINE_NUMBER_PADDING - new Integer(this.numCommandsWritten).toString().length();
        try {
            string = this.numCommandsWritten + BLANKS.substring(0, n) + "  Recording off." + Instrument.LINESEP;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.numCommandsWritten = 1;
            n = LINE_NUMBER_PADDING - new Integer(this.numCommandsWritten).toString().length();
            string = this.numCommandsWritten + BLANKS.substring(0, n) + "  Recording off." + Instrument.LINESEP;
        }
        this.numCommandsWritten = 1;
        try {
            if (this.appendWriter != null) {
                this.appendToFile(string);
                this.appendWriter.close();
                this.appendWriter = null;
            }
        }
        catch (IOException iOException) {
            throw new TMException(iOException.getMessage());
        }
    }

    public String updateRecordName() throws TMException {
        String string = this.object.getRecordName();
        if (this.object.getRecordStatus() && this.object.getRecordMode() == 2) {
            return this.parseFileName(string);
        }
        return null;
    }

    public final void appendToFile(String string) throws TMException {
        try {
            this.appendWriter.writeBytes(string + "\n");
        }
        catch (IOException iOException) {
            Instrument.displayWarning(sResources.getString("RecordFile.ErrorDuringWrite"));
            System.err.println(iOException.getMessage());
        }
        Editor editor = MLEditorServices.getEditorApplication().findEditor((StorageLocation)new FileStorageLocation(new File(this.object.getRecordName()).getAbsolutePath()));
        if (editor != null) {
            editor.reload();
        }
    }

    public final void appendAsciiDataToFile(String string, int n, String string2) throws TMException {
        String string3;
        int n2 = LINE_NUMBER_PADDING - new Integer(this.numCommandsWritten).toString().length();
        try {
            string3 = this.numCommandsWritten + BLANKS.substring(0, n2) + string2 + " ";
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.numCommandsWritten = 1;
            n2 = LINE_NUMBER_PADDING - new Integer(this.numCommandsWritten).toString().length();
            string3 = this.numCommandsWritten + BLANKS.substring(0, n2) + string2 + " ";
        }
        try {
            this.appendWriter.writeBytes(string3);
        }
        catch (IOException iOException) {
            this.object.turnOffRecordStatus();
            Instrument.displayWarning(sResources.getString("RecordFile.ErrorDuringWrite"));
        }
        switch (this.object.getRecordDetail()) {
            case 0: {
                this.appendToFile(n + " ascii values.");
                break;
            }
            case 1: {
                this.appendToFile(n + " ascii values.");
                for (int i = 0; i < string.length(); i += 60) {
                    int n3 = 60;
                    if (i + 60 > string.length()) {
                        n3 = string.length() - i;
                    }
                    this.appendToFile(BLANKS.substring(0, 7) + string.substring(i, i + n3));
                }
                break;
            }
        }
        ++this.numCommandsWritten;
    }

    public final void appendBinaryDataToFile(Object object, int n, int n2, String string, String string2, int n3) throws Exception {
        String string3;
        int n4 = LINE_NUMBER_PADDING - new Integer(this.numCommandsWritten).toString().length();
        try {
            string3 = this.numCommandsWritten + BLANKS.substring(0, n4) + string + " ";
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.numCommandsWritten = 1;
            n4 = LINE_NUMBER_PADDING - new Integer(this.numCommandsWritten).toString().length();
            string3 = this.numCommandsWritten + BLANKS.substring(0, n4) + string + " ";
        }
        try {
            this.appendWriter.writeBytes(string3);
        }
        catch (IOException iOException) {
            this.object.turnOffRecordStatus();
            Instrument.displayWarning(sResources.getString("RecordFile.ErrorDuringWrite"));
        }
        switch (this.object.getRecordDetail()) {
            case 0: {
                this.appendBinaryCompactToFile(n, n2, string2, n3);
                break;
            }
            case 1: {
                this.appendBinaryVerboseToFile(object, n, n2, string2, n3);
            }
        }
        ++this.numCommandsWritten;
    }

    private final void appendBinaryCompactToFile(int n, int n2, String string, int n3) throws TMException {
        String string2 = "";
        switch (n2) {
            case 0: {
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "int8 values" + string + ".";
                break;
            }
            case 1: {
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "int16 values" + string + ".";
                break;
            }
            case 2: {
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "int32 values" + string + ".";
                break;
            }
            case 3: {
                string2 = n + " single precision values" + string + ".";
                break;
            }
            case 4: {
                string2 = n + " double precision values.";
                break;
            }
            case 5: {
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "char values" + string + ".";
            }
        }
        this.appendToFile(string2);
    }

    private final void appendBinaryVerboseToFile(Object object, int n, int n2, String string, int n3) throws Exception {
        int n4 = 0;
        int n5 = 7;
        String string2 = "";
        switch (n2) {
            case 0: {
                byte[] byArray = object instanceof Byte ? Instrument.object2byteArray(object) : (byte[])object;
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "int8 values" + string + ".\n" + BLANKS.substring(0, n5);
                this.appendWriter.writeBytes(string2);
                for (n4 = 1; n4 <= n; ++n4) {
                    this.appendWriter.writeBytes(this.dec2hex(byArray[n4 - 1], 2, n3) + " ");
                    if (n4 % 16 != 0) continue;
                    this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n5));
                }
                break;
            }
            case 1: {
                short[] sArray = object instanceof Short ? Instrument.object2shortArray(object) : (short[])object;
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "int16 values" + string + ".\n" + BLANKS.substring(0, n5);
                this.appendWriter.writeBytes(string2);
                for (n4 = 1; n4 <= n; ++n4) {
                    this.appendWriter.writeBytes(this.dec2hex(sArray[n4 - 1], 4, n3) + " ");
                    if (n4 % 8 != 0) continue;
                    this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n5));
                }
                break;
            }
            case 2: {
                int[] nArray = object instanceof Integer ? Instrument.object2intArray(object) : (int[])object;
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "int32 values" + string + ".\n" + BLANKS.substring(0, n5);
                this.appendWriter.writeBytes(string2);
                for (n4 = 1; n4 <= n; ++n4) {
                    this.appendWriter.writeBytes(this.dec2hex(nArray[n4 - 1], 8, n3) + " ");
                    if (n4 % 4 != 0) continue;
                    this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n5));
                }
                break;
            }
            case 3: {
                Object object2;
                float[] fArray = new float[4];
                int n6 = 0;
                float[] fArray2 = object instanceof Float ? Instrument.object2floatArray(object) : (float[])object;
                this.appendWriter.writeBytes(n + " single precision values" + string + ".\n" + BLANKS.substring(0, n5));
                for (n4 = 1; n4 <= n; ++n4) {
                    object2 = this.dec2hex(Float.floatToIntBits(fArray2[n4 - 1]), 8, n3);
                    this.appendWriter.writeBytes((String)object2 + " ");
                    fArray[n6++] = fArray2[n4 - 1];
                    if (n6 != 4) continue;
                    for (int i = 0; i < 4; ++i) {
                        this.appendBinaryText("    ", String.valueOf(fArray[i]));
                    }
                    if (n4 != n) {
                        this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n5));
                    }
                    n6 = 0;
                }
                if (n6 == 0) break;
                object2 = new int[]{31, 22, 13};
                this.appendBinaryText(BLANKS.substring(0, (int)object2[n6 - 1]), String.valueOf(fArray[0]));
                for (n4 = 1; n4 < n6; ++n4) {
                    this.appendBinaryText("    ", String.valueOf(fArray[n4]));
                }
                break;
            }
            case 4: {
                double[] dArray = new double[2];
                int n7 = 0;
                double[] dArray2 = object instanceof Double ? Instrument.object2doubleArray(object) : (double[])object;
                this.appendWriter.writeBytes(n + " double precision values.\n" + BLANKS.substring(0, n5));
                for (n4 = 1; n4 <= n; ++n4) {
                    long l = Double.doubleToLongBits(dArray2[n4 - 1]);
                    this.appendWriter.writeBytes(this.dec2hex((int)(l >>> 56) & 0xFF, 2, n3) + this.dec2hex((int)(l >>> 48) & 0xFF, 2, n3) + this.dec2hex((int)(l >>> 40) & 0xFF, 2, n3) + this.dec2hex((int)(l >>> 32) & 0xFF, 2, n3) + this.dec2hex((int)(l >>> 24) & 0xFF, 2, n3) + this.dec2hex((int)(l >>> 16) & 0xFF, 2, n3) + this.dec2hex((int)(l >>> 8) & 0xFF, 2, n3) + this.dec2hex((int)l & 0xFF, 2, n3) + " ");
                    dArray[n7++] = dArray2[n4 - 1];
                    if (n7 != 2) continue;
                    this.appendBinaryText("      ", String.valueOf(dArray[0]));
                    this.appendBinaryText("    ", String.valueOf(dArray[1]));
                    if (n4 != n) {
                        this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n5));
                    }
                    n7 = 0;
                }
                if (n7 == 0) break;
                this.appendBinaryText(BLANKS.substring(0, 23), String.valueOf(dArray[0]));
                break;
            }
            case 5: {
                byte[] byArray = object instanceof Byte ? Instrument.object2byteArray(object) : (byte[])object;
                string2 = n + " " + PRE_DATATYPE_STR[n3] + "char values" + string + ".\n" + BLANKS.substring(0, n5);
                this.appendWriter.writeBytes(string2);
                for (n4 = 1; n4 <= n; ++n4) {
                    this.appendWriter.writeBytes(this.dec2hex(byArray[n4 - 1], 2, n3) + " ");
                    if (n4 % 16 != 0) continue;
                    this.appendWriter.writeBytes("\n" + BLANKS.substring(0, n5));
                }
                break;
            }
        }
        this.appendToFile("");
    }

    private void appendBinaryText(String string, String string2) throws TMException {
        try {
            String string3;
            int n = string2.lastIndexOf("E");
            if (n != -1) {
                double d;
                String string4;
                string3 = string2.substring(0, n);
                string2 = string3.length() >= 7 ? (string3.substring(6, 7).compareTo("5") >= 0 ? ((string4 = String.valueOf(d = new Double(string3.substring(0, 6)) + 1.0E-4)).length() > 6 ? string4.substring(0, 6) + "e" + string2.substring(n + 1) : string4 + "e" + string2.substring(n + 1)) : string3.substring(0, 6) + "e" + string2.substring(n + 1)) : string3.substring(0, n) + "e" + string2.substring(n + 1);
            }
            string3 = "";
            if (string2.length() < 12) {
                string3 = BLANKS.substring(0, 12 - string2.length());
            }
            this.appendWriter.writeBytes(string + string2 + string3);
        }
        catch (Exception exception) {
            this.object.turnOffRecordStatus();
            Instrument.displayWarning(sResources.getString("RecordFile.ErrorDuringWrite"));
        }
    }

    private final void appendLegendToFile() throws TMException {
        this.appendToFile("Legend: ");
        this.appendToFile("  * - An event occurred.");
        this.appendToFile("  > - A write operation occurred.");
        this.appendToFile("  < - A read operation occurred.");
        this.appendToFile(" ");
    }

    private final String parseFileName(String string) {
        if (string.equals("")) {
            return "";
        }
        String string2 = "";
        String string3 = "";
        int n = string.lastIndexOf(FILESEP);
        if (n == -1) {
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        }
        boolean bl = true;
        int n2 = string2.lastIndexOf(".");
        if (n2 == -1) {
            n2 = string2.length();
            string2 = string2 + ".txt";
            bl = false;
        }
        String string4 = string2.substring(n2, string2.length());
        char c = string2.charAt(n2 - 1);
        boolean bl2 = Character.isDigit(c);
        if (!bl2) {
            String string5 = string2.substring(0, n2);
            if (bl) {
                return string3 + string5 + "01" + string4;
            }
            return string3 + string5 + "01";
        }
        int n3 = 0;
        while (bl2 && n2 - n3 >= 1) {
            c = string2.charAt(n2 - n3 - 1);
            bl2 = Character.isDigit(c);
            if (!bl2) continue;
            ++n3;
        }
        String string6 = string2.substring(0, n2 - n3);
        String string7 = string2.substring(n2 - n3, n2);
        Integer n4 = new Integer(string7);
        int n5 = n4 + 1;
        int n6 = Integer.toString(n5).length();
        int n7 = n3 - n6;
        String string8 = n7 > 0 ? ZEROS.substring(0, n7) : "";
        if (bl) {
            return string3 + string6 + string8 + n5 + string4;
        }
        return string3 + string6 + string8 + n5;
    }

    public void appendEvent(String string, Calendar calendar) {
        try {
            int n = LINE_NUMBER_PADDING - new Integer(this.numCommandsWritten).toString().length();
            this.appendToFile(this.numCommandsWritten + BLANKS.substring(0, n) + "* " + string + " event occurred at " + this.constructEventTime(calendar) + ".");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.numCommandsWritten = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.numCommandsWritten;
    }

    private final String constructEventTime(Calendar calendar) {
        return this.padWithZero(calendar.get(5)) + "-" + MONTHS[calendar.get(2)] + "-" + calendar.get(1) + " at " + this.padWithZero(calendar.get(11)) + ":" + this.padWithZero(calendar.get(12)) + ":" + this.padWithZero(calendar.get(13)) + "." + this.padMilliWithZero(calendar.get(14));
    }

    private final String padWithZero(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return new Integer(n).toString();
    }

    private final String padMilliWithZero(int n) {
        if (n < 10) {
            return "00" + n;
        }
        if (n < 100) {
            return "0" + n;
        }
        return new Integer(n).toString();
    }

    protected final int hex2dec(String string) throws Exception {
        return Integer.parseInt(string, 16);
    }

    private final String dec2hex(long l, int n, int n2) {
        String string;
        if (n2 == 1) {
            switch (n) {
                case 2: {
                    l += 128L;
                    break;
                }
                case 4: {
                    l += 32768L;
                    break;
                }
                case 8: {
                    l += Integer.MIN_VALUE;
                }
            }
        } else if (l < 0L) {
            switch (n) {
                case 2: {
                    l += 256L;
                    break;
                }
                case 4: {
                    l += 65536L;
                    break;
                }
                case 8: {
                    l += 0L;
                }
            }
        }
        try {
            string = Long.toHexString(l);
        }
        catch (Exception exception) {
            string = "?";
        }
        int n3 = n - string.length();
        if (n3 < 0) {
            return string.substring(string.length() - n);
        }
        return ZEROS.substring(0, n3) + string;
    }
}

