/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcomm;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.toolbox.instrument.instrcomm.MatlabActionListener;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public class MatlabCaller
implements Runnable,
MatlabListener {
    protected static final int FOPEN = 0;
    protected static final int FCLOSE = 1;
    protected static final int WRITE = 2;
    protected static final int READ = 3;
    protected static final int FLUSH = 4;
    protected static final int QUERY = 5;
    protected static final int ISOPEN = 6;
    protected static final int DEMO = 7;
    protected static final int DOC = 8;
    private Vector<MatlabActionListener> listeners;
    private int matlabAction;
    private Matlab matlab = new Matlab();
    private Object[] matlabArgs;

    public void dispose() {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeAllElements();
        this.listeners = null;
    }

    public void runAction(int n, Object[] objectArray) {
        this.matlabAction = n;
        this.matlabArgs = objectArray;
        Matlab.whenMatlabReady((Runnable)this);
    }

    @Override
    public void run() {
        try {
            this.matlab.feval("instrgate", this.matlabArgs, 1, (MatlabListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        int n = Matlab.getExecutionStatus((int)matlabEvent.getStatus());
        if (n != 0) {
            this.postMatlabActionErroredEvent(this.matlabAction);
            TMStringUtil.error((String)"Communication Error", (String)"An error occurred while communicating with the instrument.");
        } else {
            this.postMatlabActionCompleteEvent(this.matlabAction, matlabEvent.getResult(), this.matlabArgs);
        }
    }

    public void addMatlabActionListener(MatlabActionListener matlabActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(matlabActionListener)) {
            this.listeners.addElement(matlabActionListener);
        }
    }

    public void removeMatlabActionListener(MatlabActionListener matlabActionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(matlabActionListener);
        matlabActionListener = null;
    }

    public void postMatlabActionCompleteEvent(int n, Object object, Object[] objectArray) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            MatlabActionListener matlabActionListener = this.listeners.elementAt(i);
            matlabActionListener.matlabActionComplete(n, object, objectArray);
        }
    }

    public void postMatlabActionErroredEvent(int n) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            MatlabActionListener matlabActionListener = this.listeners.elementAt(i);
            matlabActionListener.matlabActionErrored(n);
        }
    }
}

