/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcomm;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.TCPIP;
import com.mathworks.toolbox.instrument.instrcomm.ConnectRow;
import com.mathworks.toolbox.instrument.instrcomm.DisconnectRow;
import com.mathworks.toolbox.instrument.instrcomm.HistoryTable;
import com.mathworks.toolbox.instrument.instrcomm.MatlabActionListener;
import com.mathworks.toolbox.instrument.instrcomm.MatlabCaller;
import com.mathworks.toolbox.instrument.instrcomm.NewObjectRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;

public class CommunicationLabel
extends MJPanel
implements ActionListener,
PropertyChangedListener,
InstrumentObjectListener,
MatlabActionListener {
    private static final long serialVersionUID = 1L;
    private MJButton openButton;
    private MJButton closeButton;
    private MJLabel label;
    private boolean showLabel = true;
    private HistoryTable historyTable;
    private String objectName;
    private MatlabCaller matlabCaller;
    public Instrument currentObject;
    private int numOfObjects;

    public CommunicationLabel(HistoryTable historyTable, int n, Instrument instrument) {
        this(historyTable, n, instrument, true);
    }

    public CommunicationLabel(HistoryTable historyTable, int n, Instrument instrument, boolean bl) {
        this.historyTable = historyTable;
        this.numOfObjects = n;
        this.currentObject = instrument;
        this.showLabel = bl;
        this.matlabCaller = new MatlabCaller();
        this.matlabCaller.addMatlabActionListener(this);
        this.setLayout(new BorderLayout(0, 0));
        if (this.showLabel()) {
            this.setBorder(BorderFactory.createTitledBorder(""));
        }
        this.layoutPanel();
        if (this.numOfObjects == 0) {
            this.setComponentsEnabled(false);
        }
        if (this.enableInstrumentObjectEvents()) {
            Instrument.addInstrumentObjectListener(this);
        }
        if (this.currentObject != null) {
            this.selectedObjectUpdated(this.currentObject);
        }
        Instrument.addPropertyChangedListener(this);
        if (this.currentObject == null) {
            return;
        }
        this.selectedObjectUpdated(this.currentObject);
    }

    public void setHistoryTable(HistoryTable historyTable) {
        this.historyTable = historyTable;
    }

    public boolean showLabel() {
        return this.showLabel;
    }

    public boolean enableInstrumentObjectEvents() {
        return true;
    }

    public void setStateOpen(final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CommunicationLabel.this.setStateOpen(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (!bl) {
            this.openButton.setText("Connect");
        }
        this.openButton.setEnabled(!bl);
        this.closeButton.setEnabled(bl);
    }

    public void dispose() {
        if (this.enableInstrumentObjectEvents()) {
            Instrument.removeInstrumentObjectListener(this);
        }
        Instrument.removePropertyChangedListener(this);
        this.matlabCaller.removeMatlabActionListener(this);
        this.matlabCaller.dispose();
        this.cleanup();
    }

    public void cleanup() {
        this.openButton.removeActionListener((ActionListener)this);
        this.closeButton.removeActionListener((ActionListener)this);
    }

    public void setup() {
        this.openButton.addActionListener((ActionListener)this);
        this.closeButton.addActionListener((ActionListener)this);
    }

    private void layoutPanel() {
        MJPanel mJPanel = new MJPanel();
        if (this.showLabel()) {
            mJPanel.setLayout((LayoutManager)new FlowLayout(0));
        } else {
            mJPanel.setLayout((LayoutManager)new GridLayout(1, 2, 4, 0));
        }
        this.label = new MJLabel("Using: ");
        this.label.setName("Object Label");
        this.openButton = new MJButton("Connect");
        this.openButton.setName("Communicate Open Button");
        this.openButton.setEnabled(true);
        this.closeButton = new MJButton("Disconnect");
        this.closeButton.setName("Communicate Close Button");
        this.closeButton.setEnabled(false);
        this.setup();
        if (this.showLabel()) {
            mJPanel.add((Component)this.label);
        }
        mJPanel.add((Component)this.openButton);
        mJPanel.add((Component)this.closeButton);
        this.add((Component)mJPanel, "North");
    }

    public void setLabel(String string) {
        this.objectName = string;
        this.label.setText("Using: " + this.objectName);
        boolean bl = this.historyTable.addCommunicatingWithRow(this.objectName);
        if (bl) {
            this.historyTable.addMCode(new NewObjectRow(this.currentObject));
        }
    }

    public void setComponentsEnabled(final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CommunicationLabel.this.setComponentsEnabled(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (this.showLabel) {
            this.openButton.setEnabled(bl);
            this.closeButton.setEnabled(bl);
            this.label.setEnabled(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.blockEvents(true);
        if (actionEvent.getSource() == this.openButton) {
            if (this.openButton.getText().equals("Cancel")) {
                this.openButton.setText("Connect");
                if (this.isTCPIPServer(this.currentObject)) {
                    ((TCPIP)this.currentObject).setError("Canceled");
                }
                return;
            }
            this.callMATLABToConnect();
            this.openButton.setText("Cancel");
        } else if (actionEvent.getSource() == this.closeButton) {
            this.openButton.setText("Connect");
            if (this.isTCPIPServer(this.currentObject)) {
                ((TCPIP)this.currentObject).setError("Canceled");
            }
            this.callMATLABToDisconnect();
        }
    }

    private boolean isTCPIPServer(Instrument instrument) {
        return instrument instanceof TCPIP && ((TCPIP)instrument).getNetworkRole() == 1;
    }

    public void callMATLABToConnect() {
        this.openButton.setText("Cancel");
        Object[] objectArray = new Object[]{"privateInstrcommHelper", "fopen", this.currentObject};
        this.matlabCaller.runAction(0, objectArray);
    }

    public void callMATLABToDisconnect() {
        this.openButton.setText("Connect");
        Object[] objectArray = new Object[]{"privateInstrcommHelper", "fclose", this.currentObject};
        this.matlabCaller.runAction(1, objectArray);
    }

    public void addConnectRow() {
        this.historyTable.addMCode(new ConnectRow(this.currentObject));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommunicationLabel.this.historyTable.addRow("Connecting to", CommunicationLabel.this.currentObject.getName(), "", "");
            }
        });
    }

    public void addDisconnectRow() {
        this.historyTable.addMCode(new DisconnectRow(this.currentObject));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CommunicationLabel.this.historyTable.addRow("Disconnecting from", CommunicationLabel.this.currentObject.getName(), "", "");
            }
        });
    }

    public void selectedObjectUpdated(Instrument instrument) {
        if (this.currentObject == null && instrument != null) {
            this.setComponentsEnabled(true);
        }
        this.currentObject = instrument;
        if (this.currentObject == null) {
            this.setComponentsEnabled(false);
            return;
        }
        this.setLabel(this.currentObject.getName());
        int n = this.currentObject.getStatus();
        this.updateStateButton(n);
    }

    public void updateStateButton(int n) {
        this.openButton.removeActionListener((ActionListener)this);
        this.closeButton.removeActionListener((ActionListener)this);
        switch (n) {
            case 1: {
                this.setStateOpen(true);
                break;
            }
            case 0: {
                this.setStateOpen(false);
            }
        }
        this.openButton.addActionListener((ActionListener)this);
        this.closeButton.addActionListener((ActionListener)this);
    }

    public void setCurrentObject(Instrument instrument) {
        this.currentObject = instrument;
    }

    public void objectVisibilityUpdated(Instrument instrument) {
        this.instrumentObjectAdded(instrument, instrument.getType(), instrument.getName());
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        ++this.numOfObjects;
        if (this.numOfObjects == 1) {
            this.setComponentsEnabled(true);
        }
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        --this.numOfObjects;
        if (this.numOfObjects == 0) {
            this.setComponentsEnabled(false);
        }
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (instrument != this.currentObject) {
            return;
        }
        if (string.equals("Status")) {
            this.selectedObjectUpdated(instrument);
        } else if (string.equals("Name")) {
            this.label.setText("Using: " + object);
        }
    }

    @Override
    public void matlabActionComplete(int n, Object object, Object[] objectArray) {
        this.blockEvents(false);
    }

    @Override
    public void matlabActionErrored(int n) {
        switch (n) {
            case 0: {
                this.setStateOpen(false);
                break;
            }
            case 1: {
                this.setStateOpen(true);
            }
        }
        this.blockEvents(false);
    }

    public void blockEvents(boolean bl) {
        if (!this.isTCPIPServer(this.currentObject)) {
            try {
                this.getRootPane().getGlassPane().setVisible(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

