/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.icb;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.DocumentListener;

public class SendPanel
extends MJPanel {
    private static final long serialVersionUID = 1L;
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    public static final int BINBLOCK = 2;
    public static final String[] FORMATS = new String[]{"ASCII", "Binary", "Binblock"};
    public static final String[] PRECISIONS = new String[]{"8-bit integer", "16-bit integer", "32-bit integer", "8-bit unsigned integer", "16-bit unsigned integer", "32-bit unsigned integer", "32-bit float", "64-bit float"};
    public static final String[] BYTE_ORDERS = new String[]{"Little Endian", "Big Endian"};
    private MJTextField command;
    private MJLabel commandLabel;
    private MJLabel sendFormatLabel;
    private MJComboBox sendFormat;
    private MJLabel asciiFormattingLabel;
    private MJTextField asciiFormatting;
    private MJLabel precisionLabel;
    private MJComboBox precision;
    private MJLabel byteOrderLabel;
    private MJComboBox byteOrder;

    public SendPanel() {
        this.initComponents();
    }

    private void initComponents() {
        int n;
        this.setLayout(new GridBagLayout());
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.commandLabel = new MJLabel("Command:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.commandLabel, (Object)gridBagConstraints);
        this.command = new MJTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 7);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.command, (Object)gridBagConstraints);
        this.sendFormatLabel = new MJLabel("Output format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.sendFormatLabel, (Object)gridBagConstraints);
        this.sendFormat = new MJComboBox();
        for (n = 0; n < FORMATS.length; ++n) {
            this.sendFormat.addItem((Object)new String(FORMATS[n]));
        }
        this.sendFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendPanel.this.sendFormatActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.sendFormat, (Object)gridBagConstraints);
        this.asciiFormattingLabel = new MJLabel("ASCII format string:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.asciiFormattingLabel, (Object)gridBagConstraints);
        this.asciiFormatting = new MJTextField();
        this.asciiFormatting.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.asciiFormatting, (Object)gridBagConstraints);
        this.precisionLabel = new MJLabel("Precision:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.precisionLabel, (Object)gridBagConstraints);
        this.precision = new MJComboBox();
        for (n = 0; n < PRECISIONS.length; ++n) {
            this.precision.addItem((Object)new String(PRECISIONS[n]));
        }
        this.precision.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendPanel.this.updateByteOrderStatus();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.precision, (Object)gridBagConstraints);
        this.byteOrderLabel = new MJLabel("Byte order:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.byteOrderLabel, (Object)gridBagConstraints);
        this.byteOrder = new MJComboBox();
        for (n = 0; n < BYTE_ORDERS.length; ++n) {
            this.byteOrder.addItem((Object)new String(BYTE_ORDERS[n]));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.byteOrder, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)mJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new MJPanel(), gridBagConstraints);
        this.sendFormat.setSelectedIndex(0);
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.sendFormat.addActionListener(actionListener);
        this.precision.addActionListener(actionListener);
        this.byteOrder.addActionListener(actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
    }

    public void addTextListener(DocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        this.command.getDocument().addDocumentListener(documentListener);
        this.asciiFormatting.getDocument().addDocumentListener(documentListener);
    }

    public int getParameterValues(String[] stringArray, String[] stringArray2, int n) {
        stringArray[n] = new String("command");
        String string = this.command.getText();
        stringArray2[n++] = string.length() == 0 ? "''" : string;
        stringArray[n] = new String("sendFormat");
        stringArray2[n++] = (String)this.sendFormat.getSelectedItem();
        stringArray[n] = new String("asciiFormatting");
        string = this.asciiFormatting.getText();
        stringArray2[n++] = string.length() == 0 ? "''" : string;
        stringArray[n] = new String("precision");
        stringArray2[n++] = (String)this.precision.getSelectedItem();
        stringArray[n] = new String("byteOrder");
        stringArray2[n++] = (String)this.byteOrder.getSelectedItem();
        return n;
    }

    public void setParameterValues(String[] stringArray, String[] stringArray2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], stringArray2[i]);
        }
        this.setParameterValues(hashMap);
    }

    public void setParameterValues(Map<String, String> map) {
        String string = map.get("command");
        if (string.equalsIgnoreCase("''")) {
            this.command.setText("");
        } else {
            this.command.setText(string);
        }
        this.sendFormat.setSelectedItem((Object)map.get("sendFormat"));
        string = map.get("asciiFormatting");
        if (string.equalsIgnoreCase("''")) {
            this.asciiFormatting.setText("");
        } else {
            this.asciiFormatting.setText(string);
        }
        this.precision.setSelectedItem((Object)map.get("precision"));
        this.byteOrder.setSelectedItem((Object)map.get("byteOrder"));
    }

    public void disableComponents() {
        this.commandLabel.setEnabled(false);
        this.command.setEnabled(false);
        this.command.setBackground(this.getBackground());
        this.sendFormatLabel.setEnabled(false);
        this.sendFormat.setEnabled(false);
        this.asciiFormatting.setEnabled(false);
        this.asciiFormatting.setBackground(this.getBackground());
        this.asciiFormattingLabel.setEnabled(false);
        this.precision.setEnabled(false);
        this.precisionLabel.setEnabled(false);
        this.byteOrder.setEnabled(false);
        this.byteOrderLabel.setEnabled(false);
    }

    public void enableComponents() {
        this.commandLabel.setEnabled(true);
        this.command.setEnabled(true);
        this.command.setBackground(Color.white);
        this.sendFormatLabel.setEnabled(true);
        this.sendFormatLabel.setEnabled(true);
        this.sendFormat.setEnabled(true);
        this.sendFormatActionPerformed();
    }

    private boolean isMultibytePrecision() {
        int n = this.precision.getSelectedIndex();
        return n != 0 && n != 3;
    }

    private void enableASCII() {
        this.asciiFormatting.setEnabled(true);
        this.asciiFormatting.setBackground(Color.white);
        this.asciiFormattingLabel.setEnabled(true);
        this.precision.setEnabled(false);
        this.precisionLabel.setEnabled(false);
        this.byteOrder.setEnabled(false);
        this.byteOrderLabel.setEnabled(false);
    }

    private void enableBinary() {
        this.asciiFormatting.setEnabled(false);
        this.asciiFormatting.setBackground(this.getBackground());
        this.asciiFormattingLabel.setEnabled(false);
        this.precision.setEnabled(true);
        this.precisionLabel.setEnabled(true);
        this.updateByteOrderStatus();
    }

    private void enableBinblock() {
        this.asciiFormatting.setEnabled(false);
        this.asciiFormatting.setBackground(this.getBackground());
        this.asciiFormattingLabel.setEnabled(false);
        this.precision.setEnabled(true);
        this.precisionLabel.setEnabled(true);
        this.updateByteOrderStatus();
    }

    private void sendFormatActionPerformed() {
        int n = this.sendFormat.getSelectedIndex();
        switch (n) {
            case 0: {
                this.enableASCII();
                break;
            }
            case 1: {
                this.enableBinary();
                break;
            }
            case 2: {
                this.enableBinblock();
            }
        }
    }

    private void updateByteOrderStatus() {
        if (this.isMultibytePrecision()) {
            this.byteOrder.setEnabled(true);
            this.byteOrderLabel.setEnabled(true);
        } else {
            this.byteOrder.setEnabled(false);
            this.byteOrderLabel.setEnabled(false);
        }
    }
}

